/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.b;
import org.e.a.f;
import org.e.a.i;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaIdFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;

public class IQReplyFilter
implements StanzaFilter {
    private static final Logger LOGGER = Logger.getLogger(IQReplyFilter.class.getName());
    private final StanzaFilter iqAndIdFilter;
    private final OrFilter fromFilter;
    private final i to;
    private final f local;
    private final b server;
    private final String packetId;

    public IQReplyFilter(IQ iQ, XMPPConnection xMPPConnection) {
        if (!iQ.isRequestIQ()) {
            throw new IllegalArgumentException("IQ must be a request IQ, i.e. of type 'get' or 'set'.");
        }
        this.to = iQ.getTo();
        this.local = xMPPConnection.getUser();
        if (this.local == null) {
            throw new IllegalArgumentException("Must have a local (user) JID set. Either you didn't configure one or you where not connected at least once");
        }
        this.server = xMPPConnection.getXMPPServiceDomain();
        this.packetId = iQ.getStanzaId();
        OrFilter orFilter = new OrFilter(IQTypeFilter.ERROR, IQTypeFilter.RESULT);
        StanzaIdFilter stanzaIdFilter = new StanzaIdFilter(iQ);
        this.iqAndIdFilter = new AndFilter(orFilter, stanzaIdFilter);
        this.fromFilter = new OrFilter();
        this.fromFilter.addFilter(FromMatchesFilter.createFull(this.to));
        if (this.to == null) {
            this.fromFilter.addFilter(FromMatchesFilter.createBare((i)this.local));
            this.fromFilter.addFilter(FromMatchesFilter.createFull((i)this.server));
        } else if (this.to.a((CharSequence)this.local.n())) {
            this.fromFilter.addFilter(FromMatchesFilter.createFull(null));
        }
    }

    @Override
    public boolean accept(Stanza stanza) {
        if (!this.iqAndIdFilter.accept(stanza)) {
            return false;
        }
        if (this.fromFilter.accept(stanza)) {
            return true;
        }
        String string = String.format("Rejected potentially spoofed reply to IQ-packet. Filter settings: packetId=%s, to=%s, local=%s, server=%s. Received packet with from=%s", this.packetId, this.to, this.local, this.server, stanza.getFrom());
        LOGGER.log(Level.WARNING, string, stanza);
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(": iqAndIdFilter (").append(this.iqAndIdFilter.toString()).append("), ");
        stringBuilder.append(": fromFilter (").append(this.fromFilter.toString()).append(')');
        return stringBuilder.toString();
    }
}

