/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.fsm;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.fsm.State;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.util.Consumer;
import org.jivesoftware.smack.util.MultiMap;

public class StateDescriptorGraph {
    private static final Logger LOGGER = Logger.getLogger(StateDescriptorGraph.class.getName());

    private static GraphVertex<StateDescriptor> addNewStateDescriptorGraphVertex(Class<? extends StateDescriptor> clazz, Map<Class<? extends StateDescriptor>, GraphVertex<StateDescriptor>> map) {
        Constructor<? extends StateDescriptor> constructor = clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        StateDescriptor stateDescriptor = constructor.newInstance(new Object[0]);
        GraphVertex<StateDescriptor> graphVertex = new GraphVertex<StateDescriptor>(stateDescriptor);
        GraphVertex graphVertex2 = map.put(clazz, graphVertex);
        assert (graphVertex2 == null);
        return graphVertex;
    }

    private static void handleStateDescriptorGraphVertex(GraphVertex<StateDescriptor> graphVertex, HandleStateDescriptorGraphVertexContext handleStateDescriptorGraphVertexContext) {
        Object object;
        Object object2;
        Class<?> clazz = ((StateDescriptor)((GraphVertex)graphVertex).element).getClass();
        boolean bl = handleStateDescriptorGraphVertexContext.recurseInto(clazz);
        if (bl) {
            return;
        }
        Set<Class<? extends StateDescriptor>> set = ((StateDescriptor)((GraphVertex)graphVertex).element).getSuccessors();
        int n = set.size();
        HashMap<Class<? extends StateDescriptor>, GraphVertex> hashMap = new HashMap<Class<? extends StateDescriptor>, GraphVertex>(n);
        for (Class<? extends StateDescriptor> list2 : set) {
            Iterator iterator = handleStateDescriptorGraphVertexContext.getOrConstruct(list2);
            hashMap.put(list2, (GraphVertex)((Object)iterator));
        }
        switch (n) {
            case 0: {
                throw new IllegalStateException("State " + clazz + " has no successor");
            }
            case 1: {
                object2 = (GraphVertex)hashMap.values().iterator().next();
                ((GraphVertex)graphVertex).addOutgoingEdge((GraphVertex)object2);
                StateDescriptorGraph.handleStateDescriptorGraphVertex((GraphVertex<StateDescriptor>)object2, handleStateDescriptorGraphVertexContext);
                return;
            }
        }
        object2 = new HashMap(n);
        for (Iterator iterator : hashMap.values()) {
            GraphVertex<Class<? extends StateDescriptor>> graphVertex2;
            GraphVertex<Class<? extends StateDescriptor>> graphVertex3;
            StateDescriptor stateDescriptor = (StateDescriptor)((GraphVertex)((Object)iterator)).element;
            object = stateDescriptor.getClass();
            for (Class<? extends StateDescriptor> clazz2 : stateDescriptor.getSubordinates()) {
                if (!set.contains(clazz2)) {
                    LOGGER.severe(stateDescriptor + " points to a subordinate '" + clazz2 + "' which is not part of the successor set");
                    continue;
                }
                graphVertex3 = StateDescriptorGraph.lookupAndCreateIfRequired((Map<Class<? extends StateDescriptor>, GraphVertex<Class<? extends StateDescriptor>>>)object2, (Class<? extends StateDescriptor>)object);
                graphVertex2 = StateDescriptorGraph.lookupAndCreateIfRequired((Map<Class<? extends StateDescriptor>, GraphVertex<Class<? extends StateDescriptor>>>)object2, clazz2);
                ((GraphVertex)graphVertex3).addOutgoingEdge((GraphVertex)graphVertex2);
            }
            for (Class<? extends StateDescriptor> clazz3 : stateDescriptor.getSuperiors()) {
                if (!set.contains(clazz3)) {
                    LOGGER.severe(stateDescriptor + " points to a superior '" + clazz3 + "' which is not part of the successor set");
                    continue;
                }
                graphVertex3 = StateDescriptorGraph.lookupAndCreateIfRequired((Map<Class<? extends StateDescriptor>, GraphVertex<Class<? extends StateDescriptor>>>)object2, (Class<? extends StateDescriptor>)object);
                graphVertex2 = StateDescriptorGraph.lookupAndCreateIfRequired((Map<Class<? extends StateDescriptor>, GraphVertex<Class<? extends StateDescriptor>>>)object2, clazz3);
                ((GraphVertex)graphVertex2).addOutgoingEdge((GraphVertex)graphVertex3);
            }
        }
        List list = StateDescriptorGraph.topologicalSort(object2.values());
        block8: for (Class clazz4 : set) {
            for (GraphVertex graphVertex4 : list) {
                if (graphVertex4.getElement() != clazz4) continue;
                continue block8;
            }
            list.add(new GraphVertex(clazz4));
        }
        for (GraphVertex graphVertex5 : list) {
            object = (GraphVertex)hashMap.get(graphVertex5.element);
            ((GraphVertex)graphVertex).addOutgoingEdge((GraphVertex)object);
            StateDescriptorGraph.handleStateDescriptorGraphVertex((GraphVertex<StateDescriptor>)object, handleStateDescriptorGraphVertexContext);
        }
    }

    public static GraphVertex<StateDescriptor> constructStateDescriptorGraph(Set<Class<? extends StateDescriptor>> set) {
        HashMap<Class<? extends StateDescriptor>, GraphVertex<StateDescriptor>> hashMap = new HashMap<Class<? extends StateDescriptor>, GraphVertex<StateDescriptor>>();
        Class<ModularXmppClientToServerConnection.DisconnectedStateDescriptor> clazz = ModularXmppClientToServerConnection.DisconnectedStateDescriptor.class;
        GraphVertex<StateDescriptor> graphVertex = StateDescriptorGraph.addNewStateDescriptorGraphVertex(clazz, hashMap);
        MultiMap<Class<StateDescriptor>, Class<? extends StateDescriptor>> multiMap = new MultiMap<Class<StateDescriptor>, Class<? extends StateDescriptor>>();
        for (Class<? extends StateDescriptor> clazz2 : set) {
            GraphVertex<StateDescriptor> graphVertex2 = StateDescriptorGraph.addNewStateDescriptorGraphVertex(clazz2, hashMap);
            for (Class<? extends StateDescriptor> clazz3 : graphVertex2.getElement().getPredeccessors()) {
                multiMap.put(clazz3, clazz2);
            }
        }
        for (Class<? extends StateDescriptor> clazz2 : multiMap.getAll(clazz)) {
            graphVertex.getElement().addSuccessor(clazz2);
        }
        HandleStateDescriptorGraphVertexContext handleStateDescriptorGraphVertexContext = new HandleStateDescriptorGraphVertexContext(hashMap, multiMap);
        StateDescriptorGraph.handleStateDescriptorGraphVertex(graphVertex, handleStateDescriptorGraphVertexContext);
        return graphVertex;
    }

    private static GraphVertex<State> convertToStateGraph(GraphVertex<StateDescriptor> graphVertex, ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal, Map<StateDescriptor, GraphVertex<State>> map) {
        StateDescriptor stateDescriptor = graphVertex.getElement();
        GraphVertex<State> graphVertex2 = map.get(stateDescriptor);
        if (graphVertex2 != null) {
            return graphVertex2;
        }
        State state = stateDescriptor.constructState(modularXmppClientToServerConnectionInternal);
        graphVertex2 = new GraphVertex(state);
        map.put(stateDescriptor, graphVertex2);
        for (GraphVertex<StateDescriptor> graphVertex3 : graphVertex.getOutgoingEdges()) {
            GraphVertex<State> graphVertex4 = StateDescriptorGraph.convertToStateGraph(graphVertex3, modularXmppClientToServerConnectionInternal, map);
            ((GraphVertex)graphVertex2).addOutgoingEdge((GraphVertex)graphVertex4);
        }
        return graphVertex2;
    }

    public static GraphVertex<State> convertToStateGraph(GraphVertex<StateDescriptor> graphVertex, ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
        HashMap<StateDescriptor, GraphVertex<State>> hashMap = new HashMap<StateDescriptor, GraphVertex<State>>();
        GraphVertex<State> graphVertex2 = StateDescriptorGraph.convertToStateGraph(graphVertex, modularXmppClientToServerConnectionInternal, hashMap);
        return graphVertex2;
    }

    private static GraphVertex<Class<? extends StateDescriptor>> lookupAndCreateIfRequired(Map<Class<? extends StateDescriptor>, GraphVertex<Class<? extends StateDescriptor>>> map, Class<? extends StateDescriptor> clazz) {
        GraphVertex<Class<StateDescriptor>> graphVertex = map.get(clazz);
        if (graphVertex == null) {
            graphVertex = new GraphVertex(clazz);
            map.put(clazz, graphVertex);
        }
        return graphVertex;
    }

    private static <E> List<GraphVertex<E>> topologicalSort(Collection<GraphVertex<E>> collection) {
        ArrayList arrayList = new ArrayList();
        StateDescriptorGraph.dfs(collection, graphVertex -> arrayList.add(0, (GraphVertex)graphVertex), null);
        return arrayList;
    }

    private static <E> void dfsVisit(GraphVertex<E> graphVertex, Consumer<GraphVertex<E>> consumer, DfsEdgeFound<E> dfsEdgeFound) {
        ((GraphVertex)graphVertex).color = GraphVertex.VertexColor.grey;
        int n = graphVertex.getOutgoingEdges().size();
        int n2 = 0;
        for (GraphVertex<E> graphVertex2 : graphVertex.getOutgoingEdges()) {
            ++n2;
            if (dfsEdgeFound != null) {
                dfsEdgeFound.onEdgeFound(graphVertex, graphVertex2, n2, n);
            }
            if (((GraphVertex)graphVertex2).color != GraphVertex.VertexColor.white) continue;
            StateDescriptorGraph.dfsVisit(graphVertex2, consumer, dfsEdgeFound);
        }
        ((GraphVertex)graphVertex).color = GraphVertex.VertexColor.black;
        if (consumer != null) {
            consumer.accept(graphVertex);
        }
    }

    private static <E> void dfs(Collection<GraphVertex<E>> collection, Consumer<GraphVertex<E>> consumer, DfsEdgeFound<E> dfsEdgeFound) {
        for (GraphVertex<E> graphVertex : collection) {
            if (((GraphVertex)graphVertex).color != GraphVertex.VertexColor.white) continue;
            StateDescriptorGraph.dfsVisit(graphVertex, consumer, dfsEdgeFound);
        }
    }

    public static <E> void stateDescriptorGraphToDot(Collection<GraphVertex<StateDescriptor>> collection, PrintWriter printWriter, boolean bl) {
        printWriter.append("digraph {\n");
        StateDescriptorGraph.dfs(collection, graphVertex -> {
            boolean bl2 = ((StateDescriptor)((GraphVertex)graphVertex).element).isMultiVisitState();
            boolean bl3 = ((StateDescriptor)((GraphVertex)graphVertex).element).isFinalState();
            boolean bl4 = ((StateDescriptor)((GraphVertex)graphVertex).element).isNotImplemented();
            String string = null;
            if (bl2) {
                string = "bold";
            } else if (bl3) {
                string = "filled";
            } else if (bl4) {
                string = "dashed";
            }
            if (string == null) {
                return;
            }
            printWriter.append('\"').append(((StateDescriptor)((GraphVertex)graphVertex).element).getFullStateName(bl)).append("\" [ ").append("style=").append(string).append(" ]\n");
        }, (graphVertex, graphVertex2, n, n2) -> {
            printWriter.append("  \"").append(((StateDescriptor)graphVertex.element).getFullStateName(bl)).append("\" -> \"").append(((StateDescriptor)graphVertex2.element).getFullStateName(bl)).append('\"');
            if (n2 > 1) {
                printWriter.append(" [xlabel=\"").append(Integer.toString(n)).append("\"]");
            }
            printWriter.append(";\n");
        });
        printWriter.append("}\n");
    }

    private static interface DfsEdgeFound<E> {
        public void onEdgeFound(GraphVertex<E> var1, GraphVertex<E> var2, int var3, int var4);
    }

    public static final class GraphVertex<E> {
        private final E element;
        private final List<GraphVertex<E>> outgoingEdges = new ArrayList<GraphVertex<E>>();
        private VertexColor color = VertexColor.white;

        private GraphVertex(E e2) {
            this.element = e2;
        }

        private void addOutgoingEdge(GraphVertex<E> graphVertex) {
            assert (graphVertex != null);
            if (this.outgoingEdges.contains(graphVertex)) {
                throw new IllegalArgumentException("This " + this + " already has an outgoing edge to " + graphVertex);
            }
            this.outgoingEdges.add(graphVertex);
        }

        public E getElement() {
            return this.element;
        }

        public List<GraphVertex<E>> getOutgoingEdges() {
            return Collections.unmodifiableList(this.outgoingEdges);
        }

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("GraphVertex " + this.element + " [color=" + (Object)((Object)this.color) + ", identityHashCode=" + System.identityHashCode(this) + ", outgoingEdgeCount=" + this.outgoingEdges.size());
            if (bl) {
                stringBuilder.append(", outgoingEdges={");
                Iterator<GraphVertex<E>> iterator = this.outgoingEdges.iterator();
                while (iterator.hasNext()) {
                    GraphVertex<E> graphVertex = iterator.next();
                    stringBuilder.append(graphVertex.toString(false));
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append('}');
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        private static enum VertexColor {
            white,
            grey,
            black;

        }
    }

    private static final class HandleStateDescriptorGraphVertexContext {
        private final Set<Class<? extends StateDescriptor>> handledStateDescriptors = new HashSet<Class<? extends StateDescriptor>>();
        Map<Class<? extends StateDescriptor>, GraphVertex<StateDescriptor>> graphVertexes;
        MultiMap<Class<? extends StateDescriptor>, Class<? extends StateDescriptor>> inferredForwardEdges;

        private HandleStateDescriptorGraphVertexContext(Map<Class<? extends StateDescriptor>, GraphVertex<StateDescriptor>> map, MultiMap<Class<? extends StateDescriptor>, Class<? extends StateDescriptor>> multiMap) {
            this.graphVertexes = map;
            this.inferredForwardEdges = multiMap;
        }

        private boolean recurseInto(Class<? extends StateDescriptor> clazz) {
            boolean bl = this.handledStateDescriptors.add(clazz);
            boolean bl2 = !bl;
            return bl2;
        }

        private GraphVertex<StateDescriptor> getOrConstruct(Class<? extends StateDescriptor> clazz) {
            GraphVertex graphVertex = this.graphVertexes.get(clazz);
            if (graphVertex == null) {
                graphVertex = StateDescriptorGraph.addNewStateDescriptorGraphVertex(clazz, this.graphVertexes);
                for (Class<? extends StateDescriptor> clazz2 : this.inferredForwardEdges.getAll(clazz)) {
                    ((StateDescriptor)graphVertex.getElement()).addSuccessor(clazz2);
                }
            }
            return graphVertex;
        }
    }
}

