/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smack.util.Objects;

public interface MessageView
extends StanzaView {
    public Message.Type getType();

    default public String getSubject() {
        return this.getSubject(null);
    }

    default public String getSubject(String string) {
        Message.Subject subject = this.getMessageSubject(string);
        return subject == null ? null : subject.getSubject();
    }

    default public Message.Subject getMessageSubject(String string) {
        string = Stanza.determineLanguage(this, string);
        for (Message.Subject subject : this.getSubjects()) {
            if (!Objects.equals(string, subject.getLanguage()) && (subject.getLanguage() != null || !Objects.equals(this.getLanguage(), string))) continue;
            return subject;
        }
        return null;
    }

    default public Set<Message.Subject> getSubjects() {
        List<Message.Subject> list = this.getExtensions(Message.Subject.class);
        HashSet<Message.Subject> hashSet = new HashSet<Message.Subject>(list.size());
        hashSet.addAll(list);
        return hashSet;
    }

    default public List<String> getSubjectLanguages() {
        Message.Subject subject = this.getMessageSubject(null);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Message.Subject subject2 : this.getExtensions(Message.Subject.class)) {
            if (subject2.equals(subject)) continue;
            arrayList.add(subject2.getLanguage());
        }
        return Collections.unmodifiableList(arrayList);
    }

    default public String getBody() {
        return this.getBody(this.getLanguage());
    }

    default public String getBody(String string) {
        Message.Body body = this.getMessageBody(string);
        return body == null ? null : body.getMessage();
    }

    default public Message.Body getMessageBody(String string) {
        string = Stanza.determineLanguage(this, string);
        for (Message.Body body : this.getBodies()) {
            if (!Objects.equals(string, body.getLanguage()) && (string == null || !string.equals(this.getLanguage()) || body.getLanguage() != null)) continue;
            return body;
        }
        return null;
    }

    default public Set<Message.Body> getBodies() {
        List<ExtensionElement> list = this.getExtensions(Message.Body.QNAME);
        HashSet<Message.Body> hashSet = new HashSet<Message.Body>(list.size());
        for (ExtensionElement extensionElement : list) {
            Message.Body body = (Message.Body)extensionElement;
            hashSet.add(body);
        }
        return hashSet;
    }

    default public List<String> getBodyLanguages() {
        Message.Body body = this.getMessageBody(null);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Message.Body body2 : this.getBodies()) {
            if (body2.equals(body)) continue;
            arrayList.add(body2.getLanguage());
        }
        return Collections.unmodifiableList(arrayList);
    }

    default public String getThread() {
        Message.Thread thread = this.getExtension(Message.Thread.class);
        if (thread == null) {
            return null;
        }
        return thread.getThread();
    }
}

