/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ArrayBlockingQueueWithShutdown<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final E[] items;
    private int takeIndex;
    private int putIndex;
    private int count;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;
    private volatile boolean isShutdown = false;

    private int inc(int n) {
        return ++n == this.items.length ? 0 : n;
    }

    private void insert(E e2) {
        this.insert(e2, true);
    }

    private void insert(E e2, boolean bl) {
        this.items[this.putIndex] = e2;
        this.putIndex = this.inc(this.putIndex);
        ++this.count;
        if (bl) {
            this.notEmpty.signal();
        }
    }

    private E extract() {
        E e2 = this.items[this.takeIndex];
        this.items[this.takeIndex] = null;
        this.takeIndex = this.inc(this.takeIndex);
        --this.count;
        this.notFull.signal();
        return e2;
    }

    private void removeAt(int n) {
        if (n == this.takeIndex) {
            this.items[this.takeIndex] = null;
            this.takeIndex = this.inc(this.takeIndex);
        } else {
            int n2;
            while ((n2 = this.inc(n)) != this.putIndex) {
                this.items[n] = this.items[n2];
                n = n2;
            }
            this.items[n] = null;
            this.putIndex = n;
        }
        --this.count;
        this.notFull.signal();
    }

    private static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    private void checkNotShutdown() {
        if (this.isShutdown) {
            throw new InterruptedException("Queue was already shut down");
        }
    }

    private boolean hasNoElements() {
        return this.count == 0;
    }

    private boolean hasElements() {
        return !this.hasNoElements();
    }

    private boolean isFull() {
        return this.count == this.items.length;
    }

    private boolean isNotFull() {
        return !this.isFull();
    }

    public ArrayBlockingQueueWithShutdown(int n) {
        this(n, false);
    }

    public ArrayBlockingQueueWithShutdown(int n, boolean bl) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.items = new Object[n];
        this.lock = new ReentrantLock(bl);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    public void shutdown() {
        this.lock.lock();
        try {
            this.isShutdown = true;
            this.notEmpty.signalAll();
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean start() {
        boolean bl;
        this.lock.lock();
        try {
            bl = this.isShutdown;
            this.isShutdown = false;
        }
        finally {
            this.lock.unlock();
        }
        return bl;
    }

    public boolean isShutdown() {
        this.lock.lock();
        try {
            boolean bl = this.isShutdown;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E poll() {
        this.lock.lock();
        try {
            E e2;
            if (this.hasNoElements()) {
                E e3 = null;
                return e3;
            }
            E e4 = e2 = this.extract();
            return e4;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E peek() {
        this.lock.lock();
        try {
            E e2 = this.hasNoElements() ? null : (E)this.items[this.takeIndex];
            return e2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean offer(E e2) {
        ArrayBlockingQueueWithShutdown.checkNotNull(e2);
        this.lock.lock();
        try {
            if (this.isFull() || this.isShutdown) {
                boolean bl = false;
                return bl;
            }
            this.insert(e2);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean offerAndShutdown(E e2) {
        boolean bl;
        ArrayBlockingQueueWithShutdown.checkNotNull(e2);
        this.lock.lock();
        try {
            bl = this.offer(e2);
            this.shutdown();
        }
        finally {
            this.lock.unlock();
        }
        return bl;
    }

    private void putInternal(E e2, boolean bl) {
        assert (this.lock.isHeldByCurrentThread());
        while (this.isFull()) {
            try {
                this.notFull.await();
                this.checkNotShutdown();
            }
            catch (InterruptedException interruptedException) {
                this.notFull.signal();
                throw interruptedException;
            }
        }
        this.insert(e2, bl);
    }

    @Override
    public void put(E e2) {
        ArrayBlockingQueueWithShutdown.checkNotNull(e2);
        this.lock.lockInterruptibly();
        try {
            this.putInternal(e2, true);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean putIfNotShutdown(E e2) {
        ArrayBlockingQueueWithShutdown.checkNotNull(e2);
        this.lock.lockInterruptibly();
        try {
            if (this.isShutdown) {
                boolean bl = false;
                return bl;
            }
            this.putInternal(e2, true);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Collection<? extends E> collection) {
        ArrayBlockingQueueWithShutdown.checkNotNull(collection);
        this.lock.lockInterruptibly();
        try {
            for (E e2 : collection) {
                this.putInternal(e2, false);
            }
        }
        finally {
            this.notEmpty.signalAll();
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TryPutResult tryPut(E e2) {
        ArrayBlockingQueueWithShutdown.checkNotNull(e2);
        boolean bl = this.lock.tryLock();
        if (!bl) {
            return TryPutResult.couldNotLock;
        }
        try {
            if (this.isShutdown) {
                TryPutResult tryPutResult = TryPutResult.queueWasShutDown;
                return tryPutResult;
            }
            if (this.isFull()) {
                TryPutResult tryPutResult = TryPutResult.queueWasFull;
                return tryPutResult;
            }
            this.insert(e2);
            TryPutResult tryPutResult = TryPutResult.putSuccessful;
            return tryPutResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean offer(E var1_1, long var2_2, TimeUnit var4_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public E take() {
        this.lock.lockInterruptibly();
        try {
            E e2;
            this.checkNotShutdown();
            try {
                while (this.hasNoElements()) {
                    this.notEmpty.await();
                    this.checkNotShutdown();
                }
            }
            catch (InterruptedException interruptedException) {
                this.notEmpty.signal();
                throw interruptedException;
            }
            E e3 = e2 = this.extract();
            return e3;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TryTakeResult<E> tryTake() {
        boolean bl = this.lock.tryLock();
        if (!bl) {
            return new TryTakeResult(TryTakeResultCode.couldNotLock);
        }
        try {
            if (this.isShutdown) {
                TryTakeResult tryTakeResult = new TryTakeResult(TryTakeResultCode.queueWasShutDown);
                return tryTakeResult;
            }
            if (this.hasNoElements()) {
                TryTakeResult tryTakeResult = new TryTakeResult(TryTakeResultCode.queueWasEmpty);
                return tryTakeResult;
            }
            E e2 = this.extract();
            TryTakeResult tryTakeResult = new TryTakeResult(e2);
            return tryTakeResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public E poll(long var1_1, TimeUnit var3_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int remainingCapacity() {
        this.lock.lock();
        try {
            int n = this.items.length - this.count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection) {
        ArrayBlockingQueueWithShutdown.checkNotNull(collection);
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            int n;
            int n2 = this.takeIndex;
            for (n = 0; n < this.count; ++n) {
                collection.add(this.items[n2]);
                this.items[n2] = null;
                n2 = this.inc(n2);
            }
            if (n > 0) {
                this.count = 0;
                this.putIndex = 0;
                this.takeIndex = 0;
                this.notFull.signalAll();
            }
            int n3 = n;
            return n3;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        ArrayBlockingQueueWithShutdown.checkNotNull(collection);
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        if (n <= 0) {
            return 0;
        }
        this.lock.lock();
        try {
            int n2;
            int n3;
            int n4 = this.takeIndex;
            int n5 = n3 = n < this.count ? n : this.count;
            for (n2 = 0; n2 < n3; ++n2) {
                collection.add(this.items[n4]);
                this.items[n4] = null;
                n4 = this.inc(n4);
            }
            if (n2 > 0) {
                this.count -= n2;
                this.takeIndex = n4;
                this.notFull.signalAll();
            }
            int n6 = n2;
            return n6;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        this.lock.lock();
        try {
            Itr itr = new Itr();
            return itr;
        }
        finally {
            this.lock.unlock();
        }
    }

    private class Itr
    implements Iterator<E> {
        private int nextIndex;
        private E nextItem;
        private int lastRet = -1;

        Itr() {
            if (ArrayBlockingQueueWithShutdown.this.count == 0) {
                this.nextIndex = -1;
            } else {
                this.nextIndex = ArrayBlockingQueueWithShutdown.this.takeIndex;
                this.nextItem = ArrayBlockingQueueWithShutdown.this.items[ArrayBlockingQueueWithShutdown.this.takeIndex];
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        private void checkNext() {
            if (this.nextIndex == ArrayBlockingQueueWithShutdown.this.putIndex) {
                this.nextIndex = -1;
                this.nextItem = null;
            } else {
                this.nextItem = ArrayBlockingQueueWithShutdown.this.items[this.nextIndex];
                if (this.nextItem == null) {
                    this.nextIndex = -1;
                }
            }
        }

        @Override
        public E next() {
            ArrayBlockingQueueWithShutdown.this.lock.lock();
            try {
                if (this.nextIndex < 0) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.nextIndex;
                Object e2 = this.nextItem;
                this.nextIndex = ArrayBlockingQueueWithShutdown.this.inc(this.nextIndex);
                this.checkNext();
                Object e3 = e2;
                return e3;
            }
            finally {
                ArrayBlockingQueueWithShutdown.this.lock.unlock();
            }
        }

        @Override
        public void remove() {
            ArrayBlockingQueueWithShutdown.this.lock.lock();
            try {
                int n = this.lastRet;
                if (n < 0) {
                    throw new IllegalStateException();
                }
                this.lastRet = -1;
                int n2 = ArrayBlockingQueueWithShutdown.this.takeIndex;
                ArrayBlockingQueueWithShutdown.this.removeAt(n);
                this.nextIndex = n == n2 ? ArrayBlockingQueueWithShutdown.this.takeIndex : n;
                this.checkNext();
            }
            finally {
                ArrayBlockingQueueWithShutdown.this.lock.unlock();
            }
        }
    }

    public static final class TryTakeResult<E> {
        private final E element;
        private final TryTakeResultCode resultCode;

        private TryTakeResult(TryTakeResultCode tryTakeResultCode) {
            assert (tryTakeResultCode != null);
            this.resultCode = tryTakeResultCode;
            this.element = null;
        }

        private TryTakeResult(E e2) {
            assert (e2 != null);
            this.resultCode = TryTakeResultCode.takeSuccessful;
            this.element = e2;
        }

        public TryTakeResultCode getResultCode() {
            return this.resultCode;
        }

        public E getElement() {
            return this.element;
        }
    }

    public static enum TryTakeResultCode {
        couldNotLock,
        queueWasShutDown,
        queueWasEmpty,
        takeSuccessful;

    }

    public static enum TryPutResult {
        couldNotLock,
        queueWasShutDown,
        queueWasFull,
        putSuccessful;

    }
}

