/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.logging.Level;
import java.util.logging.Logger;

public class Async {
    public static Thread go(Runnable runnable) {
        Thread thread = Async.daemonThreadFrom(runnable);
        thread.start();
        return thread;
    }

    public static Thread go(Runnable runnable, String string) {
        Thread thread = Async.daemonThreadFrom(runnable);
        thread.setName(string);
        thread.start();
        return thread;
    }

    public static Thread daemonThreadFrom(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        return thread;
    }

    public static abstract class ThrowingRunnable
    implements Runnable {
        public static final Logger LOGGER = Logger.getLogger(ThrowingRunnable.class.getName());

        @Override
        public final void run() {
            try {
                this.runOrThrow();
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                LOGGER.log(Level.WARNING, "Caught Exception", exception);
            }
        }

        public abstract void runOrThrow();
    }
}

