/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collection;
import org.jivesoftware.smack.util.Function;
import org.jivesoftware.smack.util.StringUtils;

public class ToStringUtil {
    public static Builder builderFor(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(clazz.getSimpleName()).append('(');
        return new Builder(stringBuilder);
    }

    public static final class Builder {
        private final StringBuilder sb;

        private Builder(StringBuilder stringBuilder) {
            this.sb = stringBuilder;
        }

        public Builder addValue(String string, Object object) {
            if (object == null) {
                return this;
            }
            if (this.sb.charAt(this.sb.length() - 1) != '(') {
                this.sb.append(' ');
            }
            this.sb.append(string).append("='").append(object).append('\'');
            return this;
        }

        public <V> Builder add(String string, Collection<? extends V> collection, Function<?, V> function) {
            if (collection.isEmpty()) {
                return this;
            }
            this.sb.append(' ').append(string).append('[');
            ArrayList<String> arrayList = new ArrayList<String>(collection.size());
            for (V v : collection) {
                String string2 = function.apply(v).toString();
                arrayList.add(string2);
            }
            StringUtils.appendTo(arrayList, ", ", this.sb);
            this.sb.append(']');
            return this;
        }

        public String build() {
            this.sb.append(')');
            return this.sb.toString();
        }
    }
}

