/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.stringencoder;

import java.nio.charset.StandardCharsets;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;

public class Base64 {
    private static Encoder base64encoder;

    public static void setEncoder(Encoder encoder) {
        Objects.requireNonNull(encoder, "encoder must no be null");
        base64encoder = encoder;
    }

    public static final String encode(String string) {
        return Base64.encodeToString(string.getBytes(StandardCharsets.UTF_8));
    }

    public static final String encodeToString(byte[] byArray) {
        return base64encoder.encodeToString(byArray);
    }

    public static final String encodeToString(byte[] byArray, int n, int n2) {
        return Base64.encodeToString(Base64.slice(byArray, n, n2));
    }

    public static final String encodeToStringWithoutPadding(byte[] byArray) {
        return base64encoder.encodeToStringWithoutPadding(byArray);
    }

    public static final byte[] encode(byte[] byArray) {
        return base64encoder.encode(byArray);
    }

    public static final String decodeToString(String string) {
        byte[] byArray = Base64.decode(string);
        return new String(byArray, StandardCharsets.UTF_8);
    }

    public static final byte[] decode(String string) {
        string = StringUtils.deleteXmlWhitespace(string);
        try {
            return base64encoder.decode(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static final byte[] decode(byte[] byArray) {
        String string = new String(byArray, StandardCharsets.US_ASCII);
        return Base64.decode(string);
    }

    private static byte[] slice(byte[] byArray, int n, int n2) {
        if (n == 0 && n2 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static interface Encoder {
        public byte[] decode(String var1);

        public String encodeToString(byte[] var1);

        public String encodeToStringWithoutPadding(byte[] var1);

        public byte[] encode(byte[] var1);
    }
}

