/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.jna.windows;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinGDI;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import dorkbox.jna.windows.GDI32;
import dorkbox.jna.windows.User32;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import org.slf4j.LoggerFactory;

public class HBITMAPWrap
extends WinDef.HBITMAP {
    private static final Object lockObject = new Object();
    private WinDef.HBITMAP bitmap;
    BufferedImage img;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WinDef.HBITMAP createBitmap(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth(null);
        int n2 = bufferedImage.getHeight(null);
        Object object = lockObject;
        synchronized (object) {
            Raster raster;
            WinDef.HDC hDC = User32.User32.GetDC(null);
            WinDef.HDC hDC2 = GDI32.CreateCompatibleDC(hDC);
            WinDef.HBITMAP hBITMAP = null;
            try {
                BufferedImage bufferedImage2 = new BufferedImage(n, n2, 3);
                Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
                graphics2D.setComposite(AlphaComposite.getInstance(3));
                graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
                WinGDI.BITMAPINFO bITMAPINFO = new WinGDI.BITMAPINFO();
                bITMAPINFO.bmiHeader.biWidth = n;
                bITMAPINFO.bmiHeader.biHeight = n2;
                bITMAPINFO.bmiHeader.biPlanes = 1;
                bITMAPINFO.bmiHeader.biBitCount = (short)32;
                bITMAPINFO.bmiHeader.biCompression = 0;
                bITMAPINFO.bmiHeader.biSizeImage = n * n2 * 4;
                Memory memory = new Memory((long)(n * n2 * 32 * 4));
                PointerByReference pointerByReference = new PointerByReference((Pointer)memory);
                hBITMAP = GDI32.CreateDIBSection(hDC2, bITMAPINFO, 0, pointerByReference, null, 0);
                Pointer pointer = pointerByReference.getValue();
                if (pointer == null) {
                    LoggerFactory.getLogger(HBITMAPWrap.class).error("The image was invalid", (Object)Kernel32Util.getLastErrorMessage());
                } else {
                    raster = bufferedImage2.getData();
                    int[] nArray = new int[4];
                    int[] nArray2 = new int[n * n2];
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            raster.getPixel(j, n2 - i - 1, nArray);
                            int n3 = (nArray[2] & 0xFF) << 0;
                            int n4 = (nArray[1] & 0xFF) << 8;
                            int n5 = (nArray[0] & 0xFF) << 16;
                            int n6 = (nArray[3] & 0xFF) << 24;
                            nArray2[j + i * n] = n6 | n3 | n4 | n5;
                        }
                    }
                    pointer.write(0L, nArray2, 0, nArray2.length);
                }
                raster = hBITMAP;
                User32.User32.ReleaseDC(null, hDC);
            }
            catch (Throwable throwable) {
                User32.User32.ReleaseDC(null, hDC);
                GDI32.DeleteDC(hDC2);
                throw throwable;
            }
            GDI32.DeleteDC(hDC2);
            return raster;
        }
    }

    public HBITMAPWrap(BufferedImage bufferedImage) {
        this.bitmap = HBITMAPWrap.createBitmap(bufferedImage);
        this.setPointer(this.bitmap.getPointer());
        this.img = bufferedImage;
    }

    protected void finalize() {
        this.close();
        super.finalize();
    }

    public void close() {
        if (Pointer.nativeValue((Pointer)this.getPointer()) != 0L) {
            GDI32.DeleteObject((WinNT.HANDLE)this);
            this.setPointer(new Pointer(0L));
            this.bitmap = null;
        }
    }

    public BufferedImage getImage() {
        return this.img;
    }
}

