/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.plaf.UIResource;

public abstract class FlatAbstractIcon
implements Icon,
UIResource {
    protected final int width;
    protected final int height;
    protected Color color;

    public FlatAbstractIcon(int n, int n2, Color color) {
        this.width = n;
        this.height = n2;
        this.color = color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints(graphics2D);
            graphics2D.translate(n, n2);
            UIScale.scaleGraphics(graphics2D);
            if (this.color != null) {
                graphics2D.setColor(this.color);
            }
            this.paintIcon(component, graphics2D);
        }
        finally {
            graphics2D.dispose();
        }
    }

    protected abstract void paintIcon(Component var1, Graphics2D var2);

    @Override
    public int getIconWidth() {
        return UIScale.scale(this.width);
    }

    @Override
    public int getIconHeight() {
        return UIScale.scale(this.height);
    }
}

