/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RadialGradientPaint;
import java.awt.image.BufferedImage;
import java.util.Map;

public class FlatDropShadowBorder
extends FlatEmptyBorder
implements FlatStylingSupport.StyleableBorder {
    @FlatStylingSupport.Styleable
    protected Color shadowColor;
    @FlatStylingSupport.Styleable
    protected Insets shadowInsets;
    @FlatStylingSupport.Styleable
    protected float shadowOpacity;
    private int shadowSize;
    private Image shadowImage;
    private Color lastShadowColor;
    private float lastShadowOpacity;
    private int lastShadowSize;
    private double lastSystemScaleFactor;
    private float lastUserScaleFactor;

    public FlatDropShadowBorder() {
        this((Color)null);
    }

    public FlatDropShadowBorder(Color color) {
        this(color, 4, 0.5f);
    }

    public FlatDropShadowBorder(Color color, int n, float f) {
        this(color, new Insets(-n, -n, n, n), f);
    }

    public FlatDropShadowBorder(Color color, Insets insets, float f) {
        super(FlatDropShadowBorder.nonNegativeInsets(insets));
        this.shadowColor = color;
        this.shadowInsets = insets;
        this.shadowOpacity = f;
        this.shadowSize = this.maxInset(insets);
    }

    private static Insets nonNegativeInsets(Insets insets) {
        return new Insets(Math.max(insets.top, 0), Math.max(insets.left, 0), Math.max(insets.bottom, 0), Math.max(insets.right, 0));
    }

    private int maxInset(Insets insets) {
        return Math.max(Math.max(insets.left, insets.right), Math.max(insets.top, insets.bottom));
    }

    @Override
    public Object applyStyleProperty(String string, Object object) {
        Object object2 = FlatStylingSupport.applyToAnnotatedObject(this, string, object);
        if (string.equals("shadowInsets")) {
            this.applyStyleProperty(FlatDropShadowBorder.nonNegativeInsets(this.shadowInsets));
            this.shadowSize = this.maxInset(this.shadowInsets);
        }
        return object2;
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos() {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.shadowSize <= 0) {
            return;
        }
        HiDPIUtils.paintAtScale1x((Graphics2D)graphics, n, n2, n3, n4, this::paintImpl);
    }

    private void paintImpl(Graphics2D graphics2D, int n, int n2, int n3, int n4, double d) {
        Color color = this.shadowColor != null ? this.shadowColor : graphics2D.getColor();
        int n5 = this.scale(this.shadowSize, d);
        float f = UIScale.getUserScaleFactor();
        if (this.shadowImage == null || !color.equals(this.lastShadowColor) || this.lastShadowOpacity != this.shadowOpacity || this.lastShadowSize != n5 || this.lastSystemScaleFactor != d || this.lastUserScaleFactor != f) {
            this.shadowImage = FlatDropShadowBorder.createShadowImage(color, n5, this.shadowOpacity, (float)(d * (double)f));
            this.lastShadowColor = color;
            this.lastShadowOpacity = this.shadowOpacity;
            this.lastShadowSize = n5;
            this.lastSystemScaleFactor = d;
            this.lastUserScaleFactor = f;
        }
        int n6 = this.scale(this.shadowInsets.left, d);
        int n7 = this.scale(this.shadowInsets.right, d);
        int n8 = this.scale(this.shadowInsets.top, d);
        int n9 = this.scale(this.shadowInsets.bottom, d);
        int n10 = n - Math.min(n6, 0);
        int n11 = n2 - Math.min(n8, 0);
        int n12 = n + n3 + Math.min(n7, 0);
        int n13 = n2 + n4 + Math.min(n9, 0);
        int n14 = n10 + n5;
        int n15 = n11 + n5;
        int n16 = n12 - n5;
        int n17 = n13 - n5;
        int n18 = n5 * 2 - 1;
        int n19 = n5 - 1;
        if (n6 > 0 || n8 > 0) {
            graphics2D.drawImage(this.shadowImage, n10, n11, n14, n15, 0, 0, n19, n19, null);
        }
        if (n8 > 0) {
            graphics2D.drawImage(this.shadowImage, n14, n11, n16, n15, n19, 0, n19 + 1, n19, null);
        }
        if (n7 > 0 || n8 > 0) {
            graphics2D.drawImage(this.shadowImage, n16, n11, n12, n15, n19, 0, n18, n19, null);
        }
        if (n6 > 0) {
            graphics2D.drawImage(this.shadowImage, n10, n15, n14, n17, 0, n19, n19, n19 + 1, null);
        }
        if (n7 > 0) {
            graphics2D.drawImage(this.shadowImage, n16, n15, n12, n17, n19, n19, n18, n19 + 1, null);
        }
        if (n6 > 0 || n9 > 0) {
            graphics2D.drawImage(this.shadowImage, n10, n17, n14, n13, 0, n19, n19, n18, null);
        }
        if (n9 > 0) {
            graphics2D.drawImage(this.shadowImage, n14, n17, n16, n13, n19, n19, n19 + 1, n18, null);
        }
        if (n7 > 0 || n9 > 0) {
            graphics2D.drawImage(this.shadowImage, n16, n17, n12, n13, n19, n19, n18, n18, null);
        }
    }

    private int scale(int n, double d) {
        return (int)Math.ceil((double)UIScale.scale(n) * d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage createShadowImage(Color color, int n, float f, float f2) {
        int n2 = color.getRGB() & 0xFFFFFF;
        int n3 = (int)(255.0f * f);
        Color color2 = new Color(n2 | (n3 & 0xFF) << 24, true);
        Color color3 = new Color(n2 | (n3 / 2 & 0xFF) << 24, true);
        Color color4 = new Color(n2, true);
        int n4 = n * 2 - 1;
        int n5 = n - 1;
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(n5, (float)n5, (float)n - 0.75f * f2, new float[]{0.0f, 0.35f, 1.0f}, new Color[]{color2, color3, color4});
        BufferedImage bufferedImage = new BufferedImage(n4, n4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setPaint(radialGradientPaint);
            graphics2D.fillRect(0, 0, n4, n4);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }
}

