/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicLabelUI;

public class FlatLabelUI
extends BasicLabelUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected Color disabledForeground;
    private final boolean shared;
    private boolean defaults_initialized = false;
    private Map<String, Object> oldStyleValues;
    private static Set<String> tagsUseFontSizeSet;

    public static ComponentUI createUI(JComponent jComponent) {
        return FlatUIUtils.canUseSharedUI(jComponent) ? FlatUIUtils.createSharedUI(FlatLabelUI.class, () -> new FlatLabelUI(true)) : new FlatLabelUI(false);
    }

    protected FlatLabelUI(boolean bl) {
        this.shared = bl;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle((JLabel)jComponent);
    }

    @Override
    protected void installDefaults(JLabel jLabel) {
        super.installDefaults(jLabel);
        if (!this.defaults_initialized) {
            this.disabledForeground = UIManager.getColor("Label.disabledForeground");
            this.defaults_initialized = true;
        }
    }

    @Override
    protected void uninstallDefaults(JLabel jLabel) {
        super.uninstallDefaults(jLabel);
        this.defaults_initialized = false;
        this.oldStyleValues = null;
    }

    @Override
    protected void installComponents(JLabel jLabel) {
        super.installComponents(jLabel);
        FlatLabelUI.updateHTMLRenderer(jLabel, jLabel.getText(), false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "text" || string == "font" || string == "foreground") {
            JLabel jLabel = (JLabel)propertyChangeEvent.getSource();
            FlatLabelUI.updateHTMLRenderer(jLabel, jLabel.getText(), true);
        } else if (string.equals("FlatLaf.style") || string.equals("FlatLaf.styleClass")) {
            JLabel jLabel = (JLabel)propertyChangeEvent.getSource();
            if (this.shared && FlatStylingSupport.hasStyleProperty(jLabel)) {
                jLabel.updateUI();
            } else {
                this.installStyle(jLabel);
            }
            jLabel.revalidate();
            jLabel.repaint();
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    protected void installStyle(JLabel jLabel) {
        try {
            this.applyStyle(jLabel, FlatStylingSupport.getResolvedStyle(jLabel, "Label"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(JLabel jLabel, Object object2) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object2, (string, object) -> this.applyStyleProperty(jLabel, (String)string, object));
    }

    protected Object applyStyleProperty(JLabel jLabel, String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, jLabel, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    static void updateHTMLRenderer(JComponent jComponent, String string, boolean bl) {
        if (BasicHTML.isHTMLString(string) && jComponent.getClientProperty("html.disable") != Boolean.TRUE && FlatLabelUI.needsFontBaseSize(string)) {
            int n;
            String string2 = "<style>BASE_SIZE " + jComponent.getFont().getSize() + "</style>";
            String string3 = string.toLowerCase(Locale.ENGLISH);
            int n2 = string3.indexOf("<head>");
            if (n2 >= 0) {
                n = n2 + "<head>".length();
            } else {
                int n3 = string3.indexOf("<style>");
                if (n3 >= 0) {
                    n = n3;
                } else {
                    string2 = "<head>" + string2 + "</head>";
                    n = "<html>".length();
                }
            }
            string = string.substring(0, n) + string2 + string.substring(n);
        } else if (!bl) {
            return;
        }
        BasicHTML.updateRenderer(jComponent, string);
    }

    private static boolean needsFontBaseSize(String string) {
        if (tagsUseFontSizeSet == null) {
            tagsUseFontSizeSet = new HashSet<String>(Arrays.asList("h1", "h2", "h3", "h4", "h5", "h6", "code", "kbd", "big", "small", "samp"));
        }
        int n = string.length();
        block3: for (int i = 6; i < n - 1; ++i) {
            if (string.charAt(i) != '<') continue;
            switch (string.charAt(i + 1)) {
                case 'B': 
                case 'C': 
                case 'H': 
                case 'K': 
                case 'S': 
                case 'b': 
                case 'c': 
                case 'h': 
                case 'k': 
                case 's': {
                    int n2 = i + 1;
                    i += 2;
                    while (i < n) {
                        if (!Character.isLetterOrDigit(string.charAt(i))) {
                            String string2 = string.substring(n2, i).toLowerCase(Locale.ENGLISH);
                            if (!tagsUseFontSizeSet.contains(string2)) continue block3;
                            return true;
                        }
                        ++i;
                    }
                    continue block3;
                }
            }
        }
        return false;
    }

    static Graphics createGraphicsHTMLTextYCorrection(Graphics graphics, JComponent jComponent) {
        return jComponent.getClientProperty("html") != null ? HiDPIUtils.createGraphicsTextYCorrection((Graphics2D)graphics) : graphics;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(FlatLabelUI.createGraphicsHTMLTextYCorrection(graphics, jComponent), jComponent);
    }

    @Override
    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        int n3 = FlatLaf.isShowMnemonics() ? jLabel.getDisplayedMnemonicIndex() : -1;
        graphics.setColor(jLabel.getForeground());
        FlatUIUtils.drawStringUnderlineCharAt(jLabel, graphics, string, n3, n, n2);
    }

    @Override
    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        int n3 = FlatLaf.isShowMnemonics() ? jLabel.getDisplayedMnemonicIndex() : -1;
        graphics.setColor(this.disabledForeground);
        FlatUIUtils.drawStringUnderlineCharAt(jLabel, graphics, string, n3, n, n2);
    }

    @Override
    protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        return SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, UIScale.scale(jLabel.getIconTextGap()));
    }
}

