/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;

public class FlatLineBorder
extends FlatEmptyBorder {
    private final Color lineColor;
    private final float lineThickness;
    private final int arc;

    public FlatLineBorder(Insets insets, Color color) {
        this(insets, color, 1.0f, 0);
    }

    public FlatLineBorder(Insets insets, Color color, float f, int n) {
        super(insets);
        this.lineColor = color;
        this.lineThickness = f;
        this.arc = n;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public float getLineThickness() {
        return this.lineThickness;
    }

    public int getArc() {
        return this.arc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (component instanceof JComponent && ((JComponent)component).getClientProperty("FlatLaf.internal.FlatPopupFactory.popupUsesNativeBorder") != null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints(graphics2D);
            FlatUIUtils.paintOutlinedComponent(graphics2D, n, n2, n3, n4, 0.0f, 0.0f, 0.0f, UIScale.scale(this.getLineThickness()), UIScale.scale(this.getArc()), null, this.getLineColor(), null);
        }
        finally {
            graphics2D.dispose();
        }
    }
}

