/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatArrowButton;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class FlatSpinnerUI
extends BasicSpinnerUI
implements FlatStylingSupport.StyleableUI {
    private Handler handler;
    @FlatStylingSupport.Styleable
    protected int minimumWidth;
    @FlatStylingSupport.Styleable
    protected String buttonStyle;
    @FlatStylingSupport.Styleable
    protected String arrowType;
    @FlatStylingSupport.Styleable
    protected Color disabledBackground;
    @FlatStylingSupport.Styleable
    protected Color disabledForeground;
    @FlatStylingSupport.Styleable
    protected Color focusedBackground;
    @FlatStylingSupport.Styleable
    protected Color buttonBackground;
    @FlatStylingSupport.Styleable
    protected float buttonSeparatorWidth;
    @FlatStylingSupport.Styleable
    protected Color buttonSeparatorColor;
    @FlatStylingSupport.Styleable
    protected Color buttonDisabledSeparatorColor;
    @FlatStylingSupport.Styleable
    protected Color buttonArrowColor;
    @FlatStylingSupport.Styleable
    protected Color buttonDisabledArrowColor;
    @FlatStylingSupport.Styleable
    protected Color buttonHoverArrowColor;
    @FlatStylingSupport.Styleable
    protected Color buttonPressedArrowColor;
    @FlatStylingSupport.Styleable
    protected Insets padding;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;
    private static final int MAC_STEPPER_WIDTH = 15;
    private static final int MAC_STEPPER_GAP = 3;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatSpinnerUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.spinner, "opaque", false);
        this.minimumWidth = UIManager.getInt("Component.minimumWidth");
        this.buttonStyle = UIManager.getString("Spinner.buttonStyle");
        this.arrowType = UIManager.getString("Component.arrowType");
        this.disabledBackground = UIManager.getColor("Spinner.disabledBackground");
        this.disabledForeground = UIManager.getColor("Spinner.disabledForeground");
        this.focusedBackground = UIManager.getColor("Spinner.focusedBackground");
        this.buttonBackground = UIManager.getColor("Spinner.buttonBackground");
        this.buttonSeparatorWidth = FlatUIUtils.getUIFloat("Spinner.buttonSeparatorWidth", FlatUIUtils.getUIFloat("Component.borderWidth", 1.0f));
        this.buttonSeparatorColor = UIManager.getColor("Spinner.buttonSeparatorColor");
        this.buttonDisabledSeparatorColor = UIManager.getColor("Spinner.buttonDisabledSeparatorColor");
        this.buttonArrowColor = UIManager.getColor("Spinner.buttonArrowColor");
        this.buttonDisabledArrowColor = UIManager.getColor("Spinner.buttonDisabledArrowColor");
        this.buttonHoverArrowColor = UIManager.getColor("Spinner.buttonHoverArrowColor");
        this.buttonPressedArrowColor = UIManager.getColor("Spinner.buttonPressedArrowColor");
        this.padding = UIManager.getInsets("Spinner.padding");
        MigLayoutVisualPadding.install(this.spinner);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.disabledBackground = null;
        this.disabledForeground = null;
        this.focusedBackground = null;
        this.buttonBackground = null;
        this.buttonSeparatorColor = null;
        this.buttonDisabledSeparatorColor = null;
        this.buttonArrowColor = null;
        this.buttonDisabledArrowColor = null;
        this.buttonHoverArrowColor = null;
        this.buttonPressedArrowColor = null;
        this.padding = null;
        this.oldStyleValues = null;
        this.borderShared = null;
        MigLayoutVisualPadding.uninstall(this.spinner);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.addEditorFocusListener(this.spinner.getEditor());
        this.spinner.addFocusListener(this.getHandler());
        this.spinner.addPropertyChangeListener(this.getHandler());
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.removeEditorFocusListener(this.spinner.getEditor());
        this.spinner.removeFocusListener(this.getHandler());
        this.spinner.removePropertyChangeListener(this.getHandler());
        this.handler = null;
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.spinner, "Spinner"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        this.updateEditorPadding();
        this.updateArrowButtonsStyle();
    }

    protected Object applyStyleProperty(String string, Object object) {
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, string, object, this.spinner, this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this, this.spinner.getBorder());
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, this.spinner.getBorder(), string);
    }

    @Override
    protected JComponent createEditor() {
        JComponent jComponent = super.createEditor();
        this.configureEditor(jComponent);
        return jComponent;
    }

    @Override
    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        super.replaceEditor(jComponent, jComponent2);
        this.configureEditor(jComponent2);
        this.removeEditorFocusListener(jComponent);
        this.addEditorFocusListener(jComponent2);
    }

    protected void configureEditor(JComponent jComponent) {
        jComponent.setOpaque(false);
        JTextField jTextField = FlatSpinnerUI.getEditorTextField(jComponent);
        if (jTextField != null) {
            jTextField.setOpaque(false);
        }
        this.updateEditorPadding();
        this.updateEditorColors();
    }

    private void addEditorFocusListener(JComponent jComponent) {
        JTextField jTextField = FlatSpinnerUI.getEditorTextField(jComponent);
        if (jTextField != null) {
            jTextField.addFocusListener(this.getHandler());
        }
    }

    private void removeEditorFocusListener(JComponent jComponent) {
        JTextField jTextField = FlatSpinnerUI.getEditorTextField(jComponent);
        if (jTextField != null) {
            jTextField.removeFocusListener(this.getHandler());
        }
    }

    private void updateEditorPadding() {
        JTextField jTextField = FlatSpinnerUI.getEditorTextField(this.spinner.getEditor());
        if (jTextField != null) {
            jTextField.putClientProperty("JTextField.padding", this.padding);
        }
    }

    private void updateEditorColors() {
        JTextField jTextField = FlatSpinnerUI.getEditorTextField(this.spinner.getEditor());
        if (jTextField != null) {
            jTextField.setForeground(FlatUIUtils.nonUIResource(this.getForeground(true)));
            jTextField.setDisabledTextColor(FlatUIUtils.nonUIResource(this.getForeground(false)));
        }
    }

    private static JTextField getEditorTextField(JComponent jComponent) {
        return jComponent instanceof JSpinner.DefaultEditor ? ((JSpinner.DefaultEditor)jComponent).getTextField() : null;
    }

    public static boolean isPermanentFocusOwner(JSpinner jSpinner) {
        if (FlatUIUtils.isPermanentFocusOwner(jSpinner)) {
            return true;
        }
        JTextField jTextField = FlatSpinnerUI.getEditorTextField(jSpinner.getEditor());
        return jTextField != null && FlatUIUtils.isPermanentFocusOwner(jTextField);
    }

    protected Color getBackground(boolean bl) {
        if (bl) {
            Color color = this.spinner.getBackground();
            if (!(color instanceof UIResource)) {
                return color;
            }
            if (this.focusedBackground != null && FlatSpinnerUI.isPermanentFocusOwner(this.spinner)) {
                return this.focusedBackground;
            }
            return color;
        }
        return this.disabledBackground;
    }

    protected Color getForeground(boolean bl) {
        return bl ? this.spinner.getForeground() : this.disabledForeground;
    }

    @Override
    protected LayoutManager createLayout() {
        return this.getHandler();
    }

    @Override
    protected Component createNextButton() {
        return this.createArrowButton(1, "Spinner.nextButton");
    }

    @Override
    protected Component createPreviousButton() {
        return this.createArrowButton(5, "Spinner.previousButton");
    }

    private Component createArrowButton(int n, String string) {
        FlatArrowButton flatArrowButton = new FlatArrowButton(n, this.arrowType, this.buttonArrowColor, this.buttonDisabledArrowColor, this.buttonHoverArrowColor, null, this.buttonPressedArrowColor, null){

            @Override
            public int getArrowWidth() {
                return FlatSpinnerUI.this.isMacStyle() ? 7 : super.getArrowWidth();
            }

            @Override
            public float getArrowThickness() {
                return FlatSpinnerUI.this.isMacStyle() ? 1.5f : super.getArrowThickness();
            }

            @Override
            public float getYOffset() {
                return FlatSpinnerUI.this.isMacStyle() ? 0.0f : super.getYOffset();
            }

            @Override
            public boolean isRoundBorderAutoXOffset() {
                return FlatSpinnerUI.this.isMacStyle() ? false : super.isRoundBorderAutoXOffset();
            }
        };
        flatArrowButton.setName(string);
        flatArrowButton.setYOffset(n == 1 ? 1.25f : -1.25f);
        if (n == 1) {
            this.installNextButtonListeners(flatArrowButton);
        } else {
            this.installPreviousButtonListeners(flatArrowButton);
        }
        return flatArrowButton;
    }

    private void updateArrowButtonsStyle() {
        for (Component component : this.spinner.getComponents()) {
            if (!(component instanceof FlatArrowButton)) continue;
            ((FlatArrowButton)component).updateStyle(this.arrowType, this.buttonArrowColor, this.buttonDisabledArrowColor, this.buttonHoverArrowColor, null, this.buttonPressedArrowColor, null);
        }
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        float f = FlatUIUtils.getBorderFocusWidth(jComponent);
        float f2 = FlatUIUtils.getBorderArc(jComponent);
        if (jComponent.isOpaque() && (f > 0.0f || f2 > 0.0f)) {
            FlatUIUtils.paintParentBackground(graphics, jComponent);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object[] objectArray = FlatUIUtils.setRenderingHints(graphics2D);
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        boolean bl = this.spinner.isEnabled();
        boolean bl2 = this.spinner.getComponentOrientation().isLeftToRight();
        boolean bl3 = this.isMacStyle();
        int n3 = bl3 ? this.getMacStyleButtonsWidth() : 0;
        graphics2D.setColor(this.getBackground(bl));
        FlatUIUtils.paintComponentBackground(graphics2D, bl2 ? 0 : n3, 0, n - n3, n2, f, f2);
        boolean bl4 = !"none".equals(this.buttonStyle);
        Handler handler = this.getHandler();
        if (bl4 && (handler.nextButton != null || handler.previousButton != null)) {
            Color color;
            Component component = handler.nextButton != null ? handler.nextButton : handler.previousButton;
            int n4 = component.getX();
            int n5 = component.getWidth();
            Color color2 = color = bl ? this.buttonSeparatorColor : this.buttonDisabledSeparatorColor;
            if (bl3) {
                Insets insets = this.spinner.getInsets();
                int n6 = Math.round(FlatUIUtils.getBorderLineWidth(this.spinner));
                int n7 = n4;
                int n8 = insets.top - n6;
                int n9 = n5;
                int n10 = n2 - insets.top - insets.bottom + n6 * 2;
                float f3 = UIScale.scale(this.buttonSeparatorWidth);
                FlatUIUtils.paintOutlinedComponent(graphics2D, n7, n8, n9, n10, 0.0f, 0.0f, 0.0f, f3, UIScale.scale(12), null, color, this.buttonBackground);
                if (color != null) {
                    int n11 = UIScale.scale(1);
                    graphics2D.setColor(color);
                    graphics2D.fill(new Rectangle2D.Float((float)n7 + f3, (float)n8 + (float)(n10 - n11) / 2.0f, (float)n9 - f3 * 2.0f, n11));
                }
            } else {
                if (bl && this.buttonBackground != null) {
                    graphics2D.setColor(this.buttonBackground);
                    Shape shape = graphics2D.getClip();
                    if (bl2) {
                        graphics2D.clipRect(n4, 0, n - n4, n2);
                    } else {
                        graphics2D.clipRect(0, 0, n4 + n5, n2);
                    }
                    FlatUIUtils.paintComponentBackground(graphics2D, 0, 0, n, n2, f, f2);
                    graphics2D.setClip(shape);
                }
                if (color != null && this.buttonSeparatorWidth > 0.0f) {
                    graphics2D.setColor(color);
                    float f4 = UIScale.scale(this.buttonSeparatorWidth);
                    float f5 = bl2 ? (float)n4 : (float)(n4 + n5) - f4;
                    graphics2D.fill(new Rectangle2D.Float(f5, f, f4, (float)(n2 - 1) - f * 2.0f));
                }
            }
        }
        this.paint(graphics, jComponent);
        FlatUIUtils.resetRenderingHints(graphics, objectArray);
    }

    boolean isMacStyle() {
        return "mac".equals(this.buttonStyle);
    }

    int getMacStyleButtonsWidth() {
        return this.handler.nextButton != null || this.handler.previousButton != null ? UIScale.scale(3) + UIScale.scale(15) : 0;
    }

    private class Handler
    implements LayoutManager,
    FocusListener,
    PropertyChangeListener {
        private Component editor = null;
        private Component nextButton;
        private Component previousButton;

        private Handler() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            switch (string) {
                case "Editor": {
                    this.editor = component;
                    break;
                }
                case "Next": {
                    this.nextButton = component;
                    break;
                }
                case "Previous": {
                    this.previousButton = component;
                }
            }
        }

        @Override
        public void removeLayoutComponent(Component component) {
            if (component == this.editor) {
                this.editor = null;
            } else if (component == this.nextButton) {
                this.nextButton = null;
            } else if (component == this.previousButton) {
                this.previousButton = null;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Insets insets = container.getInsets();
            Insets insets2 = UIScale.scale(FlatSpinnerUI.this.padding);
            Dimension dimension = this.editor != null ? this.editor.getPreferredSize() : new Dimension(0, 0);
            int n = FlatUIUtils.minimumWidth(FlatSpinnerUI.this.spinner, FlatSpinnerUI.this.minimumWidth);
            int n2 = dimension.height + insets2.top + insets2.bottom;
            float f = FlatUIUtils.getBorderFocusWidth(FlatSpinnerUI.this.spinner);
            return new Dimension(Math.max(insets.left + insets.right + dimension.width + insets2.left + insets2.right + n2, UIScale.scale(n) + Math.round(f * 2.0f)), insets.top + insets.bottom + n2);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            int n2;
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            Rectangle rectangle = FlatUIUtils.subtractInsets(new Rectangle(dimension), insets);
            if (this.nextButton == null && this.previousButton == null) {
                if (this.editor != null) {
                    this.editor.setBounds(rectangle);
                }
                return;
            }
            Rectangle rectangle2 = new Rectangle(rectangle);
            Rectangle rectangle3 = new Rectangle(rectangle);
            FontMetrics fontMetrics = FlatSpinnerUI.this.spinner.getFontMetrics(FlatSpinnerUI.this.spinner.getFont());
            int n3 = fontMetrics.getHeight() + UIScale.scale(FlatSpinnerUI.this.padding.top) + UIScale.scale(FlatSpinnerUI.this.padding.bottom);
            int n4 = n3 * 3 / 4;
            boolean bl = FlatSpinnerUI.this.isMacStyle();
            int n5 = bl ? UIScale.scale(3) : 0;
            int n6 = bl ? UIScale.scale(15) : rectangle3.height;
            rectangle3.width = n2 = Math.min(Math.max(n6, n4), n3);
            rectangle2.width -= n2 + n5;
            boolean bl2 = container.getComponentOrientation().isLeftToRight();
            if (bl2) {
                rectangle3.x += rectangle2.width + n5;
            } else {
                rectangle2.x += n2 + n5;
            }
            if (bl && (n = Math.round(FlatUIUtils.getBorderLineWidth(FlatSpinnerUI.this.spinner))) > 0) {
                rectangle3.x = rectangle3.x + (bl2 ? n : -n);
                rectangle3.y -= n;
                rectangle3.height += n * 2;
            }
            if (this.editor != null) {
                this.editor.setBounds(rectangle2);
            }
            n = rectangle3.height / 2 + rectangle3.height % 2;
            if (this.nextButton != null) {
                this.nextButton.setBounds(rectangle3.x, rectangle3.y, rectangle3.width, n);
            }
            if (this.previousButton != null) {
                int n7 = rectangle3.y + rectangle3.height - n;
                this.previousButton.setBounds(rectangle3.x, n7, rectangle3.width, n);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            JTextField jTextField;
            FlatSpinnerUI.this.spinner.repaint();
            if (focusEvent.getComponent() == FlatSpinnerUI.this.spinner && (jTextField = FlatSpinnerUI.getEditorTextField(FlatSpinnerUI.this.spinner.getEditor())) != null) {
                jTextField.requestFocusInWindow();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            FlatSpinnerUI.this.spinner.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            switch (propertyChangeEvent.getPropertyName()) {
                case "foreground": 
                case "enabled": {
                    FlatSpinnerUI.this.updateEditorColors();
                    break;
                }
                case "JComponent.roundRect": 
                case "JComponent.outline": {
                    FlatSpinnerUI.this.spinner.repaint();
                    break;
                }
                case "JComponent.minimumWidth": {
                    FlatSpinnerUI.this.spinner.revalidate();
                    break;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    FlatSpinnerUI.this.installStyle();
                    FlatSpinnerUI.this.spinner.revalidate();
                    FlatSpinnerUI.this.spinner.repaint();
                }
            }
        }
    }
}

