/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatMarginBorder;
import com.formdev.flatlaf.ui.FlatToolBarUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.function.Function;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ToolBarUI;

public class FlatToolBarBorder
extends FlatMarginBorder {
    private static final int DOT_COUNT = 4;
    private static final int DOT_SIZE = 2;
    private static final int GRIP_SIZE = 6;
    protected Color gripColor = UIManager.getColor("ToolBar.gripColor");

    public FlatToolBarBorder() {
        super(UIManager.getInsets("ToolBar.borderMargins"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (component instanceof JToolBar && ((JToolBar)component).isFloatable()) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                FlatUIUtils.setRenderingHints(graphics2D);
                Color color = FlatToolBarBorder.getStyleFromToolBarUI(component, flatToolBarUI -> flatToolBarUI.gripColor);
                graphics2D.setColor(color != null ? color : this.gripColor);
                this.paintGrip(component, graphics2D, n, n2, n3, n4);
            }
            finally {
                graphics2D.dispose();
            }
        }
    }

    protected void paintGrip(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.calculateGripBounds(component, n, n2, n3, n4);
        FlatUIUtils.paintGrip(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, ((JToolBar)component).getOrientation() == 1, 4, 2, 2, false);
    }

    protected Rectangle calculateGripBounds(Component component, int n, int n2, int n3, int n4) {
        Insets insets = super.getBorderInsets(component, new Insets(0, 0, 0, 0));
        Rectangle rectangle = FlatUIUtils.subtractInsets(new Rectangle(n, n2, n3, n4), insets);
        int n5 = UIScale.scale(6);
        if (((JToolBar)component).getOrientation() == 0) {
            if (!component.getComponentOrientation().isLeftToRight()) {
                rectangle.x = rectangle.x + rectangle.width - n5;
            }
            rectangle.width = n5;
        } else {
            rectangle.height = n5;
        }
        return rectangle;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        int n;
        Insets insets2 = FlatToolBarBorder.getStyleFromToolBarUI(component, flatToolBarUI -> flatToolBarUI.borderMargins);
        if (insets2 != null) {
            n = this.top;
            int n2 = this.left;
            int n3 = this.bottom;
            int n4 = this.right;
            this.top = insets2.top;
            this.left = insets2.left;
            this.bottom = insets2.bottom;
            this.right = insets2.right;
            insets = super.getBorderInsets(component, insets);
            this.top = n;
            this.left = n2;
            this.bottom = n3;
            this.right = n4;
        } else {
            insets = super.getBorderInsets(component, insets);
        }
        if (component instanceof JToolBar && ((JToolBar)component).isFloatable()) {
            n = UIScale.scale(6);
            if (((JToolBar)component).getOrientation() == 0) {
                if (component.getComponentOrientation().isLeftToRight()) {
                    insets.left += n;
                } else {
                    insets.right += n;
                }
            } else {
                insets.top += n;
            }
        }
        return insets;
    }

    static <T> T getStyleFromToolBarUI(Component component, Function<FlatToolBarUI, T> function) {
        ToolBarUI toolBarUI;
        if (component instanceof JToolBar && (toolBarUI = ((JToolBar)component).getUI()) instanceof FlatToolBarUI) {
            return function.apply((FlatToolBarUI)toolBarUI);
        }
        return null;
    }
}

