/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.Animator;
import com.formdev.flatlaf.util.CubicBezierEasing;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;

public interface AnimatedIcon
extends Icon {
    @Override
    default public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        AnimationSupport.paintIcon(this, component, graphics, n, n2);
    }

    public void paintIconAnimated(Component var1, Graphics var2, int var3, int var4, float var5);

    public float getValue(Component var1);

    default public boolean isAnimationEnabled() {
        return true;
    }

    default public int getAnimationDuration() {
        return 150;
    }

    default public int getAnimationResolution() {
        return 10;
    }

    default public Animator.Interpolator getAnimationInterpolator() {
        return CubicBezierEasing.STANDARD_EASING;
    }

    default public Object getClientPropertyKey() {
        return this.getClass();
    }

    public static class AnimationSupport {
        private float startValue;
        private float targetValue;
        private float animatedValue;
        private float fraction;
        private Animator animator;
        private int x;
        private int y;

        public static void paintIcon(AnimatedIcon animatedIcon, Component component, Graphics graphics, int n, int n2) {
            if (!AnimationSupport.isAnimationEnabled(animatedIcon, component)) {
                AnimationSupport.paintIconImpl(animatedIcon, component, graphics, n, n2, null);
                return;
            }
            JComponent jComponent = (JComponent)component;
            Object object = animatedIcon.getClientPropertyKey();
            AnimationSupport animationSupport = (AnimationSupport)jComponent.getClientProperty(object);
            if (animationSupport == null) {
                animationSupport = new AnimationSupport();
                animationSupport.targetValue = animationSupport.animatedValue = animatedIcon.getValue(component);
                animationSupport.startValue = animationSupport.animatedValue;
                animationSupport.x = n;
                animationSupport.y = n2;
                jComponent.putClientProperty(object, animationSupport);
            } else {
                float f2 = animatedIcon.getValue(component);
                if (f2 != animationSupport.targetValue) {
                    if (animationSupport.animator == null) {
                        AnimationSupport animationSupport2 = animationSupport;
                        animationSupport.animator = new Animator(animatedIcon.getAnimationDuration(), f -> {
                            if (!component.isDisplayable()) {
                                animationSupport.animator.stop();
                                return;
                            }
                            animationSupport.animatedValue = animationSupport.startValue + (animationSupport.targetValue - animationSupport.startValue) * f;
                            animationSupport.fraction = f;
                            component.repaint(animationSupport.x, animationSupport.y, animatedIcon.getIconWidth(), animatedIcon.getIconHeight());
                        }, () -> {
                            animationSupport.startValue = animationSupport.animatedValue = animationSupport.targetValue;
                            animationSupport.animator = null;
                        });
                    }
                    if (animationSupport.animator.isRunning()) {
                        animationSupport.animator.cancel();
                        int n3 = (int)((float)animatedIcon.getAnimationDuration() * animationSupport.fraction);
                        if (n3 > 0) {
                            animationSupport.animator.setDuration(n3);
                        }
                        animationSupport.startValue = animationSupport.animatedValue;
                    } else {
                        animationSupport.animator.setDuration(animatedIcon.getAnimationDuration());
                        animationSupport.animator.setResolution(animatedIcon.getAnimationResolution());
                        animationSupport.animator.setInterpolator(animatedIcon.getAnimationInterpolator());
                        animationSupport.animatedValue = animationSupport.startValue;
                    }
                    animationSupport.targetValue = f2;
                    animationSupport.animator.start();
                }
                animationSupport.x = n;
                animationSupport.y = n2;
            }
            AnimationSupport.paintIconImpl(animatedIcon, component, graphics, n, n2, animationSupport);
        }

        private static void paintIconImpl(AnimatedIcon animatedIcon, Component component, Graphics graphics, int n, int n2, AnimationSupport animationSupport) {
            float f = animationSupport != null ? animationSupport.animatedValue : animatedIcon.getValue(component);
            animatedIcon.paintIconAnimated(component, graphics, n, n2, f);
        }

        private static boolean isAnimationEnabled(AnimatedIcon animatedIcon, Component component) {
            return Animator.useAnimation() && animatedIcon.isAnimationEnabled() && component instanceof JComponent;
        }

        public static void saveIconLocation(AnimatedIcon animatedIcon, Component component, int n, int n2) {
            if (!AnimationSupport.isAnimationEnabled(animatedIcon, component)) {
                return;
            }
            AnimationSupport animationSupport = (AnimationSupport)((JComponent)component).getClientProperty(animatedIcon.getClientPropertyKey());
            if (animationSupport != null) {
                animationSupport.x = n;
                animationSupport.y = n2;
            }
        }
    }
}

