/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.grid;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.snapping.LazyGridSnapLayoutInfoProviderKt;
import androidx.compose.foundation.lazy.grid.LazyGridItemInfo;
import androidx.compose.foundation.lazy.grid.LazyGridLayoutInfo;
import androidx.compose.foundation.lazy.grid.LazyGridPrefetchScope;
import androidx.compose.foundation.lazy.grid.LazyGridPrefetchStrategy;
import androidx.compose.foundation.lazy.layout.LazyLayoutPrefetchState;
import androidx.compose.foundation.lazy.layout.NestedPrefetchScope;
import androidx.compose.runtime.collection.MutableVector;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0016\u001a\u00020\u0010*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u001c\u0010\u0019\u001a\u00020\u0010*\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0014\u0010\u001c\u001a\u00020\u0003*\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0014\u0010\u001d\u001a\u00020\u0003*\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\b\u0010\u001e\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/compose/foundation/lazy/grid/DefaultLazyGridPrefetchStrategy;", "Landroidx/compose/foundation/lazy/grid/LazyGridPrefetchStrategy;", "initialNestedPrefetchItemCount", "", "<init>", "(I)V", "lineToPrefetch", "currentLinePrefetchHandles", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState$PrefetchHandle;", "wasScrollingForward", "", "previousPassItemCount", "previousPassDelta", "", "onScroll", "", "Landroidx/compose/foundation/lazy/grid/LazyGridPrefetchScope;", "delta", "layoutInfo", "Landroidx/compose/foundation/lazy/grid/LazyGridLayoutInfo;", "onVisibleItemsUpdated", "onNestedPrefetch", "Landroidx/compose/foundation/lazy/layout/NestedPrefetchScope;", "firstVisibleItemIndex", "evaluatePrefetchForCancellation", "currentPrefetchingLineIndex", "scrollingForward", "calculateLineIndexToPrefetch", "calculateClosestNextItemToPrefetch", "resetPrefetchState", "foundation"})
final class DefaultLazyGridPrefetchStrategy
implements LazyGridPrefetchStrategy {
    private final int initialNestedPrefetchItemCount;
    private int lineToPrefetch;
    private final MutableVector<LazyLayoutPrefetchState.PrefetchHandle> currentLinePrefetchHandles;
    private boolean wasScrollingForward;
    private int previousPassItemCount;
    private float previousPassDelta;

    public DefaultLazyGridPrefetchStrategy(int n2) {
        this.initialNestedPrefetchItemCount = n2;
        this.lineToPrefetch = -1;
        boolean bl = false;
        int n3 = 16;
        boolean bl2 = false;
        this.currentLinePrefetchHandles = new MutableVector((Object[])new LazyLayoutPrefetchState.PrefetchHandle[n3], 0);
        this.previousPassItemCount = -1;
    }

    public /* synthetic */ DefaultLazyGridPrefetchStrategy(int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n2 = 2;
        }
        this(n2);
    }

    @Override
    public void onScroll(LazyGridPrefetchScope lazyGridPrefetchScope, float f2, LazyGridLayoutInfo lazyGridLayoutInfo) {
        Intrinsics.checkNotNullParameter((Object)lazyGridPrefetchScope, (String)"");
        Intrinsics.checkNotNullParameter((Object)lazyGridLayoutInfo, (String)"");
        if (!((Collection)lazyGridLayoutInfo.getVisibleItemsInfo()).isEmpty()) {
            boolean bl = f2 < 0.0f;
            int n2 = this.calculateLineIndexToPrefetch(lazyGridLayoutInfo, bl);
            int n3 = this.calculateClosestNextItemToPrefetch(lazyGridLayoutInfo, bl);
            boolean bl2 = 0 <= n3 ? n3 < lazyGridLayoutInfo.getTotalItemsCount() : false;
            if (bl2) {
                int n4;
                Object[] objectArray;
                int n5;
                int n6;
                MutableVector<LazyLayoutPrefetchState.PrefetchHandle> mutableVector;
                if (n2 != this.lineToPrefetch && n2 >= 0) {
                    if (this.wasScrollingForward != bl) {
                        mutableVector = this.currentLinePrefetchHandles;
                        boolean bl3 = false;
                        Object[] objectArray2 = mutableVector.content;
                        n6 = mutableVector.getSize();
                        for (n5 = 0; n5 < n6; ++n5) {
                            objectArray = (Object[])objectArray2[n5];
                            n4 = 0;
                            objectArray.cancel();
                        }
                    }
                    this.wasScrollingForward = bl;
                    this.lineToPrefetch = n2;
                    this.currentLinePrefetchHandles.clear();
                    mutableVector = this.currentLinePrefetchHandles;
                    List<LazyLayoutPrefetchState.PrefetchHandle> list = lazyGridPrefetchScope.scheduleLinePrefetch(n2);
                    n5 = 0;
                    mutableVector.addAll(mutableVector.getSize(), list);
                }
                if (bl) {
                    mutableVector = (MutableVector<LazyLayoutPrefetchState.PrefetchHandle>)CollectionsKt.last(lazyGridLayoutInfo.getVisibleItemsInfo());
                    int n7 = LazyGridSnapLayoutInfoProviderKt.sizeOnMainAxis(mutableVector, lazyGridLayoutInfo.getOrientation());
                    n5 = lazyGridLayoutInfo.getMainAxisItemSpacing();
                    int n8 = LazyGridSnapLayoutInfoProviderKt.offsetOnMainAxis(mutableVector, lazyGridLayoutInfo.getOrientation()) + n7 + n5 - lazyGridLayoutInfo.getViewportEndOffset();
                    if ((float)n8 < -f2) {
                        MutableVector<LazyLayoutPrefetchState.PrefetchHandle> mutableVector2 = this.currentLinePrefetchHandles;
                        boolean bl4 = false;
                        Object[] objectArray3 = mutableVector2.content;
                        int n9 = mutableVector2.getSize();
                        for (n4 = 0; n4 < n9; ++n4) {
                            LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = (LazyLayoutPrefetchState.PrefetchHandle)objectArray3[n4];
                            boolean bl5 = false;
                            prefetchHandle.markAsUrgent();
                        }
                    }
                } else {
                    mutableVector = (LazyGridItemInfo)CollectionsKt.first(lazyGridLayoutInfo.getVisibleItemsInfo());
                    int n10 = lazyGridLayoutInfo.getViewportStartOffset() - LazyGridSnapLayoutInfoProviderKt.offsetOnMainAxis(mutableVector, lazyGridLayoutInfo.getOrientation());
                    if ((float)n10 < f2) {
                        MutableVector<LazyLayoutPrefetchState.PrefetchHandle> mutableVector3 = this.currentLinePrefetchHandles;
                        boolean bl6 = false;
                        objectArray = mutableVector3.content;
                        n4 = mutableVector3.getSize();
                        for (n6 = 0; n6 < n4; ++n6) {
                            LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = (LazyLayoutPrefetchState.PrefetchHandle)objectArray[n6];
                            boolean bl7 = false;
                            prefetchHandle.markAsUrgent();
                        }
                    }
                }
            }
        }
        this.previousPassDelta = f2;
    }

    @Override
    public void onVisibleItemsUpdated(LazyGridPrefetchScope lazyGridPrefetchScope, LazyGridLayoutInfo lazyGridLayoutInfo) {
        Intrinsics.checkNotNullParameter((Object)lazyGridPrefetchScope, (String)"");
        Intrinsics.checkNotNullParameter((Object)lazyGridLayoutInfo, (String)"");
        this.evaluatePrefetchForCancellation(lazyGridLayoutInfo, this.lineToPrefetch, this.wasScrollingForward);
        int n2 = lazyGridLayoutInfo.getTotalItemsCount();
        if (this.previousPassItemCount != -1 && !(this.previousPassDelta == 0.0f) && this.previousPassItemCount != n2 && !((Collection)lazyGridLayoutInfo.getVisibleItemsInfo()).isEmpty()) {
            int n3 = this.calculateLineIndexToPrefetch(lazyGridLayoutInfo, this.previousPassDelta < 0.0f);
            int n4 = this.calculateClosestNextItemToPrefetch(lazyGridLayoutInfo, this.previousPassDelta < 0.0f);
            boolean bl = 0 <= n4 ? n4 < lazyGridLayoutInfo.getTotalItemsCount() : false;
            if (bl && n3 != this.lineToPrefetch && n3 >= 0) {
                this.lineToPrefetch = n3;
                this.currentLinePrefetchHandles.clear();
                MutableVector<LazyLayoutPrefetchState.PrefetchHandle> mutableVector = this.currentLinePrefetchHandles;
                List<LazyLayoutPrefetchState.PrefetchHandle> list = lazyGridPrefetchScope.scheduleLinePrefetch(n3);
                boolean bl2 = false;
                mutableVector.addAll(mutableVector.getSize(), list);
            }
        }
        this.previousPassItemCount = n2;
    }

    @Override
    public void onNestedPrefetch(NestedPrefetchScope nestedPrefetchScope, int n2) {
        Intrinsics.checkNotNullParameter((Object)nestedPrefetchScope, (String)"");
        int n3 = nestedPrefetchScope.getNestedPrefetchItemCount() == -1 ? this.initialNestedPrefetchItemCount : nestedPrefetchScope.getNestedPrefetchItemCount();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n4++;
            boolean bl = false;
            nestedPrefetchScope.schedulePrecomposition(n2 + n5);
        }
    }

    private final void evaluatePrefetchForCancellation(LazyGridLayoutInfo lazyGridLayoutInfo, int n2, boolean bl) {
        int n3;
        if (n2 != -1 && !((Collection)lazyGridLayoutInfo.getVisibleItemsInfo()).isEmpty() && n2 != (n3 = this.calculateLineIndexToPrefetch(lazyGridLayoutInfo, bl))) {
            this.resetPrefetchState();
        }
    }

    private final int calculateLineIndexToPrefetch(LazyGridLayoutInfo lazyGridLayoutInfo, boolean bl) {
        int n2;
        if (bl) {
            LazyGridItemInfo lazyGridItemInfo = (LazyGridItemInfo)CollectionsKt.last(lazyGridLayoutInfo.getVisibleItemsInfo());
            boolean bl2 = false;
            n2 = (lazyGridLayoutInfo.getOrientation() == Orientation.Vertical ? lazyGridItemInfo.getRow() : lazyGridItemInfo.getColumn()) + 1;
        } else {
            LazyGridItemInfo lazyGridItemInfo = (LazyGridItemInfo)CollectionsKt.first(lazyGridLayoutInfo.getVisibleItemsInfo());
            boolean bl3 = false;
            n2 = (lazyGridLayoutInfo.getOrientation() == Orientation.Vertical ? lazyGridItemInfo.getRow() : lazyGridItemInfo.getColumn()) - 1;
        }
        return n2;
    }

    private final int calculateClosestNextItemToPrefetch(LazyGridLayoutInfo lazyGridLayoutInfo, boolean bl) {
        return bl ? ((LazyGridItemInfo)CollectionsKt.last(lazyGridLayoutInfo.getVisibleItemsInfo())).getIndex() + 1 : ((LazyGridItemInfo)CollectionsKt.first(lazyGridLayoutInfo.getVisibleItemsInfo())).getIndex() - 1;
    }

    private final void resetPrefetchState() {
        this.lineToPrefetch = -1;
        MutableVector<LazyLayoutPrefetchState.PrefetchHandle> mutableVector = this.currentLinePrefetchHandles;
        boolean bl = false;
        Object[] objectArray = mutableVector.content;
        int n2 = mutableVector.getSize();
        for (int k = 0; k < n2; ++k) {
            LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = (LazyLayoutPrefetchState.PrefetchHandle)objectArray[k];
            boolean bl2 = false;
            prefetchHandle.cancel();
        }
        this.currentLinePrefetchHandles.clear();
    }

    public DefaultLazyGridPrefetchStrategy() {
        this(0, 1, null);
    }
}

