/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.text.input.internal.GapBuffer;
import androidx.compose.foundation.text.input.internal.ToCharArray_skikoKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J2\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0011\u001a\u00020\b2\b\b\u0002\u0010\u0012\u001a\u00020\bJ\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0096\u0002J\u0018\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Landroidx/compose/foundation/text/input/internal/PartialGapBuffer;", "", "text", "<init>", "(Ljava/lang/CharSequence;)V", "buffer", "Landroidx/compose/foundation/text/input/internal/GapBuffer;", "bufStart", "", "bufEnd", "length", "getLength", "()I", "replace", "", "start", "end", "textStart", "textEnd", "get", "", "index", "subSequence", "startIndex", "endIndex", "toString", "", "contentEquals", "", "other", "Companion", "foundation"})
public final class PartialGapBuffer
implements CharSequence {
    public static final Companion Companion = new Companion(null);
    private CharSequence text;
    private GapBuffer buffer;
    private int bufStart;
    private int bufEnd;
    public static final int $stable = 8;
    public static final int BUF_SIZE = 255;
    public static final int SURROUNDING_SIZE = 64;
    public static final int NOWHERE = -1;

    public PartialGapBuffer(CharSequence charSequence) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"");
        this.text = charSequence;
        this.bufStart = -1;
        this.bufEnd = -1;
    }

    public int getLength() {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text.length();
        }
        GapBuffer gapBuffer2 = gapBuffer;
        return this.text.length() - (this.bufEnd - this.bufStart) + gapBuffer2.length();
    }

    public final void replace(int n2, int n3, CharSequence charSequence, int n4, int n5) {
        int n6;
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"");
        boolean bl = n2 <= n3;
        int n7 = 0;
        if (!bl) {
            n6 = 0;
            InlineClassHelperKt.throwIllegalArgumentException("start=" + n2 + " > end=" + n3);
        }
        bl = n4 <= n5;
        n7 = 0;
        if (!bl) {
            n6 = 0;
            InlineClassHelperKt.throwIllegalArgumentException("textStart=" + n4 + " > textEnd=" + n5);
        }
        bl = n2 >= 0;
        n7 = 0;
        if (!bl) {
            n6 = 0;
            InlineClassHelperKt.throwIllegalArgumentException("start must be non-negative, but was " + n2);
        }
        bl = n4 >= 0;
        n7 = 0;
        if (!bl) {
            n6 = 0;
            InlineClassHelperKt.throwIllegalArgumentException("textStart must be non-negative, but was " + n4);
        }
        GapBuffer gapBuffer = this.buffer;
        n7 = n5 - n4;
        if (gapBuffer == null) {
            char[] cArray = new char[Math.max(255, n7 + 128)];
            int n8 = Math.min(n2, 64);
            int n9 = Math.min(this.text.length() - n3, 64);
            ToCharArray_skikoKt.toCharArray(this.text, cArray, 0, n2 - n8, n2);
            ToCharArray_skikoKt.toCharArray(this.text, cArray, cArray.length - n9, n3, n3 + n9);
            ToCharArray_skikoKt.toCharArray(charSequence, cArray, n8, n4, n5);
            this.buffer = new GapBuffer(cArray, n8 + n7, cArray.length - n9);
            this.bufStart = n2 - n8;
            this.bufEnd = n3 + n9;
            return;
        }
        n6 = n2 - this.bufStart;
        int n10 = n3 - this.bufStart;
        if (n6 < 0 || n10 > gapBuffer.length()) {
            this.text = this.toString();
            this.buffer = null;
            this.bufStart = -1;
            this.bufEnd = -1;
            this.replace(n2, n3, charSequence, n4, n5);
            return;
        }
        gapBuffer.replace(n6, n10, charSequence, n4, n5);
    }

    public static /* synthetic */ void replace$default(PartialGapBuffer partialGapBuffer, int n2, int n3, CharSequence charSequence, int n4, int n5, int n6, Object object) {
        if ((n6 & 8) != 0) {
            n4 = 0;
        }
        if ((n6 & 0x10) != 0) {
            n5 = charSequence.length();
        }
        partialGapBuffer.replace(n2, n3, charSequence, n4, n5);
    }

    public char get(int n2) {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text.charAt(n2);
        }
        GapBuffer gapBuffer2 = gapBuffer;
        if (n2 < this.bufStart) {
            return this.text.charAt(n2);
        }
        int n3 = gapBuffer2.length();
        if (n2 < n3 + this.bufStart) {
            return gapBuffer2.get(n2 - this.bufStart);
        }
        return this.text.charAt(n2 - (n3 - this.bufEnd + this.bufStart));
    }

    @Override
    public CharSequence subSequence(int n2, int n3) {
        return this.toString().subSequence(n2, n3);
    }

    @Override
    public String toString() {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return ((Object)this.text).toString();
        }
        GapBuffer gapBuffer2 = gapBuffer;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.text, 0, this.bufStart);
        gapBuffer2.append(stringBuilder);
        stringBuilder.append(this.text, this.bufEnd, this.text.length());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final boolean contentEquals(CharSequence charSequence) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"");
        return Intrinsics.areEqual((Object)this.toString(), (Object)((Object)charSequence).toString());
    }

    @Override
    public final int length() {
        return this.getLength();
    }

    @Override
    public final char charAt(int n2) {
        return this.get(n2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/compose/foundation/text/input/internal/PartialGapBuffer$Companion;", "", "<init>", "()V", "BUF_SIZE", "", "SURROUNDING_SIZE", "NOWHERE", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

