/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.Limits;
import io.netty.channel.unix.NativeInetAddress;
import io.netty.channel.unix.SegmentedDatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;

final class NativeDatagramPacketArray {
    private final NativeDatagramPacket[] packets = new NativeDatagramPacket[Limits.UIO_MAX_IOV];
    private final IovArray iovArray = new IovArray();
    private final byte[] ipv4Bytes = new byte[4];
    private final MyMessageProcessor processor = new MyMessageProcessor();
    private int count;

    NativeDatagramPacketArray() {
        for (int i = 0; i < this.packets.length; ++i) {
            this.packets[i] = new NativeDatagramPacket();
        }
    }

    boolean addWritable(ByteBuf byteBuf, int n, int n2) {
        return this.add0(byteBuf, n, n2, 0, null);
    }

    private boolean add0(ByteBuf byteBuf, int n, int n2, int n3, InetSocketAddress inetSocketAddress) {
        if (this.count == this.packets.length) {
            return false;
        }
        if (n2 == 0) {
            return true;
        }
        int n4 = this.iovArray.count();
        if (n4 == Limits.IOV_MAX || !this.iovArray.add(byteBuf, n, n2)) {
            return false;
        }
        NativeDatagramPacket nativeDatagramPacket = this.packets[this.count];
        nativeDatagramPacket.init(this.iovArray.memoryAddress(n4), this.iovArray.count() - n4, n3, inetSocketAddress);
        ++this.count;
        return true;
    }

    void add(ChannelOutboundBuffer channelOutboundBuffer, boolean bl, int n) {
        this.processor.connected = bl;
        this.processor.maxMessagesPerWrite = n;
        channelOutboundBuffer.forEachFlushedMessage((ChannelOutboundBuffer.MessageProcessor)this.processor);
    }

    int count() {
        return this.count;
    }

    NativeDatagramPacket[] packets() {
        return this.packets;
    }

    void clear() {
        this.count = 0;
        this.iovArray.clear();
    }

    void release() {
        this.iovArray.release();
    }

    private static InetSocketAddress newAddress(byte[] byArray, int n, int n2, int n3, byte[] byArray2) {
        InetAddress inetAddress;
        if (n == byArray2.length) {
            System.arraycopy(byArray, 0, byArray2, 0, n);
            inetAddress = InetAddress.getByAddress(byArray2);
        } else {
            inetAddress = Inet6Address.getByAddress(null, byArray, n3);
        }
        return new InetSocketAddress(inetAddress, n2);
    }

    public final class NativeDatagramPacket {
        private long memoryAddress;
        private int count;
        private final byte[] senderAddr = new byte[16];
        private int senderAddrLen;
        private int senderScopeId;
        private int senderPort;
        private final byte[] recipientAddr = new byte[16];
        private int recipientAddrLen;
        private int recipientScopeId;
        private int recipientPort;
        private int segmentSize;

        private void init(long l, int n, int n2, InetSocketAddress inetSocketAddress) {
            this.memoryAddress = l;
            this.count = n;
            this.segmentSize = n2;
            this.senderScopeId = 0;
            this.senderPort = 0;
            this.senderAddrLen = 0;
            if (inetSocketAddress == null) {
                this.recipientScopeId = 0;
                this.recipientPort = 0;
                this.recipientAddrLen = 0;
            } else {
                InetAddress inetAddress = inetSocketAddress.getAddress();
                if (inetAddress instanceof Inet6Address) {
                    System.arraycopy(inetAddress.getAddress(), 0, this.recipientAddr, 0, this.recipientAddr.length);
                    this.recipientScopeId = ((Inet6Address)inetAddress).getScopeId();
                } else {
                    NativeInetAddress.copyIpv4MappedIpv6Address((byte[])inetAddress.getAddress(), (byte[])this.recipientAddr);
                    this.recipientScopeId = 0;
                }
                this.recipientAddrLen = this.recipientAddr.length;
                this.recipientPort = inetSocketAddress.getPort();
            }
        }

        boolean hasSender() {
            return this.senderPort > 0;
        }

        DatagramPacket newDatagramPacket(ByteBuf byteBuf, InetSocketAddress inetSocketAddress) {
            InetSocketAddress inetSocketAddress2 = NativeDatagramPacketArray.newAddress(this.senderAddr, this.senderAddrLen, this.senderPort, this.senderScopeId, NativeDatagramPacketArray.this.ipv4Bytes);
            if (this.recipientAddrLen != 0) {
                inetSocketAddress = NativeDatagramPacketArray.newAddress(this.recipientAddr, this.recipientAddrLen, this.recipientPort, this.recipientScopeId, NativeDatagramPacketArray.this.ipv4Bytes);
            }
            ByteBuf byteBuf2 = byteBuf.retainedSlice(byteBuf.readerIndex(), this.count);
            if (this.segmentSize > 0) {
                return new SegmentedDatagramPacket(byteBuf2, this.segmentSize, inetSocketAddress, inetSocketAddress2);
            }
            return new DatagramPacket(byteBuf2, inetSocketAddress, inetSocketAddress2);
        }
    }

    private final class MyMessageProcessor
    implements ChannelOutboundBuffer.MessageProcessor {
        private boolean connected;
        private int maxMessagesPerWrite;

        private MyMessageProcessor() {
        }

        public boolean processMessage(Object object) {
            boolean bl;
            if (object instanceof DatagramPacket) {
                DatagramPacket datagramPacket = (DatagramPacket)object;
                ByteBuf byteBuf = (ByteBuf)datagramPacket.content();
                int n = 0;
                if (datagramPacket instanceof SegmentedDatagramPacket) {
                    int n2 = ((SegmentedDatagramPacket)datagramPacket).segmentSize();
                    if (byteBuf.readableBytes() > n2) {
                        n = n2;
                    }
                }
                bl = NativeDatagramPacketArray.this.add0(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), n, (InetSocketAddress)datagramPacket.recipient());
            } else if (object instanceof ByteBuf && this.connected) {
                ByteBuf byteBuf = (ByteBuf)object;
                bl = NativeDatagramPacketArray.this.add0(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), 0, null);
            } else {
                bl = false;
            }
            if (bl) {
                --this.maxMessagesPerWrite;
                return this.maxMessagesPerWrite > 0;
            }
            return false;
        }
    }
}

