/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.ByteBufChecksum;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.FastLz;
import java.util.List;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class FastLzFrameDecoder
extends ByteToMessageDecoder {
    private State currentState = State.INIT_BLOCK;
    private final ByteBufChecksum checksum;
    private int chunkLength;
    private int originalLength;
    private boolean isCompressed;
    private boolean hasChecksum;
    private int currentChecksum;

    public FastLzFrameDecoder() {
        this(false);
    }

    public FastLzFrameDecoder(boolean bl) {
        this(bl ? new Adler32() : null);
    }

    public FastLzFrameDecoder(Checksum checksum) {
        this.checksum = checksum == null ? null : ByteBufChecksum.wrapChecksum(checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            switch (this.currentState) {
                case INIT_BLOCK: {
                    if (byteBuf.readableBytes() < 4) break;
                    int n = byteBuf.readUnsignedMedium();
                    if (n != 4607066) {
                        throw new DecompressionException("unexpected block identifier");
                    }
                    byte by = byteBuf.readByte();
                    this.isCompressed = (by & 1) == 1;
                    this.hasChecksum = (by & 0x10) == 16;
                    this.currentState = State.INIT_BLOCK_PARAMS;
                }
                case INIT_BLOCK_PARAMS: {
                    if (byteBuf.readableBytes() < 2 + (this.isCompressed ? 2 : 0) + (this.hasChecksum ? 4 : 0)) break;
                    this.currentChecksum = this.hasChecksum ? byteBuf.readInt() : 0;
                    this.chunkLength = byteBuf.readUnsignedShort();
                    this.originalLength = this.isCompressed ? byteBuf.readUnsignedShort() : this.chunkLength;
                    this.currentState = State.DECOMPRESS_DATA;
                }
                case DECOMPRESS_DATA: {
                    int n = this.chunkLength;
                    if (byteBuf.readableBytes() < n) break;
                    int n2 = byteBuf.readerIndex();
                    int n3 = this.originalLength;
                    ByteBuf byteBuf2 = null;
                    try {
                        int n4;
                        if (this.isCompressed) {
                            int n5;
                            byteBuf2 = channelHandlerContext.alloc().buffer(n3);
                            n4 = FastLz.decompress(byteBuf, n2, n, byteBuf2, n5 = byteBuf2.writerIndex(), n3);
                            if (n3 != n4) {
                                throw new DecompressionException(String.format("stream corrupted: originalLength(%d) and actual length(%d) mismatch", n3, n4));
                            }
                            byteBuf2.writerIndex(byteBuf2.writerIndex() + n4);
                        } else {
                            byteBuf2 = byteBuf.retainedSlice(n2, n);
                        }
                        ByteBufChecksum byteBufChecksum = this.checksum;
                        if (this.hasChecksum && byteBufChecksum != null) {
                            byteBufChecksum.reset();
                            byteBufChecksum.update(byteBuf2, byteBuf2.readerIndex(), byteBuf2.readableBytes());
                            n4 = (int)byteBufChecksum.getValue();
                            if (n4 != this.currentChecksum) {
                                throw new DecompressionException(String.format("stream corrupted: mismatching checksum: %d (expected: %d)", n4, this.currentChecksum));
                            }
                        }
                        if (byteBuf2.readableBytes() > 0) {
                            list.add(byteBuf2);
                        } else {
                            byteBuf2.release();
                        }
                        byteBuf2 = null;
                        byteBuf.skipBytes(n);
                        this.currentState = State.INIT_BLOCK;
                        break;
                    }
                    finally {
                        if (byteBuf2 != null) {
                            byteBuf2.release();
                        }
                    }
                }
                case CORRUPTED: {
                    byteBuf.skipBytes(byteBuf.readableBytes());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (Exception exception) {
            this.currentState = State.CORRUPTED;
            throw exception;
        }
    }

    private static enum State {
        INIT_BLOCK,
        INIT_BLOCK_PARAMS,
        DECOMPRESS_DATA,
        CORRUPTED;

    }
}

