/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.model.LevelModel;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;

public class LevelModelHandler
extends ModelHandlerBase {
    boolean inError = false;

    public LevelModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new LevelModelHandler(context);
    }

    protected Class<? extends LevelModel> getSupportedModelClass() {
        return LevelModel.class;
    }

    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        Object object = modelInterpretationContext.peekObject();
        if (!(object instanceof Logger)) {
            this.inError = true;
            this.addError("For element <level>, could not find a logger at the top of execution stack.");
            return;
        }
        Logger logger = (Logger)object;
        String string = logger.getName();
        LevelModel levelModel = (LevelModel)model;
        String string2 = modelInterpretationContext.subst(levelModel.getValue());
        if ("INHERITED".equalsIgnoreCase(string2) || "NULL".equalsIgnoreCase(string2)) {
            if ("ROOT".equalsIgnoreCase(string)) {
                this.addError("The level for the ROOT logger cannot be set to NULL or INHERITED. Ignoring.");
            } else {
                logger.setLevel(null);
            }
        } else {
            logger.setLevel(Level.toLevel(string2, Level.DEBUG));
        }
        this.addInfo(string + " level set to " + String.valueOf(logger.getLevel()));
    }
}

