/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.ClassicConstants;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.boolex.OnErrorEvaluator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.net.SMTPAppenderBase;
import java.util.List;
import java.util.concurrent.Future;
import org.slf4j.Marker;

public class SMTPAppender
extends SMTPAppenderBase<ILoggingEvent> {
    static final String DEFAULT_SUBJECT_PATTERN = "%logger{20} - %m";
    private boolean includeCallerData = false;

    public SMTPAppender() {
    }

    public void start() {
        if (this.eventEvaluator == null) {
            OnErrorEvaluator onErrorEvaluator = new OnErrorEvaluator();
            onErrorEvaluator.setContext(this.getContext());
            onErrorEvaluator.setName("onError");
            onErrorEvaluator.start();
            this.eventEvaluator = onErrorEvaluator;
        }
        super.start();
    }

    public SMTPAppender(EventEvaluator<ILoggingEvent> eventEvaluator) {
        this.eventEvaluator = eventEvaluator;
    }

    protected void subAppend(CyclicBuffer<ILoggingEvent> cyclicBuffer, ILoggingEvent iLoggingEvent) {
        if (this.includeCallerData) {
            iLoggingEvent.getCallerData();
        }
        iLoggingEvent.prepareForDeferredProcessing();
        cyclicBuffer.add((Object)iLoggingEvent);
    }

    protected void fillBuffer(CyclicBuffer<ILoggingEvent> cyclicBuffer, StringBuffer stringBuffer) {
        int n = cyclicBuffer.length();
        for (int i = 0; i < n; ++i) {
            ILoggingEvent iLoggingEvent = (ILoggingEvent)cyclicBuffer.get();
            stringBuffer.append(this.layout.doLayout((Object)iLoggingEvent));
        }
    }

    protected boolean eventMarksEndOfLife(ILoggingEvent iLoggingEvent) {
        List<Marker> list = iLoggingEvent.getMarkerList();
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (Marker marker : list) {
            if (!marker.contains(ClassicConstants.FINALIZE_SESSION_MARKER)) continue;
            return true;
        }
        return false;
    }

    protected Layout<ILoggingEvent> makeSubjectLayout(String string) {
        if (string == null) {
            string = DEFAULT_SUBJECT_PATTERN;
        }
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setContext(this.getContext());
        patternLayout.setPattern(string);
        patternLayout.setPostCompileProcessor(null);
        patternLayout.start();
        return patternLayout;
    }

    protected PatternLayout makeNewToPatternLayout(String string) {
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setPattern(string + "%nopex");
        return patternLayout;
    }

    public boolean isIncludeCallerData() {
        return this.includeCallerData;
    }

    public void setIncludeCallerData(boolean bl) {
        this.includeCallerData = bl;
    }

    Future<?> getAsynchronousSendingFuture() {
        return this.asynchronousSendingFuture;
    }
}

