/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.PackagingDataCalculator;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.util.OptionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

public class ThrowableProxy
implements IThrowableProxy {
    static final StackTraceElementProxy[] EMPTY_STEP = new StackTraceElementProxy[0];
    private Throwable throwable;
    private String className;
    private String message;
    StackTraceElementProxy[] stackTraceElementProxyArray;
    int commonFrames;
    private ThrowableProxy cause;
    private ThrowableProxy[] suppressed = NO_SUPPRESSED;
    private transient PackagingDataCalculator packagingDataCalculator;
    private boolean calculatedPackageData = false;
    private boolean cyclic;
    private static final ThrowableProxy[] NO_SUPPRESSED = new ThrowableProxy[0];

    public ThrowableProxy(Throwable throwable) {
        this(throwable, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private ThrowableProxy(Throwable throwable, boolean bl) {
        this.throwable = throwable;
        this.className = throwable.getClass().getName();
        this.message = throwable.getMessage();
        this.stackTraceElementProxyArray = EMPTY_STEP;
        this.cyclic = true;
    }

    public ThrowableProxy(Throwable throwable, Set<Throwable> set) {
        Object[] objectArray;
        this.throwable = throwable;
        this.className = throwable.getClass().getName();
        this.message = throwable.getMessage();
        this.stackTraceElementProxyArray = ThrowableProxyUtil.steArrayToStepArray(throwable.getStackTrace());
        this.cyclic = false;
        set.add(throwable);
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            if (set.contains(throwable2)) {
                this.cause = new ThrowableProxy(throwable2, true);
            } else {
                this.cause = new ThrowableProxy(throwable2, set);
                this.cause.commonFrames = ThrowableProxyUtil.findNumberOfCommonFrames(throwable2.getStackTrace(), this.stackTraceElementProxyArray);
            }
        }
        if (OptionHelper.isNotEmtpy((Object[])(objectArray = throwable.getSuppressed()))) {
            ArrayList<ThrowableProxy> arrayList = new ArrayList<ThrowableProxy>(objectArray.length);
            for (Object object : objectArray) {
                ThrowableProxy throwableProxy;
                if (set.contains(object)) {
                    throwableProxy = new ThrowableProxy((Throwable)object, true);
                    arrayList.add(throwableProxy);
                    continue;
                }
                throwableProxy = new ThrowableProxy((Throwable)object, set);
                throwableProxy.commonFrames = ThrowableProxyUtil.findNumberOfCommonFrames(((Throwable)object).getStackTrace(), this.stackTraceElementProxyArray);
                arrayList.add(throwableProxy);
            }
            this.suppressed = arrayList.toArray(new ThrowableProxy[arrayList.size()]);
        }
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public StackTraceElementProxy[] getStackTraceElementProxyArray() {
        return this.stackTraceElementProxyArray;
    }

    @Override
    public boolean isCyclic() {
        return this.cyclic;
    }

    @Override
    public int getCommonFrames() {
        return this.commonFrames;
    }

    @Override
    public IThrowableProxy getCause() {
        return this.cause;
    }

    @Override
    public IThrowableProxy[] getSuppressed() {
        return this.suppressed;
    }

    public PackagingDataCalculator getPackagingDataCalculator() {
        if (this.throwable != null && this.packagingDataCalculator == null) {
            this.packagingDataCalculator = new PackagingDataCalculator();
        }
        return this.packagingDataCalculator;
    }

    public void calculatePackagingData() {
        if (this.calculatedPackageData) {
            return;
        }
        PackagingDataCalculator packagingDataCalculator = this.getPackagingDataCalculator();
        if (packagingDataCalculator != null) {
            this.calculatedPackageData = true;
            packagingDataCalculator.calculate(this);
        }
    }

    public void fullDump() {
        StringBuilder stringBuilder = new StringBuilder();
        for (StackTraceElementProxy stackTraceElementProxy : this.stackTraceElementProxyArray) {
            String string = stackTraceElementProxy.toString();
            stringBuilder.append('\t').append(string);
            ThrowableProxyUtil.subjoinPackagingData(stringBuilder, stackTraceElementProxy);
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        }
        System.out.println(stringBuilder.toString());
    }
}

