/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KFunction;
import kotlin.reflect.KMutableProperty;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.internal.KCallableImpl;
import kotlin.reflect.jvm.internal.KPackageImpl;
import kotlin.reflect.jvm.internal.KPropertyImpl;
import kotlin.reflect.jvm.internal.KTypeImpl;
import kotlin.reflect.jvm.internal.UtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a\u000e\u0010 \u001a\u0004\u0018\u00010!*\u00020\"H\u0002\u001a$\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030(0'2\u0006\u0010)\u001a\u00020\u0006H\u0002\u001a$\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030(0'2\u0006\u0010+\u001a\u00020\u0001H\u0002\"\u001b\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001b\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001b\u0010\t\u001a\u0004\u0018\u00010\u0006*\u0006\u0012\u0002\b\u00030\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u001b\u0010\r\u001a\u0004\u0018\u00010\u0006*\u0006\u0012\u0002\b\u00030\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"/\u0010\u0011\u001a\n\u0012\u0004\u0012\u0002H\u0013\u0018\u00010\u0012\"\u0004\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00130\u000e8F\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\"\u0015\u0010\u0018\u001a\u00020\u0019*\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u001b\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\"\u001b\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\"-\u0010#\u001a\n\u0012\u0004\u0012\u0002H\u0013\u0018\u00010\u000e\"\b\b\u0000\u0010\u0013*\u00020,*\b\u0012\u0004\u0012\u0002H\u00130\u00128F\u00a2\u0006\u0006\u001a\u0004\b$\u0010-\u00a8\u0006."}, d2={"javaField", "Ljava/lang/reflect/Field;", "Lkotlin/reflect/KProperty;", "getJavaField", "(Lkotlin/reflect/KProperty;)Ljava/lang/reflect/Field;", "javaGetter", "Ljava/lang/reflect/Method;", "getJavaGetter", "(Lkotlin/reflect/KProperty;)Ljava/lang/reflect/Method;", "javaSetter", "Lkotlin/reflect/KMutableProperty;", "getJavaSetter", "(Lkotlin/reflect/KMutableProperty;)Ljava/lang/reflect/Method;", "javaMethod", "Lkotlin/reflect/KFunction;", "getJavaMethod", "(Lkotlin/reflect/KFunction;)Ljava/lang/reflect/Method;", "javaConstructor", "Ljava/lang/reflect/Constructor;", "T", "getJavaConstructor$annotations", "(Lkotlin/reflect/KFunction;)V", "getJavaConstructor", "(Lkotlin/reflect/KFunction;)Ljava/lang/reflect/Constructor;", "javaType", "Ljava/lang/reflect/Type;", "Lkotlin/reflect/KType;", "getJavaType", "(Lkotlin/reflect/KType;)Ljava/lang/reflect/Type;", "kotlinProperty", "getKotlinProperty", "(Ljava/lang/reflect/Field;)Lkotlin/reflect/KProperty;", "getKPackage", "Lkotlin/reflect/KDeclarationContainer;", "Ljava/lang/reflect/Member;", "kotlinFunction", "getKotlinFunction", "(Ljava/lang/reflect/Method;)Lkotlin/reflect/KFunction;", "findKFunction", "", "Lkotlin/reflect/KCallable;", "method", "findKProperty", "field", "", "(Ljava/lang/reflect/Constructor;)Lkotlin/reflect/KFunction;", "kotlin-reflection"})
public final class ReflectJvmMapping {
    public static final Field getJavaField(KProperty<?> kProperty) {
        Intrinsics.checkNotNullParameter(kProperty, (String)"");
        KPropertyImpl<?> kPropertyImpl = UtilKt.asKPropertyImpl(kProperty);
        return kPropertyImpl != null ? kPropertyImpl.getJavaField() : null;
    }

    public static final Method getJavaGetter(KProperty<?> kProperty) {
        Intrinsics.checkNotNullParameter(kProperty, (String)"");
        return ReflectJvmMapping.getJavaMethod((KFunction)kProperty.getGetter());
    }

    public static final Method getJavaSetter(KMutableProperty<?> kMutableProperty) {
        Intrinsics.checkNotNullParameter(kMutableProperty, (String)"");
        return ReflectJvmMapping.getJavaMethod((KFunction)kMutableProperty.getSetter());
    }

    public static final Method getJavaMethod(KFunction<?> kFunction) {
        Intrinsics.checkNotNullParameter(kFunction, (String)"");
        KCallableImpl<?> kCallableImpl = UtilKt.asKCallableImpl(kFunction);
        Object var1_1 = kCallableImpl != null && (kCallableImpl = kCallableImpl.getCaller()) != null ? kCallableImpl.getMember() : null;
        return var1_1 instanceof Method ? (Method)var1_1 : null;
    }

    public static final <T> Constructor<T> getJavaConstructor(KFunction<? extends T> kFunction) {
        Intrinsics.checkNotNullParameter(kFunction, (String)"");
        KCallableImpl<?> kCallableImpl = UtilKt.asKCallableImpl(kFunction);
        Object var1_1 = kCallableImpl != null && (kCallableImpl = kCallableImpl.getCaller()) != null ? kCallableImpl.getMember() : null;
        return var1_1 instanceof Constructor ? (Constructor)var1_1 : null;
    }

    public static /* synthetic */ void getJavaConstructor$annotations(KFunction kFunction) {
    }

    public static final Type getJavaType(KType kType) {
        Intrinsics.checkNotNullParameter((Object)kType, (String)"");
        Type type = ((KTypeImpl)kType).getJavaType();
        if (type == null) {
            type = TypesJVMKt.getJavaType((KType)kType);
        }
        return type;
    }

    public static final KProperty<?> getKotlinProperty(Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"");
        if (field.isSynthetic()) {
            return null;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            KDeclarationContainer kDeclarationContainer = ReflectJvmMapping.getKPackage(field);
            if (kDeclarationContainer != null) {
                return ReflectJvmMapping.findKProperty(kDeclarationContainer.getMembers(), field);
            }
            Class<?> clazz = field.getDeclaringClass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
            KClass<?> kClass = KClasses.getCompanionObject(JvmClassMappingKt.getKotlinClass(clazz));
            if (kClass != null) {
                KProperty<?> kProperty;
                Class<?> clazz2 = field.getDeclaringClass();
                Intrinsics.checkNotNullExpressionValue(clazz2, (String)"");
                String string = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                Field field2 = UtilKt.getDeclaredFieldOrNull(clazz2, string);
                if (field2 != null && (kProperty = ReflectJvmMapping.findKProperty(KClasses.getMemberProperties(kClass), field2)) != null) {
                    KProperty<?> kProperty2 = kProperty;
                    boolean bl = false;
                    return kProperty2;
                }
            }
        }
        Class<?> clazz = field.getDeclaringClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
        return ReflectJvmMapping.findKProperty(KClasses.getMemberProperties(JvmClassMappingKt.getKotlinClass(clazz)), field);
    }

    private static final KDeclarationContainer getKPackage(Member member) {
        KDeclarationContainer kDeclarationContainer;
        Class<?> clazz = member.getDeclaringClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
        Object object = ReflectKotlinClass.Factory.create(clazz);
        KotlinClassHeader.Kind kind = object != null && (object = ((ReflectKotlinClass)object).getClassHeader()) != null ? ((KotlinClassHeader)object).getKind() : null;
        switch (kind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                Class<?> clazz2 = member.getDeclaringClass();
                Intrinsics.checkNotNullExpressionValue(clazz2, (String)"");
                kDeclarationContainer = (KDeclarationContainer)new KPackageImpl(clazz2);
                break;
            }
            default: {
                kDeclarationContainer = null;
            }
        }
        return kDeclarationContainer;
    }

    public static final KFunction<?> getKotlinFunction(Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"");
        if (Modifier.isStatic(method.getModifiers())) {
            KDeclarationContainer kDeclarationContainer = ReflectJvmMapping.getKPackage(method);
            if (kDeclarationContainer != null) {
                return ReflectJvmMapping.findKFunction(kDeclarationContainer.getMembers(), method);
            }
            Class<?> clazz = method.getDeclaringClass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
            KClass<?> kClass = KClasses.getCompanionObject(JvmClassMappingKt.getKotlinClass(clazz));
            if (kClass != null) {
                Class clazz2 = JvmClassMappingKt.getJavaClass(kClass);
                String string = method.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                KFunction<?> kFunction = method.getParameterTypes();
                Method method2 = UtilKt.getDeclaredMethodOrNull(clazz2, string, Arrays.copyOf(kFunction, ((Class<?>[])kFunction).length));
                if (method2 != null && (kFunction = ReflectJvmMapping.findKFunction(KClasses.getFunctions(kClass), method2)) != null) {
                    KFunction<?> kFunction2 = kFunction;
                    boolean bl = false;
                    return kFunction2;
                }
            }
        }
        Class<?> clazz = method.getDeclaringClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
        return ReflectJvmMapping.findKFunction(KClasses.getFunctions(JvmClassMappingKt.getKotlinClass(clazz)), method);
    }

    private static final KFunction<?> findKFunction(Collection<? extends KCallable<?>> collection, Method method) {
        for (KCallable<?> kCallable : collection) {
            if (!(kCallable instanceof KFunction) || !Intrinsics.areEqual((Object)((KFunction)kCallable).getName(), (Object)method.getName()) || !Intrinsics.areEqual((Object)ReflectJvmMapping.getJavaMethod((KFunction)kCallable), (Object)method)) continue;
            return (KFunction)kCallable;
        }
        for (KCallable<?> kCallable : collection) {
            if (!(kCallable instanceof KFunction) || Intrinsics.areEqual((Object)((KFunction)kCallable).getName(), (Object)method.getName()) || !Intrinsics.areEqual((Object)ReflectJvmMapping.getJavaMethod((KFunction)kCallable), (Object)method)) continue;
            return (KFunction)kCallable;
        }
        return null;
    }

    private static final KProperty<?> findKProperty(Collection<? extends KCallable<?>> collection, Field field) {
        for (KCallable<?> kCallable : collection) {
            if (!(kCallable instanceof KProperty) || !Intrinsics.areEqual((Object)((KProperty)kCallable).getName(), (Object)field.getName()) || !Intrinsics.areEqual((Object)ReflectJvmMapping.getJavaField((KProperty)kCallable), (Object)field)) continue;
            return (KProperty)kCallable;
        }
        for (KCallable<?> kCallable : collection) {
            if (!(kCallable instanceof KProperty) || Intrinsics.areEqual((Object)((KProperty)kCallable).getName(), (Object)field.getName()) || !Intrinsics.areEqual((Object)ReflectJvmMapping.getJavaField((KProperty)kCallable), (Object)field)) continue;
            return (KProperty)kCallable;
        }
        return null;
    }

    public static final <T> KFunction<T> getKotlinFunction(Constructor<T> constructor) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter(constructor, (String)"");
            Class<T> clazz = constructor.getDeclaringClass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
            Iterable iterable = JvmClassMappingKt.getKotlinClass(clazz).getConstructors();
            boolean bl = false;
            for (Object t : iterable) {
                KFunction kFunction = (KFunction)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(ReflectJvmMapping.getJavaConstructor(kFunction), constructor)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinClassHeader.Kind.values().length];
            try {
                nArray[KotlinClassHeader.Kind.FILE_FACADE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS_PART.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

