/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference;
import kotlin.jvm.internal.RepeatableContainer;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.KVisibility;
import kotlin.reflect.jvm.internal.KCallableImpl;
import kotlin.reflect.jvm.internal.KFunctionImpl;
import kotlin.reflect.jvm.internal.KPropertyImpl;
import kotlin.reflect.jvm.internal.KTypeImpl;
import kotlin.reflect.jvm.internal.ModuleByClassLoaderKt;
import kotlin.reflect.jvm.internal.Util;
import kotlin.reflect.jvm.internal.calls.AnnotationConstructorCallerKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectAnnotationSource;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectJavaClassFinderKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.RuntimeModuleData;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.RuntimeSourceElementFactory;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionRequirementTable;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.NullValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.TypedArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.MemberDeserializer;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u00da\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005*\u00020\u0006H\u0000\u001a(\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0002\u001a.\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0014\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0005*\u0006\u0012\u0002\b\u00030\u0005H\u0000\u001a\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0014H\u0000\u001a\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u0018H\u0000\u001a\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002\u001a\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0017*\u00020\u001bH\u0002\u001a\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u001d*\u00020 2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a%\u0010!\u001a\u0002H\"\"\u0004\b\u0000\u0010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0$H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%\u001a\u0010\u0010&\u001a\u0004\u0018\u00010'*\u0004\u0018\u00010\u001dH\u0000\u001a\u0014\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010)*\u0004\u0018\u00010\u001dH\u0000\u001a\u0014\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010+*\u0004\u0018\u00010\u001dH\u0000\u001al\u00101\u001a\u0002H2\"\b\b\u0000\u00103*\u000204\"\b\b\u0001\u00102*\u00020.2\n\u00105\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u00106\u001a\u0002H32\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u001d\u0010=\u001a\u0019\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u0002H3\u0012\u0004\u0012\u0002H20>\u00a2\u0006\u0002\b@H\u0000\u00a2\u0006\u0002\u0010A\u001a\u0012\u0010H\u001a\u0004\u0018\u00010\u001d2\u0006\u0010I\u001a\u00020JH\u0000\u001a;\u0010K\u001a\u0004\u0018\u00010L*\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010M\u001a\u00020\u000f2\u001a\u0010N\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00050O\"\u0006\u0012\u0002\b\u00030\u0005H\u0000\u00a2\u0006\u0002\u0010P\u001a\u001a\u0010Q\u001a\u0004\u0018\u00010R*\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010M\u001a\u00020\u000fH\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u001a\u0010,\u001a\u0004\u0018\u00010-*\u00020.8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\"\u0018\u0010B\u001a\u00020C*\u00020D8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010E\"\u0018\u0010F\u001a\u00020C*\u00020D8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010E\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006S"}, d2={"JVM_STATIC", "Lkotlin/reflect/jvm/internal/impl/name/FqName;", "getJVM_STATIC", "()Lorg/jetbrains/kotlin/name/FqName;", "toJavaClass", "Ljava/lang/Class;", "Lkotlin/reflect/jvm/internal/impl/descriptors/ClassDescriptor;", "loadClass", "classLoader", "Ljava/lang/ClassLoader;", "kotlinClassId", "Lkotlin/reflect/jvm/internal/impl/name/ClassId;", "arrayDimensions", "", "packageName", "", "className", "createArrayType", "toKVisibility", "Lkotlin/reflect/KVisibility;", "Lkotlin/reflect/jvm/internal/impl/descriptors/DescriptorVisibility;", "computeAnnotations", "", "", "Lkotlin/reflect/jvm/internal/impl/descriptors/annotations/Annotated;", "unwrapRepeatableAnnotations", "toAnnotationInstance", "Lkotlin/reflect/jvm/internal/impl/descriptors/annotations/AnnotationDescriptor;", "toRuntimeValue", "", "Lkotlin/reflect/jvm/internal/impl/resolve/constants/ConstantValue;", "arrayToRuntimeValue", "Lkotlin/reflect/jvm/internal/impl/resolve/constants/ArrayValue;", "reflectionCall", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "asKFunctionImpl", "Lkotlin/reflect/jvm/internal/KFunctionImpl;", "asKPropertyImpl", "Lkotlin/reflect/jvm/internal/KPropertyImpl;", "asKCallableImpl", "Lkotlin/reflect/jvm/internal/KCallableImpl;", "instanceReceiverParameter", "Lkotlin/reflect/jvm/internal/impl/descriptors/ReceiverParameterDescriptor;", "Lkotlin/reflect/jvm/internal/impl/descriptors/CallableDescriptor;", "getInstanceReceiverParameter", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "deserializeToDescriptor", "D", "M", "Lkotlin/reflect/jvm/internal/impl/protobuf/MessageLite;", "moduleAnchor", "proto", "nameResolver", "Lkotlin/reflect/jvm/internal/impl/metadata/deserialization/NameResolver;", "typeTable", "Lkotlin/reflect/jvm/internal/impl/metadata/deserialization/TypeTable;", "metadataVersion", "Lkotlin/reflect/jvm/internal/impl/metadata/deserialization/BinaryVersion;", "createDescriptor", "Lkotlin/Function2;", "Lkotlin/reflect/jvm/internal/impl/serialization/deserialization/MemberDeserializer;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Class;Lorg/jetbrains/kotlin/protobuf/MessageLite;Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isInlineClassType", "", "Lkotlin/reflect/KType;", "(Lkotlin/reflect/KType;)Z", "needsMultiFieldValueClassFlattening", "getNeedsMultiFieldValueClassFlattening", "defaultPrimitiveValue", "type", "Ljava/lang/reflect/Type;", "getDeclaredMethodOrNull", "Ljava/lang/reflect/Method;", "name", "parameterTypes", "", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "getDeclaredFieldOrNull", "Ljava/lang/reflect/Field;", "kotlin-reflection"})
public final class UtilKt {
    private static final FqName JVM_STATIC = new FqName("kotlin.jvm.JvmStatic");

    public static final FqName getJVM_STATIC() {
        return JVM_STATIC;
    }

    public static final Class<?> toJavaClass(ClassDescriptor classDescriptor) {
        AnnotatedElement annotatedElement;
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
        SourceElement sourceElement = classDescriptor.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"");
        SourceElement sourceElement2 = sourceElement;
        if (sourceElement2 instanceof KotlinJvmBinarySourceElement) {
            KotlinJvmBinaryClass kotlinJvmBinaryClass = ((KotlinJvmBinarySourceElement)sourceElement2).getBinaryClass();
            Intrinsics.checkNotNull((Object)kotlinJvmBinaryClass);
            annotatedElement = ((ReflectKotlinClass)kotlinJvmBinaryClass).getKlass();
        } else if (sourceElement2 instanceof RuntimeSourceElementFactory.RuntimeSourceElement) {
            ReflectJavaElement reflectJavaElement = ((RuntimeSourceElementFactory.RuntimeSourceElement)sourceElement2).getJavaElement();
            Intrinsics.checkNotNull((Object)reflectJavaElement);
            annotatedElement = ((ReflectJavaClass)reflectJavaElement).getElement();
        } else {
            ClassId classId = DescriptorUtilsKt.getClassId(classDescriptor);
            if (classId == null) {
                return null;
            }
            ClassId classId2 = classId;
            annotatedElement = UtilKt.loadClass(ReflectClassUtilKt.getSafeClassLoader(classDescriptor.getClass()), classId2, 0);
        }
        return annotatedElement;
    }

    private static final Class<?> loadClass(ClassLoader classLoader, ClassId classId, int n) {
        ClassId classId2 = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(classId.asSingleFqName().toUnsafe());
        if (classId2 == null) {
            classId2 = classId;
        }
        ClassId classId3 = classId2;
        return UtilKt.loadClass(classLoader, classId3.getPackageFqName().asString(), classId3.getRelativeClassName().asString(), n);
    }

    static /* synthetic */ Class loadClass$default(ClassLoader classLoader, ClassId classId, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return UtilKt.loadClass(classLoader, classId, n);
    }

    private static final Class<?> loadClass(ClassLoader classLoader, String string, String string2, int n) {
        StringBuilder stringBuilder;
        block35: {
            if (!Intrinsics.areEqual((Object)string, (Object)"kotlin")) break block35;
            switch (string2) {
                case "Array": {
                    return Object[].class;
                }
                case "BooleanArray": {
                    return boolean[].class;
                }
                case "ByteArray": {
                    return byte[].class;
                }
                case "CharArray": {
                    return char[].class;
                }
                case "DoubleArray": {
                    return double[].class;
                }
                case "FloatArray": {
                    return float[].class;
                }
                case "IntArray": {
                    return int[].class;
                }
                case "LongArray": {
                    return long[].class;
                }
                case "ShortArray": {
                    return short[].class;
                }
            }
        }
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                boolean bl2 = false;
                stringBuilder2.append("[");
            }
            stringBuilder2.append("L");
        }
        if (((CharSequence)string).length() > 0) {
            stringBuilder2.append(string + '.');
        }
        stringBuilder2.append(StringsKt.replace$default((String)string2, (char)'.', (char)'$', (boolean)false, (int)4, null));
        if (n > 0) {
            stringBuilder2.append(";");
        }
        String string3 = stringBuilder.toString();
        return ReflectJavaClassFinderKt.tryLoadClass(classLoader, string3);
    }

    public static final Class<?> createArrayType(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        return Array.newInstance(clazz, 0).getClass();
    }

    public static final KVisibility toKVisibility(DescriptorVisibility descriptorVisibility) {
        Intrinsics.checkNotNullParameter((Object)descriptorVisibility, (String)"");
        DescriptorVisibility descriptorVisibility2 = descriptorVisibility;
        return Intrinsics.areEqual((Object)descriptorVisibility2, (Object)DescriptorVisibilities.PUBLIC) ? KVisibility.PUBLIC : (Intrinsics.areEqual((Object)descriptorVisibility2, (Object)DescriptorVisibilities.PROTECTED) ? KVisibility.PROTECTED : (Intrinsics.areEqual((Object)descriptorVisibility2, (Object)DescriptorVisibilities.INTERNAL) ? KVisibility.INTERNAL : (Intrinsics.areEqual((Object)descriptorVisibility2, (Object)DescriptorVisibilities.PRIVATE) || Intrinsics.areEqual((Object)descriptorVisibility2, (Object)DescriptorVisibilities.PRIVATE_TO_THIS) ? KVisibility.PRIVATE : null)));
    }

    public static final List<Annotation> computeAnnotations(Annotated annotated) {
        Intrinsics.checkNotNullParameter((Object)annotated, (String)"");
        Iterable iterable = annotated.getAnnotations();
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Iterator iterator2 = iterable3.iterator();
        while (iterator2.hasNext()) {
            Annotation annotation;
            Object t;
            Object t2 = t = iterator2.next();
            boolean bl4 = false;
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)t2;
            boolean bl5 = false;
            SourceElement sourceElement = annotationDescriptor.getSource();
            if (sourceElement instanceof ReflectAnnotationSource) {
                annotation = ((ReflectAnnotationSource)sourceElement).getAnnotation();
            } else if (sourceElement instanceof RuntimeSourceElementFactory.RuntimeSourceElement) {
                ReflectJavaElement reflectJavaElement = ((RuntimeSourceElementFactory.RuntimeSourceElement)sourceElement).getJavaElement();
                ReflectJavaAnnotation reflectJavaAnnotation = reflectJavaElement instanceof ReflectJavaAnnotation ? (ReflectJavaAnnotation)reflectJavaElement : null;
                annotation = reflectJavaAnnotation != null ? reflectJavaAnnotation.getAnnotation() : null;
            } else {
                annotation = UtilKt.toAnnotationInstance(annotationDescriptor);
            }
            if (annotation == null) continue;
            Annotation annotation2 = annotation;
            boolean bl6 = false;
            collection.add(annotation2);
        }
        return UtilKt.unwrapRepeatableAnnotations((List)collection);
    }

    private static final List<Annotation> unwrapRepeatableAnnotations(List<? extends Annotation> list) {
        List list2;
        boolean bl;
        boolean bl2;
        Iterable iterable;
        block8: {
            iterable = list;
            bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object object : iterable) {
                    Annotation annotation = (Annotation)object;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation)).getSimpleName(), (Object)"Container")) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            Object object;
            iterable = list;
            bl2 = false;
            Iterable iterable2 = iterable;
            object = new ArrayList();
            boolean bl4 = false;
            Iterator iterator2 = iterable2.iterator();
            while (iterator2.hasNext()) {
                List list3;
                Object t = iterator2.next();
                Object object2 = (Annotation)t;
                boolean bl5 = false;
                Class clazz = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)object2));
                if (Intrinsics.areEqual((Object)clazz.getSimpleName(), (Object)"Container") && clazz.getAnnotation(RepeatableContainer.class) != null) {
                    Object object3 = clazz.getDeclaredMethod("value", new Class[0]).invoke(object2, new Object[0]);
                    Intrinsics.checkNotNull((Object)object3);
                    list3 = ArraysKt.asList((Object[])((Annotation[])object3));
                } else {
                    list3 = CollectionsKt.listOf((Object)object2);
                }
                object2 = list3;
                CollectionsKt.addAll(object, (Iterable)object2);
            }
            list2 = (List)object;
        } else {
            list2 = list;
        }
        return list2;
    }

    private static final Annotation toAnnotationInstance(AnnotationDescriptor annotationDescriptor) {
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
        Class<?> clazz = classDescriptor != null ? UtilKt.toJavaClass(classDescriptor) : null;
        Class<Object> clazz2 = clazz instanceof Class ? clazz : null;
        if (clazz2 == null) {
            return null;
        }
        Class<?> clazz3 = clazz2;
        Iterable iterable = annotationDescriptor.getAllValueArguments().entrySet();
        Class<?> clazz4 = clazz3;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Iterator iterator2 = iterable3.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            Object t;
            Object t2 = t = iterator2.next();
            boolean bl4 = false;
            Map.Entry entry = (Map.Entry)t2;
            boolean bl5 = false;
            Name name = (Name)entry.getKey();
            ConstantValue constantValue = (ConstantValue)entry.getValue();
            ClassLoader classLoader = clazz3.getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"");
            if (UtilKt.toRuntimeValue(constantValue, classLoader) != null) {
                Object object;
                String string = name.asString();
                Object object2 = object;
                boolean bl6 = false;
                pair = TuplesKt.to((Object)string, (Object)object2);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl7 = false;
            collection.add(pair2);
        }
        return (Annotation)AnnotationConstructorCallerKt.createAnnotationInstance$default(clazz4, MapsKt.toMap((Iterable)((List)collection)), null, 4, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Object toRuntimeValue(ConstantValue<?> constantValue, ClassLoader classLoader) {
        Object object;
        ConstantValue<?> constantValue2 = constantValue;
        if (constantValue2 instanceof AnnotationValue) {
            object = UtilKt.toAnnotationInstance((AnnotationDescriptor)((AnnotationValue)constantValue).getValue());
            return object;
        } else if (constantValue2 instanceof ArrayValue) {
            object = UtilKt.arrayToRuntimeValue((ArrayValue)constantValue, classLoader);
            return object;
        } else if (constantValue2 instanceof EnumValue) {
            Pair pair = (Pair)((EnumValue)constantValue).getValue();
            ClassId classId = (ClassId)pair.component1();
            Name name = (Name)pair.component2();
            Class clazz = UtilKt.loadClass$default(classLoader, classId, 0, 4, null);
            if (clazz == null) return null;
            Class clazz2 = clazz;
            boolean bl = false;
            object = Util.getEnumConstantByName(clazz2, name.asString());
            return object;
        } else if (constantValue2 instanceof KClassValue) {
            KClassValue.Value value = (KClassValue.Value)((KClassValue)constantValue).getValue();
            if (value instanceof KClassValue.Value.NormalClass) {
                object = UtilKt.loadClass(classLoader, ((KClassValue.Value.NormalClass)value).getClassId(), ((KClassValue.Value.NormalClass)value).getArrayDimensions());
                return object;
            } else {
                if (!(value instanceof KClassValue.Value.LocalClass)) throw new NoWhenBranchMatchedException();
                ClassifierDescriptor classifierDescriptor = ((KClassValue.Value.LocalClass)value).getType().getConstructor().getDeclarationDescriptor();
                if (!(classifierDescriptor instanceof ClassDescriptor)) return null;
                ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
                if (classDescriptor == null) return null;
                object = UtilKt.toJavaClass(classDescriptor);
            }
            return object;
        } else {
            if (constantValue2 instanceof ErrorValue) return null;
            if (constantValue2 instanceof NullValue) {
                return null;
            }
            object = constantValue.getValue();
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Object arrayToRuntimeValue(ArrayValue arrayValue, ClassLoader classLoader) {
        if (!(arrayValue instanceof TypedArrayValue)) return null;
        TypedArrayValue typedArrayValue = (TypedArrayValue)arrayValue;
        Object object = typedArrayValue;
        if (typedArrayValue == null) return null;
        if ((object = ((TypedArrayValue)object).getType()) == null) {
            return null;
        }
        Object object2 = object;
        Iterable iterable = (Iterable)arrayValue.getValue();
        boolean bl = false;
        Object object3 = iterable;
        Object object4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        int n = 0;
        Object[] objectArray = object3.iterator();
        while (objectArray.hasNext()) {
            Object t = objectArray.next();
            ConstantValue constantValue = (ConstantValue)t;
            Collection collection = object4;
            boolean bl2 = false;
            collection.add(UtilKt.toRuntimeValue(constantValue, classLoader));
        }
        List list = (List)object4;
        PrimitiveType primitiveType = KotlinBuiltIns.getPrimitiveArrayElementType((KotlinType)object2);
        switch (primitiveType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[primitiveType.ordinal()]) {
            case 1: {
                int n2 = 0;
                int n3 = ((List)arrayValue.getValue()).size();
                boolean[] blArray = new boolean[n3];
                while (n2 < n3) {
                    int n4 = n2++;
                    Object e = list.get(n4);
                    Intrinsics.checkNotNull(e);
                    blArray[n4] = (Boolean)e;
                }
                Object[] objectArray2 = blArray;
                return objectArray2;
            }
            case 2: {
                int n5 = 0;
                int n6 = ((List)arrayValue.getValue()).size();
                char[] cArray = new char[n6];
                while (n5 < n6) {
                    int n7 = n5++;
                    Object e = list.get(n7);
                    Intrinsics.checkNotNull(e);
                    cArray[n7] = ((Character)e).charValue();
                }
                Object[] objectArray2 = cArray;
                return objectArray2;
            }
            case 3: {
                int n8 = 0;
                int n9 = ((List)arrayValue.getValue()).size();
                byte[] byArray = new byte[n9];
                while (n8 < n9) {
                    int n10 = n8++;
                    Object e = list.get(n10);
                    Intrinsics.checkNotNull(e);
                    byArray[n10] = (Byte)e;
                }
                Object[] objectArray2 = byArray;
                return objectArray2;
            }
            case 4: {
                int n11 = 0;
                int n12 = ((List)arrayValue.getValue()).size();
                short[] sArray = new short[n12];
                while (n11 < n12) {
                    int n13 = n11++;
                    Object e = list.get(n13);
                    Intrinsics.checkNotNull(e);
                    sArray[n13] = (Short)e;
                }
                Object[] objectArray2 = sArray;
                return objectArray2;
            }
            case 5: {
                int n14 = 0;
                int n15 = ((List)arrayValue.getValue()).size();
                int[] nArray = new int[n15];
                while (n14 < n15) {
                    int n16 = n14++;
                    Object e = list.get(n16);
                    Intrinsics.checkNotNull(e);
                    nArray[n16] = (Integer)e;
                }
                Object[] objectArray2 = nArray;
                return objectArray2;
            }
            case 6: {
                int n17 = 0;
                int n18 = ((List)arrayValue.getValue()).size();
                float[] fArray = new float[n18];
                while (n17 < n18) {
                    int n19 = n17++;
                    Object e = list.get(n19);
                    Intrinsics.checkNotNull(e);
                    fArray[n19] = ((Float)e).floatValue();
                }
                Object[] objectArray2 = fArray;
                return objectArray2;
            }
            case 7: {
                int n20 = 0;
                int n21 = ((List)arrayValue.getValue()).size();
                long[] lArray = new long[n21];
                while (n20 < n21) {
                    int n22 = n20++;
                    Object e = list.get(n22);
                    Intrinsics.checkNotNull(e);
                    lArray[n22] = (Long)e;
                }
                Object[] objectArray2 = lArray;
                return objectArray2;
            }
            case 8: {
                int n23 = 0;
                int n24 = ((List)arrayValue.getValue()).size();
                double[] dArray = new double[n24];
                while (n23 < n24) {
                    int n25 = n23++;
                    Object e = list.get(n25);
                    Intrinsics.checkNotNull(e);
                    dArray[n25] = (Double)e;
                }
                Object[] objectArray2 = dArray;
                return objectArray2;
            }
            case -1: {
                Object[] objectArray2;
                if (!KotlinBuiltIns.isArray((KotlinType)object2)) {
                    boolean bl3 = false;
                    String string = "Not an array type: " + object2;
                    throw new IllegalStateException(string.toString());
                }
                KotlinType kotlinType = ((TypeProjection)CollectionsKt.single(((KotlinType)object2).getArguments())).getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
                object3 = kotlinType;
                objectArray = ((KotlinType)object3).getConstructor().getDeclarationDescriptor();
                ClassDescriptor classDescriptor = objectArray instanceof ClassDescriptor ? (ClassDescriptor)objectArray : null;
                if (classDescriptor == null) {
                    throw new IllegalStateException(("Not a class type: " + object3).toString());
                }
                object4 = classDescriptor;
                if (KotlinBuiltIns.isString((KotlinType)object3)) {
                    n = 0;
                    int n26 = ((List)arrayValue.getValue()).size();
                    String[] stringArray = new String[n26];
                    while (n < n26) {
                        int n27 = n++;
                        Intrinsics.checkNotNull(list.get(n27));
                    }
                    objectArray2 = stringArray;
                    return objectArray2;
                }
                if (KotlinBuiltIns.isKClass((ClassDescriptor)object4)) {
                    n = 0;
                    int n28 = ((List)arrayValue.getValue()).size();
                    Class[] classArray = new Class[n28];
                    while (n < n28) {
                        int n29 = n++;
                        Intrinsics.checkNotNull(list.get(n29));
                    }
                    objectArray2 = classArray;
                    return objectArray2;
                }
                ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)object4);
                Object object5 = classId;
                if (classId == null) return null;
                ClassId classId2 = object5;
                boolean bl4 = false;
                Class clazz = UtilKt.loadClass$default(classLoader, classId2, 0, 4, null);
                object5 = clazz;
                if (clazz == null) {
                    return null;
                }
                Object object6 = object5;
                Object object7 = Array.newInstance(object6, ((List)arrayValue.getValue()).size());
                Intrinsics.checkNotNull((Object)object7);
                objectArray = (Object[])object7;
                int n30 = list.size();
                int n31 = 0;
                while (n31 < n30) {
                    int n32 = n31++;
                    bl4 = false;
                    objectArray[n32] = list.get(n32);
                }
                objectArray2 = objectArray;
                return objectArray2;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public static final KFunctionImpl asKFunctionImpl(Object object) {
        KFunctionImpl kFunctionImpl = object instanceof KFunctionImpl ? (KFunctionImpl)object : null;
        if (kFunctionImpl == null) {
            FunctionReference functionReference = object instanceof FunctionReference ? (FunctionReference)object : null;
            KCallable kCallable = functionReference != null ? functionReference.compute() : null;
            kFunctionImpl = kCallable instanceof KFunctionImpl ? (KFunctionImpl)kCallable : null;
        }
        return kFunctionImpl;
    }

    public static final KPropertyImpl<?> asKPropertyImpl(Object object) {
        KPropertyImpl kPropertyImpl = object instanceof KPropertyImpl ? (KPropertyImpl)object : null;
        if (kPropertyImpl == null) {
            PropertyReference propertyReference = object instanceof PropertyReference ? (PropertyReference)object : null;
            KCallable kCallable = propertyReference != null ? propertyReference.compute() : null;
            kPropertyImpl = kCallable instanceof KPropertyImpl ? (KPropertyImpl)kCallable : null;
        }
        return kPropertyImpl;
    }

    public static final KCallableImpl<?> asKCallableImpl(Object object) {
        KCallableImpl kCallableImpl = object instanceof KCallableImpl ? (KCallableImpl)object : null;
        if (kCallableImpl == null) {
            KFunctionImpl kFunctionImpl = UtilKt.asKFunctionImpl(object);
            kCallableImpl = kFunctionImpl != null ? (KCallableImpl)kFunctionImpl : (KCallableImpl)UtilKt.asKPropertyImpl(object);
        }
        return kCallableImpl;
    }

    public static final ReceiverParameterDescriptor getInstanceReceiverParameter(CallableDescriptor callableDescriptor) {
        ReceiverParameterDescriptor receiverParameterDescriptor;
        Intrinsics.checkNotNullParameter((Object)callableDescriptor, (String)"");
        if (callableDescriptor.getDispatchReceiverParameter() != null) {
            DeclarationDescriptor declarationDescriptor = callableDescriptor.getContainingDeclaration();
            Intrinsics.checkNotNull((Object)declarationDescriptor);
            receiverParameterDescriptor = ((ClassDescriptor)declarationDescriptor).getThisAsReceiverParameter();
        } else {
            receiverParameterDescriptor = null;
        }
        return receiverParameterDescriptor;
    }

    public static final <M extends MessageLite, D extends CallableDescriptor> D deserializeToDescriptor(Class<?> clazz, M m, NameResolver nameResolver, TypeTable typeTable, BinaryVersion binaryVersion, Function2<? super MemberDeserializer, ? super M, ? extends D> function2) {
        List<ProtoBuf.TypeParameter> list;
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Intrinsics.checkNotNullParameter(m, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        Intrinsics.checkNotNullParameter((Object)binaryVersion, (String)"");
        Intrinsics.checkNotNullParameter(function2, (String)"");
        RuntimeModuleData runtimeModuleData = ModuleByClassLoaderKt.getOrCreateModule(clazz);
        Object object = m;
        if (object instanceof ProtoBuf.Function) {
            list = ((ProtoBuf.Function)m).getTypeParameterList();
        } else if (object instanceof ProtoBuf.Property) {
            list = ((ProtoBuf.Property)m).getTypeParameterList();
        } else {
            throw new IllegalStateException(("Unsupported message: " + m).toString());
        }
        List<ProtoBuf.TypeParameter> list2 = list;
        DeserializationComponents deserializationComponents = runtimeModuleData.getDeserialization();
        DeclarationDescriptor declarationDescriptor = runtimeModuleData.getModule();
        VersionRequirementTable versionRequirementTable = VersionRequirementTable.Companion.getEMPTY();
        Intrinsics.checkNotNull(list2);
        object = new DeserializationContext(deserializationComponents, nameResolver, declarationDescriptor, typeTable, versionRequirementTable, binaryVersion, null, null, list2);
        return (D)((CallableDescriptor)function2.invoke((Object)new MemberDeserializer((DeserializationContext)object), m));
    }

    public static final boolean isInlineClassType(KType kType) {
        Intrinsics.checkNotNullParameter((Object)kType, (String)"");
        Object object = kType instanceof KTypeImpl ? (KTypeImpl)kType : null;
        return object != null && (object = ((KTypeImpl)object).getType()) != null ? InlineClassesUtilsKt.isInlineClassType((KotlinType)object) : false;
    }

    public static final boolean getNeedsMultiFieldValueClassFlattening(KType kType) {
        Intrinsics.checkNotNullParameter((Object)kType, (String)"");
        Object object = kType instanceof KTypeImpl ? (KTypeImpl)kType : null;
        return object != null && (object = ((KTypeImpl)object).getType()) != null ? InlineClassesUtilsKt.needsMfvcFlattening((KotlinType)object) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Object defaultPrimitiveValue(Type type) {
        Comparable<Boolean> comparable;
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        if (!(type instanceof Class)) return null;
        if (!((Class)type).isPrimitive()) return null;
        Class clazz = (Class)type;
        if (Intrinsics.areEqual((Object)clazz, Boolean.TYPE)) {
            comparable = false;
            return comparable;
        } else if (Intrinsics.areEqual((Object)clazz, Character.TYPE)) {
            comparable = Character.valueOf('\u0000');
            return comparable;
        } else if (Intrinsics.areEqual((Object)clazz, Byte.TYPE)) {
            comparable = (byte)0;
            return comparable;
        } else if (Intrinsics.areEqual((Object)clazz, Short.TYPE)) {
            comparable = (short)0;
            return comparable;
        } else if (Intrinsics.areEqual((Object)clazz, Integer.TYPE)) {
            comparable = 0;
            return comparable;
        } else if (Intrinsics.areEqual((Object)clazz, Float.TYPE)) {
            comparable = Float.valueOf(0.0f);
            return comparable;
        } else if (Intrinsics.areEqual((Object)clazz, Long.TYPE)) {
            comparable = 0L;
            return comparable;
        } else if (Intrinsics.areEqual((Object)clazz, Double.TYPE)) {
            comparable = 0.0;
            return comparable;
        } else {
            if (!Intrinsics.areEqual((Object)clazz, Void.TYPE)) throw new UnsupportedOperationException("Unknown primitive: " + type);
            throw new IllegalStateException("Parameter with void type is illegal");
        }
    }

    public static final Method getDeclaredMethodOrNull(Class<?> clazz, String string, Class<?> ... classArray) {
        Method method;
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(classArray, (String)"");
        try {
            method = clazz.getDeclaredMethod(string, Arrays.copyOf(classArray, classArray.length));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        return method;
    }

    public static final Field getDeclaredFieldOrNull(Class<?> clazz, String string) {
        Field field;
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        try {
            field = clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            field = null;
        }
        return field;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PrimitiveType.values().length];
            try {
                nArray[PrimitiveType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.CHAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.BYTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.SHORT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.INT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.LONG.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.DOUBLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

