/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.jvm;

import java.util.Collection;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;

public final class JavaToKotlinClassMapper {
    public static final JavaToKotlinClassMapper INSTANCE = new JavaToKotlinClassMapper();

    private JavaToKotlinClassMapper() {
    }

    public final Collection<ClassDescriptor> mapPlatformClass(FqName fqName, KotlinBuiltIns kotlinBuiltIns) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        ClassDescriptor classDescriptor = JavaToKotlinClassMapper.mapJavaToKotlin$default(this, fqName, kotlinBuiltIns, null, 4, null);
        if (classDescriptor == null) {
            return SetsKt.emptySet();
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        FqName fqName2 = JavaToKotlinClassMap.INSTANCE.readOnlyToMutable(DescriptorUtilsKt.getFqNameUnsafe(classDescriptor2));
        if (fqName2 == null) {
            return SetsKt.setOf((Object)classDescriptor2);
        }
        FqName fqName3 = fqName2;
        Object[] objectArray = new ClassDescriptor[]{classDescriptor2, kotlinBuiltIns.getBuiltInClassByFqName(fqName3)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public final ClassDescriptor mapJavaToKotlin(FqName fqName, KotlinBuiltIns kotlinBuiltIns, Integer n) {
        ClassId classId;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        ClassId classId2 = classId = n != null && Intrinsics.areEqual((Object)fqName, (Object)JavaToKotlinClassMap.INSTANCE.getFUNCTION_N_FQ_NAME()) ? StandardNames.getFunctionClassId(n) : JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName);
        return classId2 != null ? kotlinBuiltIns.getBuiltInClassByFqName(classId2.asSingleFqName()) : null;
    }

    public static /* synthetic */ ClassDescriptor mapJavaToKotlin$default(JavaToKotlinClassMapper javaToKotlinClassMapper, FqName fqName, KotlinBuiltIns kotlinBuiltIns, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return javaToKotlinClassMapper.mapJavaToKotlin(fqName, kotlinBuiltIns, n);
    }

    public final boolean isMutable(ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
        return JavaToKotlinClassMap.INSTANCE.isMutable(DescriptorUtils.getFqName(classDescriptor));
    }

    public final boolean isReadOnly(ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
        return JavaToKotlinClassMap.INSTANCE.isReadOnly(DescriptorUtils.getFqName(classDescriptor));
    }

    public final ClassDescriptor convertMutableToReadOnly(ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
        JavaToKotlinClassMapper javaToKotlinClassMapper = this;
        String string = "mutable";
        boolean bl = false;
        Object object = DescriptorUtils.getFqName(classDescriptor);
        boolean bl2 = false;
        FqName fqName = JavaToKotlinClassMap.INSTANCE.mutableToReadOnly((FqNameUnsafe)object);
        if (fqName == null) {
            throw new IllegalArgumentException("Given class " + classDescriptor + " is not a " + string + " collection");
        }
        object = fqName;
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getBuiltIns(classDescriptor).getBuiltInClassByFqName((FqName)object);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"");
        return classDescriptor2;
    }

    public final ClassDescriptor convertReadOnlyToMutable(ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
        JavaToKotlinClassMapper javaToKotlinClassMapper = this;
        String string = "read-only";
        boolean bl = false;
        Object object = DescriptorUtils.getFqName(classDescriptor);
        boolean bl2 = false;
        FqName fqName = JavaToKotlinClassMap.INSTANCE.readOnlyToMutable((FqNameUnsafe)object);
        if (fqName == null) {
            throw new IllegalArgumentException("Given class " + classDescriptor + " is not a " + string + " collection");
        }
        object = fqName;
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getBuiltIns(classDescriptor).getBuiltInClassByFqName((FqName)object);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"");
        return classDescriptor2;
    }
}

