/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Deprecated;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProviderKt;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProviderOptimized;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;

public final class CompositePackageFragmentProvider
implements PackageFragmentProviderOptimized {
    private final List<PackageFragmentProvider> providers;
    private final String debugName;

    public CompositePackageFragmentProvider(List<? extends PackageFragmentProvider> list, String string) {
        boolean bl;
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.providers = list;
        this.debugName = string;
        boolean bl2 = bl = this.providers.size() == CollectionsKt.toSet((Iterable)this.providers).size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "providers.size is " + this.providers.size() + " while only " + CollectionsKt.toSet((Iterable)this.providers).size() + " unique providers";
            throw new AssertionError((Object)string2);
        }
    }

    @Override
    @Deprecated(message="for usages use #packageFragments(FqName) at final point, for impl use #collectPackageFragments(FqName, MutableCollection<PackageFragmentDescriptor>)")
    public List<PackageFragmentDescriptor> getPackageFragments(FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        ArrayList arrayList = new ArrayList();
        for (PackageFragmentProvider packageFragmentProvider : this.providers) {
            PackageFragmentProviderKt.collectPackageFragmentsOptimizedIfPossible(packageFragmentProvider, fqName, arrayList);
        }
        return CollectionsKt.toList((Iterable)arrayList);
    }

    @Override
    public void collectPackageFragments(FqName fqName, Collection<PackageFragmentDescriptor> collection) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter(collection, (String)"");
        for (PackageFragmentProvider packageFragmentProvider : this.providers) {
            PackageFragmentProviderKt.collectPackageFragmentsOptimizedIfPossible(packageFragmentProvider, fqName, collection);
        }
    }

    @Override
    public boolean isEmpty(FqName fqName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
            Iterable iterable = this.providers;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = true;
            } else {
                for (Object t : iterable) {
                    PackageFragmentProvider packageFragmentProvider = (PackageFragmentProvider)t;
                    boolean bl3 = false;
                    if (PackageFragmentProviderKt.isEmpty(packageFragmentProvider, fqName)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public Collection<FqName> getSubPackagesOf(FqName fqName, Function1<? super Name, Boolean> function1) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        HashSet<FqName> hashSet = new HashSet<FqName>();
        for (PackageFragmentProvider packageFragmentProvider : this.providers) {
            hashSet.addAll(packageFragmentProvider.getSubPackagesOf(fqName, function1));
        }
        return hashSet;
    }

    public String toString() {
        return this.debugName;
    }
}

