/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Named;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithDifferentJvmName;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithSpecialGenericSignature;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinSpecialProperties;
import kotlin.reflect.jvm.internal.impl.load.java.ClassicBuiltinSpecialProperties;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers$$Lambda$2;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialGenericSignatures;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaClassDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeCheckingProcedure;

public final class SpecialBuiltinMembers {
    public static final <T extends CallableMemberDescriptor> T getOverriddenBuiltinWithDifferentJvmName(T t) {
        Intrinsics.checkNotNullParameter(t, (String)"");
        if (!SpecialGenericSignatures.Companion.getORIGINAL_SHORT_NAMES().contains(((Named)t).getName()) && !BuiltinSpecialProperties.INSTANCE.getSPECIAL_SHORT_NAMES().contains(DescriptorUtilsKt.getPropertyIfAccessor(t).getName())) {
            return null;
        }
        T t2 = t;
        return (T)(t2 instanceof PropertyDescriptor || t2 instanceof PropertyAccessorDescriptor ? DescriptorUtilsKt.firstOverridden$default(t, false, SpecialBuiltinMembers$$Lambda$0.INSTANCE, 1, null) : (t2 instanceof SimpleFunctionDescriptor ? DescriptorUtilsKt.firstOverridden$default(t, false, SpecialBuiltinMembers$$Lambda$1.INSTANCE, 1, null) : null));
    }

    public static final boolean doesOverrideBuiltinWithDifferentJvmName(CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        return SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName(callableMemberDescriptor) != null;
    }

    public static final <T extends CallableMemberDescriptor> T getOverriddenSpecialBuiltin(T t) {
        Intrinsics.checkNotNullParameter(t, (String)"");
        T t2 = SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName(t);
        if (t2 != null) {
            T t3 = t2;
            boolean bl = false;
            return t3;
        }
        Name name = ((Named)t).getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        if (!BuiltinMethodsWithSpecialGenericSignature.INSTANCE.getSameAsBuiltinMethodWithErasedValueParameters(name)) {
            return null;
        }
        return (T)DescriptorUtilsKt.firstOverridden$default(t, false, SpecialBuiltinMembers$$Lambda$2.INSTANCE, 1, null);
    }

    public static final String getJvmMethodNameIfSpecial(CallableMemberDescriptor callableMemberDescriptor) {
        String string;
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        CallableMemberDescriptor callableMemberDescriptor2 = SpecialBuiltinMembers.getOverriddenBuiltinThatAffectsJvmName(callableMemberDescriptor);
        if (callableMemberDescriptor2 == null || (callableMemberDescriptor2 = DescriptorUtilsKt.getPropertyIfAccessor(callableMemberDescriptor2)) == null) {
            return null;
        }
        CallableMemberDescriptor callableMemberDescriptor3 = callableMemberDescriptor2;
        CallableMemberDescriptor callableMemberDescriptor4 = callableMemberDescriptor3;
        if (callableMemberDescriptor4 instanceof PropertyDescriptor) {
            string = ClassicBuiltinSpecialProperties.INSTANCE.getBuiltinSpecialPropertyGetterName(callableMemberDescriptor3);
        } else if (callableMemberDescriptor4 instanceof SimpleFunctionDescriptor) {
            Name name = BuiltinMethodsWithDifferentJvmName.INSTANCE.getJvmName((SimpleFunctionDescriptor)callableMemberDescriptor3);
            string = name != null ? name.asString() : null;
        } else {
            string = null;
        }
        return string;
    }

    private static final CallableMemberDescriptor getOverriddenBuiltinThatAffectsJvmName(CallableMemberDescriptor callableMemberDescriptor) {
        return KotlinBuiltIns.isBuiltIn(callableMemberDescriptor) ? SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName(callableMemberDescriptor) : null;
    }

    public static final boolean hasRealKotlinSuperClassWithOverrideOf(ClassDescriptor classDescriptor, CallableDescriptor callableDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)callableDescriptor, (String)"");
        DeclarationDescriptor declarationDescriptor = callableDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNull((Object)declarationDescriptor);
        SimpleType simpleType = ((ClassDescriptor)declarationDescriptor).getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
        SimpleType simpleType2 = simpleType;
        ClassDescriptor classDescriptor2 = DescriptorUtils.getSuperClassDescriptor(classDescriptor);
        while (classDescriptor2 != null) {
            if (!(classDescriptor2 instanceof JavaClassDescriptor)) {
                boolean bl;
                boolean bl2 = bl = TypeCheckingProcedure.findCorrespondingSupertype(classDescriptor2.getDefaultType(), simpleType2) != null;
                if (bl) {
                    return !KotlinBuiltIns.isBuiltIn(classDescriptor2);
                }
            }
            classDescriptor2 = DescriptorUtils.getSuperClassDescriptor(classDescriptor2);
        }
        return false;
    }

    public static final boolean isFromJava(CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        CallableMemberDescriptor callableMemberDescriptor2 = DescriptorUtilsKt.getPropertyIfAccessor(callableMemberDescriptor);
        return callableMemberDescriptor2.getContainingDeclaration() instanceof JavaClassDescriptor;
    }

    public static final boolean isFromJavaOrBuiltins(CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        return SpecialBuiltinMembers.isFromJava(callableMemberDescriptor) || KotlinBuiltIns.isBuiltIn(callableMemberDescriptor);
    }

    private static final boolean getOverriddenBuiltinWithDifferentJvmName$lambda$0(CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        return ClassicBuiltinSpecialProperties.INSTANCE.hasBuiltinSpecialPropertyFqName(DescriptorUtilsKt.getPropertyIfAccessor(callableMemberDescriptor));
    }

    private static final boolean getOverriddenBuiltinWithDifferentJvmName$lambda$1(CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        return BuiltinMethodsWithDifferentJvmName.INSTANCE.isBuiltinFunctionWithDifferentNameInJvm((SimpleFunctionDescriptor)callableMemberDescriptor);
    }

    private static final boolean getOverriddenSpecialBuiltin$lambda$3(CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        return KotlinBuiltIns.isBuiltIn(callableMemberDescriptor) && BuiltinMethodsWithSpecialGenericSignature.getSpecialSignatureInfo(callableMemberDescriptor) != null;
    }

    static /* synthetic */ boolean accessor$SpecialBuiltinMembers$lambda0(CallableMemberDescriptor callableMemberDescriptor) {
        return SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName$lambda$0(callableMemberDescriptor);
    }

    static /* synthetic */ boolean accessor$SpecialBuiltinMembers$lambda1(CallableMemberDescriptor callableMemberDescriptor) {
        return SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName$lambda$1(callableMemberDescriptor);
    }

    static /* synthetic */ boolean accessor$SpecialBuiltinMembers$lambda2(CallableMemberDescriptor callableMemberDescriptor) {
        return SpecialBuiltinMembers.getOverriddenSpecialBuiltin$lambda$3(callableMemberDescriptor);
    }
}

