/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.components;

import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaDeprecatedAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaRetentionAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaTargetAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;

public final class JavaAnnotationMapper {
    public static final JavaAnnotationMapper INSTANCE = new JavaAnnotationMapper();
    private static final Name DEPRECATED_ANNOTATION_MESSAGE;
    private static final Name TARGET_ANNOTATION_ALLOWED_TARGETS;
    private static final Name RETENTION_ANNOTATION_VALUE;
    private static final Map<FqName, FqName> kotlinToJavaNameMap;

    private JavaAnnotationMapper() {
    }

    public final Name getDEPRECATED_ANNOTATION_MESSAGE$descriptors_jvm() {
        return DEPRECATED_ANNOTATION_MESSAGE;
    }

    public final Name getTARGET_ANNOTATION_ALLOWED_TARGETS$descriptors_jvm() {
        return TARGET_ANNOTATION_ALLOWED_TARGETS;
    }

    public final Name getRETENTION_ANNOTATION_VALUE$descriptors_jvm() {
        return RETENTION_ANNOTATION_VALUE;
    }

    public final AnnotationDescriptor mapOrResolveJavaAnnotation(JavaAnnotation javaAnnotation, LazyJavaResolverContext lazyJavaResolverContext, boolean bl) {
        AnnotationDescriptor annotationDescriptor;
        Intrinsics.checkNotNullParameter((Object)javaAnnotation, (String)"");
        Intrinsics.checkNotNullParameter((Object)lazyJavaResolverContext, (String)"");
        ClassId classId = javaAnnotation.getClassId();
        FqName fqName = JvmAnnotationNames.TARGET_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"");
        if (Intrinsics.areEqual((Object)classId, (Object)ClassId.Companion.topLevel(fqName))) {
            annotationDescriptor = new JavaTargetAnnotationDescriptor(javaAnnotation, lazyJavaResolverContext);
        } else {
            FqName fqName2 = JvmAnnotationNames.RETENTION_ANNOTATION;
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"");
            if (Intrinsics.areEqual((Object)classId, (Object)ClassId.Companion.topLevel(fqName2))) {
                annotationDescriptor = new JavaRetentionAnnotationDescriptor(javaAnnotation, lazyJavaResolverContext);
            } else {
                FqName fqName3 = JvmAnnotationNames.DOCUMENTED_ANNOTATION;
                Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"");
                if (Intrinsics.areEqual((Object)classId, (Object)ClassId.Companion.topLevel(fqName3))) {
                    annotationDescriptor = new JavaAnnotationDescriptor(lazyJavaResolverContext, javaAnnotation, StandardNames.FqNames.mustBeDocumented);
                } else {
                    FqName fqName4 = JvmAnnotationNames.DEPRECATED_ANNOTATION;
                    Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"");
                    annotationDescriptor = Intrinsics.areEqual((Object)classId, (Object)ClassId.Companion.topLevel(fqName4)) ? null : (AnnotationDescriptor)new LazyJavaAnnotationDescriptor(lazyJavaResolverContext, javaAnnotation, bl);
                }
            }
        }
        return annotationDescriptor;
    }

    public static /* synthetic */ AnnotationDescriptor mapOrResolveJavaAnnotation$default(JavaAnnotationMapper javaAnnotationMapper, JavaAnnotation javaAnnotation, LazyJavaResolverContext lazyJavaResolverContext, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return javaAnnotationMapper.mapOrResolveJavaAnnotation(javaAnnotation, lazyJavaResolverContext, bl);
    }

    public final AnnotationDescriptor findMappedJavaAnnotation(FqName fqName, JavaAnnotationOwner javaAnnotationOwner, LazyJavaResolverContext lazyJavaResolverContext) {
        AnnotationDescriptor annotationDescriptor;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)javaAnnotationOwner, (String)"");
        Intrinsics.checkNotNullParameter((Object)lazyJavaResolverContext, (String)"");
        if (Intrinsics.areEqual((Object)fqName, (Object)StandardNames.FqNames.deprecated)) {
            FqName fqName2 = JvmAnnotationNames.DEPRECATED_ANNOTATION;
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"");
            JavaAnnotation javaAnnotation = javaAnnotationOwner.findAnnotation(fqName2);
            if (javaAnnotation != null || javaAnnotationOwner.isDeprecatedInJavaDoc()) {
                return new JavaDeprecatedAnnotationDescriptor(javaAnnotation, lazyJavaResolverContext);
            }
        }
        FqName fqName3 = kotlinToJavaNameMap.get(fqName);
        if (fqName3 != null) {
            FqName fqName4 = fqName3;
            boolean bl = false;
            JavaAnnotation javaAnnotation = javaAnnotationOwner.findAnnotation(fqName4);
            if (javaAnnotation != null) {
                JavaAnnotation javaAnnotation2 = javaAnnotation;
                boolean bl2 = false;
                annotationDescriptor = JavaAnnotationMapper.mapOrResolveJavaAnnotation$default(INSTANCE, javaAnnotation2, lazyJavaResolverContext, false, 4, null);
            } else {
                annotationDescriptor = null;
            }
        } else {
            annotationDescriptor = null;
        }
        return annotationDescriptor;
    }

    static {
        Name name = Name.identifier("message");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        DEPRECATED_ANNOTATION_MESSAGE = name;
        Name name2 = Name.identifier("allowedTargets");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"");
        TARGET_ANNOTATION_ALLOWED_TARGETS = name2;
        Name name3 = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"");
        RETENTION_ANNOTATION_VALUE = name3;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)StandardNames.FqNames.target, (Object)JvmAnnotationNames.TARGET_ANNOTATION), TuplesKt.to((Object)StandardNames.FqNames.retention, (Object)JvmAnnotationNames.RETENTION_ANNOTATION), TuplesKt.to((Object)StandardNames.FqNames.mustBeDocumented, (Object)JvmAnnotationNames.DOCUMENTED_ANNOTATION)};
        kotlinToJavaNameMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

