/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.JavaResolverSettings;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawTypeImpl;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.JavaTypeQualifiers;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.NotNullTypeParameterImpl;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.NullabilityQualifier;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeComponentPosition;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeComponentPositionKt;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.RawType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class JavaTypeEnhancement {
    private final JavaResolverSettings javaResolverSettings;

    public JavaTypeEnhancement(JavaResolverSettings javaResolverSettings) {
        Intrinsics.checkNotNullParameter((Object)javaResolverSettings, (String)"");
        this.javaResolverSettings = javaResolverSettings;
    }

    public final KotlinType enhance(KotlinType kotlinType, Function1<? super Integer, JavaTypeQualifiers> function1, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        return this.enhancePossiblyFlexible(kotlinType.unwrap(), function1, 0, bl).getType();
    }

    private final Result enhancePossiblyFlexible(UnwrappedType unwrappedType, Function1<? super Integer, JavaTypeQualifiers> function1, int n, boolean bl) {
        Result result;
        block20: {
            UnwrappedType unwrappedType2;
            block14: {
                UnwrappedType unwrappedType3;
                SimpleResult simpleResult;
                block16: {
                    SimpleResult simpleResult2;
                    boolean bl2;
                    block17: {
                        UnwrappedType unwrappedType4;
                        block19: {
                            block18: {
                                block15: {
                                    boolean bl3;
                                    if (KotlinTypeKt.isError(unwrappedType)) {
                                        return new Result(null, 1);
                                    }
                                    unwrappedType2 = unwrappedType;
                                    if (!(unwrappedType2 instanceof FlexibleType)) break block14;
                                    bl2 = unwrappedType instanceof RawType;
                                    simpleResult = this.enhanceInflexible(((FlexibleType)unwrappedType).getLowerBound(), function1, n, TypeComponentPosition.FLEXIBLE_LOWER, bl2, bl);
                                    simpleResult2 = this.enhanceInflexible(((FlexibleType)unwrappedType).getUpperBound(), function1, n, TypeComponentPosition.FLEXIBLE_UPPER, bl2, bl);
                                    boolean bl4 = bl3 = simpleResult.getSubtreeSize() == simpleResult2.getSubtreeSize();
                                    if (_Assertions.ENABLED && !bl3) {
                                        boolean bl5 = false;
                                        String string = "Different tree sizes of bounds: lower = (" + ((FlexibleType)unwrappedType).getLowerBound() + ", " + simpleResult.getSubtreeSize() + "), upper = (" + ((FlexibleType)unwrappedType).getUpperBound() + ", " + simpleResult2.getSubtreeSize() + ')';
                                        throw new AssertionError((Object)string);
                                    }
                                    if (simpleResult.getType() != null || simpleResult2.getType() != null) break block15;
                                    unwrappedType3 = null;
                                    break block16;
                                }
                                if (!simpleResult.getForWarnings() && !simpleResult2.getForWarnings()) break block17;
                                unwrappedType4 = simpleResult2.getType();
                                if (unwrappedType4 == null) break block18;
                                SimpleType simpleType = unwrappedType4;
                                boolean bl6 = false;
                                SimpleType simpleType2 = simpleResult.getType();
                                if (simpleType2 == null) {
                                    simpleType2 = simpleType;
                                }
                                UnwrappedType unwrappedType5 = KotlinTypeFactory.flexibleType(simpleType2, simpleType);
                                unwrappedType4 = unwrappedType5;
                                if (unwrappedType5 != null) break block19;
                            }
                            SimpleType simpleType = simpleResult.getType();
                            Intrinsics.checkNotNull((Object)simpleType);
                            unwrappedType4 = simpleType;
                        }
                        UnwrappedType unwrappedType6 = unwrappedType4;
                        unwrappedType3 = TypeWithEnhancementKt.wrapEnhancement(unwrappedType, unwrappedType6);
                        break block16;
                    }
                    if (bl2) {
                        SimpleType simpleType;
                        SimpleType simpleType3 = simpleResult.getType();
                        if (simpleType3 == null) {
                            simpleType3 = ((FlexibleType)unwrappedType).getLowerBound();
                        }
                        if ((simpleType = simpleResult2.getType()) == null) {
                            simpleType = ((FlexibleType)unwrappedType).getUpperBound();
                        }
                        unwrappedType3 = new RawTypeImpl(simpleType3, simpleType);
                    } else {
                        SimpleType simpleType;
                        SimpleType simpleType4 = simpleResult.getType();
                        if (simpleType4 == null) {
                            simpleType4 = ((FlexibleType)unwrappedType).getLowerBound();
                        }
                        if ((simpleType = simpleResult2.getType()) == null) {
                            simpleType = ((FlexibleType)unwrappedType).getUpperBound();
                        }
                        unwrappedType3 = KotlinTypeFactory.flexibleType(simpleType4, simpleType);
                    }
                }
                UnwrappedType unwrappedType7 = unwrappedType3;
                result = new Result(unwrappedType7, simpleResult.getSubtreeSize());
                break block20;
            }
            if (unwrappedType2 instanceof SimpleType) {
                SimpleResult simpleResult = JavaTypeEnhancement.enhanceInflexible$default(this, (SimpleType)unwrappedType, function1, n, TypeComponentPosition.INFLEXIBLE, false, bl, 8, null);
                result = new Result(simpleResult.getForWarnings() ? TypeWithEnhancementKt.wrapEnhancement(unwrappedType, simpleResult.getType()) : (UnwrappedType)simpleResult.getType(), simpleResult.getSubtreeSize());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return result;
    }

    private final SimpleResult enhanceInflexible(SimpleType simpleType, Function1<? super Integer, JavaTypeQualifiers> function1, int n, TypeComponentPosition typeComponentPosition, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        boolean bl3;
        boolean bl4 = TypeComponentPositionKt.shouldEnhance(typeComponentPosition);
        boolean bl5 = bl3 = !bl2 || !bl;
        if (!bl4 && simpleType.getArguments().isEmpty()) {
            return new SimpleResult(null, 1, false);
        }
        ClassifierDescriptor classifierDescriptor = simpleType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return new SimpleResult(null, 1, false);
        }
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
        JavaTypeQualifiers javaTypeQualifiers = (JavaTypeQualifiers)function1.invoke((Object)n);
        ClassifierDescriptor classifierDescriptor3 = TypeEnhancementKt.access$enhanceMutability(classifierDescriptor2, javaTypeQualifiers, typeComponentPosition);
        Boolean bl6 = TypeEnhancementKt.access$getEnhancedNullability(javaTypeQualifiers, typeComponentPosition);
        Object object4 = classifierDescriptor3;
        if (object4 == null || (object4 = object4.getTypeConstructor()) == null) {
            object4 = simpleType.getConstructor();
        }
        Object object5 = object4;
        int n2 = 0;
        n2 = n + 1;
        Iterable iterable = simpleType.getArguments();
        List<TypeParameterDescriptor> list = object5.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        Iterable iterable2 = list;
        boolean bl7 = false;
        Object object6 = iterable.iterator();
        Object object72 = iterable2.iterator();
        Object object8 = new ArrayList(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10)));
        while (object6.hasNext() && object72.hasNext()) {
            TypeProjection typeProjection;
            Result result;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)object72.next();
            object3 = (TypeProjection)object6.next();
            object2 = object8;
            boolean bl8 = false;
            if (!bl3) {
                result = new Result(null, 0);
            } else if (!object3.isStarProjection()) {
                result = this.enhancePossiblyFlexible(object3.getType().unwrap(), function1, n2, bl2);
            } else if (((JavaTypeQualifiers)function1.invoke((Object)n2)).getNullability() == NullabilityQualifier.FORCE_FLEXIBILITY) {
                object = object3.getType().unwrap();
                boolean bl9 = false;
                result = new Result(KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible((KotlinType)object).makeNullableAsSpecified(false), FlexibleTypesKt.upperIfFlexible((KotlinType)object).makeNullableAsSpecified(true)), 1);
            } else {
                result = new Result(null, 1);
            }
            Result result2 = result;
            n2 += result2.getSubtreeSize();
            if (result2.getType() != null) {
                KotlinType kotlinType = result2.getType();
                Variance variance = object3.getProjectionKind();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)variance), (String)"");
                typeProjection = TypeUtilsKt.createProjection(kotlinType, variance, typeParameterDescriptor);
            } else if (classifierDescriptor3 != null && !object3.isStarProjection()) {
                KotlinType kotlinType = object3.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
                Variance variance = object3.getProjectionKind();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)variance), (String)"");
                typeProjection = TypeUtilsKt.createProjection(kotlinType, variance, typeParameterDescriptor);
            } else {
                typeProjection = classifierDescriptor3 != null ? TypeUtils.makeStarProjection(typeParameterDescriptor) : null;
            }
            object2.add(typeProjection);
        }
        List list2 = (List)object8;
        int n3 = n2 - n;
        if (classifierDescriptor3 == null && bl6 == null) {
            boolean bl10;
            block21: {
                iterable2 = list2;
                bl7 = false;
                if (iterable2 instanceof Collection && ((Collection)iterable2).isEmpty()) {
                    bl10 = true;
                } else {
                    for (Object object72 : iterable2) {
                        object8 = (TypeProjection)object72;
                        boolean bl11 = false;
                        if (object8 == null) continue;
                        bl10 = false;
                        break block21;
                    }
                    bl10 = true;
                }
            }
            if (bl10) {
                return new SimpleResult(null, n3, false);
            }
        }
        Object object9 = new Annotations[3];
        object9[0] = simpleType.getAnnotations();
        object6 = TypeEnhancementKt.access$getENHANCED_MUTABILITY_ANNOTATIONS$p();
        object72 = object6;
        int n4 = 1;
        object2 = object9;
        boolean bl12 = false;
        boolean bl13 = classifierDescriptor3 != null;
        object2[n4] = bl13 ? object6 : null;
        object6 = TypeEnhancementKt.getENHANCED_NULLABILITY_ANNOTATIONS();
        object72 = object6;
        n4 = 2;
        object2 = object9;
        bl12 = false;
        bl13 = bl6 != null;
        object2[n4] = bl13 ? object6 : null;
        iterable2 = TypeEnhancementKt.access$compositeAnnotationsOrSingle(CollectionsKt.listOfNotNull((Object[])object9));
        object6 = list2;
        object72 = simpleType.getArguments();
        Object object10 = object5;
        object2 = TypeAttributesKt.toDefaultAttributes((Annotations)iterable2);
        bl12 = false;
        Iterator iterator2 = object6.iterator();
        object3 = object72.iterator();
        ArrayList<Object> arrayList = new ArrayList<Object>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)object6, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)object72, (int)10)));
        while (iterator2.hasNext() && object3.hasNext()) {
            object = (TypeProjection)object3.next();
            TypeProjection typeProjection = (TypeProjection)iterator2.next();
            ArrayList<Object> arrayList2 = arrayList;
            boolean bl14 = false;
            Object object11 = typeProjection;
            if (object11 == null) {
                object11 = object;
            }
            arrayList2.add(object11);
        }
        List list3 = arrayList;
        Boolean bl15 = bl6;
        object9 = KotlinTypeFactory.simpleType$default((TypeAttributes)object2, (TypeConstructor)object10, list3, bl15 != null ? bl15.booleanValue() : simpleType.isMarkedNullable(), null, 16, null);
        object6 = javaTypeQualifiers.getDefinitelyNotNull() ? this.notNullTypeParameter((SimpleType)object9) : object9;
        boolean bl16 = bl6 != null && javaTypeQualifiers.isNullabilityQualifierForWarning();
        return new SimpleResult((SimpleType)object6, n3, bl16);
    }

    static /* synthetic */ SimpleResult enhanceInflexible$default(JavaTypeEnhancement javaTypeEnhancement, SimpleType simpleType, Function1 function1, int n, TypeComponentPosition typeComponentPosition, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        return javaTypeEnhancement.enhanceInflexible(simpleType, (Function1<? super Integer, JavaTypeQualifiers>)function1, n, typeComponentPosition, bl, bl2);
    }

    private final SimpleType notNullTypeParameter(SimpleType simpleType) {
        return this.javaResolverSettings.getCorrectNullabilityForNotNullTypeParameter() ? SpecialTypesKt.makeSimpleTypeDefinitelyNotNullOrNotNull(simpleType, true) : (SimpleType)new NotNullTypeParameterImpl(simpleType);
    }

    private static final class Result {
        private final KotlinType type;
        private final int subtreeSize;

        public Result(KotlinType kotlinType, int n) {
            this.type = kotlinType;
            this.subtreeSize = n;
        }

        public final KotlinType getType() {
            return this.type;
        }

        public final int getSubtreeSize() {
            return this.subtreeSize;
        }
    }

    private static final class SimpleResult {
        private final SimpleType type;
        private final int subtreeSize;
        private final boolean forWarnings;

        public SimpleResult(SimpleType simpleType, int n, boolean bl) {
            this.type = simpleType;
            this.subtreeSize = n;
            this.forWarnings = bl;
        }

        public final SimpleType getType() {
            return this.type;
        }

        public final int getSubtreeSize() {
            return this.subtreeSize;
        }

        public final boolean getForWarnings() {
            return this.forWarnings;
        }
    }
}

