/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin.header;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;

public final class KotlinClassHeader {
    private final Kind kind;
    private final JvmMetadataVersion metadataVersion;
    private final String[] data;
    private final String[] incompatibleData;
    private final String[] strings;
    private final String extraString;
    private final int extraInt;
    private final String packageName;
    private final byte[] serializedIr;

    public KotlinClassHeader(Kind kind, JvmMetadataVersion jvmMetadataVersion, String[] stringArray, String[] stringArray2, String[] stringArray3, String string, int n, String string2, byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"");
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"");
        this.kind = kind;
        this.metadataVersion = jvmMetadataVersion;
        this.data = stringArray;
        this.incompatibleData = stringArray2;
        this.strings = stringArray3;
        this.extraString = string;
        this.extraInt = n;
        this.packageName = string2;
        this.serializedIr = byArray;
    }

    public final Kind getKind() {
        return this.kind;
    }

    public final JvmMetadataVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    public final String[] getData() {
        return this.data;
    }

    public final String[] getIncompatibleData() {
        return this.incompatibleData;
    }

    public final String[] getStrings() {
        return this.strings;
    }

    public final String getMultifileClassName() {
        String string;
        String string2 = string = this.extraString;
        boolean bl = false;
        return this.kind == Kind.MULTIFILE_CLASS_PART ? string : null;
    }

    public final List<String> getMultifilePartNames() {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = this.data;
        boolean bl = false;
        Object object = this.kind == Kind.MULTIFILE_CLASS ? objectArray : null;
        List list = object != null ? ArraysKt.asList((Object[])object) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean isUnstableJvmIrBinary() {
        return this.has(this.extraInt, 16) && !this.has(this.extraInt, 32);
    }

    public final boolean isPreRelease() {
        return this.has(this.extraInt, 2);
    }

    public String toString() {
        return (Object)((Object)this.kind) + " version=" + this.metadataVersion;
    }

    private final boolean has(int n, int n2) {
        return (n & n2) != 0;
    }

    public static final class Kind
    extends Enum<Kind> {
        public static final Companion Companion;
        private final int id;
        private static final Map<Integer, Kind> entryById;
        public static final /* enum */ Kind UNKNOWN;
        public static final /* enum */ Kind CLASS;
        public static final /* enum */ Kind FILE_FACADE;
        public static final /* enum */ Kind SYNTHETIC_CLASS;
        public static final /* enum */ Kind MULTIFILE_CLASS;
        public static final /* enum */ Kind MULTIFILE_CLASS_PART;
        private static final /* synthetic */ Kind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Kind(int n2) {
            this.id = n2;
        }

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String string) {
            return Enum.valueOf(Kind.class, string);
        }

        @JvmStatic
        public static final Kind getById(int n) {
            return Companion.getById(n);
        }

        static {
            UNKNOWN = new Kind(0);
            CLASS = new Kind(1);
            FILE_FACADE = new Kind(2);
            SYNTHETIC_CLASS = new Kind(3);
            MULTIFILE_CLASS = new Kind(4);
            MULTIFILE_CLASS_PART = new Kind(5);
            $VALUES = kindArray = new Kind[]{Kind.UNKNOWN, Kind.CLASS, Kind.FILE_FACADE, Kind.SYNTHETIC_CLASS, Kind.MULTIFILE_CLASS, Kind.MULTIFILE_CLASS_PART};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Kind[] kindArray = Kind.values();
            boolean bl = false;
            int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)kindArray.length), (int)16);
            Kind[] kindArray2 = kindArray;
            Map map = new LinkedHashMap(n);
            boolean bl2 = false;
            int n2 = kindArray2.length;
            for (int i = 0; i < n2; ++i) {
                Kind kind;
                Kind kind2 = kind = kindArray2[i];
                Map map2 = map;
                boolean bl3 = false;
                map2.put(kind2.id, kind);
            }
            entryById = map;
        }

        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            public final Kind getById(int n) {
                Kind kind = (Kind)((Object)entryById.get(n));
                if (kind == null) {
                    kind = UNKNOWN;
                }
                return kind;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }
        }
    }
}

