/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.State;
import kotlin.text.StringsKt;

public final class FqNamesUtilKt {
    public static final boolean isSubpackageOf(FqName fqName, FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        return Intrinsics.areEqual((Object)fqName, (Object)fqName2) ? true : (fqName2.isRoot() ? true : FqNamesUtilKt.isSubpackageOf(fqName.asString(), fqName2.asString()));
    }

    public static final boolean isChildOf(FqName fqName, FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        return Intrinsics.areEqual((Object)FqNamesUtilKt.parentOrNull(fqName), (Object)fqName2);
    }

    private static final boolean isSubpackageOf(String string, String string2) {
        return StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null) && string.charAt(string2.length()) == '.';
    }

    public static final FqName tail(FqName fqName, FqName fqName2) {
        FqName fqName3;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        if (!FqNamesUtilKt.isSubpackageOf(fqName, fqName2) || fqName2.isRoot()) {
            fqName3 = fqName;
        } else if (Intrinsics.areEqual((Object)fqName, (Object)fqName2)) {
            fqName3 = FqName.ROOT;
        } else {
            String string = fqName.asString().substring(fqName2.asString().length() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            fqName3 = new FqName(string);
        }
        return fqName3;
    }

    public static final FqName parentOrNull(FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        return fqName.isRoot() ? null : fqName.parent();
    }

    public static final boolean isValidJavaFqName(String string) {
        if (string == null) {
            return false;
        }
        State state = State.BEGINNING;
        block4: for (int i = 0; i < ((CharSequence)string).length(); ++i) {
            char c = ((CharSequence)string).charAt(i);
            switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: 
                case 2: {
                    if (!Character.isJavaIdentifierStart(c)) {
                        return false;
                    }
                    state = State.MIDDLE;
                    continue block4;
                }
                case 3: {
                    if (c == '.') {
                        state = State.AFTER_DOT;
                        continue block4;
                    }
                    if (Character.isJavaIdentifierPart(c)) continue block4;
                    return false;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return state != State.AFTER_DOT;
    }

    public static final <V> V findValueForMostSpecificFqname(FqName fqName, Map<FqName, ? extends V> map) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter(map, (String)"");
        Map map3 = map;
        boolean bl = false;
        Map map4 = map3;
        Map map5 = new LinkedHashMap();
        boolean bl2 = false;
        Iterator iterator2 = map4.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry object2;
            Map.Entry bl6 = object2 = iterator2.next();
            boolean fqName3 = false;
            FqName fqName2 = (FqName)bl6.getKey();
            if (!(Intrinsics.areEqual((Object)fqName, (Object)fqName2) || FqNamesUtilKt.isChildOf(fqName, fqName2))) continue;
            map5.put(object2.getKey(), object2.getValue());
        }
        map3 = map5;
        Object object = map3;
        boolean bl4 = false;
        Map map6 = !object.isEmpty() ? map3 : null;
        if (map6 == null) {
            return null;
        }
        Map map7 = map6;
        object = map7.entrySet();
        Iterator iterator22 = object.iterator();
        if (!iterator22.hasNext()) {
            map2 = null;
        } else {
            map5 = iterator22.next();
            if (!iterator22.hasNext()) {
                map2 = map5;
            } else {
                Map.Entry entry = (Map.Entry)((Object)map5);
                boolean bl5 = false;
                FqName entry2 = (FqName)entry.getKey();
                int n = FqNamesUtilKt.tail(entry2, fqName).asString().length();
                do {
                    Object t = iterator22.next();
                    Map.Entry n2 = (Map.Entry)t;
                    boolean bl3 = false;
                    FqName fqName3 = (FqName)n2.getKey();
                    int n3 = FqNamesUtilKt.tail(fqName3, fqName).asString().length();
                    if (n <= n3) continue;
                    map5 = t;
                    n = n3;
                } while (iterator22.hasNext());
                map2 = map5;
            }
        }
        Map.Entry entry = (Map.Entry)((Object)map2);
        return (V)(entry != null ? entry.getValue() : null);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.BEGINNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.AFTER_DOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

