/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.util.NoSuchElementException;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.LiteralByteString;

class BoundedByteString
extends LiteralByteString {
    private final int bytesOffset;
    private final int bytesLength;

    BoundedByteString(byte[] byArray, int n, int n2) {
        super(byArray);
        if (n < 0) {
            int n3 = n;
            throw new IllegalArgumentException(new StringBuilder(29).append("Offset too small: ").append(n3).toString());
        }
        if (n2 < 0) {
            int n4 = n;
            throw new IllegalArgumentException(new StringBuilder(29).append("Length too small: ").append(n4).toString());
        }
        if ((long)n + (long)n2 > (long)byArray.length) {
            int n5 = n;
            int n6 = n2;
            throw new IllegalArgumentException(new StringBuilder(48).append("Offset+Length too large: ").append(n5).append("+").append(n6).toString());
        }
        this.bytesOffset = n;
        this.bytesLength = n2;
    }

    @Override
    public byte byteAt(int n) {
        if (n < 0) {
            int n2 = n;
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(28).append("Index too small: ").append(n2).toString());
        }
        if (n >= this.size()) {
            int n3 = n;
            int n4 = this.size();
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(41).append("Index too large: ").append(n3).append(", ").append(n4).toString());
        }
        return this.bytes[this.bytesOffset + n];
    }

    @Override
    public int size() {
        return this.bytesLength;
    }

    @Override
    protected int getOffsetIntoBytes() {
        return this.bytesOffset;
    }

    @Override
    protected void copyToInternal(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(this.bytes, this.getOffsetIntoBytes() + n, byArray, n2, n3);
    }

    @Override
    public ByteString.ByteIterator iterator() {
        return new BoundedByteIterator();
    }

    private class BoundedByteIterator
    implements ByteString.ByteIterator {
        private int position;
        private final int limit;

        private BoundedByteIterator() {
            this.position = BoundedByteString.this.getOffsetIntoBytes();
            this.limit = this.position + BoundedByteString.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.position < this.limit;
        }

        @Override
        public Byte next() {
            return this.nextByte();
        }

        @Override
        public byte nextByte() {
            if (this.position >= this.limit) {
                throw new NoSuchElementException();
            }
            return BoundedByteString.this.bytes[this.position++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

