/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.Internal;
import kotlin.reflect.jvm.internal.impl.protobuf.LazyStringList;
import kotlin.reflect.jvm.internal.impl.protobuf.UnmodifiableLazyStringList;

public class LazyStringArrayList
extends AbstractList<String>
implements RandomAccess,
LazyStringList {
    public static final LazyStringList EMPTY = new LazyStringArrayList().getUnmodifiableView();
    private final List<Object> list;

    public LazyStringArrayList() {
        this.list = new ArrayList<Object>();
    }

    public LazyStringArrayList(LazyStringList lazyStringList) {
        this.list = new ArrayList<Object>(lazyStringList.size());
        this.addAll(lazyStringList);
    }

    @Override
    public String get(int n) {
        Object object = this.list.get(n);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof ByteString) {
            ByteString byteString = (ByteString)object;
            String string = byteString.toStringUtf8();
            if (byteString.isValidUtf8()) {
                this.list.set(n, string);
            }
            return string;
        }
        byte[] byArray = (byte[])object;
        String string = Internal.toStringUtf8(byArray);
        if (Internal.isValidUtf8(byArray)) {
            this.list.set(n, string);
        }
        return string;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public String set(int n, String string) {
        Object object = this.list.set(n, string);
        return LazyStringArrayList.asString(object);
    }

    @Override
    public void add(int n, String string) {
        this.list.add(n, string);
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends String> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends String> collection) {
        Collection<? extends String> collection2 = collection instanceof LazyStringList ? ((LazyStringList)collection).getUnderlyingElements() : collection;
        boolean bl = this.list.addAll(n, collection2);
        ++this.modCount;
        return bl;
    }

    @Override
    public String remove(int n) {
        Object object = this.list.remove(n);
        ++this.modCount;
        return LazyStringArrayList.asString(object);
    }

    @Override
    public void clear() {
        this.list.clear();
        ++this.modCount;
    }

    @Override
    public void add(ByteString byteString) {
        this.list.add(byteString);
        ++this.modCount;
    }

    @Override
    public ByteString getByteString(int n) {
        Object object = this.list.get(n);
        ByteString byteString = LazyStringArrayList.asByteString(object);
        if (byteString != object) {
            this.list.set(n, byteString);
        }
        return byteString;
    }

    private static String asString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof ByteString) {
            return ((ByteString)object).toStringUtf8();
        }
        return Internal.toStringUtf8((byte[])object);
    }

    private static ByteString asByteString(Object object) {
        if (object instanceof ByteString) {
            return (ByteString)object;
        }
        if (object instanceof String) {
            return ByteString.copyFromUtf8((String)object);
        }
        return ByteString.copyFrom((byte[])object);
    }

    @Override
    public List<?> getUnderlyingElements() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public LazyStringList getUnmodifiableView() {
        return new UnmodifiableLazyStringList(this);
    }
}

