/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithSource;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.FieldDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PossiblyInnerType;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertySetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterUtilsKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationUseSiteTarget;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.renderer.AnnotationArgumentsRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.ClassifierNamePolicy;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$$Lambda$2;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$$Lambda$3;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$$Lambda$4;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$$Lambda$5;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererModifier;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptionsImpl;
import kotlin.reflect.jvm.internal.impl.renderer.OverrideRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.ParameterNameRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.PropertyAccessorRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingFormat;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.AbbreviatedType;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.StubTypeForBuilderInference;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.WrappedType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;

public final class DescriptorRendererImpl
extends DescriptorRenderer
implements DescriptorRendererOptions {
    private final DescriptorRendererOptionsImpl options;
    private final Lazy functionTypeAnnotationsRenderer$delegate;

    public DescriptorRendererImpl(DescriptorRendererOptionsImpl descriptorRendererOptionsImpl) {
        Intrinsics.checkNotNullParameter((Object)descriptorRendererOptionsImpl, (String)"");
        this.options = descriptorRendererOptionsImpl;
        boolean bl = this.options.isLocked();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        DescriptorRendererImpl descriptorRendererImpl = this;
        this.functionTypeAnnotationsRenderer$delegate = LazyKt.lazy((Function0)new DescriptorRendererImpl$$Lambda$0(descriptorRendererImpl));
    }

    public final DescriptorRendererOptionsImpl getOptions() {
        return this.options;
    }

    private final DescriptorRendererImpl getFunctionTypeAnnotationsRenderer() {
        Lazy lazy = this.functionTypeAnnotationsRenderer$delegate;
        return (DescriptorRendererImpl)lazy.getValue();
    }

    private final String renderKeyword(String string) {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                string2 = string;
                break;
            }
            case 2: {
                if (this.getBoldOnlyForNamesInHtml()) {
                    string2 = string;
                    break;
                }
                string2 = "<b>" + string + "</b>";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    private final String renderError(String string) {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                string2 = string;
                break;
            }
            case 2: {
                string2 = "<font color=red><b>" + string + "</b></font>";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    private final String escape(String string) {
        return this.getTextFormat().escape(string);
    }

    private final String lt() {
        return this.escape("<");
    }

    private final String gt() {
        return this.escape(">");
    }

    private final String arrow() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                string = this.escape("->");
                break;
            }
            case 2: {
                string = "&rarr;";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public String renderMessage(String string) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        switch (WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                string2 = string;
                break;
            }
            case 2: {
                string2 = "<i>" + string + "</i>";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    @Override
    public String renderName(Name name, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        String string = this.escape(RenderingUtilsKt.render(name));
        return this.getBoldOnlyForNamesInHtml() && this.getTextFormat() == RenderingFormat.HTML && bl ? "<b>" + string + "</b>" : string;
    }

    private final void renderName(DeclarationDescriptor declarationDescriptor, StringBuilder stringBuilder, boolean bl) {
        Name name = declarationDescriptor.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        stringBuilder.append(this.renderName(name, bl));
    }

    private final void renderCompanionObjectName(DeclarationDescriptor declarationDescriptor, StringBuilder stringBuilder) {
        if (this.getRenderCompanionObjectName()) {
            if (this.getStartFromName()) {
                stringBuilder.append("companion object");
            }
            this.renderSpaceIfNeeded(stringBuilder);
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor.getContainingDeclaration();
            if (declarationDescriptor2 != null) {
                stringBuilder.append("of ");
                Name name = declarationDescriptor2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                stringBuilder.append(this.renderName(name, false));
            }
        }
        if (this.getVerbose() || !Intrinsics.areEqual((Object)declarationDescriptor.getName(), (Object)SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT)) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(stringBuilder);
            }
            Name name = declarationDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            stringBuilder.append(this.renderName(name, true));
        }
    }

    @Override
    public String renderFqName(FqNameUnsafe fqNameUnsafe) {
        Intrinsics.checkNotNullParameter((Object)fqNameUnsafe, (String)"");
        return this.renderFqName(fqNameUnsafe.pathSegments());
    }

    private final String renderFqName(List<Name> list) {
        return this.escape(RenderingUtilsKt.renderFqName(list));
    }

    public String renderClassifierName(ClassifierDescriptor classifierDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classifierDescriptor, (String)"");
        return ErrorUtils.isError(classifierDescriptor) ? classifierDescriptor.getTypeConstructor().toString() : this.getClassifierNamePolicy().renderClassifier(classifierDescriptor, this);
    }

    @Override
    public String renderType(KotlinType kotlinType) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.renderNormalizedType(stringBuilder2, (KotlinType)this.getTypeNormalizer().invoke((Object)kotlinType));
        return stringBuilder.toString();
    }

    private final void renderNormalizedType(StringBuilder stringBuilder, KotlinType kotlinType) {
        AbbreviatedType abbreviatedType;
        UnwrappedType unwrappedType = kotlinType.unwrap();
        AbbreviatedType abbreviatedType2 = abbreviatedType = unwrappedType instanceof AbbreviatedType ? (AbbreviatedType)unwrappedType : null;
        if (abbreviatedType != null) {
            if (this.getRenderTypeExpansions()) {
                this.renderNormalizedTypeAsIs(stringBuilder, abbreviatedType.getExpandedType());
                if (this.getRenderAbbreviatedTypeComments()) {
                    this.renderAbbreviatedTypeComment(stringBuilder, abbreviatedType);
                }
            } else {
                this.renderNormalizedTypeAsIs(stringBuilder, abbreviatedType.getAbbreviation());
                if (this.getRenderUnabbreviatedType()) {
                    this.renderExpandedTypeComment(stringBuilder, abbreviatedType);
                }
            }
            return;
        }
        this.renderNormalizedTypeAsIs(stringBuilder, kotlinType);
    }

    private final void renderAbbreviatedTypeComment(StringBuilder stringBuilder, AbbreviatedType abbreviatedType) {
        DescriptorRendererImpl descriptorRendererImpl = this;
        StringBuilder stringBuilder2 = stringBuilder;
        boolean bl = false;
        if (descriptorRendererImpl.getTextFormat() == RenderingFormat.HTML) {
            stringBuilder2.append("<font color=\"808080\"><i>");
        }
        stringBuilder2.append(" /* ");
        boolean bl2 = false;
        stringBuilder.append("from: ");
        this.renderNormalizedTypeAsIs(stringBuilder, abbreviatedType.getAbbreviation());
        stringBuilder2.append(" */");
        if (descriptorRendererImpl.getTextFormat() == RenderingFormat.HTML) {
            stringBuilder2.append("</i></font>");
        }
    }

    private final void renderExpandedTypeComment(StringBuilder stringBuilder, AbbreviatedType abbreviatedType) {
        DescriptorRendererImpl descriptorRendererImpl = this;
        StringBuilder stringBuilder2 = stringBuilder;
        boolean bl = false;
        if (descriptorRendererImpl.getTextFormat() == RenderingFormat.HTML) {
            stringBuilder2.append("<font color=\"808080\"><i>");
        }
        stringBuilder2.append(" /* ");
        boolean bl2 = false;
        stringBuilder.append("= ");
        this.renderNormalizedTypeAsIs(stringBuilder, abbreviatedType.getExpandedType());
        stringBuilder2.append(" */");
        if (descriptorRendererImpl.getTextFormat() == RenderingFormat.HTML) {
            stringBuilder2.append("</i></font>");
        }
    }

    private final void renderNormalizedTypeAsIs(StringBuilder stringBuilder, KotlinType kotlinType) {
        if (kotlinType instanceof WrappedType && this.getDebugMode() && !((WrappedType)kotlinType).isComputed()) {
            stringBuilder.append("<Not computed yet>");
            return;
        }
        UnwrappedType unwrappedType = kotlinType.unwrap();
        if (unwrappedType instanceof FlexibleType) {
            stringBuilder.append(((FlexibleType)unwrappedType).render(this, this));
        } else if (unwrappedType instanceof SimpleType) {
            this.renderSimpleType(stringBuilder, (SimpleType)unwrappedType);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void renderSimpleType(StringBuilder stringBuilder, SimpleType simpleType) {
        if (Intrinsics.areEqual((Object)simpleType, (Object)TypeUtils.CANNOT_INFER_FUNCTION_PARAM_TYPE) || TypeUtils.isDontCarePlaceholder(simpleType)) {
            stringBuilder.append("???");
            return;
        }
        if (ErrorUtils.isUninferredTypeVariable(simpleType)) {
            StringBuilder stringBuilder2;
            if (this.getUninferredTypeParameterAsName()) {
                TypeConstructor typeConstructor2 = simpleType.getConstructor();
                Intrinsics.checkNotNull((Object)typeConstructor2);
                stringBuilder2 = stringBuilder.append(this.renderError(((ErrorTypeConstructor)typeConstructor2).getParam(0)));
            } else {
                stringBuilder2 = stringBuilder.append("???");
            }
            return;
        }
        if (KotlinTypeKt.isError(simpleType)) {
            this.renderDefaultType(stringBuilder, simpleType);
            return;
        }
        if (this.shouldRenderAsPrettyFunctionType(simpleType)) {
            this.renderFunctionType(stringBuilder, simpleType);
        } else {
            this.renderDefaultType(stringBuilder, simpleType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldRenderAsPrettyFunctionType(KotlinType kotlinType) {
        TypeProjection typeProjection;
        if (!FunctionTypesKt.isBuiltinFunctionalType(kotlinType)) return false;
        Iterable iterable = kotlinType.getArguments();
        boolean bl = false;
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return true;
        }
        Iterator iterator2 = iterable.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object t = iterator2.next();
            typeProjection = (TypeProjection)t;
            boolean bl2 = false;
        } while (!typeProjection.isStarProjection());
        return false;
    }

    @Override
    public String renderFlexibleType(String string, String string2, KotlinBuiltIns kotlinBuiltIns) {
        String string3;
        String string4;
        String string5;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        if (RenderingUtilsKt.typeStringsDifferOnlyInNullability(string, string2)) {
            if (StringsKt.startsWith$default((String)string2, (String)"(", (boolean)false, (int)2, null)) {
                return '(' + string + ")!";
            }
            return string + '!';
        }
        ClassifierNamePolicy classifierNamePolicy = this.getClassifierNamePolicy();
        ClassDescriptor classDescriptor = kotlinBuiltIns.getCollection();
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"");
        String string6 = StringsKt.substringBefore$default((String)classifierNamePolicy.renderClassifier(classDescriptor, this), (String)"Collection", null, (int)2, null);
        String string7 = "Mutable";
        String string8 = string5 = RenderingUtilsKt.replacePrefixesInTypeRepresentations(string, string6 + string7, string2, string6, string6 + '(' + string7 + ')');
        if (string8 != null) {
            return string8;
        }
        String string9 = string4 = RenderingUtilsKt.replacePrefixesInTypeRepresentations(string, string6 + "MutableMap.MutableEntry", string2, string6 + "Map.Entry", string6 + "(Mutable)Map.(Mutable)Entry");
        if (string9 != null) {
            return string9;
        }
        ClassifierNamePolicy classifierNamePolicy2 = this.getClassifierNamePolicy();
        ClassDescriptor classDescriptor2 = kotlinBuiltIns.getArray();
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"");
        String string10 = StringsKt.substringBefore$default((String)classifierNamePolicy2.renderClassifier(classDescriptor2, this), (String)"Array", null, (int)2, null);
        String string11 = string3 = RenderingUtilsKt.replacePrefixesInTypeRepresentations(string, string10 + this.escape("Array<"), string2, string10 + this.escape("Array<out "), string10 + this.escape("Array<(out) "));
        if (string11 != null) {
            return string11;
        }
        return '(' + string + ".." + string2 + ')';
    }

    public String renderTypeArguments(List<? extends TypeProjection> list) {
        String string;
        Intrinsics.checkNotNullParameter(list, (String)"");
        if (list.isEmpty()) {
            string = "";
        } else {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            boolean bl = false;
            stringBuilder2.append(this.lt());
            this.appendTypeProjections(stringBuilder2, list);
            stringBuilder2.append(this.gt());
            string = stringBuilder.toString();
        }
        return string;
    }

    private final void renderDefaultType(StringBuilder stringBuilder, KotlinType kotlinType) {
        StringBuilder stringBuilder2;
        DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, kotlinType, null, 2, null);
        DefinitelyNotNullType definitelyNotNullType = kotlinType instanceof DefinitelyNotNullType ? (DefinitelyNotNullType)kotlinType : null;
        SimpleType simpleType = definitelyNotNullType != null ? definitelyNotNullType.getOriginal() : null;
        if (KotlinTypeKt.isError(kotlinType)) {
            if (TypeUtilsKt.isUnresolvedType(kotlinType) && this.getPresentableUnresolvedTypes()) {
                stringBuilder2 = stringBuilder.append(this.renderError(ErrorUtils.INSTANCE.unresolvedTypeAsItIs(kotlinType)));
            } else {
                StringBuilder stringBuilder3 = kotlinType instanceof ErrorType && !this.getInformativeErrorType() ? stringBuilder.append(((ErrorType)kotlinType).getDebugMessage()) : stringBuilder.append(kotlinType.getConstructor().toString());
                stringBuilder2 = stringBuilder.append(this.renderTypeArguments(kotlinType.getArguments()));
            }
        } else if (kotlinType instanceof StubTypeForBuilderInference) {
            stringBuilder2 = stringBuilder.append(((StubTypeForBuilderInference)kotlinType).getOriginalTypeVariable().toString());
        } else if (simpleType instanceof StubTypeForBuilderInference) {
            stringBuilder2 = stringBuilder.append(((StubTypeForBuilderInference)simpleType).getOriginalTypeVariable().toString());
        } else {
            DescriptorRendererImpl.renderTypeConstructorAndArguments$default(this, stringBuilder, kotlinType, null, 2, null);
            stringBuilder2 = Unit.INSTANCE;
        }
        if (kotlinType.isMarkedNullable()) {
            stringBuilder.append("?");
        }
        if (SpecialTypesKt.isDefinitelyNotNullType(kotlinType)) {
            stringBuilder.append(" & Any");
        }
    }

    private final void renderTypeConstructorAndArguments(StringBuilder stringBuilder, KotlinType kotlinType, TypeConstructor typeConstructor2) {
        PossiblyInnerType possiblyInnerType = TypeParameterUtilsKt.buildPossiblyInnerType(kotlinType);
        if (possiblyInnerType == null) {
            stringBuilder.append(this.renderTypeConstructor(typeConstructor2));
            stringBuilder.append(this.renderTypeArguments(kotlinType.getArguments()));
            return;
        }
        this.renderPossiblyInnerType(stringBuilder, possiblyInnerType);
    }

    static /* synthetic */ void renderTypeConstructorAndArguments$default(DescriptorRendererImpl descriptorRendererImpl, StringBuilder stringBuilder, KotlinType kotlinType, TypeConstructor typeConstructor2, int n, Object object) {
        if ((n & 2) != 0) {
            typeConstructor2 = kotlinType.getConstructor();
        }
        descriptorRendererImpl.renderTypeConstructorAndArguments(stringBuilder, kotlinType, typeConstructor2);
    }

    private final void renderPossiblyInnerType(StringBuilder stringBuilder, PossiblyInnerType possiblyInnerType) {
        block3: {
            Object object;
            block2: {
                object = possiblyInnerType.getOuterType();
                if (object == null) break block2;
                PossiblyInnerType possiblyInnerType2 = object;
                boolean bl = false;
                this.renderPossiblyInnerType(stringBuilder, possiblyInnerType2);
                stringBuilder.append('.');
                Name name = possiblyInnerType.getClassifierDescriptor().getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                StringBuilder stringBuilder2 = stringBuilder.append(this.renderName(name, false));
                object = stringBuilder2;
                if (stringBuilder2 != null) break block3;
            }
            TypeConstructor typeConstructor2 = possiblyInnerType.getClassifierDescriptor().getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"");
            object = stringBuilder.append(this.renderTypeConstructor(typeConstructor2));
        }
        stringBuilder.append(this.renderTypeArguments(possiblyInnerType.getArguments()));
    }

    public String renderTypeConstructor(TypeConstructor typeConstructor2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"");
        ClassifierDescriptor classifierDescriptor = typeConstructor2.getDeclarationDescriptor();
        if (classifierDescriptor instanceof TypeParameterDescriptor || classifierDescriptor instanceof ClassDescriptor || classifierDescriptor instanceof TypeAliasDescriptor) {
            string = this.renderClassifierName(classifierDescriptor);
        } else if (classifierDescriptor == null) {
            string = typeConstructor2 instanceof IntersectionTypeConstructor ? ((IntersectionTypeConstructor)typeConstructor2).makeDebugNameForIntersectionType(DescriptorRendererImpl$$Lambda$1.INSTANCE) : typeConstructor2.toString();
        } else {
            throw new IllegalStateException(("Unexpected classifier: " + classifierDescriptor.getClass()).toString());
        }
        return string;
    }

    @Override
    public String renderTypeProjection(TypeProjection typeProjection) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)typeProjection, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.appendTypeProjections(stringBuilder2, CollectionsKt.listOf((Object)typeProjection));
        return stringBuilder.toString();
    }

    private final void appendTypeProjections(StringBuilder stringBuilder, List<? extends TypeProjection> list) {
        DescriptorRendererImpl descriptorRendererImpl = this;
        CollectionsKt.joinTo$default((Iterable)list, (Appendable)stringBuilder, (CharSequence)", ", null, null, (int)0, null, (Function1)new DescriptorRendererImpl$$Lambda$2(descriptorRendererImpl), (int)60, null);
    }

    private final void renderFunctionType(StringBuilder stringBuilder, KotlinType kotlinType) {
        boolean bl;
        boolean bl2;
        int n = stringBuilder.length();
        Object object = this.getFunctionTypeAnnotationsRenderer();
        boolean bl3 = false;
        DescriptorRendererImpl.renderAnnotations$default((DescriptorRendererImpl)object, stringBuilder, kotlinType, null, 2, null);
        boolean bl4 = stringBuilder.length() != n;
        object = FunctionTypesKt.getReceiverTypeFromFunctionType(kotlinType);
        List<KotlinType> list = FunctionTypesKt.getContextReceiverTypesFromFunctionType(kotlinType);
        boolean bl5 = FunctionTypesKt.isSuspendFunctionType(kotlinType);
        boolean bl6 = kotlinType.isMarkedNullable();
        boolean bl7 = bl2 = bl6 || bl4 && object != null;
        if (bl2) {
            StringBuilder stringBuilder2;
            if (bl5) {
                stringBuilder2 = stringBuilder.insert(n, '(');
            } else {
                if (bl4) {
                    bl = CharsKt.isWhitespace((char)StringsKt.last((CharSequence)stringBuilder));
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    if (stringBuilder.charAt(StringsKt.getLastIndex((CharSequence)stringBuilder) - 1) != ')') {
                        stringBuilder.insert(StringsKt.getLastIndex((CharSequence)stringBuilder), "()");
                    }
                }
                stringBuilder2 = stringBuilder.append("(");
            }
        }
        if (!((Collection)list).isEmpty()) {
            stringBuilder.append("context(");
            List<KotlinType> list2 = list.subList(0, CollectionsKt.getLastIndex(list));
            for (KotlinType kotlinType2 : list2) {
                this.renderNormalizedType(stringBuilder, kotlinType2);
                stringBuilder.append(", ");
            }
            this.renderNormalizedType(stringBuilder, (KotlinType)CollectionsKt.last(list));
            stringBuilder.append(") ");
        }
        this.renderModifier(stringBuilder, bl5, "suspend");
        if (object != null) {
            boolean bl8 = bl = this.shouldRenderAsPrettyFunctionType((KotlinType)object) && !((KotlinType)object).isMarkedNullable() || this.hasModifiersOrAnnotations((KotlinType)object) || object instanceof DefinitelyNotNullType;
            if (bl) {
                stringBuilder.append("(");
            }
            this.renderNormalizedType(stringBuilder, (KotlinType)object);
            if (bl) {
                stringBuilder.append(")");
            }
            stringBuilder.append(".");
        }
        stringBuilder.append("(");
        if (FunctionTypesKt.isBuiltinExtensionFunctionalType(kotlinType) && kotlinType.getArguments().size() <= 1) {
            stringBuilder.append("???");
        } else {
            List<TypeProjection> list3 = FunctionTypesKt.getValueParameterTypesFromFunctionType(kotlinType);
            Iterator<KotlinType> iterator2 = ((Iterable)list3).iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                Name name;
                Name name2;
                int n3 = n2++;
                TypeProjection typeProjection = (TypeProjection)((Object)iterator2.next());
                if (n3 > 0) {
                    stringBuilder.append(", ");
                }
                if (this.getParameterNamesInFunctionalTypes()) {
                    KotlinType kotlinType3 = typeProjection.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"");
                    name2 = FunctionTypesKt.extractParameterNameFromFunctionTypeArgument(kotlinType3);
                } else {
                    name2 = name = null;
                }
                if (name != null) {
                    stringBuilder.append(this.renderName(name, false));
                    stringBuilder.append(": ");
                }
                stringBuilder.append(this.renderTypeProjection(typeProjection));
            }
        }
        stringBuilder.append(") ").append(this.arrow()).append(" ");
        this.renderNormalizedType(stringBuilder, FunctionTypesKt.getReturnTypeFromFunctionType(kotlinType));
        if (bl2) {
            stringBuilder.append(")");
        }
        if (bl6) {
            stringBuilder.append("?");
        }
    }

    private final boolean hasModifiersOrAnnotations(KotlinType kotlinType) {
        return FunctionTypesKt.isSuspendFunctionType(kotlinType) || !kotlinType.getAnnotations().isEmpty();
    }

    private final void appendDefinedIn(StringBuilder stringBuilder, DeclarationDescriptor declarationDescriptor) {
        block3: {
            if (declarationDescriptor instanceof PackageFragmentDescriptor || declarationDescriptor instanceof PackageViewDescriptor) {
                return;
            }
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor.getContainingDeclaration();
            if (declarationDescriptor2 == null || declarationDescriptor2 instanceof ModuleDescriptor) break block3;
            stringBuilder.append(" ").append(this.renderMessage("defined in")).append(" ");
            FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(declarationDescriptor2);
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"");
            FqNameUnsafe fqNameUnsafe2 = fqNameUnsafe;
            stringBuilder.append(fqNameUnsafe2.isRoot() ? "root package" : this.renderFqName(fqNameUnsafe2));
            if (this.getWithSourceFileForTopLevel() && declarationDescriptor2 instanceof PackageFragmentDescriptor && declarationDescriptor instanceof DeclarationDescriptorWithSource) {
                String string = ((DeclarationDescriptorWithSource)declarationDescriptor).getSource().getContainingFile().getName();
                if (string != null) {
                    String string2 = string;
                    boolean bl = false;
                    stringBuilder.append(" ").append(this.renderMessage("in file")).append(" ").append(string2);
                }
            }
        }
    }

    private final void renderAnnotations(StringBuilder stringBuilder, Annotated annotated, AnnotationUseSiteTarget annotationUseSiteTarget) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.ANNOTATIONS)) {
            return;
        }
        Set<FqName> set = annotated instanceof KotlinType ? this.getExcludedTypeAnnotationClasses() : this.getExcludedAnnotationClasses();
        Function1<AnnotationDescriptor, Boolean> function1 = this.getAnnotationFilter();
        for (AnnotationDescriptor annotationDescriptor : annotated.getAnnotations()) {
            if (CollectionsKt.contains((Iterable)set, (Object)annotationDescriptor.getFqName()) || this.isParameterName(annotationDescriptor) || function1 != null && !((Boolean)function1.invoke((Object)annotationDescriptor)).booleanValue()) continue;
            stringBuilder.append(this.renderAnnotation(annotationDescriptor, annotationUseSiteTarget));
            StringBuilder stringBuilder2 = this.getEachAnnotationOnNewLine() ? stringBuilder.append('\n') : stringBuilder.append(" ");
        }
    }

    static /* synthetic */ void renderAnnotations$default(DescriptorRendererImpl descriptorRendererImpl, StringBuilder stringBuilder, Annotated annotated, AnnotationUseSiteTarget annotationUseSiteTarget, int n, Object object) {
        if ((n & 2) != 0) {
            annotationUseSiteTarget = null;
        }
        descriptorRendererImpl.renderAnnotations(stringBuilder, annotated, annotationUseSiteTarget);
    }

    private final boolean isParameterName(AnnotationDescriptor annotationDescriptor) {
        return Intrinsics.areEqual((Object)annotationDescriptor.getFqName(), (Object)StandardNames.FqNames.parameterName);
    }

    @Override
    public String renderAnnotation(AnnotationDescriptor annotationDescriptor, AnnotationUseSiteTarget annotationUseSiteTarget) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)annotationDescriptor, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder2.append('@');
        if (annotationUseSiteTarget != null) {
            stringBuilder2.append(annotationUseSiteTarget.getRenderName() + ':');
        }
        KotlinType kotlinType = annotationDescriptor.getType();
        stringBuilder2.append(this.renderType(kotlinType));
        if (this.getIncludeAnnotationArguments()) {
            List<String> list = this.renderAndSortAnnotationArguments(annotationDescriptor);
            if (this.getIncludeEmptyAnnotationArguments() || !((Collection)list).isEmpty()) {
                CollectionsKt.joinTo$default((Iterable)list, (Appendable)stringBuilder2, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)112, null);
            }
        }
        if (this.getVerbose() && (KotlinTypeKt.isError(kotlinType) || kotlinType.getConstructor().getDeclarationDescriptor() instanceof NotFoundClasses.MockClassDescriptor)) {
            stringBuilder2.append(" /* annotation class not found */");
        }
        return stringBuilder.toString();
    }

    private final List<String> renderAndSortAnnotationArguments(AnnotationDescriptor annotationDescriptor) {
        Object object4;
        List list;
        List list2;
        Object object2;
        Iterable<ValueParameterDescriptor> iterable;
        List list3;
        Object object3;
        ClassDescriptor classDescriptor;
        Map<Name, ConstantValue<?>> map = annotationDescriptor.getAllValueArguments();
        ClassDescriptor classDescriptor2 = classDescriptor = this.getRenderDefaultAnnotationArguments() ? DescriptorUtilsKt.getAnnotationClass(annotationDescriptor) : null;
        if (classDescriptor != null && (object3 = classDescriptor.getUnsubstitutedPrimaryConstructor()) != null && (list3 = object3.getValueParameters()) != null) {
            boolean bl;
            ValueParameterDescriptor valueParameterDescriptor;
            iterable = list3;
            boolean bl2 = false;
            Iterable<ValueParameterDescriptor> iterable2 = iterable;
            Object object4 = new ArrayList();
            boolean bl3 = false;
            for (Object bl5 : iterable2) {
                valueParameterDescriptor = (ValueParameterDescriptor)bl5;
                bl = false;
                if (!valueParameterDescriptor.declaresDefaultValue()) continue;
                object4.add(bl5);
            }
            iterable = (List)object4;
            bl2 = false;
            iterable2 = iterable;
            object4 = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
            boolean e = false;
            for (Object entry : iterable2) {
                valueParameterDescriptor = (ValueParameterDescriptor)entry;
                object2 = object4;
                bl = false;
                object2.add(valueParameterDescriptor.getName());
            }
            list2 = (List)object4;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        List list4 = list;
        list3 = list4;
        boolean bl = false;
        iterable = list3;
        Iterable iterable3 = new ArrayList();
        boolean bl4 = false;
        for (Object e : iterable) {
            object4 = (Name)e;
            boolean bl2 = false;
            if (!(!map.containsKey(object4))) continue;
            iterable3.add(e);
        }
        list3 = (List)iterable3;
        bl = false;
        iterable = list3;
        iterable3 = new ArrayList(CollectionsKt.collectionSizeOrDefault(list3, (int)10));
        bl4 = false;
        for (Object e : iterable) {
            object4 = (Name)e;
            object2 = iterable3;
            boolean bl3 = false;
            object2.add(((Name)object4).asString() + " = ...");
        }
        object3 = (List)iterable3;
        Iterable iterable2 = map.entrySet();
        boolean bl7 = false;
        iterable3 = iterable2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
        boolean bl8 = false;
        for (Object object4 : iterable3) {
            Map.Entry entry = (Map.Entry)object4;
            object2 = collection;
            boolean bl5 = false;
            Name name = (Name)entry.getKey();
            ConstantValue constantValue = (ConstantValue)entry.getValue();
            object2.add(name.asString() + " = " + (!list4.contains(name) ? this.renderConstant(constantValue) : "..."));
        }
        list3 = (List)collection;
        return CollectionsKt.sorted((Iterable)CollectionsKt.plus((Collection)((Collection)object3), (Iterable)list3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String renderConstant(ConstantValue<?> constantValue) {
        String string;
        Function1<ConstantValue<?>, String> function1 = this.options.getPropertyConstantRenderer();
        if (function1 != null) {
            Function1<ConstantValue<?>, String> function12 = function1;
            return (String)function12.invoke(constantValue);
        }
        ConstantValue<?> constantValue2 = constantValue;
        if (constantValue2 instanceof ArrayValue) {
            Iterable iterable = (Iterable)((ArrayValue)constantValue).getValue();
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList();
            boolean bl2 = false;
            Iterable iterable3 = iterable2;
            boolean bl3 = false;
            Iterator iterator2 = iterable3.iterator();
            while (iterator2.hasNext()) {
                String string2;
                Object t;
                Object t2 = t = iterator2.next();
                boolean bl4 = false;
                ConstantValue constantValue3 = (ConstantValue)t2;
                boolean bl5 = false;
                if (this.renderConstant(constantValue3) == null) continue;
                boolean bl6 = false;
                collection.add(string2);
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)collection), (CharSequence)", ", (CharSequence)"{", (CharSequence)"}", (int)0, null, null, (int)56, null);
            return string;
        } else if (constantValue2 instanceof AnnotationValue) {
            string = StringsKt.removePrefix((String)DescriptorRenderer.renderAnnotation$default(this, (AnnotationDescriptor)((AnnotationValue)constantValue).getValue(), null, 2, null), (CharSequence)"@");
            return string;
        } else if (constantValue2 instanceof KClassValue) {
            KClassValue.Value value = (KClassValue.Value)((KClassValue)constantValue).getValue();
            if (value instanceof KClassValue.Value.LocalClass) {
                string = ((KClassValue.Value.LocalClass)value).getType() + "::class";
                return string;
            } else {
                if (!(value instanceof KClassValue.Value.NormalClass)) throw new NoWhenBranchMatchedException();
                String string3 = null;
                string3 = ((KClassValue.Value.NormalClass)value).getClassId().asSingleFqName().asString();
                int n = ((KClassValue.Value.NormalClass)value).getArrayDimensions();
                int n2 = 0;
                while (n2 < n) {
                    int n3 = n2++;
                    boolean bl = false;
                    string3 = "kotlin.Array<" + string3 + '>';
                }
                string = string3 + "::class";
            }
            return string;
        } else {
            string = constantValue.toString();
        }
        return string;
    }

    private final boolean renderVisibility(DescriptorVisibility descriptorVisibility, StringBuilder stringBuilder) {
        DescriptorVisibility descriptorVisibility2 = descriptorVisibility;
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.VISIBILITY)) {
            return false;
        }
        if (this.getNormalizedVisibilities()) {
            descriptorVisibility2 = descriptorVisibility2.normalize();
        }
        if (!this.getRenderDefaultVisibility() && Intrinsics.areEqual((Object)descriptorVisibility2, (Object)DescriptorVisibilities.DEFAULT_VISIBILITY)) {
            return false;
        }
        stringBuilder.append(this.renderKeyword(descriptorVisibility2.getInternalDisplayName())).append(" ");
        return true;
    }

    private final void renderModality(Modality modality, StringBuilder stringBuilder, Modality modality2) {
        if (!this.getRenderDefaultModality() && modality == modality2) {
            return;
        }
        this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.MODALITY), CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(modality.name()));
    }

    private final Modality implicitModalityWithoutExtensions(MemberDescriptor memberDescriptor) {
        if (memberDescriptor instanceof ClassDescriptor) {
            return ((ClassDescriptor)memberDescriptor).getKind() == ClassKind.INTERFACE ? Modality.ABSTRACT : Modality.FINAL;
        }
        DeclarationDescriptor declarationDescriptor = memberDescriptor.getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return Modality.FINAL;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (!(memberDescriptor instanceof CallableMemberDescriptor)) {
            return Modality.FINAL;
        }
        Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)memberDescriptor).getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"");
        if (!collection.isEmpty() && classDescriptor2.getModality() != Modality.FINAL) {
            return Modality.OPEN;
        }
        return classDescriptor2.getKind() == ClassKind.INTERFACE && !Intrinsics.areEqual((Object)((CallableMemberDescriptor)memberDescriptor).getVisibility(), (Object)DescriptorVisibilities.PRIVATE) ? (((CallableMemberDescriptor)memberDescriptor).getModality() == Modality.ABSTRACT ? Modality.ABSTRACT : Modality.OPEN) : Modality.FINAL;
    }

    private final void renderModalityForCallable(CallableMemberDescriptor callableMemberDescriptor, StringBuilder stringBuilder) {
        if (!DescriptorUtils.isTopLevelDeclaration(callableMemberDescriptor) || callableMemberDescriptor.getModality() != Modality.FINAL) {
            if (this.getOverrideRenderingPolicy() == OverrideRenderingPolicy.RENDER_OVERRIDE && callableMemberDescriptor.getModality() == Modality.OPEN && this.overridesSomething(callableMemberDescriptor)) {
                return;
            }
            Modality modality = callableMemberDescriptor.getModality();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)modality), (String)"");
            this.renderModality(modality, stringBuilder, this.implicitModalityWithoutExtensions(callableMemberDescriptor));
        }
    }

    private final void renderOverride(CallableMemberDescriptor callableMemberDescriptor, StringBuilder stringBuilder) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.OVERRIDE)) {
            return;
        }
        if (this.overridesSomething(callableMemberDescriptor) && this.getOverrideRenderingPolicy() != OverrideRenderingPolicy.RENDER_OPEN) {
            this.renderModifier(stringBuilder, true, "override");
            if (this.getVerbose()) {
                stringBuilder.append("/*").append(callableMemberDescriptor.getOverriddenDescriptors().size()).append("*/ ");
            }
        }
    }

    private final void renderMemberKind(CallableMemberDescriptor callableMemberDescriptor, StringBuilder stringBuilder) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.MEMBER_KIND)) {
            return;
        }
        if (this.getVerbose() && callableMemberDescriptor.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            stringBuilder.append("/*").append(CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(callableMemberDescriptor.getKind().name())).append("*/ ");
        }
    }

    private final void renderModifier(StringBuilder stringBuilder, boolean bl, String string) {
        if (bl) {
            stringBuilder.append(this.renderKeyword(string));
            stringBuilder.append(" ");
        }
    }

    private final void renderMemberModifiers(MemberDescriptor memberDescriptor, StringBuilder stringBuilder) {
        this.renderModifier(stringBuilder, memberDescriptor.isExternal(), "external");
        this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.EXPECT) && memberDescriptor.isExpect(), "expect");
        this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.ACTUAL) && memberDescriptor.isActual(), "actual");
    }

    /*
     * Unable to fully structure code
     */
    private final void renderAdditionalModifiers(FunctionDescriptor var1_1, StringBuilder var2_2) {
        block11: {
            block10: {
                if (!var1_1.isOperator()) ** GOTO lbl-1000
                v0 = var1_1.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(v0, (String)"");
                var4_3 = v0;
                var5_5 = false;
                if (((Collection)var4_3).isEmpty()) {
                    v1 = true;
                } else {
                    for (Iterator<T> var7_9 : var4_3) {
                        var8_10 = (FunctionDescriptor)var7_9;
                        var9_11 = false;
                        if (!var8_10.isOperator()) continue;
                        v1 = false;
                        break block10;
                    }
                    v1 = true;
                }
            }
            if (v1 || this.getAlwaysRenderModifiers()) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = var3_13 = false;
            }
            if (!var1_1.isInfix()) ** GOTO lbl-1000
            v3 = var1_1.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(v3, (String)"");
            var5_6 = v3;
            var6_8 = false;
            if (((Collection)var5_6).isEmpty()) {
                v4 = true;
            } else {
                var7_9 = var5_6.iterator();
                while (var7_9.hasNext()) {
                    var9_12 = var8_10 = var7_9.next();
                    var10_14 = false;
                    if (!var9_12.isInfix()) continue;
                    v4 = false;
                    break block11;
                }
                v4 = true;
            }
        }
        if (v4 || this.getAlwaysRenderModifiers()) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        var4_4 = v5;
        this.renderModifier(var2_2, var1_1.isTailrec(), "tailrec");
        this.renderSuspendModifier(var1_1, var2_2);
        this.renderModifier(var2_2, var1_1.isInline(), "inline");
        this.renderModifier(var2_2, var4_4, "infix");
        this.renderModifier(var2_2, var3_13, "operator");
    }

    private final void renderSuspendModifier(FunctionDescriptor functionDescriptor, StringBuilder stringBuilder) {
        this.renderModifier(stringBuilder, functionDescriptor.isSuspend(), "suspend");
    }

    @Override
    public String render(DeclarationDescriptor declarationDescriptor) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        declarationDescriptor.accept(new RenderDeclarationDescriptorVisitor(), stringBuilder2);
        if (this.getWithDefinedIn()) {
            this.appendDefinedIn(stringBuilder2, declarationDescriptor);
        }
        return stringBuilder.toString();
    }

    private final void renderTypeParameter(TypeParameterDescriptor typeParameterDescriptor, StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            stringBuilder.append(this.lt());
        }
        if (this.getVerbose()) {
            stringBuilder.append("/*").append(typeParameterDescriptor.getIndex()).append("*/ ");
        }
        this.renderModifier(stringBuilder, typeParameterDescriptor.isReified(), "reified");
        String string = typeParameterDescriptor.getVariance().getLabel();
        this.renderModifier(stringBuilder, ((CharSequence)string).length() > 0, string);
        DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, typeParameterDescriptor, null, 2, null);
        this.renderName(typeParameterDescriptor, stringBuilder, bl);
        int n = typeParameterDescriptor.getUpperBounds().size();
        if (n > 1 && !bl || n == 1) {
            KotlinType kotlinType = typeParameterDescriptor.getUpperBounds().iterator().next();
            if (!KotlinBuiltIns.isDefaultBound(kotlinType)) {
                StringBuilder stringBuilder2 = stringBuilder.append(" : ");
                Intrinsics.checkNotNull((Object)kotlinType);
                stringBuilder2.append(this.renderType(kotlinType));
            }
        } else if (bl) {
            boolean bl2 = true;
            for (KotlinType kotlinType : typeParameterDescriptor.getUpperBounds()) {
                if (KotlinBuiltIns.isDefaultBound(kotlinType)) continue;
                StringBuilder stringBuilder3 = bl2 ? stringBuilder.append(" : ") : stringBuilder.append(" & ");
                Intrinsics.checkNotNull((Object)kotlinType);
                stringBuilder.append(this.renderType(kotlinType));
                bl2 = false;
            }
        }
        if (bl) {
            stringBuilder.append(this.gt());
        }
    }

    private final void renderTypeParameters(List<? extends TypeParameterDescriptor> list, StringBuilder stringBuilder, boolean bl) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        if (!((Collection)list).isEmpty()) {
            stringBuilder.append(this.lt());
            this.renderTypeParameterList(stringBuilder, list);
            stringBuilder.append(this.gt());
            if (bl) {
                stringBuilder.append(" ");
            }
        }
    }

    private final void renderTypeParameterList(StringBuilder stringBuilder, List<? extends TypeParameterDescriptor> list) {
        Iterator<? extends TypeParameterDescriptor> iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameterDescriptor = iterator2.next();
            this.renderTypeParameter(typeParameterDescriptor, stringBuilder, false);
            if (!iterator2.hasNext()) continue;
            stringBuilder.append(", ");
        }
    }

    private final void renderFunction(FunctionDescriptor functionDescriptor, StringBuilder stringBuilder) {
        if (!this.getStartFromName()) {
            if (!this.getStartFromDeclarationKeyword()) {
                List<ReceiverParameterDescriptor> list = functionDescriptor.getContextReceiverParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"");
                this.renderContextReceivers(list, stringBuilder);
                DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, functionDescriptor, null, 2, null);
                DescriptorVisibility descriptorVisibility = functionDescriptor.getVisibility();
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"");
                this.renderVisibility(descriptorVisibility, stringBuilder);
                this.renderModalityForCallable(functionDescriptor, stringBuilder);
                if (this.getIncludeAdditionalModifiers()) {
                    this.renderMemberModifiers(functionDescriptor, stringBuilder);
                }
                this.renderOverride(functionDescriptor, stringBuilder);
                if (this.getIncludeAdditionalModifiers()) {
                    this.renderAdditionalModifiers(functionDescriptor, stringBuilder);
                } else {
                    this.renderSuspendModifier(functionDescriptor, stringBuilder);
                }
                this.renderMemberKind(functionDescriptor, stringBuilder);
                if (this.getVerbose()) {
                    if (functionDescriptor.isHiddenToOvercomeSignatureClash()) {
                        stringBuilder.append("/*isHiddenToOvercomeSignatureClash*/ ");
                    }
                    if (functionDescriptor.isHiddenForResolutionEverywhereBesideSupercalls()) {
                        stringBuilder.append("/*isHiddenForResolutionEverywhereBesideSupercalls*/ ");
                    }
                }
            }
            stringBuilder.append(this.renderKeyword("fun")).append(" ");
            List<TypeParameterDescriptor> list = functionDescriptor.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            this.renderTypeParameters(list, stringBuilder, true);
            this.renderReceiver(functionDescriptor, stringBuilder);
        }
        this.renderName(functionDescriptor, stringBuilder, true);
        List<ValueParameterDescriptor> list = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        this.renderValueParameters((Collection<? extends ValueParameterDescriptor>)list, functionDescriptor.hasSynthesizedParameterNames(), stringBuilder);
        this.renderReceiverAfterName(functionDescriptor, stringBuilder);
        KotlinType kotlinType = functionDescriptor.getReturnType();
        if (!(this.getWithoutReturnType() || !this.getUnitReturnType() && kotlinType != null && KotlinBuiltIns.isUnit(kotlinType))) {
            KotlinType kotlinType2 = kotlinType;
            stringBuilder.append(": ").append(kotlinType2 == null ? "[NULL]" : this.renderType(kotlinType2));
        }
        List<TypeParameterDescriptor> list2 = functionDescriptor.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"");
        this.renderWhereSuffix(list2, stringBuilder);
    }

    private final void renderReceiverAfterName(CallableDescriptor callableDescriptor, StringBuilder stringBuilder) {
        if (!this.getReceiverAfterName()) {
            return;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = callableDescriptor.getExtensionReceiverParameter();
        if (receiverParameterDescriptor != null) {
            StringBuilder stringBuilder2 = stringBuilder.append(" on ");
            KotlinType kotlinType = receiverParameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
            stringBuilder2.append(this.renderType(kotlinType));
        }
    }

    private final String renderForReceiver(KotlinType kotlinType) {
        String string = this.renderType(kotlinType);
        if (this.shouldRenderAsPrettyFunctionType(kotlinType) && !TypeUtils.isNullableType(kotlinType) || kotlinType instanceof DefinitelyNotNullType) {
            string = '(' + string + ')';
        }
        return string;
    }

    private final void renderContextReceivers(List<? extends ReceiverParameterDescriptor> list, StringBuilder stringBuilder) {
        if (!(!((Collection)list).isEmpty())) {
            return;
        }
        stringBuilder.append("context(");
        Iterator iterator2 = ((Iterable)list).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int n2 = n++;
            ReceiverParameterDescriptor receiverParameterDescriptor = (ReceiverParameterDescriptor)iterator2.next();
            this.renderAnnotations(stringBuilder, receiverParameterDescriptor, AnnotationUseSiteTarget.RECEIVER);
            KotlinType kotlinType = receiverParameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
            String string = this.renderForReceiver(kotlinType);
            stringBuilder.append(string);
            StringBuilder stringBuilder2 = n2 == CollectionsKt.getLastIndex(list) ? stringBuilder.append(") ") : stringBuilder.append(", ");
        }
    }

    private final void renderReceiver(CallableDescriptor callableDescriptor, StringBuilder stringBuilder) {
        ReceiverParameterDescriptor receiverParameterDescriptor = callableDescriptor.getExtensionReceiverParameter();
        if (receiverParameterDescriptor != null) {
            this.renderAnnotations(stringBuilder, receiverParameterDescriptor, AnnotationUseSiteTarget.RECEIVER);
            KotlinType kotlinType = receiverParameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
            String string = this.renderForReceiver(kotlinType);
            stringBuilder.append(string).append(".");
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void renderConstructor(ConstructorDescriptor var1_1, StringBuilder var2_2) {
        DescriptorRendererImpl.renderAnnotations$default(this, var2_2, var1_1, null, 2, null);
        if (!this.options.getRenderDefaultVisibility() && var1_1.getConstructedClass().getModality() == Modality.SEALED) ** GOTO lbl-1000
        v0 = var1_1.getVisibility();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"");
        if (this.renderVisibility(v0, var2_2)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        var3_3 = v1;
        this.renderMemberKind(var1_1, var2_2);
        v2 = var4_4 = this.getRenderConstructorKeyword() != false || var1_1.isPrimary() == false || var3_3 != false;
        if (var4_4) {
            var2_2.append(this.renderKeyword("constructor"));
        }
        v3 = var1_1.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"");
        var5_5 = v3;
        if (this.getSecondaryConstructorsAsPrimary()) {
            if (var4_4) {
                var2_2.append(" ");
            }
            this.renderName(var5_5, var2_2, true);
            v4 = var1_1.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(v4, (String)"");
            this.renderTypeParameters(v4, var2_2, false);
        }
        v5 = var1_1.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(v5, (String)"");
        this.renderValueParameters((Collection<? extends ValueParameterDescriptor>)v5, var1_1.hasSynthesizedParameterNames(), var2_2);
        if (this.getRenderConstructorDelegation() && !var1_1.isPrimary() && var5_5 instanceof ClassDescriptor && (var6_6 = ((ClassDescriptor)var5_5).getUnsubstitutedPrimaryConstructor()) != null) {
            v6 = var6_6.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(v6, (String)"");
            var8_7 = v6;
            var9_8 = false;
            var10_9 = var8_7;
            var11_10 = new ArrayList<E>();
            var12_11 = false;
            for (T var14_13 : var10_9) {
                var15_14 = (ValueParameterDescriptor)var14_13;
                var16_15 = false;
                if (!(var15_14.declaresDefaultValue() == false && var15_14.getVarargElementType() == null)) continue;
                var11_10.add(var14_13);
            }
            var7_16 = (List)var11_10;
            if (((Collection)var7_16).isEmpty() == false) {
                var2_2.append(" : ").append(this.renderKeyword("this"));
                var2_2.append(CollectionsKt.joinToString$default((Iterable)var7_16, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)DescriptorRendererImpl$$Lambda$3.INSTANCE, (int)24, null));
            }
        }
        if (this.getSecondaryConstructorsAsPrimary()) {
            v7 = var1_1.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(v7, (String)"");
            this.renderWhereSuffix(v7, var2_2);
        }
    }

    private final void renderWhereSuffix(List<? extends TypeParameterDescriptor> list, StringBuilder stringBuilder) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        ArrayList arrayList = new ArrayList(0);
        for (TypeParameterDescriptor typeParameterDescriptor : list) {
            List<KotlinType> list2 = typeParameterDescriptor.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"");
            Iterable iterable = CollectionsKt.drop((Iterable)list2, (int)1);
            boolean bl = false;
            for (Object t : iterable) {
                KotlinType kotlinType = (KotlinType)t;
                Collection collection = arrayList;
                boolean bl2 = false;
                StringBuilder stringBuilder2 = new StringBuilder();
                Name name = typeParameterDescriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                StringBuilder stringBuilder3 = stringBuilder2.append(this.renderName(name, false)).append(" : ");
                Intrinsics.checkNotNull((Object)kotlinType);
                collection.add(stringBuilder3.append(this.renderType(kotlinType)).toString());
            }
        }
        if (!((Collection)arrayList).isEmpty()) {
            stringBuilder.append(" ").append(this.renderKeyword("where")).append(" ");
            CollectionsKt.joinTo$default((Iterable)arrayList, (Appendable)stringBuilder, (CharSequence)", ", null, null, (int)0, null, null, (int)124, null);
        }
    }

    private final void renderValueParameters(Collection<? extends ValueParameterDescriptor> collection, boolean bl, StringBuilder stringBuilder) {
        boolean bl2 = this.shouldRenderParameterNames(bl);
        int n = collection.size();
        this.getValueParametersHandler().appendBeforeValueParameters(n, stringBuilder);
        Iterator iterator2 = ((Iterable)collection).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int n3 = n2++;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)iterator2.next();
            this.getValueParametersHandler().appendBeforeValueParameter(valueParameterDescriptor, n3, n, stringBuilder);
            this.renderValueParameter(valueParameterDescriptor, bl2, stringBuilder, false);
            this.getValueParametersHandler().appendAfterValueParameter(valueParameterDescriptor, n3, n, stringBuilder);
        }
        this.getValueParametersHandler().appendAfterValueParameters(n, stringBuilder);
    }

    private final boolean shouldRenderParameterNames(boolean bl) {
        boolean bl2;
        switch (WhenMappings.$EnumSwitchMapping$1[this.getParameterNameRenderingPolicy().ordinal()]) {
            case 1: {
                bl2 = true;
                break;
            }
            case 2: {
                if (!bl) {
                    bl2 = true;
                    break;
                }
                bl2 = false;
                break;
            }
            case 3: {
                bl2 = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl2;
    }

    /*
     * Unable to fully structure code
     */
    private final void renderValueParameter(ValueParameterDescriptor var1_1, boolean var2_2, StringBuilder var3_3, boolean var4_4) {
        if (var4_4) {
            var3_3.append(this.renderKeyword("value-parameter")).append(" ");
        }
        if (this.getVerbose()) {
            var3_3.append("/*").append(var1_1.getIndex()).append("*/ ");
        }
        DescriptorRendererImpl.renderAnnotations$default(this, var3_3, var1_1, null, 2, null);
        this.renderModifier(var3_3, var1_1.isCrossinline(), "crossinline");
        this.renderModifier(var3_3, var1_1.isNoinline(), "noinline");
        if (!this.getRenderPrimaryConstructorParametersAsProperties()) ** GOTO lbl-1000
        var7_5 = var1_1.getContainingDeclaration();
        v0 = var7_5 instanceof ClassConstructorDescriptor != false ? (ClassConstructorDescriptor)var7_5 : null;
        v1 = v0 != null ? v0.isPrimary() : false;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = var5_6 = false;
        }
        if (var5_6) {
            this.renderModifier(var3_3, this.getActualPropertiesInPrimaryConstructor(), "actual");
        }
        this.renderVariable(var1_1, var2_2, var3_3, var4_4, var5_6);
        v3 = this.getDefaultParameterValueRenderer() != null && (this.getDebugMode() != false ? var1_1.declaresDefaultValue() : DescriptorUtilsKt.declaresOrInheritsDefaultValue(var1_1)) != false ? true : (var6_7 = false);
        if (var6_7) {
            v4 = new StringBuilder().append(" = ");
            v5 = this.getDefaultParameterValueRenderer();
            Intrinsics.checkNotNull(v5);
            var3_3.append(v4.append((String)v5.invoke((Object)var1_1)).toString());
        }
    }

    private final void renderValVarPrefix(VariableDescriptor variableDescriptor, StringBuilder stringBuilder, boolean bl) {
        if (bl || !(variableDescriptor instanceof ValueParameterDescriptor)) {
            stringBuilder.append(this.renderKeyword(variableDescriptor.isVar() ? "var" : "val")).append(" ");
        }
    }

    static /* synthetic */ void renderValVarPrefix$default(DescriptorRendererImpl descriptorRendererImpl, VariableDescriptor variableDescriptor, StringBuilder stringBuilder, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        descriptorRendererImpl.renderValVarPrefix(variableDescriptor, stringBuilder, bl);
    }

    private final void renderVariable(VariableDescriptor variableDescriptor, boolean bl, StringBuilder stringBuilder, boolean bl2, boolean bl3) {
        KotlinType kotlinType = variableDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        KotlinType kotlinType2 = kotlinType;
        ValueParameterDescriptor valueParameterDescriptor = variableDescriptor instanceof ValueParameterDescriptor ? (ValueParameterDescriptor)variableDescriptor : null;
        KotlinType kotlinType3 = valueParameterDescriptor != null ? valueParameterDescriptor.getVarargElementType() : null;
        KotlinType kotlinType4 = kotlinType3;
        if (kotlinType4 == null) {
            kotlinType4 = kotlinType2;
        }
        KotlinType kotlinType5 = kotlinType4;
        this.renderModifier(stringBuilder, kotlinType3 != null, "vararg");
        if (bl3 || bl2 && !this.getStartFromName()) {
            this.renderValVarPrefix(variableDescriptor, stringBuilder, bl3);
        }
        if (bl) {
            this.renderName(variableDescriptor, stringBuilder, bl2);
            stringBuilder.append(": ");
        }
        stringBuilder.append(this.renderType(kotlinType5));
        this.renderInitializer(variableDescriptor, stringBuilder);
        if (this.getVerbose() && kotlinType3 != null) {
            stringBuilder.append(" /*").append(this.renderType(kotlinType2)).append("*/");
        }
    }

    private final void renderProperty(PropertyDescriptor propertyDescriptor, StringBuilder stringBuilder) {
        if (!this.getStartFromName()) {
            if (!this.getStartFromDeclarationKeyword()) {
                List<ReceiverParameterDescriptor> list = propertyDescriptor.getContextReceiverParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"");
                this.renderContextReceivers(list, stringBuilder);
                this.renderPropertyAnnotations(propertyDescriptor, stringBuilder);
                DescriptorVisibility descriptorVisibility = propertyDescriptor.getVisibility();
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"");
                this.renderVisibility(descriptorVisibility, stringBuilder);
                this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.CONST) && propertyDescriptor.isConst(), "const");
                this.renderMemberModifiers(propertyDescriptor, stringBuilder);
                this.renderModalityForCallable(propertyDescriptor, stringBuilder);
                this.renderOverride(propertyDescriptor, stringBuilder);
                this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.LATEINIT) && propertyDescriptor.isLateInit(), "lateinit");
                this.renderMemberKind(propertyDescriptor, stringBuilder);
            }
            DescriptorRendererImpl.renderValVarPrefix$default(this, propertyDescriptor, stringBuilder, false, 4, null);
            List<TypeParameterDescriptor> list = propertyDescriptor.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            this.renderTypeParameters(list, stringBuilder, true);
            this.renderReceiver(propertyDescriptor, stringBuilder);
        }
        this.renderName(propertyDescriptor, stringBuilder, true);
        StringBuilder stringBuilder2 = stringBuilder.append(": ");
        KotlinType kotlinType = propertyDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        stringBuilder2.append(this.renderType(kotlinType));
        this.renderReceiverAfterName(propertyDescriptor, stringBuilder);
        this.renderInitializer(propertyDescriptor, stringBuilder);
        List<TypeParameterDescriptor> list = propertyDescriptor.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        this.renderWhereSuffix(list, stringBuilder);
    }

    private final void renderPropertyAnnotations(PropertyDescriptor propertyDescriptor, StringBuilder stringBuilder) {
        block5: {
            boolean bl;
            Annotated annotated;
            if (!this.getModifiers().contains((Object)DescriptorRendererModifier.ANNOTATIONS)) {
                return;
            }
            DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, propertyDescriptor, null, 2, null);
            FieldDescriptor fieldDescriptor = propertyDescriptor.getBackingField();
            if (fieldDescriptor != null) {
                annotated = fieldDescriptor;
                bl = false;
                this.renderAnnotations(stringBuilder, annotated, AnnotationUseSiteTarget.FIELD);
            }
            FieldDescriptor fieldDescriptor2 = propertyDescriptor.getDelegateField();
            if (fieldDescriptor2 != null) {
                annotated = fieldDescriptor2;
                bl = false;
                this.renderAnnotations(stringBuilder, annotated, AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD);
            }
            if (this.getPropertyAccessorRenderingPolicy() != PropertyAccessorRenderingPolicy.NONE) break block5;
            PropertyGetterDescriptor propertyGetterDescriptor = propertyDescriptor.getGetter();
            if (propertyGetterDescriptor != null) {
                annotated = propertyGetterDescriptor;
                bl = false;
                this.renderAnnotations(stringBuilder, annotated, AnnotationUseSiteTarget.PROPERTY_GETTER);
            }
            PropertySetterDescriptor propertySetterDescriptor = propertyDescriptor.getSetter();
            if (propertySetterDescriptor != null) {
                annotated = propertySetterDescriptor;
                bl = false;
                Annotated annotated2 = annotated;
                boolean bl2 = false;
                this.renderAnnotations(stringBuilder, annotated2, AnnotationUseSiteTarget.PROPERTY_SETTER);
                List<ValueParameterDescriptor> list = annotated.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"");
                annotated2 = (ValueParameterDescriptor)CollectionsKt.single(list);
                bl2 = false;
                Intrinsics.checkNotNull((Object)annotated2);
                this.renderAnnotations(stringBuilder, annotated2, AnnotationUseSiteTarget.SETTER_PARAMETER);
            }
        }
    }

    private final void renderInitializer(VariableDescriptor variableDescriptor, StringBuilder stringBuilder) {
        block2: {
            if (!this.getIncludePropertyConstant()) break block2;
            ConstantValue<?> constantValue = variableDescriptor.getCompileTimeInitializer();
            if (constantValue != null) {
                ConstantValue<?> constantValue2 = constantValue;
                boolean bl = false;
                String string = this.renderConstant(constantValue2);
                if (string != null) {
                    stringBuilder.append(" = ").append(this.escape(string));
                }
            }
        }
    }

    private final void renderTypeAlias(TypeAliasDescriptor typeAliasDescriptor, StringBuilder stringBuilder) {
        DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, typeAliasDescriptor, null, 2, null);
        DescriptorVisibility descriptorVisibility = typeAliasDescriptor.getVisibility();
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"");
        this.renderVisibility(descriptorVisibility, stringBuilder);
        this.renderMemberModifiers(typeAliasDescriptor, stringBuilder);
        stringBuilder.append(this.renderKeyword("typealias")).append(" ");
        this.renderName(typeAliasDescriptor, stringBuilder, true);
        List<TypeParameterDescriptor> list = typeAliasDescriptor.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        this.renderTypeParameters(list, stringBuilder, false);
        this.renderCapturedTypeParametersIfRequired(typeAliasDescriptor, stringBuilder);
        stringBuilder.append(" = ").append(this.renderType(typeAliasDescriptor.getUnderlyingType()));
    }

    private final void renderCapturedTypeParametersIfRequired(ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters, StringBuilder stringBuilder) {
        List<TypeParameterDescriptor> list = classifierDescriptorWithTypeParameters.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        List<TypeParameterDescriptor> list2 = list;
        List<TypeParameterDescriptor> list3 = classifierDescriptorWithTypeParameters.getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"");
        List<TypeParameterDescriptor> list4 = list3;
        if (this.getVerbose() && classifierDescriptorWithTypeParameters.isInner() && list4.size() > list2.size()) {
            stringBuilder.append(" /*captured type parameters: ");
            this.renderTypeParameterList(stringBuilder, list4.subList(list2.size(), list4.size()));
            stringBuilder.append("*/");
        }
    }

    private final void renderClass(ClassDescriptor classDescriptor, StringBuilder stringBuilder) {
        ClassConstructorDescriptor classConstructorDescriptor;
        boolean bl;
        boolean bl2 = bl = classDescriptor.getKind() == ClassKind.ENUM_ENTRY;
        if (!this.getStartFromName()) {
            List<ReceiverParameterDescriptor> list = classDescriptor.getContextReceivers();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            this.renderContextReceivers(list, stringBuilder);
            DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, classDescriptor, null, 2, null);
            if (!bl) {
                DescriptorVisibility descriptorVisibility = classDescriptor.getVisibility();
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"");
                this.renderVisibility(descriptorVisibility, stringBuilder);
            }
            if (!(classDescriptor.getKind() == ClassKind.INTERFACE && classDescriptor.getModality() == Modality.ABSTRACT || classDescriptor.getKind().isSingleton() && classDescriptor.getModality() == Modality.FINAL)) {
                Modality modality = classDescriptor.getModality();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)modality), (String)"");
                this.renderModality(modality, stringBuilder, this.implicitModalityWithoutExtensions(classDescriptor));
            }
            this.renderMemberModifiers(classDescriptor, stringBuilder);
            this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.INNER) && classDescriptor.isInner(), "inner");
            this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.DATA) && classDescriptor.isData(), "data");
            this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.INLINE) && classDescriptor.isInline(), "inline");
            this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.VALUE) && classDescriptor.isValue(), "value");
            this.renderModifier(stringBuilder, this.getModifiers().contains((Object)DescriptorRendererModifier.FUN) && classDescriptor.isFun(), "fun");
            this.renderClassKindPrefix(classDescriptor, stringBuilder);
        }
        if (!DescriptorUtils.isCompanionObject(classDescriptor)) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(stringBuilder);
            }
            this.renderName(classDescriptor, stringBuilder, true);
        } else {
            this.renderCompanionObjectName(classDescriptor, stringBuilder);
        }
        if (bl) {
            return;
        }
        List<TypeParameterDescriptor> list = classDescriptor.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        List<TypeParameterDescriptor> list2 = list;
        this.renderTypeParameters(list2, stringBuilder, false);
        this.renderCapturedTypeParametersIfRequired(classDescriptor, stringBuilder);
        if (!classDescriptor.getKind().isSingleton() && this.getClassWithPrimaryConstructor() && (classConstructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor()) != null) {
            stringBuilder.append(" ");
            DescriptorRendererImpl.renderAnnotations$default(this, stringBuilder, classConstructorDescriptor, null, 2, null);
            DescriptorVisibility descriptorVisibility = classConstructorDescriptor.getVisibility();
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"");
            this.renderVisibility(descriptorVisibility, stringBuilder);
            stringBuilder.append(this.renderKeyword("constructor"));
            List<ValueParameterDescriptor> list3 = classConstructorDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"");
            this.renderValueParameters((Collection<? extends ValueParameterDescriptor>)list3, classConstructorDescriptor.hasSynthesizedParameterNames(), stringBuilder);
        }
        this.renderSuperTypes(classDescriptor, stringBuilder);
        this.renderWhereSuffix(list2, stringBuilder);
    }

    private final void renderSuperTypes(ClassDescriptor classDescriptor, StringBuilder stringBuilder) {
        if (this.getWithoutSuperTypes()) {
            return;
        }
        if (KotlinBuiltIns.isNothing(classDescriptor.getDefaultType())) {
            return;
        }
        Collection<KotlinType> collection = classDescriptor.getTypeConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"");
        Collection<KotlinType> collection2 = collection;
        if (collection2.isEmpty() || collection2.size() == 1 && KotlinBuiltIns.isAnyOrNullableAny(collection2.iterator().next())) {
            return;
        }
        this.renderSpaceIfNeeded(stringBuilder);
        stringBuilder.append(": ");
        DescriptorRendererImpl descriptorRendererImpl = this;
        CollectionsKt.joinTo$default((Iterable)collection2, (Appendable)stringBuilder, (CharSequence)", ", null, null, (int)0, null, (Function1)new DescriptorRendererImpl$$Lambda$4(descriptorRendererImpl), (int)60, null);
    }

    private final void renderClassKindPrefix(ClassDescriptor classDescriptor, StringBuilder stringBuilder) {
        stringBuilder.append(this.renderKeyword(DescriptorRenderer.Companion.getClassifierKindPrefix(classDescriptor)));
    }

    private final void renderPackageView(PackageViewDescriptor packageViewDescriptor, StringBuilder stringBuilder) {
        this.renderPackageHeader(packageViewDescriptor.getFqName(), "package", stringBuilder);
        if (this.getDebugMode()) {
            stringBuilder.append(" in context of ");
            this.renderName(packageViewDescriptor.getModule(), stringBuilder, false);
        }
    }

    private final void renderPackageFragment(PackageFragmentDescriptor packageFragmentDescriptor, StringBuilder stringBuilder) {
        this.renderPackageHeader(packageFragmentDescriptor.getFqName(), "package-fragment", stringBuilder);
        if (this.getDebugMode()) {
            stringBuilder.append(" in ");
            this.renderName(packageFragmentDescriptor.getContainingDeclaration(), stringBuilder, false);
        }
    }

    private final void renderPackageHeader(FqName fqName, String string, StringBuilder stringBuilder) {
        stringBuilder.append(this.renderKeyword(string));
        String string2 = this.renderFqName(fqName.toUnsafe());
        if (((CharSequence)string2).length() > 0) {
            stringBuilder.append(" ");
            stringBuilder.append(string2);
        }
    }

    private final void renderAccessorModifiers(PropertyAccessorDescriptor propertyAccessorDescriptor, StringBuilder stringBuilder) {
        this.renderMemberModifiers(propertyAccessorDescriptor, stringBuilder);
    }

    private final void renderSpaceIfNeeded(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        if (n == 0 || stringBuilder.charAt(n - 1) != ' ') {
            stringBuilder.append(' ');
        }
    }

    private final boolean overridesSomething(CallableMemberDescriptor callableMemberDescriptor) {
        return !callableMemberDescriptor.getOverriddenDescriptors().isEmpty();
    }

    public ClassifierNamePolicy getClassifierNamePolicy() {
        return this.options.getClassifierNamePolicy();
    }

    @Override
    public void setClassifierNamePolicy(ClassifierNamePolicy classifierNamePolicy) {
        Intrinsics.checkNotNullParameter((Object)classifierNamePolicy, (String)"");
        this.options.setClassifierNamePolicy(classifierNamePolicy);
    }

    public boolean getWithDefinedIn() {
        return this.options.getWithDefinedIn();
    }

    @Override
    public void setWithDefinedIn(boolean bl) {
        this.options.setWithDefinedIn(bl);
    }

    public boolean getWithSourceFileForTopLevel() {
        return this.options.getWithSourceFileForTopLevel();
    }

    public Set<DescriptorRendererModifier> getModifiers() {
        return this.options.getModifiers();
    }

    @Override
    public void setModifiers(Set<? extends DescriptorRendererModifier> set) {
        Intrinsics.checkNotNullParameter(set, (String)"");
        this.options.setModifiers(set);
    }

    public boolean getStartFromName() {
        return this.options.getStartFromName();
    }

    @Override
    public void setStartFromName(boolean bl) {
        this.options.setStartFromName(bl);
    }

    public boolean getStartFromDeclarationKeyword() {
        return this.options.getStartFromDeclarationKeyword();
    }

    @Override
    public boolean getDebugMode() {
        return this.options.getDebugMode();
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.options.setDebugMode(bl);
    }

    public boolean getClassWithPrimaryConstructor() {
        return this.options.getClassWithPrimaryConstructor();
    }

    public boolean getVerbose() {
        return this.options.getVerbose();
    }

    @Override
    public void setVerbose(boolean bl) {
        this.options.setVerbose(bl);
    }

    public boolean getUnitReturnType() {
        return this.options.getUnitReturnType();
    }

    @Override
    public boolean getEnhancedTypes() {
        return this.options.getEnhancedTypes();
    }

    public boolean getWithoutReturnType() {
        return this.options.getWithoutReturnType();
    }

    public boolean getNormalizedVisibilities() {
        return this.options.getNormalizedVisibilities();
    }

    public boolean getRenderDefaultVisibility() {
        return this.options.getRenderDefaultVisibility();
    }

    public boolean getRenderDefaultModality() {
        return this.options.getRenderDefaultModality();
    }

    public boolean getRenderConstructorDelegation() {
        return this.options.getRenderConstructorDelegation();
    }

    public boolean getRenderPrimaryConstructorParametersAsProperties() {
        return this.options.getRenderPrimaryConstructorParametersAsProperties();
    }

    public boolean getActualPropertiesInPrimaryConstructor() {
        return this.options.getActualPropertiesInPrimaryConstructor();
    }

    public boolean getUninferredTypeParameterAsName() {
        return this.options.getUninferredTypeParameterAsName();
    }

    public OverrideRenderingPolicy getOverrideRenderingPolicy() {
        return this.options.getOverrideRenderingPolicy();
    }

    public DescriptorRenderer.ValueParametersHandler getValueParametersHandler() {
        return this.options.getValueParametersHandler();
    }

    public RenderingFormat getTextFormat() {
        return this.options.getTextFormat();
    }

    @Override
    public void setTextFormat(RenderingFormat renderingFormat) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderingFormat), (String)"");
        this.options.setTextFormat(renderingFormat);
    }

    public Set<FqName> getExcludedAnnotationClasses() {
        return this.options.getExcludedAnnotationClasses();
    }

    @Override
    public Set<FqName> getExcludedTypeAnnotationClasses() {
        return this.options.getExcludedTypeAnnotationClasses();
    }

    @Override
    public void setExcludedTypeAnnotationClasses(Set<FqName> set) {
        Intrinsics.checkNotNullParameter(set, (String)"");
        this.options.setExcludedTypeAnnotationClasses(set);
    }

    public Function1<AnnotationDescriptor, Boolean> getAnnotationFilter() {
        return this.options.getAnnotationFilter();
    }

    public boolean getEachAnnotationOnNewLine() {
        return this.options.getEachAnnotationOnNewLine();
    }

    @Override
    public AnnotationArgumentsRenderingPolicy getAnnotationArgumentsRenderingPolicy() {
        return this.options.getAnnotationArgumentsRenderingPolicy();
    }

    @Override
    public void setAnnotationArgumentsRenderingPolicy(AnnotationArgumentsRenderingPolicy annotationArgumentsRenderingPolicy) {
        Intrinsics.checkNotNullParameter((Object)((Object)annotationArgumentsRenderingPolicy), (String)"");
        this.options.setAnnotationArgumentsRenderingPolicy(annotationArgumentsRenderingPolicy);
    }

    public boolean getIncludeAnnotationArguments() {
        return this.options.getIncludeAnnotationArguments();
    }

    public boolean getIncludeEmptyAnnotationArguments() {
        return this.options.getIncludeEmptyAnnotationArguments();
    }

    public boolean getBoldOnlyForNamesInHtml() {
        return this.options.getBoldOnlyForNamesInHtml();
    }

    public boolean getIncludePropertyConstant() {
        return this.options.getIncludePropertyConstant();
    }

    public ParameterNameRenderingPolicy getParameterNameRenderingPolicy() {
        return this.options.getParameterNameRenderingPolicy();
    }

    @Override
    public void setParameterNameRenderingPolicy(ParameterNameRenderingPolicy parameterNameRenderingPolicy) {
        Intrinsics.checkNotNullParameter((Object)((Object)parameterNameRenderingPolicy), (String)"");
        this.options.setParameterNameRenderingPolicy(parameterNameRenderingPolicy);
    }

    public boolean getWithoutTypeParameters() {
        return this.options.getWithoutTypeParameters();
    }

    @Override
    public void setWithoutTypeParameters(boolean bl) {
        this.options.setWithoutTypeParameters(bl);
    }

    public boolean getReceiverAfterName() {
        return this.options.getReceiverAfterName();
    }

    @Override
    public void setReceiverAfterName(boolean bl) {
        this.options.setReceiverAfterName(bl);
    }

    public boolean getRenderCompanionObjectName() {
        return this.options.getRenderCompanionObjectName();
    }

    @Override
    public void setRenderCompanionObjectName(boolean bl) {
        this.options.setRenderCompanionObjectName(bl);
    }

    public boolean getWithoutSuperTypes() {
        return this.options.getWithoutSuperTypes();
    }

    @Override
    public void setWithoutSuperTypes(boolean bl) {
        this.options.setWithoutSuperTypes(bl);
    }

    public Function1<KotlinType, KotlinType> getTypeNormalizer() {
        return this.options.getTypeNormalizer();
    }

    public Function1<ValueParameterDescriptor, String> getDefaultParameterValueRenderer() {
        return this.options.getDefaultParameterValueRenderer();
    }

    public boolean getSecondaryConstructorsAsPrimary() {
        return this.options.getSecondaryConstructorsAsPrimary();
    }

    public PropertyAccessorRenderingPolicy getPropertyAccessorRenderingPolicy() {
        return this.options.getPropertyAccessorRenderingPolicy();
    }

    public boolean getRenderDefaultAnnotationArguments() {
        return this.options.getRenderDefaultAnnotationArguments();
    }

    public boolean getAlwaysRenderModifiers() {
        return this.options.getAlwaysRenderModifiers();
    }

    public boolean getRenderConstructorKeyword() {
        return this.options.getRenderConstructorKeyword();
    }

    public boolean getRenderUnabbreviatedType() {
        return this.options.getRenderUnabbreviatedType();
    }

    public boolean getRenderTypeExpansions() {
        return this.options.getRenderTypeExpansions();
    }

    public boolean getRenderAbbreviatedTypeComments() {
        return this.options.getRenderAbbreviatedTypeComments();
    }

    public boolean getIncludeAdditionalModifiers() {
        return this.options.getIncludeAdditionalModifiers();
    }

    public boolean getParameterNamesInFunctionalTypes() {
        return this.options.getParameterNamesInFunctionalTypes();
    }

    public boolean getPresentableUnresolvedTypes() {
        return this.options.getPresentableUnresolvedTypes();
    }

    public boolean getInformativeErrorType() {
        return this.options.getInformativeErrorType();
    }

    private static final Unit functionTypeAnnotationsRenderer_delegate$lambda$1$lambda$0(DescriptorRendererOptions descriptorRendererOptions) {
        Intrinsics.checkNotNullParameter((Object)descriptorRendererOptions, (String)"");
        Object[] objectArray = new FqName[]{StandardNames.FqNames.extensionFunctionType, StandardNames.FqNames.contextFunctionTypeParams};
        descriptorRendererOptions.setExcludedTypeAnnotationClasses(SetsKt.plus(descriptorRendererOptions.getExcludedTypeAnnotationClasses(), (Iterable)CollectionsKt.listOf((Object[])objectArray)));
        return Unit.INSTANCE;
    }

    private static final DescriptorRendererImpl functionTypeAnnotationsRenderer_delegate$lambda$1(DescriptorRendererImpl descriptorRendererImpl) {
        DescriptorRenderer descriptorRenderer = descriptorRendererImpl.withOptions(DescriptorRendererImpl$$Lambda$5.INSTANCE);
        Intrinsics.checkNotNull((Object)descriptorRenderer);
        return (DescriptorRendererImpl)descriptorRenderer;
    }

    private static final Object renderTypeConstructor$lambda$8(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return kotlinType instanceof StubTypeForBuilderInference ? ((StubTypeForBuilderInference)kotlinType).getOriginalTypeVariable() : kotlinType;
    }

    private static final CharSequence appendTypeProjections$lambda$10(DescriptorRendererImpl descriptorRendererImpl, TypeProjection typeProjection) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)typeProjection, (String)"");
        if (typeProjection.isStarProjection()) {
            charSequence = "*";
        } else {
            KotlinType kotlinType = typeProjection.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
            String string = descriptorRendererImpl.renderType(kotlinType);
            charSequence = typeProjection.getProjectionKind() == Variance.INVARIANT ? string : (Object)((Object)typeProjection.getProjectionKind()) + ' ' + string;
        }
        return charSequence;
    }

    private static final CharSequence renderConstructor$lambda$26(ValueParameterDescriptor valueParameterDescriptor) {
        return "";
    }

    private static final CharSequence renderSuperTypes$lambda$36(DescriptorRendererImpl descriptorRendererImpl, KotlinType kotlinType) {
        Intrinsics.checkNotNull((Object)kotlinType);
        return descriptorRendererImpl.renderType(kotlinType);
    }

    static /* synthetic */ DescriptorRendererImpl accessor$DescriptorRendererImpl$lambda0(DescriptorRendererImpl descriptorRendererImpl) {
        return DescriptorRendererImpl.functionTypeAnnotationsRenderer_delegate$lambda$1(descriptorRendererImpl);
    }

    static /* synthetic */ Object accessor$DescriptorRendererImpl$lambda1(KotlinType kotlinType) {
        return DescriptorRendererImpl.renderTypeConstructor$lambda$8(kotlinType);
    }

    static /* synthetic */ CharSequence accessor$DescriptorRendererImpl$lambda2(DescriptorRendererImpl descriptorRendererImpl, TypeProjection typeProjection) {
        return DescriptorRendererImpl.appendTypeProjections$lambda$10(descriptorRendererImpl, typeProjection);
    }

    static /* synthetic */ CharSequence accessor$DescriptorRendererImpl$lambda3(ValueParameterDescriptor valueParameterDescriptor) {
        return DescriptorRendererImpl.renderConstructor$lambda$26(valueParameterDescriptor);
    }

    static /* synthetic */ CharSequence accessor$DescriptorRendererImpl$lambda4(DescriptorRendererImpl descriptorRendererImpl, KotlinType kotlinType) {
        return DescriptorRendererImpl.renderSuperTypes$lambda$36(descriptorRendererImpl, kotlinType);
    }

    static /* synthetic */ Unit accessor$DescriptorRendererImpl$lambda5(DescriptorRendererOptions descriptorRendererOptions) {
        return DescriptorRendererImpl.functionTypeAnnotationsRenderer_delegate$lambda$1$lambda$0(descriptorRendererOptions);
    }

    private final class RenderDeclarationDescriptorVisitor
    implements DeclarationDescriptorVisitor<Unit, StringBuilder> {
        @Override
        public void visitValueParameterDescriptor(ValueParameterDescriptor valueParameterDescriptor, StringBuilder stringBuilder) {
            Intrinsics.checkNotNullParameter((Object)valueParameterDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
            DescriptorRendererImpl.this.renderValueParameter(valueParameterDescriptor, true, stringBuilder, true);
        }

        @Override
        public void visitPropertyDescriptor(PropertyDescriptor propertyDescriptor, StringBuilder stringBuilder) {
            Intrinsics.checkNotNullParameter((Object)propertyDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
            DescriptorRendererImpl.this.renderProperty(propertyDescriptor, stringBuilder);
        }

        @Override
        public void visitPropertyGetterDescriptor(PropertyGetterDescriptor propertyGetterDescriptor, StringBuilder stringBuilder) {
            Intrinsics.checkNotNullParameter((Object)propertyGetterDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
            this.visitPropertyAccessorDescriptor(propertyGetterDescriptor, stringBuilder, "getter");
        }

        @Override
        public void visitPropertySetterDescriptor(PropertySetterDescriptor propertySetterDescriptor, StringBuilder stringBuilder) {
            Intrinsics.checkNotNullParameter((Object)propertySetterDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
            this.visitPropertyAccessorDescriptor(propertySetterDescriptor, stringBuilder, "setter");
        }

        private final void visitPropertyAccessorDescriptor(PropertyAccessorDescriptor propertyAccessorDescriptor, StringBuilder stringBuilder, String string) {
            switch (WhenMappings.$EnumSwitchMapping$0[DescriptorRendererImpl.this.getPropertyAccessorRenderingPolicy().ordinal()]) {
                case 1: {
                    DescriptorRendererImpl.this.renderAccessorModifiers(propertyAccessorDescriptor, stringBuilder);
                    stringBuilder.append(string + " for ");
                    PropertyDescriptor propertyDescriptor = propertyAccessorDescriptor.getCorrespondingProperty();
                    Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"");
                    DescriptorRendererImpl.this.renderProperty(propertyDescriptor, stringBuilder);
                    break;
                }
                case 2: {
                    this.visitFunctionDescriptor((FunctionDescriptor)propertyAccessorDescriptor, stringBuilder);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        @Override
        public void visitFunctionDescriptor(FunctionDescriptor functionDescriptor, StringBuilder stringBuilder) {
            Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
            DescriptorRendererImpl.this.renderFunction(functionDescriptor, stringBuilder);
        }

        @Override
        public void visitReceiverParameterDescriptor(ReceiverParameterDescriptor receiverParameterDescriptor, StringBuilder stringBuilder) {
            Intrinsics.checkNotNullParameter((Object)receiverParameterDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
            stringBuilder.append(receiverParameterDescriptor.getName());
        }

        @Override
        public void visitConstructorDescriptor(ConstructorDescriptor constructorDescriptor, StringBuilder stringBuilder) {
            Intrinsics.checkNotNullParameter((Object)constructorDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
            DescriptorRendererImpl.this.renderConstructor(constructorDescriptor, stringBuilder);
        }

        @Override
        public void visitTypeParameterDescriptor(TypeParameterDescriptor typeParameterDescriptor, StringBuilder stringBuilder) {
            Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
            DescriptorRendererImpl.this.renderTypeParameter(typeParameterDescriptor, stringBuilder, true);
        }

        @Override
        public void visitPackageFragmentDescriptor(PackageFragmentDescriptor packageFragmentDescriptor, StringBuilder stringBuilder) {
            Intrinsics.checkNotNullParameter((Object)packageFragmentDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
            DescriptorRendererImpl.this.renderPackageFragment(packageFragmentDescriptor, stringBuilder);
        }

        @Override
        public void visitPackageViewDescriptor(PackageViewDescriptor packageViewDescriptor, StringBuilder stringBuilder) {
            Intrinsics.checkNotNullParameter((Object)packageViewDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
            DescriptorRendererImpl.this.renderPackageView(packageViewDescriptor, stringBuilder);
        }

        @Override
        public void visitModuleDeclaration(ModuleDescriptor moduleDescriptor, StringBuilder stringBuilder) {
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
            DescriptorRendererImpl.this.renderName(moduleDescriptor, stringBuilder, true);
        }

        @Override
        public void visitClassDescriptor(ClassDescriptor classDescriptor, StringBuilder stringBuilder) {
            Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
            DescriptorRendererImpl.this.renderClass(classDescriptor, stringBuilder);
        }

        @Override
        public void visitTypeAliasDescriptor(TypeAliasDescriptor typeAliasDescriptor, StringBuilder stringBuilder) {
            Intrinsics.checkNotNullParameter((Object)typeAliasDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
            DescriptorRendererImpl.this.renderTypeAlias(typeAliasDescriptor, stringBuilder);
        }

        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PropertyAccessorRenderingPolicy.values().length];
                try {
                    nArray[PropertyAccessorRenderingPolicy.PRETTY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PropertyAccessorRenderingPolicy.DEBUG.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PropertyAccessorRenderingPolicy.NONE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RenderingFormat.values().length];
            try {
                nArray[RenderingFormat.PLAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenderingFormat.HTML.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ParameterNameRenderingPolicy.values().length];
            try {
                nArray[ParameterNameRenderingPolicy.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParameterNameRenderingPolicy.ONLY_NON_SYNTHESIZED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParameterNameRenderingPolicy.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

