/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.ClassId;

public final class IncompatibleVersionErrorData<T> {
    private final T actualVersion;
    private final T compilerVersion;
    private final T languageVersion;
    private final T expectedVersion;
    private final String filePath;
    private final ClassId classId;

    public IncompatibleVersionErrorData(T t, T t2, T t3, T t4, String string, ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        this.actualVersion = t;
        this.compilerVersion = t2;
        this.languageVersion = t3;
        this.expectedVersion = t4;
        this.filePath = string;
        this.classId = classId;
    }

    public String toString() {
        return "IncompatibleVersionErrorData(actualVersion=" + this.actualVersion + ", compilerVersion=" + this.compilerVersion + ", languageVersion=" + this.languageVersion + ", expectedVersion=" + this.expectedVersion + ", filePath=" + this.filePath + ", classId=" + this.classId + ')';
    }

    public int hashCode() {
        int n = this.actualVersion == null ? 0 : this.actualVersion.hashCode();
        n = n * 31 + (this.compilerVersion == null ? 0 : this.compilerVersion.hashCode());
        n = n * 31 + (this.languageVersion == null ? 0 : this.languageVersion.hashCode());
        n = n * 31 + (this.expectedVersion == null ? 0 : this.expectedVersion.hashCode());
        n = n * 31 + this.filePath.hashCode();
        n = n * 31 + this.classId.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IncompatibleVersionErrorData)) {
            return false;
        }
        IncompatibleVersionErrorData incompatibleVersionErrorData = (IncompatibleVersionErrorData)object;
        if (!Intrinsics.areEqual(this.actualVersion, incompatibleVersionErrorData.actualVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.compilerVersion, incompatibleVersionErrorData.compilerVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.languageVersion, incompatibleVersionErrorData.languageVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.expectedVersion, incompatibleVersionErrorData.expectedVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.filePath, (Object)incompatibleVersionErrorData.filePath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.classId, (Object)incompatibleVersionErrorData.classId);
    }
}

