/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.AbbreviatedType;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedType;

public final class SpecialTypesKt {
    public static final AbbreviatedType getAbbreviatedType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        UnwrappedType unwrappedType = kotlinType.unwrap();
        return unwrappedType instanceof AbbreviatedType ? (AbbreviatedType)unwrappedType : null;
    }

    public static final SimpleType getAbbreviation(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        AbbreviatedType abbreviatedType = SpecialTypesKt.getAbbreviatedType(kotlinType);
        return abbreviatedType != null ? abbreviatedType.getAbbreviation() : null;
    }

    public static final SimpleType withAbbreviation(SimpleType simpleType, SimpleType simpleType2) {
        Intrinsics.checkNotNullParameter((Object)simpleType, (String)"");
        Intrinsics.checkNotNullParameter((Object)simpleType2, (String)"");
        if (KotlinTypeKt.isError(simpleType)) {
            return simpleType;
        }
        return new AbbreviatedType(simpleType, simpleType2);
    }

    public static final boolean isDefinitelyNotNullType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return kotlinType.unwrap() instanceof DefinitelyNotNullType;
    }

    public static final SimpleType makeSimpleTypeDefinitelyNotNullOrNotNull(SimpleType simpleType, boolean bl) {
        SimpleType simpleType2;
        Intrinsics.checkNotNullParameter((Object)simpleType, (String)"");
        DefinitelyNotNullType definitelyNotNullType = DefinitelyNotNullType.Companion.makeDefinitelyNotNull$default(DefinitelyNotNullType.Companion, simpleType, bl, false, 4, null);
        if (definitelyNotNullType != null) {
            simpleType2 = definitelyNotNullType;
        } else {
            simpleType2 = SpecialTypesKt.makeIntersectionTypeDefinitelyNotNullOrNotNull(simpleType);
            if (simpleType2 == null) {
                simpleType2 = simpleType.makeNullableAsSpecified(false);
            }
        }
        return simpleType2;
    }

    public static /* synthetic */ SimpleType makeSimpleTypeDefinitelyNotNullOrNotNull$default(SimpleType simpleType, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return SpecialTypesKt.makeSimpleTypeDefinitelyNotNullOrNotNull(simpleType, bl);
    }

    public static final NewCapturedType withNotNullProjection(NewCapturedType newCapturedType) {
        Intrinsics.checkNotNullParameter((Object)newCapturedType, (String)"");
        return new NewCapturedType(newCapturedType.getCaptureStatus(), newCapturedType.getConstructor(), newCapturedType.getLowerType(), newCapturedType.getAttributes(), newCapturedType.isMarkedNullable(), true);
    }

    public static final UnwrappedType makeDefinitelyNotNullOrNotNull(UnwrappedType unwrappedType, boolean bl) {
        UnwrappedType unwrappedType2;
        Intrinsics.checkNotNullParameter((Object)unwrappedType, (String)"");
        DefinitelyNotNullType definitelyNotNullType = DefinitelyNotNullType.Companion.makeDefinitelyNotNull$default(DefinitelyNotNullType.Companion, unwrappedType, bl, false, 4, null);
        if (definitelyNotNullType != null) {
            unwrappedType2 = definitelyNotNullType;
        } else {
            SimpleType simpleType = SpecialTypesKt.makeIntersectionTypeDefinitelyNotNullOrNotNull(unwrappedType);
            unwrappedType2 = simpleType != null ? (UnwrappedType)simpleType : unwrappedType.makeNullableAsSpecified(false);
        }
        return unwrappedType2;
    }

    public static /* synthetic */ UnwrappedType makeDefinitelyNotNullOrNotNull$default(UnwrappedType unwrappedType, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return SpecialTypesKt.makeDefinitelyNotNullOrNotNull(unwrappedType, bl);
    }

    private static final SimpleType makeIntersectionTypeDefinitelyNotNullOrNotNull(KotlinType kotlinType) {
        TypeConstructor typeConstructor2 = kotlinType.getConstructor();
        IntersectionTypeConstructor intersectionTypeConstructor = typeConstructor2 instanceof IntersectionTypeConstructor ? (IntersectionTypeConstructor)typeConstructor2 : null;
        if (intersectionTypeConstructor == null) {
            return null;
        }
        IntersectionTypeConstructor intersectionTypeConstructor2 = intersectionTypeConstructor;
        IntersectionTypeConstructor intersectionTypeConstructor3 = SpecialTypesKt.makeDefinitelyNotNullOrNotNull(intersectionTypeConstructor2);
        if (intersectionTypeConstructor3 == null) {
            return null;
        }
        IntersectionTypeConstructor intersectionTypeConstructor4 = intersectionTypeConstructor3;
        return intersectionTypeConstructor4.createType();
    }

    private static final IntersectionTypeConstructor makeDefinitelyNotNullOrNotNull(IntersectionTypeConstructor intersectionTypeConstructor) {
        IntersectionTypeConstructor intersectionTypeConstructor2;
        boolean bl;
        Object object;
        IntersectionTypeConstructor intersectionTypeConstructor3 = intersectionTypeConstructor;
        boolean bl2 = false;
        boolean bl3 = false;
        Iterable iterable = intersectionTypeConstructor3.getSupertypes();
        boolean bl4 = false;
        Iterable iterable2 = iterable;
        Object object2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl5 = false;
        for (Object t : iterable2) {
            KotlinType kotlinType;
            KotlinType kotlinType2 = (KotlinType)t;
            Collection collection = object2;
            boolean bl6 = false;
            object = kotlinType2;
            bl = false;
            if (TypeUtils.isNullableType((KotlinType)object)) {
                bl3 = true;
                object = kotlinType2;
                bl = false;
                kotlinType = SpecialTypesKt.makeDefinitelyNotNullOrNotNull$default(((KotlinType)object).unwrap(), false, 1, null);
            } else {
                kotlinType = kotlinType2;
            }
            collection.add(kotlinType);
        }
        List list = (List)object2;
        if (!bl3) {
            intersectionTypeConstructor2 = null;
        } else {
            Object object3;
            KotlinType kotlinType = intersectionTypeConstructor3.getAlternativeType();
            if (kotlinType != null) {
                object2 = kotlinType;
                bl5 = false;
                object = object2;
                bl = false;
                if (TypeUtils.isNullableType((KotlinType)object)) {
                    object = object2;
                    bl = false;
                    object3 = SpecialTypesKt.makeDefinitelyNotNullOrNotNull$default(((KotlinType)object).unwrap(), false, 1, null);
                } else {
                    object3 = object2;
                }
            } else {
                object3 = null;
            }
            iterable = object3;
            intersectionTypeConstructor2 = new IntersectionTypeConstructor(list).setAlternative((KotlinType)((Object)iterable));
        }
        return intersectionTypeConstructor2;
    }
}

