/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeWithEnhancement;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SimpleTypeWithEnhancement;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancement;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;

public final class TypeWithEnhancementKt {
    public static final KotlinType getEnhancement(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return kotlinType instanceof TypeWithEnhancement ? ((TypeWithEnhancement)((Object)kotlinType)).getEnhancement() : null;
    }

    public static final UnwrappedType inheritEnhancement(UnwrappedType unwrappedType, KotlinType kotlinType, Function1<? super KotlinType, ? extends KotlinType> function1) {
        Intrinsics.checkNotNullParameter((Object)unwrappedType, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        KotlinType kotlinType2 = TypeWithEnhancementKt.getEnhancement(kotlinType);
        return TypeWithEnhancementKt.wrapEnhancement(unwrappedType, kotlinType2 != null ? (KotlinType)function1.invoke((Object)kotlinType2) : null);
    }

    public static final UnwrappedType inheritEnhancement(UnwrappedType unwrappedType, KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)unwrappedType, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return TypeWithEnhancementKt.wrapEnhancement(unwrappedType, TypeWithEnhancementKt.getEnhancement(kotlinType));
    }

    public static final UnwrappedType wrapEnhancement(UnwrappedType unwrappedType, KotlinType kotlinType) {
        UnwrappedType unwrappedType2;
        Intrinsics.checkNotNullParameter((Object)unwrappedType, (String)"");
        if (unwrappedType instanceof TypeWithEnhancement) {
            return TypeWithEnhancementKt.wrapEnhancement(((TypeWithEnhancement)((Object)unwrappedType)).getOrigin(), kotlinType);
        }
        if (kotlinType == null || Intrinsics.areEqual((Object)kotlinType, (Object)unwrappedType)) {
            return unwrappedType;
        }
        UnwrappedType unwrappedType3 = unwrappedType;
        if (unwrappedType3 instanceof SimpleType) {
            unwrappedType2 = new SimpleTypeWithEnhancement((SimpleType)unwrappedType, kotlinType);
        } else if (unwrappedType3 instanceof FlexibleType) {
            unwrappedType2 = new FlexibleTypeWithEnhancement((FlexibleType)unwrappedType, kotlinType);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return unwrappedType2;
    }
}

