/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.util.Check;

public abstract class MemberKindCheck
implements Check {
    private final String description;

    private MemberKindCheck(String string) {
        this.description = string;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String invoke(FunctionDescriptor functionDescriptor) {
        return Check.DefaultImpls.invoke(this, functionDescriptor);
    }

    public /* synthetic */ MemberKindCheck(String string, DefaultConstructorMarker defaultConstructorMarker) {
        this(string);
    }

    public static final class Member
    extends MemberKindCheck {
        public static final Member INSTANCE = new Member();

        private Member() {
            super("must be a member function", null);
        }

        @Override
        public boolean check(FunctionDescriptor functionDescriptor) {
            Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
            return functionDescriptor.getDispatchReceiverParameter() != null;
        }
    }

    public static final class MemberOrExtension
    extends MemberKindCheck {
        public static final MemberOrExtension INSTANCE = new MemberOrExtension();

        private MemberOrExtension() {
            super("must be a member or an extension function", null);
        }

        @Override
        public boolean check(FunctionDescriptor functionDescriptor) {
            Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
            return functionDescriptor.getDispatchReceiverParameter() != null || functionDescriptor.getExtensionReceiverParameter() != null;
        }
    }
}

