/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers.ImplicitClassReceiver;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers.ReceiverValue;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.AbstractModifierChecks;
import kotlin.reflect.jvm.internal.impl.util.Check;
import kotlin.reflect.jvm.internal.impl.util.Checks;
import kotlin.reflect.jvm.internal.impl.util.IsKPropertyCheck;
import kotlin.reflect.jvm.internal.impl.util.MemberKindCheck;
import kotlin.reflect.jvm.internal.impl.util.NoDefaultAndVarargsCheck;
import kotlin.reflect.jvm.internal.impl.util.OperatorChecks$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.util.OperatorChecks$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.util.OperatorChecks$$Lambda$2;
import kotlin.reflect.jvm.internal.impl.util.OperatorNameConventions;
import kotlin.reflect.jvm.internal.impl.util.ReturnsCheck;
import kotlin.reflect.jvm.internal.impl.util.ValueParameterCountCheck;

public final class OperatorChecks
extends AbstractModifierChecks {
    public static final OperatorChecks INSTANCE = new OperatorChecks();
    private static final List<Checks> checks;

    private OperatorChecks() {
    }

    @Override
    public List<Checks> getChecks$descriptors() {
        return checks;
    }

    private final boolean incDecCheckForExpectClass(FunctionDescriptor functionDescriptor, ReceiverParameterDescriptor receiverParameterDescriptor) {
        ReceiverValue receiverValue = receiverParameterDescriptor.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)receiverValue, (String)"");
        ReceiverValue receiverValue2 = receiverValue;
        if (!(receiverValue2 instanceof ImplicitClassReceiver)) {
            return false;
        }
        ClassDescriptor classDescriptor = ((ImplicitClassReceiver)receiverValue2).getClassDescriptor();
        if (!classDescriptor.isExpect()) {
            return false;
        }
        ClassId classId = DescriptorUtilsKt.getClassId(classDescriptor);
        if (classId == null) {
            return false;
        }
        ClassId classId2 = classId;
        ClassifierDescriptor classifierDescriptor = FindClassInModuleKt.findClassifierAcrossModuleDependencies(DescriptorUtilsKt.getModule(classDescriptor), classId2);
        TypeAliasDescriptor typeAliasDescriptor = classifierDescriptor instanceof TypeAliasDescriptor ? (TypeAliasDescriptor)classifierDescriptor : null;
        if (typeAliasDescriptor == null) {
            return false;
        }
        TypeAliasDescriptor typeAliasDescriptor2 = typeAliasDescriptor;
        KotlinType kotlinType = functionDescriptor.getReturnType();
        if (kotlinType != null) {
            KotlinType kotlinType2 = kotlinType;
            boolean bl = false;
            return TypeUtilsKt.isSubtypeOf(kotlinType2, typeAliasDescriptor2.getExpandedType());
        }
        return false;
    }

    private static final String checks$lambda$2(FunctionDescriptor functionDescriptor) {
        String string;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
        List<ValueParameterDescriptor> list = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.lastOrNull(list);
        if (valueParameterDescriptor != null) {
            ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor;
            boolean bl2 = false;
            bl = !DescriptorUtilsKt.declaresOrInheritsDefaultValue(valueParameterDescriptor2) && valueParameterDescriptor2.getVarargElementType() == null;
        } else {
            bl = false;
        }
        boolean bl3 = bl;
        AbstractModifierChecks abstractModifierChecks = INSTANCE;
        boolean bl4 = false;
        if (!bl3) {
            boolean bl5 = false;
            string = "last parameter should not have a default value or be a vararg";
        } else {
            string = null;
        }
        return string;
    }

    private static final boolean checks$lambda$6$isAny(DeclarationDescriptor declarationDescriptor) {
        return declarationDescriptor instanceof ClassDescriptor && KotlinBuiltIns.isAny((ClassDescriptor)declarationDescriptor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String checks$lambda$6(FunctionDescriptor functionDescriptor) {
        boolean bl;
        Object object;
        StringBuilder stringBuilder2;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
        AbstractModifierChecks abstractModifierChecks = INSTANCE;
        DeclarationDescriptor declarationDescriptor = functionDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"");
        if (OperatorChecks.checks$lambda$6$isAny(declarationDescriptor)) return null;
        Collection<? extends FunctionDescriptor> collection = functionDescriptor.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"");
        Iterable iterable = collection;
        boolean bl3 = false;
        if (((Collection)iterable).isEmpty()) {
            bl2 = false;
        } else {
            for (StringBuilder stringBuilder2 : iterable) {
                object = (FunctionDescriptor)((Object)stringBuilder2);
                bl = false;
                DeclarationDescriptor declarationDescriptor2 = object.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor2, (String)"");
                if (!OperatorChecks.checks$lambda$6$isAny(declarationDescriptor2)) continue;
                return null;
            }
            bl2 = false;
        }
        if (bl2) return null;
        if (DescriptorUtilKt.isTypedEqualsInValueClass(functionDescriptor)) {
            return null;
        }
        boolean bl4 = false;
        boolean bl5 = bl4;
        bl3 = false;
        if (bl5) return null;
        boolean bl6 = false;
        stringBuilder2 = new StringBuilder();
        object = stringBuilder2;
        bl = false;
        ((StringBuilder)object).append("must override ''equals()'' in Any");
        DeclarationDescriptor declarationDescriptor3 = functionDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor3, (String)"");
        if (InlineClassesUtilsKt.isValueClass(declarationDescriptor3)) {
            DeclarationDescriptor declarationDescriptor4 = functionDescriptor.getContainingDeclaration();
            Intrinsics.checkNotNull((Object)declarationDescriptor4);
            SimpleType simpleType = ((ClassDescriptor)declarationDescriptor4).getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
            String string = DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(TypeUtilsKt.replaceArgumentsWithStarProjections(simpleType));
            ((StringBuilder)object).append(" or define ''equals(other: " + string + "): Boolean''");
        }
        String string = stringBuilder2.toString();
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String checks$lambda$8(FunctionDescriptor functionDescriptor) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
        ReceiverParameterDescriptor receiverParameterDescriptor = functionDescriptor.getDispatchReceiverParameter();
        if (receiverParameterDescriptor == null) {
            receiverParameterDescriptor = functionDescriptor.getExtensionReceiverParameter();
        }
        ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
        AbstractModifierChecks abstractModifierChecks = INSTANCE;
        if (receiverParameterDescriptor2 == null) return "receiver must be a supertype of the return type";
        KotlinType kotlinType = functionDescriptor.getReturnType();
        if (kotlinType != null) {
            KotlinType kotlinType2 = receiverParameterDescriptor2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"");
            bl = TypeUtilsKt.isSubtypeOf(kotlinType, kotlinType2);
        } else {
            bl = false;
        }
        if (bl) return null;
        if (!INSTANCE.incDecCheckForExpectClass(functionDescriptor, receiverParameterDescriptor2)) return "receiver must be a supertype of the return type";
        return null;
    }

    static {
        Object[] objectArray = new Checks[19];
        Object[] objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, new ValueParameterCountCheck.AtLeast(1)};
        objectArray[0] = new Checks(OperatorNameConventions.GET, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, new ValueParameterCountCheck.AtLeast(2)};
        objectArray[1] = new Checks(OperatorNameConventions.SET, (Check[])objectArray2, (Function1<? super FunctionDescriptor, String>)OperatorChecks$$Lambda$0.INSTANCE);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, new ValueParameterCountCheck.AtLeast(2), IsKPropertyCheck.INSTANCE};
        objectArray[2] = new Checks(OperatorNameConventions.GET_VALUE, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, new ValueParameterCountCheck.AtLeast(3), IsKPropertyCheck.INSTANCE};
        objectArray[3] = new Checks(OperatorNameConventions.SET_VALUE, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, new ValueParameterCountCheck.Equals(2), IsKPropertyCheck.INSTANCE};
        objectArray[4] = new Checks(OperatorNameConventions.PROVIDE_DELEGATE, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE};
        objectArray[5] = new Checks(OperatorNameConventions.INVOKE, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, ReturnsCheck.ReturnsBoolean.INSTANCE};
        objectArray[6] = new Checks(OperatorNameConventions.CONTAINS, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE};
        objectArray[7] = new Checks(OperatorNameConventions.ITERATOR, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE};
        objectArray[8] = new Checks(OperatorNameConventions.NEXT, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE, ReturnsCheck.ReturnsBoolean.INSTANCE};
        objectArray[9] = new Checks(OperatorNameConventions.HAS_NEXT, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE};
        objectArray[10] = new Checks(OperatorNameConventions.RANGE_TO, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE};
        objectArray[11] = new Checks(OperatorNameConventions.RANGE_UNTIL, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.Member.INSTANCE};
        objectArray[12] = new Checks(OperatorNameConventions.EQUALS, (Check[])objectArray2, (Function1<? super FunctionDescriptor, String>)OperatorChecks$$Lambda$1.INSTANCE);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ReturnsCheck.ReturnsInt.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE};
        objectArray[13] = new Checks(OperatorNameConventions.COMPARE_TO, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE};
        objectArray[14] = new Checks(OperatorNameConventions.BINARY_OPERATION_NAMES, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE};
        objectArray[15] = new Checks(OperatorNameConventions.SIMPLE_UNARY_OPERATION_NAMES, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Name[]{OperatorNameConventions.INC, OperatorNameConventions.DEC};
        Collection collection = CollectionsKt.listOf((Object[])objectArray2);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE};
        objectArray[16] = new Checks(collection, (Check[])objectArray2, (Function1<? super FunctionDescriptor, String>)OperatorChecks$$Lambda$2.INSTANCE);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ReturnsCheck.ReturnsUnit.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE};
        objectArray[17] = new Checks(OperatorNameConventions.ASSIGNMENT_OPERATIONS, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE};
        objectArray[18] = new Checks(OperatorNameConventions.COMPONENT_REGEX, (Check[])objectArray2, null, 4, null);
        checks = CollectionsKt.listOf((Object[])objectArray);
    }

    static /* synthetic */ String accessor$OperatorChecks$lambda0(FunctionDescriptor functionDescriptor) {
        return OperatorChecks.checks$lambda$2(functionDescriptor);
    }

    static /* synthetic */ String accessor$OperatorChecks$lambda1(FunctionDescriptor functionDescriptor) {
        return OperatorChecks.checks$lambda$6(functionDescriptor);
    }

    static /* synthetic */ String accessor$OperatorChecks$lambda2(FunctionDescriptor functionDescriptor) {
        return OperatorChecks.checks$lambda$8(functionDescriptor);
    }
}

