/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;

public final class CollectionsKt {
    public static final <K> Map<K, Integer> mapToIndex(Iterable<? extends K> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"");
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        Iterator<K> iterator2 = iterable.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int n2 = n++;
            K k = iterator2.next();
            Integer n3 = n2;
            ((Map)linkedHashMap).put(k, n3);
        }
        return linkedHashMap;
    }

    public static final <T> void addIfNotNull(Collection<T> collection, T t) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        if (t != null) {
            collection.add(t);
        }
    }

    public static final <K, V> HashMap<K, V> newHashMapWithExpectedSize(int n) {
        return new HashMap(CollectionsKt.capacity(n));
    }

    public static final <E> HashSet<E> newHashSetWithExpectedSize(int n) {
        return new HashSet(CollectionsKt.capacity(n));
    }

    public static final <E> LinkedHashSet<E> newLinkedHashSetWithExpectedSize(int n) {
        return new LinkedHashSet(CollectionsKt.capacity(n));
    }

    private static final int capacity(int n) {
        return n < 3 ? 3 : n + n / 3 + 1;
    }

    public static final <T> List<T> compact(ArrayList<T> arrayList) {
        List list;
        Intrinsics.checkNotNullParameter(arrayList, (String)"");
        switch (arrayList.size()) {
            case 0: {
                list = kotlin.collections.CollectionsKt.emptyList();
                break;
            }
            case 1: {
                list = kotlin.collections.CollectionsKt.listOf((Object)kotlin.collections.CollectionsKt.first((List)arrayList));
                break;
            }
            default: {
                ArrayList<T> arrayList2;
                ArrayList<T> arrayList3 = arrayList2 = arrayList;
                boolean bl = false;
                arrayList3.trimToSize();
                list = arrayList2;
            }
        }
        return list;
    }
}

