/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray;

import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.CheckboxPeer;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.util.SwingUtil;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;

public class Checkbox
extends Entry {
    private volatile boolean isChecked = false;
    private volatile String text;
    private volatile ActionListener callback;
    private volatile boolean enabled = true;
    private volatile char mnemonicKey;
    private volatile String tooltip;

    public Checkbox() {
        this(null, null);
    }

    public Checkbox(String string) {
        this(string, null);
    }

    public Checkbox(JCheckBoxMenuItem jCheckBoxMenuItem) {
        ActionListener[] actionListenerArray = jCheckBoxMenuItem.getActionListeners();
        if (actionListenerArray != null) {
            if (actionListenerArray.length == 1) {
                this.setCallback(actionListenerArray[0]);
            } else {
                ActionListener actionListener = actionEvent -> {
                    for (ActionListener actionListener : actionListenerArray) {
                        actionListener.actionPerformed(actionEvent);
                    }
                };
                this.setCallback(actionListener);
            }
        }
        this.setEnabled(jCheckBoxMenuItem.isEnabled());
        this.setChecked(jCheckBoxMenuItem.getState());
        this.setShortcut(jCheckBoxMenuItem.getMnemonic());
        this.setText(jCheckBoxMenuItem.getText());
    }

    public Checkbox(String string, ActionListener actionListener) {
        this.text = string;
        this.callback = actionListener;
    }

    public void bind(CheckboxPeer checkboxPeer, Menu menu, ImageResizeUtil imageResizeUtil) {
        super.bind(checkboxPeer, menu, imageResizeUtil);
        checkboxPeer.setEnabled(this);
        checkboxPeer.setText(this);
        checkboxPeer.setCallback(this);
        checkboxPeer.setShortcut(this);
        checkboxPeer.setChecked(this);
    }

    public boolean getChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean bl) {
        this.isChecked = bl;
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setChecked(this);
        }
    }

    public ActionListener getCallback() {
        return this.callback;
    }

    public void setCallback(ActionListener actionListener) {
        this.callback = actionListener;
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setCallback(this);
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setEnabled(this);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setText(this);
        }
    }

    public char getShortcut() {
        return this.mnemonicKey;
    }

    public void setShortcut(char c) {
        this.mnemonicKey = c;
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setShortcut(this);
        }
    }

    public void setShortcut(int n) {
        this.mnemonicKey = SwingUtil.INSTANCE.getFromVirtualKey(n);
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setShortcut(this);
        }
    }

    public void setTooltip(String string) {
        if (string != null) {
            if (string.length() > 64) {
                throw new RuntimeException("Tooltip text cannot be longer than 64 characters.");
            }
            if (!MenuItem.alreadyEmittedTooltipWarning) {
                MenuItem.alreadyEmittedTooltipWarning = true;
                SystemTray.logger.warn("Please disable tooltips, as they are not consistent across all platforms and tray types.");
            }
        }
        this.tooltip = string;
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setTooltip(this);
        }
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public JCheckBoxMenuItem asSwingComponent() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
        jCheckBoxMenuItem.setText(this.getText());
        jCheckBoxMenuItem.setToolTipText(this.getTooltip());
        jCheckBoxMenuItem.setEnabled(this.getEnabled());
        jCheckBoxMenuItem.setMnemonic(SwingUtil.INSTANCE.getVirtualKey(this.getShortcut()));
        jCheckBoxMenuItem.setState(this.getChecked());
        jCheckBoxMenuItem.addActionListener(this.getCallback());
        return jCheckBoxMenuItem;
    }
}

