/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.Status;
import dorkbox.systemTray.peer.EntryPeer;
import dorkbox.systemTray.peer.MenuPeer;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.util.SwingUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class Menu
extends MenuItem {
    final List<Entry> menuEntries = new ArrayList<Entry>();

    public Menu() {
    }

    public Menu(String string) {
        super(string);
    }

    public Menu(String string, ActionListener actionListener) {
        super(string, actionListener);
    }

    public Menu(String string, String string2) {
        super(string, string2);
    }

    public Menu(String string, File file) {
        super(string, file);
    }

    public Menu(String string, URL uRL) {
        super(string, uRL);
    }

    public Menu(String string, InputStream inputStream) {
        super(string, inputStream);
    }

    public Menu(String string, Image image) {
        super(string, image);
    }

    public Menu(String string, String string2, ActionListener actionListener) {
        super(string, string2, actionListener);
    }

    public Menu(String string, File file, ActionListener actionListener) {
        super(string, file, actionListener);
    }

    public Menu(String string, URL uRL, ActionListener actionListener) {
        super(string, uRL, actionListener);
    }

    public Menu(String string, InputStream inputStream, ActionListener actionListener) {
        super(string, inputStream, actionListener);
    }

    public Menu(String string, Image image, ActionListener actionListener) {
        super(string, image, actionListener);
    }

    public Menu(JMenu jMenu) {
        this.setEnabled(jMenu.isEnabled());
        Icon icon = jMenu.getIcon();
        if (icon != null) {
            Component[] componentArray = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            this.setImage((Image)componentArray);
        }
        this.setText(jMenu.getText());
        this.setShortcut(jMenu.getMnemonic());
        for (Component component : jMenu.getMenuComponents()) {
            if (component instanceof JMenu) {
                this.add((JMenu)component);
                continue;
            }
            if (component instanceof JCheckBoxMenuItem) {
                this.add((JCheckBoxMenuItem)component);
                continue;
            }
            if (component instanceof JMenuItem) {
                this.add((JMenuItem)component);
                continue;
            }
            if (!(component instanceof JSeparator)) continue;
            this.add((JSeparator)component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(MenuPeer menuPeer, Menu menu, ImageResizeUtil imageResizeUtil) {
        ArrayList<Entry> arrayList;
        super.bind(menuPeer, menu, imageResizeUtil);
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            arrayList = new ArrayList<Entry>(this.menuEntries);
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Entry entry = (Entry)arrayList.get(i);
            menuPeer.add(this, entry, i);
        }
    }

    public final <T extends Entry> T add(T t) {
        return this.add(t, -1);
    }

    public final Menu add(JMenu jMenu) {
        this.add(new Menu(jMenu));
        return this;
    }

    public final Menu add(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this.add(new Checkbox(jCheckBoxMenuItem));
        return this;
    }

    public final Menu add(JMenuItem jMenuItem) {
        this.add(new MenuItem(jMenuItem));
        return this;
    }

    public final Menu add(JSeparator jSeparator) {
        this.add(new Separator());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Entry> T add(T t, int n) {
        int n2;
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            if (n == -1) {
                n2 = this.menuEntries.size();
                this.menuEntries.add(t);
            } else {
                n2 = !this.menuEntries.isEmpty() && this.menuEntries.get(0) instanceof Status ? n + 1 : n;
                this.menuEntries.add(n, t);
            }
        }
        EventDispatch.runLater(() -> {
            EntryPeer entryPeer = this.peer;
            if (entryPeer != null) {
                ((MenuPeer)entryPeer).add(this, t, n2);
            }
        });
        return t;
    }

    public final Entry getFirst() {
        return this.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getLast() {
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            if (!this.menuEntries.isEmpty()) {
                for (int i = this.menuEntries.size() - 1; i >= 0; --i) {
                    Entry entry = this.menuEntries.get(i);
                    if (entry instanceof Separator || entry instanceof Status) continue;
                    return entry;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry get(int n) {
        if (n < 0) {
            return null;
        }
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            if (!this.menuEntries.isEmpty()) {
                int n2 = 0;
                for (Entry entry : this.menuEntries) {
                    if (entry instanceof Separator || entry instanceof Status) continue;
                    if (n2 == n) {
                        return entry;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> getEntries() {
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Entry>(this.menuEntries));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMenu asSwingComponent() {
        JMenu jMenu = new JMenu();
        if (this.getImage() != null) {
            jMenu.setIcon(new ImageIcon(this.getImage().getAbsolutePath()));
        }
        jMenu.setText(this.getText());
        jMenu.setToolTipText(this.getTooltip());
        jMenu.setEnabled(this.getEnabled());
        jMenu.setMnemonic(SwingUtil.INSTANCE.getVirtualKey(this.getShortcut()));
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            for (Entry entry : this.menuEntries) {
                Entry entry2;
                if (entry instanceof Menu) {
                    entry2 = (Menu)entry;
                    jMenu.add(((Menu)entry2).asSwingComponent());
                    continue;
                }
                if (entry instanceof Checkbox) {
                    entry2 = (Checkbox)entry;
                    jMenu.add(((Checkbox)entry2).asSwingComponent());
                    continue;
                }
                if (entry instanceof MenuItem) {
                    entry2 = (MenuItem)entry;
                    jMenu.add(((MenuItem)entry2).asSwingComponent());
                    continue;
                }
                if (entry instanceof Separator) {
                    entry2 = (Separator)entry;
                    jMenu.add(((Separator)entry2).asSwingComponent());
                    continue;
                }
                if (!(entry instanceof Status)) continue;
                entry2 = (Status)entry;
                jMenu.add(((Status)entry2).asSwingComponent());
            }
        }
        return jMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Entry entry) {
        if (entry != null) {
            Entry entry2 = null;
            List<Entry> list = this.menuEntries;
            synchronized (list) {
                Iterator<Entry> iterator = this.menuEntries.iterator();
                while (iterator.hasNext()) {
                    Entry entry3 = iterator.next();
                    if (entry3 != entry) continue;
                    iterator.remove();
                    entry2 = entry3;
                    break;
                }
            }
            if (entry2 != null) {
                list = entry2;
                EventDispatch.runLater(() -> list.remove());
                entry2 = null;
            }
            list = this.menuEntries;
            synchronized (list) {
                if (!this.menuEntries.isEmpty() && this.menuEntries.get(0) instanceof Separator) {
                    entry2 = this.menuEntries.get(0);
                }
            }
            if (entry2 != null) {
                this.remove(entry2);
                entry2 = null;
            }
            list = this.menuEntries;
            synchronized (list) {
                if (!this.menuEntries.isEmpty() && this.menuEntries.get(this.menuEntries.size() - 1) instanceof Separator) {
                    entry2 = this.menuEntries.get(this.menuEntries.size() - 1);
                }
            }
            if (entry2 != null) {
                this.remove(entry2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            for (Entry entry : this.menuEntries) {
                entry.remove();
            }
            this.menuEntries.clear();
        }
        EventDispatch.runLater(() -> this.remove_());
    }

    private void remove_() {
        MenuPeer menuPeer;
        if (this.peer instanceof MenuPeer && !(menuPeer = (MenuPeer)this.peer).hasParent()) {
            return;
        }
        super.remove();
    }
}

