/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.awt;

import dorkbox.collections.ArrayMap;
import dorkbox.os.OS;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.awt.AwtMenu;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.util.SwingUtil;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.TrayIcon;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import javax.swing.ImageIcon;

public final class _AwtTray
extends Tray {
    private volatile java.awt.SystemTray tray;
    private volatile TrayIcon trayIcon;
    private volatile boolean visible = false;
    private volatile File imageFile;
    private volatile String tooltipText = "";
    private volatile CountDownLatch keepAliveLatch = new CountDownLatch(1);
    private volatile Thread keepAliveThread;
    private final ArrayMap<String, Image> imageCache = new ArrayMap(false, 10);

    public _AwtTray(String string, ImageResizeUtil imageResizeUtil, Runnable runnable) {
        super(runnable);
        if (!java.awt.SystemTray.isSupported()) {
            throw new RuntimeException("System Tray is not supported in this configuration! Please write an issue and include your OS type and configuration");
        }
        AwtMenu awtMenu = new AwtMenu(null){

            @Override
            public void setEnabled(MenuItem menuItem) {
                SwingUtil.INSTANCE.invokeLater(() -> {
                    if (_AwtTray.this.tray == null) {
                        _AwtTray.this.tray = java.awt.SystemTray.getSystemTray();
                    }
                    boolean bl = menuItem.getEnabled();
                    if (OS.INSTANCE.isMacOsX()) {
                        if (_AwtTray.this.keepAliveThread != null) {
                            CountDownLatch countDownLatch = _AwtTray.this.keepAliveLatch;
                            synchronized (countDownLatch) {
                                _AwtTray.this.keepAliveLatch.countDown();
                            }
                        }
                        _AwtTray.this.keepAliveThread = null;
                        if (_AwtTray.this.visible && !bl) {
                            _AwtTray.this.keepAliveThread = new Thread(() -> {
                                CountDownLatch countDownLatch = _AwtTray.this.keepAliveLatch;
                                synchronized (countDownLatch) {
                                    _AwtTray.this.keepAliveLatch.countDown();
                                    _AwtTray.this.keepAliveLatch = new CountDownLatch(1);
                                }
                            }, "TrayKeepAliveThread");
                            _AwtTray.this.keepAliveThread.start();
                        }
                    }
                    if (_AwtTray.this.visible && !bl) {
                        _AwtTray.this.tray.remove(_AwtTray.this.trayIcon);
                        _AwtTray.this.visible = false;
                    } else if (!_AwtTray.this.visible && bl && _AwtTray.this.trayIcon != null) {
                        try {
                            _AwtTray.this.tray.add(_AwtTray.this.trayIcon);
                            _AwtTray.this.visible = true;
                            _AwtTray.this.trayIcon.setToolTip(_AwtTray.this.tooltipText);
                        }
                        catch (AWTException aWTException) {
                            SystemTray.logger.error("Error adding the icon back to the tray", (Throwable)aWTException);
                        }
                    }
                });
            }

            @Override
            public void setImage(MenuItem menuItem) {
                _AwtTray.this.imageFile = menuItem.getImage();
                SwingUtil.INSTANCE.invokeLater(() -> {
                    Image image;
                    if (_AwtTray.this.tray == null) {
                        _AwtTray.this.tray = java.awt.SystemTray.getSystemTray();
                    }
                    if (_AwtTray.this.imageFile != null) {
                        String string = _AwtTray.this.imageFile.getAbsolutePath();
                        ArrayMap arrayMap = _AwtTray.this.imageCache;
                        synchronized (arrayMap) {
                            Image image2 = (Image)_AwtTray.this.imageCache.get((Object)string);
                            if (image2 == null) {
                                image2 = new ImageIcon(string).getImage();
                                _AwtTray.this.imageCache.put((Object)string, (Object)image2);
                                if (_AwtTray.this.imageCache.getSize() > 120) {
                                    SystemTray.logger.error("More than 120 different images used for the SystemTray icon. This will lead to performance issues.");
                                }
                            }
                            image = image2;
                        }
                    } else {
                        image = null;
                    }
                    if (_AwtTray.this.trayIcon == null) {
                        if (image == null) {
                            return;
                        }
                        _AwtTray.this.trayIcon = new TrayIcon(image);
                        _AwtTray.this.trayIcon.setPopupMenu((PopupMenu)this._native);
                        try {
                            _AwtTray.this.tray.add(_AwtTray.this.trayIcon);
                            _AwtTray.this.visible = true;
                        }
                        catch (AWTException aWTException) {
                            SystemTray.logger.error("TrayIcon could not be added.", (Throwable)aWTException);
                        }
                    } else {
                        _AwtTray.this.trayIcon.setImage(image);
                    }
                    _AwtTray.this.trayIcon.setToolTip(_AwtTray.this.tooltipText);
                });
            }

            @Override
            public void setText(MenuItem menuItem) {
            }

            @Override
            public void setShortcut(MenuItem menuItem) {
            }

            @Override
            public void setTooltip(MenuItem menuItem) {
                String string = menuItem.getTooltip();
                if (_AwtTray.this.tooltipText != null && _AwtTray.this.tooltipText.equals(string)) {
                    return;
                }
                _AwtTray.this.tooltipText = string;
                SwingUtil.INSTANCE.invokeLater(() -> {
                    if (_AwtTray.this.trayIcon != null) {
                        _AwtTray.this.trayIcon.setToolTip(string);
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                Object object = _AwtTray.this.imageCache;
                synchronized (object) {
                    for (Image image : _AwtTray.this.imageCache.values()) {
                        image.flush();
                    }
                    _AwtTray.this.imageCache.clear();
                }
                SwingUtil.INSTANCE.invokeAndWaitQuietly(() -> {
                    if (_AwtTray.this.trayIcon != null) {
                        _AwtTray.this.trayIcon.setPopupMenu(null);
                        if (_AwtTray.this.tray != null) {
                            _AwtTray.this.tray.remove(_AwtTray.this.trayIcon);
                        }
                        _AwtTray.this.trayIcon = null;
                    }
                    _AwtTray.this.tray = null;
                    super.remove();
                });
                if (_AwtTray.this.keepAliveThread != null) {
                    object = _AwtTray.this.keepAliveLatch;
                    synchronized (object) {
                        _AwtTray.this.keepAliveLatch.countDown();
                    }
                }
            }
        };
        this.bind(awtMenu, null, imageResizeUtil);
    }

    @Override
    public boolean hasImage() {
        return this.imageFile != null;
    }
}

