/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.gtk;

import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import dorkbox.jna.linux.GEventCallback;
import dorkbox.jna.linux.GObject;
import dorkbox.jna.linux.Gtk;
import dorkbox.jna.linux.GtkEventDispatch;
import dorkbox.jna.linux.structs.GdkEventButton;
import dorkbox.jna.rendering.RenderProvider;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.gtk.GtkBaseMenuItem;
import dorkbox.systemTray.ui.gtk.GtkMenu;
import dorkbox.systemTray.ui.gtk.GtkMenuItemCheckbox;
import dorkbox.systemTray.util.ImageResizeUtil;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;

public final class _GtkStatusIconNativeTray
extends Tray {
    private volatile Pointer trayIcon;
    private GEventCallback gtkCallback = null;
    private final AtomicBoolean shuttingDown = new AtomicBoolean();
    private volatile boolean isActive = false;
    private volatile boolean visible = true;
    private volatile File imageFile;
    private volatile String tooltipText = "";
    private final GtkMenu gtkMenu;

    public _GtkStatusIconNativeTray(String string, ImageResizeUtil imageResizeUtil, Runnable runnable) {
        super(runnable);
        GtkBaseMenuItem.transparentIcon = imageResizeUtil.getTransparentImage();
        GtkMenuItemCheckbox.uncheckedFile = imageResizeUtil.getTransparentImage().getAbsolutePath();
        this.gtkMenu = new GtkMenu(){

            @Override
            public void setEnabled(MenuItem menuItem) {
                GtkEventDispatch.dispatch(() -> {
                    boolean bl = menuItem.getEnabled();
                    if (_GtkStatusIconNativeTray.this.visible && !bl) {
                        Gtk.Gtk2.gtk_status_icon_set_visible(_GtkStatusIconNativeTray.this.trayIcon, false);
                        _GtkStatusIconNativeTray.this.visible = false;
                    } else if (!_GtkStatusIconNativeTray.this.visible && bl) {
                        Gtk.Gtk2.gtk_status_icon_set_visible(_GtkStatusIconNativeTray.this.trayIcon, true);
                        _GtkStatusIconNativeTray.this.visible = true;
                    }
                });
            }

            @Override
            public void setImage(MenuItem menuItem) {
                _GtkStatusIconNativeTray.this.imageFile = menuItem.getImage();
                if (_GtkStatusIconNativeTray.this.imageFile == null) {
                    return;
                }
                GtkEventDispatch.dispatch(() -> {
                    Gtk.Gtk2.gtk_status_icon_set_from_file(_GtkStatusIconNativeTray.this.trayIcon, _GtkStatusIconNativeTray.this.imageFile.getAbsolutePath());
                    if (!_GtkStatusIconNativeTray.this.isActive) {
                        _GtkStatusIconNativeTray.this.isActive = true;
                        Gtk.Gtk2.gtk_status_icon_set_visible(_GtkStatusIconNativeTray.this.trayIcon, true);
                    }
                });
            }

            @Override
            public void setText(MenuItem menuItem) {
            }

            @Override
            public void setShortcut(MenuItem menuItem) {
            }

            @Override
            public void setTooltip(MenuItem menuItem) {
                String string = menuItem.getTooltip();
                if (_GtkStatusIconNativeTray.this.tooltipText != null && _GtkStatusIconNativeTray.this.tooltipText.equals(string)) {
                    return;
                }
                _GtkStatusIconNativeTray.this.tooltipText = string;
                GtkEventDispatch.dispatch(() -> Gtk.Gtk2.gtk_status_icon_set_tooltip_text(_GtkStatusIconNativeTray.this.trayIcon, string));
            }

            @Override
            public void remove() {
                if (!_GtkStatusIconNativeTray.this.shuttingDown.getAndSet(true)) {
                    GtkEventDispatch.dispatchAndWait(() -> {
                        Gtk.Gtk2.gtk_status_icon_set_visible(_GtkStatusIconNativeTray.this.trayIcon, false);
                        GObject.g_object_unref((Pointer)_GtkStatusIconNativeTray.this.trayIcon);
                        _GtkStatusIconNativeTray.this.trayIcon = null;
                        _GtkStatusIconNativeTray.this.gtkCallback = null;
                    });
                    super.remove();
                    GtkEventDispatch.shutdownGui();
                }
            }
        };
        GtkEventDispatch.dispatch(() -> {
            this.trayIcon = Gtk.Gtk2.gtk_status_icon_new();
            this.gtkCallback = new GEventCallback(){

                public void callback(Pointer pointer, GdkEventButton gdkEventButton) {
                    if (gdkEventButton.type == 4) {
                        Gtk.Gtk2.gtk_menu_popup(((_GtkStatusIconNativeTray)_GtkStatusIconNativeTray.this).gtkMenu._nativeMenu, null, null, Gtk.gtk_status_icon_position_menu, _GtkStatusIconNativeTray.this.trayIcon, 0, gdkEventButton.time);
                    }
                }
            };
            GObject.g_signal_connect_object((Pointer)this.trayIcon, (String)"button_press_event", (Callback)this.gtkCallback, null, (int)0);
        });
        GtkEventDispatch.waitForEventsToComplete();
        GtkEventDispatch.dispatchAndWait(() -> {
            Gtk.Gtk2.gtk_status_icon_set_title(this.trayIcon, string);
            if (RenderProvider.isJavaFX() || Tray.gtkGnomeWorkaround) {
                Gtk.Gtk2.gtk_status_icon_set_name(this.trayIcon, string);
            }
        });
        this.bind(this.gtkMenu, null, imageResizeUtil);
    }

    @Override
    public boolean hasImage() {
        return this.imageFile != null;
    }
}

