/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0019\u0010\u0002\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0004\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0013\u0010\u0006\u001a\u00020\u0000*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0005\u001a\u0019\u0010\u0002\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\b\u00a8\u0006\t"}, d2={"Ljava/nio/file/Path;", "relativePath", "combineSafe", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)Ljava/nio/file/Path;", "normalizeAndRelativize", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;", "dropLeadingTopDirs", "Ljava/io/File;", "(Ljava/io/File;Ljava/nio/file/Path;)Ljava/io/File;", "ktor-utils"})
public final class NioPathKt {
    public static final Path combineSafe(Path path, Path path2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"");
        Path path3 = NioPathKt.normalizeAndRelativize(path2);
        if (path3.startsWith("..")) {
            throw new InvalidPathException(((Object)path2).toString(), "Relative path " + path2 + " beginning with .. is invalid");
        }
        if (!(!path3.isAbsolute())) {
            boolean bl = false;
            String string = "Bad relative path " + path2;
            throw new IllegalStateException(string.toString());
        }
        if (path.getNameCount() == 0) {
            return path3;
        }
        Path path4 = path.resolve(path3);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"");
        return path4;
    }

    public static final Path normalizeAndRelativize(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"");
        Path path2 = path.getRoot();
        if (path2 == null || (path2 = path2.relativize(path)) == null || (path2 = path2.normalize()) == null || (path2 = NioPathKt.dropLeadingTopDirs(path2)) == null) {
            Path path3 = path.normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"");
            path2 = NioPathKt.dropLeadingTopDirs(path3);
        }
        return path2;
    }

    private static final Path dropLeadingTopDirs(Path path) {
        int n;
        block4: {
            int n2;
            Iterable iterable = path;
            boolean bl = false;
            int n3 = 0;
            for (Object t : iterable) {
                if (n3 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Path path2 = (Path)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)((Object)path2).toString(), (Object)"..")) {
                    n2 = n3;
                    break block4;
                }
                ++n3;
            }
            n2 = n = -1;
        }
        if (n <= 0) {
            return path;
        }
        Path path3 = path.subpath(n, path.getNameCount());
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"");
        return path3;
    }

    public static final File combineSafe(File file, Path path) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)path, (String)"");
        Path path2 = NioPathKt.normalizeAndRelativize(path);
        if (path2.startsWith("..")) {
            throw new InvalidPathException(((Object)path).toString(), "Relative path " + path + " beginning with .. is invalid");
        }
        if (!(!path2.isAbsolute())) {
            boolean bl = false;
            String string = "Bad relative path " + path;
            throw new IllegalStateException(string.toString());
        }
        return new File(file, ((Object)path2).toString());
    }
}

