/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.e.a.b.d;
import org.h.b.a;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.compress.packet.Compress;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.internal.SmackTlsContext;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StartTls;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.sasl.packet.SaslNonza;
import org.jivesoftware.smack.sm.SMUtils;
import org.jivesoftware.smack.sm.StreamManagementException;
import org.jivesoftware.smack.sm.packet.StreamManagement;
import org.jivesoftware.smack.sm.predicates.Predicate;
import org.jivesoftware.smack.sm.provider.ParseStreamManagement;
import org.jivesoftware.smack.tcp.BundleAndDefer;
import org.jivesoftware.smack.tcp.BundleAndDeferCallback;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smack.tcp.rce.RemoteXmppTcpConnectionEndpoints;
import org.jivesoftware.smack.tcp.rce.Rfc6120TcpRemoteConnectionEndpoint;
import org.jivesoftware.smack.util.ArrayBlockingQueueWithShutdown;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.TLSUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpoint;
import org.jivesoftware.smack.util.rce.RemoteConnectionException;
import org.jivesoftware.smack.xml.SmackXmlParser;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class XMPPTCPConnection
extends AbstractXMPPConnection {
    private static final int QUEUE_SIZE = 500;
    private static final Logger LOGGER = Logger.getLogger(XMPPTCPConnection.class.getName());
    private Socket socket;
    private boolean disconnectedButResumeable = false;
    private SSLSocket secureSocket;
    protected final PacketWriter packetWriter = new PacketWriter();
    protected final PacketReader packetReader = new PacketReader();
    private boolean streamFeaturesAfterAuthenticationReceived;
    private boolean compressSyncPoint;
    private static BundleAndDeferCallback defaultBundleAndDeferCallback;
    private BundleAndDeferCallback bundleAndDeferCallback = defaultBundleAndDeferCallback;
    private static boolean useSmDefault;
    private static boolean useSmResumptionDefault;
    private String smSessionId;
    private volatile AbstractXMPPConnection.SyncPointState smResumedSyncPoint;
    private StreamManagement.Failed smResumptionFailed;
    private volatile boolean smEnabledSyncPoint;
    private int smClientMaxResumptionTime = -1;
    private int smServerMaxResumptionTime = -1;
    private boolean useSm = useSmDefault;
    private boolean useSmResumption = useSmResumptionDefault;
    private long serverHandledStanzasCount = 0L;
    private long clientHandledStanzasCount = 0L;
    private BlockingQueue<Stanza> unacknowledgedStanzas;
    private boolean smWasEnabledAtLeastOnce = false;
    private final Collection<StanzaListener> stanzaAcknowledgedListeners = new ConcurrentLinkedQueue<StanzaListener>();
    private final Collection<StanzaListener> stanzaDroppedListeners = new ConcurrentLinkedQueue<StanzaListener>();
    private final Map<String, StanzaListener> stanzaIdAcknowledgedListeners = new ConcurrentHashMap<String, StanzaListener>();
    private final Set<StanzaFilter> requestAckPredicates = new LinkedHashSet<StanzaFilter>();
    private final XMPPTCPConnectionConfiguration config;

    public XMPPTCPConnection(XMPPTCPConnectionConfiguration xMPPTCPConnectionConfiguration) {
        super((ConnectionConfiguration)xMPPTCPConnectionConfiguration);
        this.config = xMPPTCPConnectionConfiguration;
        this.addConnectionListener(new ConnectionListener(){

            public void connectionClosedOnError(Exception exception) {
                if (exception instanceof XMPPException.StreamErrorException || exception instanceof StreamManagementException) {
                    XMPPTCPConnection.this.dropSmState();
                }
            }
        });
        this.buildNonzaCallback().listenFor(SaslNonza.Success.class, success -> this.resetParser()).install();
    }

    public XMPPTCPConnection(CharSequence charSequence, String string) {
        this(((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setXmppAddressAndPassword(charSequence, string)).build());
    }

    public XMPPTCPConnection(CharSequence charSequence, String string, String string2) {
        this(((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setUsernameAndPassword(charSequence, string)).setXmppDomain(org.e.a.a.d.e((String)string2))).build());
    }

    protected void throwNotConnectedExceptionIfAppropriate() {
        if (this.packetWriter == null) {
            throw new SmackException.NotConnectedException();
        }
        this.packetWriter.throwNotConnectedExceptionIfDoneAndResumptionNotPossible();
    }

    protected void throwAlreadyConnectedExceptionIfAppropriate() {
        if (this.isConnected() && !this.disconnectedButResumeable) {
            throw new SmackException.AlreadyConnectedException();
        }
    }

    protected void throwAlreadyLoggedInExceptionIfAppropriate() {
        if (this.isAuthenticated() && !this.disconnectedButResumeable) {
            throw new SmackException.AlreadyLoggedInException();
        }
    }

    protected void afterSuccessfulLogin(boolean bl) {
        this.disconnectedButResumeable = false;
        super.afterSuccessfulLogin(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void loginInternal(String string, String string2, d d2) {
        SSLSession sSLSession = this.secureSocket != null ? this.secureSocket.getSession() : null;
        this.streamFeaturesAfterAuthenticationReceived = false;
        this.authenticate(string, string2, this.config.getAuthzid(), sSLSession);
        this.waitForConditionOrThrowConnectionException(() -> this.streamFeaturesAfterAuthenticationReceived, "compress features from server");
        this.maybeEnableCompression();
        this.smResumedSyncPoint = AbstractXMPPConnection.SyncPointState.initial;
        this.smResumptionFailed = null;
        if (this.isSmResumptionPossible()) {
            this.smResumedSyncPoint = AbstractXMPPConnection.SyncPointState.request_sent;
            this.sendNonza((Nonza)new StreamManagement.Resume(this.clientHandledStanzasCount, this.smSessionId));
            this.waitForConditionOrThrowConnectionException(() -> this.smResumedSyncPoint == AbstractXMPPConnection.SyncPointState.successful || this.smResumptionFailed != null, "resume previous stream");
            if (this.smResumedSyncPoint == AbstractXMPPConnection.SyncPointState.successful) {
                this.afterSuccessfulLogin(true);
                return;
            }
            assert (this.smResumptionFailed != null);
            LOGGER.fine("Stream resumption failed, continuing with normal stream establishment process: " + this.smResumptionFailed);
        }
        this.smEnabledSyncPoint = false;
        LinkedList linkedList = new LinkedList();
        if (this.unacknowledgedStanzas != null) {
            this.unacknowledgedStanzas.drainTo(linkedList);
            this.dropSmState();
        }
        this.bindResourceAndEstablishSession(d2);
        if (this.isSmAvailable() && this.useSm) {
            this.serverHandledStanzasCount = 0L;
            this.sendNonza((Nonza)new StreamManagement.Enable(this.useSmResumption, this.smClientMaxResumptionTime));
            this.waitForConditionOrThrowConnectionException(() -> this.smEnabledSyncPoint, "enabling stream mangement");
            Set<StanzaFilter> set = this.requestAckPredicates;
            synchronized (set) {
                if (this.requestAckPredicates.isEmpty()) {
                    this.requestAckPredicates.add(Predicate.forMessagesOrAfter5Stanzas());
                }
            }
        }
        if (!this.stanzaDroppedListeners.isEmpty()) {
            for (Stanza stanza : linkedList) {
                for (StanzaListener stanzaListener : this.stanzaDroppedListeners) {
                    try {
                        stanzaListener.processStanza(stanza);
                    }
                    catch (InterruptedException | SmackException.NotConnectedException | SmackException.NotLoggedInException throwable) {
                        LOGGER.log(Level.FINER, "StanzaDroppedListener received exception", throwable);
                    }
                }
            }
        } else {
            for (Stanza stanza : linkedList) {
                this.sendStanzaInternal(stanza);
            }
        }
        this.afterSuccessfulLogin(false);
    }

    public boolean isSecureConnection() {
        return this.secureSocket != null;
    }

    protected void shutdown() {
        if (this.isSmEnabled()) {
            try {
                this.sendSmAcknowledgementInternal();
            }
            catch (InterruptedException | SmackException.NotConnectedException throwable) {
                LOGGER.log(Level.FINE, "Can not send final SM ack as connection is not connected", throwable);
            }
        }
        this.shutdown(false);
    }

    public synchronized void instantShutdown() {
        this.shutdown(true);
    }

    private void shutdown(boolean bl) {
        if (!this.packetWriter.done()) {
            LOGGER.finer(this.packetWriter.threadName + " shutdown()");
            this.packetWriter.shutdown(bl);
            LOGGER.finer(this.packetWriter.threadName + " shutdown() returned");
            if (!bl) {
                this.waitForClosingStreamTagFromServer();
            }
        }
        LOGGER.finer(this.packetReader.threadName + " shutdown()");
        this.packetReader.shutdown();
        LOGGER.finer(this.packetReader.threadName + " shutdown() returned");
        CloseableUtil.maybeClose((Closeable)this.socket, (Logger)LOGGER);
        this.setWasAuthenticated();
        try {
            boolean bl2 = this.waitFor(() -> !this.packetWriter.running && !this.packetReader.running);
            if (!bl2) {
                LOGGER.severe("Reader and/or writer threads did not terminate timely. Writer running: " + this.packetWriter.running + ", Reader running: " + this.packetReader.running);
            } else {
                LOGGER.fine("Reader and writer threads terminated");
            }
        }
        catch (InterruptedException interruptedException) {
            LOGGER.log(Level.FINE, "Interrupted while waiting for reader and writer threads to terminate", interruptedException);
        }
        if (this.disconnectedButResumeable) {
            return;
        }
        if (bl) {
            this.disconnectedButResumeable = this.isSmResumptionPossible();
            if (!this.disconnectedButResumeable) {
                this.smSessionId = null;
            }
        } else {
            this.disconnectedButResumeable = false;
            this.dropSmState();
        }
        this.authenticated = false;
        this.connected = false;
        this.secureSocket = null;
        this.reader = null;
        this.writer = null;
        this.initState();
    }

    public void sendNonza(Nonza nonza) {
        this.packetWriter.sendStreamElement((Element)nonza);
    }

    protected void sendStanzaInternal(Stanza stanza) {
        this.packetWriter.sendStreamElement((Element)stanza);
        if (this.isSmEnabled()) {
            for (StanzaFilter stanzaFilter : this.requestAckPredicates) {
                if (!stanzaFilter.accept(stanza)) continue;
                this.requestSmAcknowledgementInternal();
                break;
            }
        }
    }

    private void connectUsingConfiguration() {
        RemoteXmppTcpConnectionEndpoints.Result<Rfc6120TcpRemoteConnectionEndpoint> result = RemoteXmppTcpConnectionEndpoints.lookup(this.config);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        SocketFactory socketFactory = this.config.getSocketFactory();
        ProxyInfo proxyInfo = this.config.getProxyInfo();
        int n = this.config.getConnectTimeout();
        if (socketFactory == null) {
            socketFactory = SocketFactory.getDefault();
        }
        block4: for (Rfc6120TcpRemoteConnectionEndpoint rfc6120TcpRemoteConnectionEndpoint : result.discoveredRemoteConnectionEndpoints) {
            InetSocketAddress inetSocketAddress;
            Object object;
            String string = rfc6120TcpRemoteConnectionEndpoint.getHost().toString();
            UInt16 uInt16 = rfc6120TcpRemoteConnectionEndpoint.getPort();
            int n2 = uInt16.intValue();
            if (proxyInfo == null) {
                Iterator iterator = rfc6120TcpRemoteConnectionEndpoint.getInetAddresses().iterator();
                assert (iterator.hasNext());
                while (iterator.hasNext()) {
                    object = new SmackFuture.SocketFuture(socketFactory);
                    InetAddress inetAddress = (InetAddress)iterator.next();
                    inetSocketAddress = new InetSocketAddress(inetAddress, n2);
                    LOGGER.finer("Trying to establish TCP connection to " + inetSocketAddress);
                    object.connectAsync((SocketAddress)inetSocketAddress, n);
                    try {
                        this.socket = (Socket)object.getOrThrow();
                    }
                    catch (IOException iOException) {
                        RemoteConnectionException remoteConnectionException = new RemoteConnectionException((RemoteConnectionEndpoint)rfc6120TcpRemoteConnectionEndpoint, inetAddress, (Exception)iOException);
                        arrayList.add(remoteConnectionException);
                        if (!iterator.hasNext()) continue block4;
                        continue;
                    }
                    LOGGER.finer("Established TCP connection to " + inetSocketAddress);
                    this.host = string;
                    this.port = uInt16;
                    return;
                }
                continue;
            }
            this.socket = socketFactory.createSocket();
            StringUtils.requireNotNullNorEmpty((CharSequence)string, (String)("Host of endpoint " + rfc6120TcpRemoteConnectionEndpoint + " must not be null when using a Proxy"));
            object = string + " at port " + n2;
            LOGGER.finer("Trying to establish TCP connection via Proxy to " + (String)object);
            try {
                proxyInfo.getProxySocketConnection().connect(this.socket, string, n2, n);
            }
            catch (IOException iOException) {
                CloseableUtil.maybeClose((Closeable)this.socket, (Logger)LOGGER);
                inetSocketAddress = new RemoteConnectionException((RemoteConnectionEndpoint)rfc6120TcpRemoteConnectionEndpoint, null, (Exception)iOException);
                arrayList.add(inetSocketAddress);
                continue;
            }
            LOGGER.finer("Established TCP connection to " + (String)object);
            this.host = string;
            this.port = uInt16;
            return;
        }
        throw SmackException.EndpointConnectionException.from(result.lookupFailures, arrayList);
    }

    private void initConnection() {
        this.compressionHandler = null;
        this.initReaderAndWriter();
        this.packetWriter.init();
        this.packetReader.init();
    }

    private void initReaderAndWriter() {
        InputStream inputStream = this.socket.getInputStream();
        OutputStream outputStream = this.socket.getOutputStream();
        if (this.compressionHandler != null) {
            inputStream = this.compressionHandler.getInputStream(inputStream);
            outputStream = this.compressionHandler.getOutputStream(outputStream);
        }
        this.writer = new OutputStreamWriter(outputStream, "UTF-8");
        this.reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        this.initDebugger();
    }

    private void proceedTLSReceived() {
        String string;
        HostnameVerifier hostnameVerifier;
        SmackTlsContext smackTlsContext = this.getSmackTlsContext();
        Socket socket = this.socket;
        int n = socket.getPort();
        String string2 = this.config.getXMPPServiceDomain().toString();
        SSLSocketFactory sSLSocketFactory = smackTlsContext.sslContext.getSocketFactory();
        this.socket = sSLSocketFactory.createSocket(socket, string2, n, true);
        SSLSocket sSLSocket = (SSLSocket)this.socket;
        TLSUtils.setEnabledProtocolsAndCiphers((SSLSocket)sSLSocket, (String[])this.config.getEnabledSSLProtocols(), (String[])this.config.getEnabledSSLCiphers());
        this.initReaderAndWriter();
        sSLSocket.startHandshake();
        if (smackTlsContext.daneVerifier != null) {
            smackTlsContext.daneVerifier.finish(sSLSocket.getSession());
        }
        if ((hostnameVerifier = this.getConfiguration().getHostnameVerifier()) == null) {
            throw new IllegalStateException("No HostnameVerifier set. Use connectionConfiguration.setHostnameVerifier() to configure.");
        }
        a a2 = this.getConfiguration().getXmppServiceDomainAsDnsNameIfPossible();
        if (a2 != null) {
            string = a2.e;
        } else {
            LOGGER.log(Level.WARNING, "XMPP service domain name '" + this.getXMPPServiceDomain() + "' can not be represented as DNS name. TLS X.509 certificate validiation may fail.");
            string = this.getXMPPServiceDomain().toString();
        }
        boolean bl = hostnameVerifier.verify(string, sSLSocket.getSession());
        if (!bl) {
            throw new CertificateException("Hostname verification of certificate failed. Certificate does not authenticate " + this.getXMPPServiceDomain());
        }
        this.secureSocket = sSLSocket;
    }

    private static XMPPInputOutputStream maybeGetCompressionHandler(Compress.Feature feature) {
        for (XMPPInputOutputStream xMPPInputOutputStream : SmackConfiguration.getCompressionHandlers()) {
            String string = xMPPInputOutputStream.getCompressionMethod();
            if (!feature.getMethods().contains(string)) continue;
            return xMPPInputOutputStream;
        }
        return null;
    }

    public boolean isUsingCompression() {
        return this.compressionHandler != null && this.compressSyncPoint;
    }

    private void maybeEnableCompression() {
        if (!this.config.isCompressionEnabled()) {
            return;
        }
        Compress.Feature feature = (Compress.Feature)this.getFeature(Compress.Feature.class);
        if (feature == null) {
            return;
        }
        this.compressionHandler = XMPPTCPConnection.maybeGetCompressionHandler(feature);
        if (this.compressionHandler != null) {
            this.compressSyncPoint = false;
            this.sendNonza((Nonza)new Compress(this.compressionHandler.getCompressionMethod()));
            this.waitForConditionOrThrowConnectionException(() -> this.compressSyncPoint, "establishing stream compression");
        } else {
            LOGGER.warning("Could not enable compression because no matching handler/method pair was found");
        }
    }

    protected void connectInternal() {
        this.connectUsingConfiguration();
        this.connected = true;
        this.initConnection();
        this.waitForConditionOrThrowConnectionException(() -> this.tlsHandled, "establishing TLS");
        this.waitForConditionOrThrowConnectionException(() -> this.saslFeatureReceived, "SASL mechanisms stream feature from server");
    }

    protected void setWriter(Writer writer) {
        this.writer = writer;
    }

    protected void afterFeaturesReceived() {
        StartTls startTls = (StartTls)this.getFeature(StartTls.class);
        if (startTls != null) {
            if (startTls.required() && this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
                SmackException.SecurityRequiredByServerException securityRequiredByServerException = new SmackException.SecurityRequiredByServerException();
                this.currentSmackException = securityRequiredByServerException;
                this.notifyWaitingThreads();
                throw securityRequiredByServerException;
            }
            if (this.config.getSecurityMode() != ConnectionConfiguration.SecurityMode.disabled) {
                this.sendNonza((Nonza)new StartTls());
            } else {
                this.tlsHandled = true;
                this.notifyWaitingThreads();
            }
        } else {
            this.tlsHandled = true;
            this.notifyWaitingThreads();
        }
        if (this.isSaslAuthenticated()) {
            this.streamFeaturesAfterAuthenticationReceived = true;
            this.notifyWaitingThreads();
        }
    }

    private void resetParser() {
        try {
            this.packetReader.parser = SmackXmlParser.newXmlParser((Reader)this.reader);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new IOException(xmlPullParserException);
        }
    }

    private void openStreamAndResetParser() {
        this.sendStreamOpen();
        this.resetParser();
    }

    public static void setUseStreamManagementDefault(boolean bl) {
        useSmDefault = bl;
    }

    @Deprecated
    public static void setUseStreamManagementResumptiodDefault(boolean bl) {
        XMPPTCPConnection.setUseStreamManagementResumptionDefault(bl);
    }

    public static void setUseStreamManagementResumptionDefault(boolean bl) {
        if (bl) {
            XMPPTCPConnection.setUseStreamManagementDefault(bl);
        }
        useSmResumptionDefault = bl;
    }

    public void setUseStreamManagement(boolean bl) {
        this.useSm = bl;
    }

    public void setUseStreamManagementResumption(boolean bl) {
        if (bl) {
            this.setUseStreamManagement(bl);
        }
        this.useSmResumption = bl;
    }

    public void setPreferredResumptionTime(int n) {
        this.smClientMaxResumptionTime = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRequestAckPredicate(StanzaFilter stanzaFilter) {
        Set<StanzaFilter> set = this.requestAckPredicates;
        synchronized (set) {
            return this.requestAckPredicates.add(stanzaFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRequestAckPredicate(StanzaFilter stanzaFilter) {
        Set<StanzaFilter> set = this.requestAckPredicates;
        synchronized (set) {
            return this.requestAckPredicates.remove(stanzaFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllRequestAckPredicates() {
        Set<StanzaFilter> set = this.requestAckPredicates;
        synchronized (set) {
            this.requestAckPredicates.clear();
        }
    }

    public void requestSmAcknowledgement() {
        if (!this.isSmEnabled()) {
            throw new StreamManagementException.StreamManagementNotEnabledException();
        }
        this.requestSmAcknowledgementInternal();
    }

    private void requestSmAcknowledgementInternal() {
        this.packetWriter.sendStreamElement((Element)StreamManagement.AckRequest.INSTANCE);
    }

    public void sendSmAcknowledgement() {
        if (!this.isSmEnabled()) {
            throw new StreamManagementException.StreamManagementNotEnabledException();
        }
        this.sendSmAcknowledgementInternal();
    }

    private void sendSmAcknowledgementInternal() {
        StreamManagement.AckAnswer ackAnswer = new StreamManagement.AckAnswer(this.clientHandledStanzasCount);
        this.packetWriter.queue.putIfNotShutdown((Object)ackAnswer);
    }

    public void addStanzaAcknowledgedListener(StanzaListener stanzaListener) {
        this.stanzaAcknowledgedListeners.add(stanzaListener);
    }

    public boolean removeStanzaAcknowledgedListener(StanzaListener stanzaListener) {
        return this.stanzaAcknowledgedListeners.remove(stanzaListener);
    }

    public void removeAllStanzaAcknowledgedListeners() {
        this.stanzaAcknowledgedListeners.clear();
    }

    public void addStanzaDroppedListener(StanzaListener stanzaListener) {
        this.stanzaDroppedListeners.add(stanzaListener);
    }

    public boolean removeStanzaDroppedListener(StanzaListener stanzaListener) {
        return this.stanzaDroppedListeners.remove(stanzaListener);
    }

    public StanzaListener addStanzaIdAcknowledgedListener(final String string, StanzaListener stanzaListener) {
        if (!this.smWasEnabledAtLeastOnce) {
            throw new StreamManagementException.StreamManagementNotEnabledException();
        }
        int n = Math.min(this.getMaxSmResumptionTime(), 10800);
        XMPPTCPConnection.schedule((Runnable)new Runnable(){

            @Override
            public void run() {
                XMPPTCPConnection.this.stanzaIdAcknowledgedListeners.remove(string);
            }
        }, (long)n, (TimeUnit)TimeUnit.SECONDS);
        return this.stanzaIdAcknowledgedListeners.put(string, stanzaListener);
    }

    public StanzaListener removeStanzaIdAcknowledgedListener(String string) {
        return this.stanzaIdAcknowledgedListeners.remove(string);
    }

    public void removeAllStanzaIdAcknowledgedListeners() {
        this.stanzaIdAcknowledgedListeners.clear();
    }

    public boolean isSmAvailable() {
        return this.hasFeature("sm", "urn:xmpp:sm:3");
    }

    public boolean isSmEnabled() {
        return this.smEnabledSyncPoint;
    }

    public boolean streamWasResumed() {
        return this.smResumedSyncPoint == AbstractXMPPConnection.SyncPointState.successful;
    }

    public boolean isDisconnectedButSmResumptionPossible() {
        return this.disconnectedButResumeable && this.isSmResumptionPossible();
    }

    public boolean isSmResumptionPossible() {
        if (this.smSessionId == null) {
            return false;
        }
        Long l = this.packetWriter.shutdownTimestamp;
        if (l == null) {
            return true;
        }
        long l2 = System.currentTimeMillis();
        long l3 = (long)this.getMaxSmResumptionTime() * 1000L;
        return l2 <= l + l3;
    }

    private void dropSmState() {
        this.smSessionId = null;
        this.unacknowledgedStanzas = null;
    }

    public int getMaxSmResumptionTime() {
        int n = this.smClientMaxResumptionTime > 0 ? this.smClientMaxResumptionTime : Integer.MAX_VALUE;
        int n2 = this.smServerMaxResumptionTime > 0 ? this.smServerMaxResumptionTime : Integer.MAX_VALUE;
        return Math.min(n, n2);
    }

    private void processHandledCount(long l) {
        long l2 = SMUtils.calculateDelta((long)l, (long)this.serverHandledStanzasCount);
        final ArrayList<Stanza> arrayList = new ArrayList<Stanza>(l2 <= Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE);
        for (long i = 0L; i < l2; ++i) {
            Stanza stanza = (Stanza)this.unacknowledgedStanzas.poll();
            if (stanza == null) {
                throw new StreamManagementException.StreamManagementCounterError(l, this.serverHandledStanzasCount, l2, arrayList);
            }
            arrayList.add(stanza);
        }
        boolean bl = false;
        if (!this.stanzaAcknowledgedListeners.isEmpty()) {
            bl = true;
        } else {
            for (Stanza stanza : arrayList) {
                String string = stanza.getStanzaId();
                if (string == null || !this.stanzaIdAcknowledgedListeners.containsKey(string)) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            XMPPTCPConnection.asyncGo((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (Stanza stanza : arrayList) {
                        StanzaListener stanzaListener2;
                        for (StanzaListener stanzaListener2 : XMPPTCPConnection.this.stanzaAcknowledgedListeners) {
                            try {
                                stanzaListener2.processStanza(stanza);
                            }
                            catch (InterruptedException | SmackException.NotConnectedException | SmackException.NotLoggedInException throwable) {
                                LOGGER.log(Level.FINER, "Received exception", throwable);
                            }
                        }
                        String string = stanza.getStanzaId();
                        if (StringUtils.isNullOrEmpty((CharSequence)string) || (stanzaListener2 = (StanzaListener)XMPPTCPConnection.this.stanzaIdAcknowledgedListeners.remove(string)) == null) continue;
                        try {
                            stanzaListener2.processStanza(stanza);
                        }
                        catch (InterruptedException | SmackException.NotConnectedException | SmackException.NotLoggedInException throwable) {
                            LOGGER.log(Level.FINER, "Received exception", throwable);
                        }
                    }
                }
            });
        }
        this.serverHandledStanzasCount = l;
    }

    public static void setDefaultBundleAndDeferCallback(BundleAndDeferCallback bundleAndDeferCallback) {
        defaultBundleAndDeferCallback = bundleAndDeferCallback;
    }

    public void setBundleandDeferCallback(BundleAndDeferCallback bundleAndDeferCallback) {
        this.bundleAndDeferCallback = bundleAndDeferCallback;
    }

    static {
        useSmDefault = true;
        useSmResumptionDefault = true;
    }

    protected class PacketWriter {
        public static final int QUEUE_SIZE = 500;
        public static final int UNACKKNOWLEDGED_STANZAS_QUEUE_SIZE = 1024;
        public static final int UNACKKNOWLEDGED_STANZAS_QUEUE_SIZE_HIGH_WATER_MARK = 307;
        private final String threadName;
        private final ArrayBlockingQueueWithShutdown<Element> queue;
        protected volatile Long shutdownTimestamp;
        private volatile boolean instantShutdown;
        private boolean shouldBundleAndDefer;
        private boolean running;

        protected PacketWriter() {
            this.threadName = "Smack Writer (" + XMPPTCPConnection.this.getConnectionCounter() + ')';
            this.queue = new ArrayBlockingQueueWithShutdown(500, true);
            this.shutdownTimestamp = null;
        }

        void init() {
            this.shutdownTimestamp = null;
            if (XMPPTCPConnection.this.unacknowledgedStanzas != null) {
                this.drainWriterQueueToUnacknowledgedStanzas();
            }
            this.queue.start();
            this.running = true;
            Async.go((Runnable)new Runnable(){

                @Override
                public void run() {
                    LOGGER.finer(PacketWriter.this.threadName + " start");
                    try {
                        PacketWriter.this.writePackets();
                    }
                    finally {
                        LOGGER.finer(PacketWriter.this.threadName + " exit");
                        PacketWriter.this.running = false;
                        XMPPTCPConnection.this.notifyWaitingThreads();
                    }
                }
            }, (String)this.threadName);
        }

        private boolean done() {
            return this.shutdownTimestamp != null;
        }

        protected void throwNotConnectedExceptionIfDoneAndResumptionNotPossible() {
            boolean bl;
            boolean bl2 = this.done();
            if (bl2 && !(bl = XMPPTCPConnection.this.isSmResumptionPossible())) {
                throw new SmackException.NotConnectedException((XMPPConnection)XMPPTCPConnection.this, "done=" + bl2 + " smResumptionPossible=" + bl);
            }
        }

        protected void sendStreamElement(Element element) {
            this.throwNotConnectedExceptionIfDoneAndResumptionNotPossible();
            try {
                this.queue.put((Object)element);
            }
            catch (InterruptedException interruptedException) {
                this.throwNotConnectedExceptionIfDoneAndResumptionNotPossible();
                throw interruptedException;
            }
        }

        void shutdown(boolean bl) {
            this.instantShutdown = bl;
            this.queue.shutdown();
            this.shutdownTimestamp = System.currentTimeMillis();
        }

        private Element nextStreamElement() {
            Element element;
            block3: {
                if (this.queue.isEmpty()) {
                    this.shouldBundleAndDefer = true;
                }
                element = null;
                try {
                    element = (Element)this.queue.take();
                }
                catch (InterruptedException interruptedException) {
                    if (this.queue.isShutdown()) break block3;
                    LOGGER.log(Level.WARNING, "Writer thread was interrupted. Don't do that. Use disconnect() instead.", interruptedException);
                }
            }
            return element;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writePackets() {
            block26: {
                try {
                    BundleAndDeferCallback bundleAndDeferCallback;
                    Element element;
                    while (!this.done()) {
                        Object object;
                        element = this.nextStreamElement();
                        if (element == null) continue;
                        bundleAndDeferCallback = XMPPTCPConnection.this.bundleAndDeferCallback;
                        if (bundleAndDeferCallback != null && XMPPTCPConnection.this.isAuthenticated() && this.shouldBundleAndDefer) {
                            this.shouldBundleAndDefer = false;
                            object = new AtomicBoolean();
                            int n = bundleAndDeferCallback.getBundleAndDeferMillis(new BundleAndDefer((AtomicBoolean)object));
                            if (n > 0) {
                                long l = n;
                                long l2 = System.currentTimeMillis();
                                Object object2 = object;
                                synchronized (object2) {
                                    while (!((AtomicBoolean)object).get() && l > 0L) {
                                        object.wait(l);
                                        l = (long)n - (System.currentTimeMillis() - l2);
                                    }
                                }
                            }
                        }
                        object = null;
                        if (element instanceof Stanza) {
                            object = (Stanza)element;
                        } else if (element instanceof StreamManagement.Enable) {
                            XMPPTCPConnection.this.unacknowledgedStanzas = new ArrayBlockingQueue(1024);
                        }
                        this.maybeAddToUnacknowledgedStanzas((Stanza)object);
                        CharSequence charSequence = element.toXML(XMPPTCPConnection.this.outgoingStreamXmlEnvironment);
                        if (charSequence instanceof XmlStringBuilder) {
                            try {
                                ((XmlStringBuilder)charSequence).write(XMPPTCPConnection.this.writer, XMPPTCPConnection.this.outgoingStreamXmlEnvironment);
                            }
                            catch (NullPointerException nullPointerException) {
                                LOGGER.log(Level.FINE, "NPE in XmlStringBuilder of " + element.getClass() + ": " + element, nullPointerException);
                                throw nullPointerException;
                            }
                        } else {
                            XMPPTCPConnection.this.writer.write(charSequence.toString());
                        }
                        if (this.queue.isEmpty()) {
                            XMPPTCPConnection.this.writer.flush();
                        }
                        if (object == null) continue;
                        XMPPTCPConnection.this.firePacketSendingListeners((TopLevelStreamElement)object);
                    }
                    if (!this.instantShutdown) {
                        try {
                            while (!this.queue.isEmpty()) {
                                element = (Element)this.queue.remove();
                                if (element instanceof Stanza) {
                                    bundleAndDeferCallback = (Stanza)element;
                                    this.maybeAddToUnacknowledgedStanzas((Stanza)bundleAndDeferCallback);
                                }
                                XMPPTCPConnection.this.writer.write(element.toXML().toString());
                            }
                        }
                        catch (Exception exception) {
                            LOGGER.log(Level.WARNING, "Exception flushing queue during shutdown, ignore and continue", exception);
                        }
                        try {
                            XMPPTCPConnection.this.writer.write("</stream:stream>");
                            XMPPTCPConnection.this.writer.flush();
                        }
                        catch (Exception exception) {
                            LOGGER.log(Level.WARNING, "Exception writing closing stream element", exception);
                        }
                        this.queue.clear();
                        break block26;
                    }
                    if (this.instantShutdown && XMPPTCPConnection.this.isSmEnabled()) {
                        this.drainWriterQueueToUnacknowledgedStanzas();
                    }
                }
                catch (Exception exception) {
                    if (!this.done() && !this.queue.isShutdown()) {
                        this.running = false;
                        XMPPTCPConnection.this.notifyConnectionError(exception);
                    }
                    LOGGER.log(Level.FINE, "Ignoring Exception in writePackets()", exception);
                }
            }
        }

        private void drainWriterQueueToUnacknowledgedStanzas() {
            ArrayList arrayList = new ArrayList(this.queue.size());
            this.queue.drainTo(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                Element element = (Element)arrayList.get(i);
                if (XMPPTCPConnection.this.unacknowledgedStanzas.remainingCapacity() == 0) {
                    StreamManagementException.UnacknowledgedQueueFullException unacknowledgedQueueFullException = StreamManagementException.UnacknowledgedQueueFullException.newWith((int)i, arrayList, (BlockingQueue)XMPPTCPConnection.this.unacknowledgedStanzas);
                    LOGGER.log(Level.WARNING, "Some stanzas may be lost as not all could be drained to the unacknowledged stanzas queue", (Throwable)unacknowledgedQueueFullException);
                    return;
                }
                if (!(element instanceof Stanza)) continue;
                XMPPTCPConnection.this.unacknowledgedStanzas.add((Stanza)element);
            }
        }

        private void maybeAddToUnacknowledgedStanzas(Stanza stanza) {
            if (XMPPTCPConnection.this.unacknowledgedStanzas != null && stanza != null) {
                if (XMPPTCPConnection.this.unacknowledgedStanzas.size() == 307) {
                    XMPPTCPConnection.this.writer.write(StreamManagement.AckRequest.INSTANCE.toXML().toString());
                }
                try {
                    XMPPTCPConnection.this.unacknowledgedStanzas.put(stanza);
                }
                catch (InterruptedException interruptedException) {
                    throw new IllegalStateException(interruptedException);
                }
            }
        }
    }

    protected class PacketReader {
        private final String threadName;
        XmlPullParser parser;
        private volatile boolean done;
        private boolean running;

        protected PacketReader() {
            this.threadName = "Smack Reader (" + XMPPTCPConnection.this.getConnectionCounter() + ')';
        }

        void init() {
            this.done = false;
            this.running = true;
            Async.go((Runnable)new Runnable(){

                @Override
                public void run() {
                    LOGGER.finer(PacketReader.this.threadName + " start");
                    try {
                        PacketReader.this.parsePackets();
                    }
                    finally {
                        LOGGER.finer(PacketReader.this.threadName + " exit");
                        PacketReader.this.running = false;
                        XMPPTCPConnection.this.notifyWaitingThreads();
                    }
                }
            }, (String)this.threadName);
        }

        void shutdown() {
            this.done = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parsePackets() {
            try {
                XMPPTCPConnection.this.openStreamAndResetParser();
                XmlPullParser.Event event = this.parser.getEventType();
                while (!this.done) {
                    block2 : switch (event) {
                        case START_ELEMENT: {
                            String string;
                            switch (string = this.parser.getName()) {
                                case "message": 
                                case "iq": 
                                case "presence": {
                                    try {
                                        XMPPTCPConnection.this.parseAndProcessStanza(this.parser);
                                        break block2;
                                    }
                                    finally {
                                        XMPPTCPConnection.this.clientHandledStanzasCount = SMUtils.incrementHeight((long)XMPPTCPConnection.this.clientHandledStanzasCount);
                                    }
                                }
                                case "stream": {
                                    XMPPTCPConnection.this.onStreamOpen(this.parser);
                                    break block2;
                                }
                                case "error": {
                                    StreamError streamError = PacketParserUtils.parseStreamError((XmlPullParser)this.parser);
                                    throw new XMPPException.StreamErrorException(streamError);
                                }
                                case "features": {
                                    XMPPTCPConnection.this.parseFeaturesAndNotify(this.parser);
                                    break block2;
                                }
                                case "proceed": {
                                    XMPPTCPConnection.this.proceedTLSReceived();
                                    XMPPTCPConnection.this.openStreamAndResetParser();
                                    break block2;
                                }
                                case "failure": {
                                    String string2 = this.parser.getNamespace(null);
                                    switch (string2) {
                                        case "urn:ietf:params:xml:ns:xmpp-tls": {
                                            throw new SmackException.SmackMessageException("TLS negotiation has failed");
                                        }
                                        case "http://jabber.org/protocol/compress": {
                                            XMPPTCPConnection.this.currentSmackException = (SmackException)new SmackException.SmackMessageException("Could not establish compression");
                                            XMPPTCPConnection.this.notifyWaitingThreads();
                                            break block2;
                                        }
                                    }
                                    XMPPTCPConnection.this.parseAndProcessNonza(this.parser);
                                    break block2;
                                }
                                case "compressed": {
                                    XMPPTCPConnection.this.initReaderAndWriter();
                                    XMPPTCPConnection.this.openStreamAndResetParser();
                                    XMPPTCPConnection.this.compressSyncPoint = true;
                                    XMPPTCPConnection.this.notifyWaitingThreads();
                                    break block2;
                                }
                                case "enabled": {
                                    Object object = ParseStreamManagement.enabled((XmlPullParser)this.parser);
                                    if (object.isResumeSet()) {
                                        XMPPTCPConnection.this.smSessionId = object.getId();
                                        if (StringUtils.isNullOrEmpty((CharSequence)XMPPTCPConnection.this.smSessionId)) {
                                            SmackException.SmackMessageException smackMessageException = new SmackException.SmackMessageException("Stream Management 'enabled' element with resume attribute but without session id received");
                                            XMPPTCPConnection.this.setCurrentConnectionExceptionAndNotify((Exception)smackMessageException);
                                            throw smackMessageException;
                                        }
                                        XMPPTCPConnection.this.smServerMaxResumptionTime = object.getMaxResumptionTime();
                                    } else {
                                        XMPPTCPConnection.this.smSessionId = null;
                                    }
                                    XMPPTCPConnection.this.clientHandledStanzasCount = 0L;
                                    XMPPTCPConnection.this.smWasEnabledAtLeastOnce = true;
                                    XMPPTCPConnection.this.smEnabledSyncPoint = true;
                                    XMPPTCPConnection.this.notifyWaitingThreads();
                                    break block2;
                                }
                                case "failed": {
                                    StreamManagement.Failed failed = ParseStreamManagement.failed((XmlPullParser)this.parser);
                                    if (XMPPTCPConnection.this.smResumedSyncPoint == AbstractXMPPConnection.SyncPointState.request_sent) {
                                        XMPPTCPConnection.this.smResumptionFailed = failed;
                                        XMPPTCPConnection.this.notifyWaitingThreads();
                                        break block2;
                                    }
                                    StreamManagement.Resumed resumed = new XMPPException.FailedNonzaException((Nonza)failed, failed.getStanzaErrorCondition());
                                    XMPPTCPConnection.this.setCurrentConnectionExceptionAndNotify((Exception)resumed);
                                    break block2;
                                }
                                case "resumed": {
                                    StreamManagement.Resumed resumed = ParseStreamManagement.resumed((XmlPullParser)this.parser);
                                    if (!XMPPTCPConnection.this.smSessionId.equals(resumed.getPrevId())) {
                                        throw new StreamManagementException.StreamIdDoesNotMatchException(XMPPTCPConnection.this.smSessionId, resumed.getPrevId());
                                    }
                                    XMPPTCPConnection.this.smEnabledSyncPoint = true;
                                    XMPPTCPConnection.this.processHandledCount(resumed.getHandledCount());
                                    ArrayList arrayList = new ArrayList(XMPPTCPConnection.this.unacknowledgedStanzas.size());
                                    XMPPTCPConnection.this.unacknowledgedStanzas.drainTo(arrayList);
                                    for (Stanza stanza : arrayList) {
                                        XMPPTCPConnection.this.sendStanzaInternal(stanza);
                                    }
                                    if (!arrayList.isEmpty()) {
                                        XMPPTCPConnection.this.requestSmAcknowledgementInternal();
                                    }
                                    XMPPTCPConnection.this.smResumedSyncPoint = AbstractXMPPConnection.SyncPointState.successful;
                                    XMPPTCPConnection.this.notifyWaitingThreads();
                                    break block2;
                                }
                                case "a": {
                                    StreamManagement.AckAnswer ackAnswer = ParseStreamManagement.ackAnswer((XmlPullParser)this.parser);
                                    XMPPTCPConnection.this.processHandledCount(ackAnswer.getHandledCount());
                                    break block2;
                                }
                                case "r": {
                                    ParseStreamManagement.ackRequest((XmlPullParser)this.parser);
                                    if (XMPPTCPConnection.this.smEnabledSyncPoint) {
                                        XMPPTCPConnection.this.sendSmAcknowledgementInternal();
                                        break block2;
                                    }
                                    LOGGER.warning("SM Ack Request received while SM is not enabled");
                                    break block2;
                                }
                            }
                            XMPPTCPConnection.this.parseAndProcessNonza(this.parser);
                            break;
                        }
                        case END_ELEMENT: {
                            String string = this.parser.getName();
                            if (!"stream".equals(string)) break;
                            if (!this.parser.getNamespace().equals("http://etherx.jabber.org/streams")) {
                                LOGGER.warning((Object)((Object)XMPPTCPConnection.this) + " </stream> but different namespace " + this.parser.getNamespace());
                                break;
                            }
                            int n = XMPPTCPConnection.this.packetWriter.queue.isShutdown() ? 1 : 0;
                            XMPPTCPConnection.this.closingStreamReceived = true;
                            XMPPTCPConnection.this.notifyWaitingThreads();
                            if (n != 0) {
                                return;
                            }
                            LOGGER.info((Object)((Object)XMPPTCPConnection.this) + " received closing </stream> element. Server wants to terminate the connection, calling disconnect()");
                            ASYNC_BUT_ORDERED.performAsyncButOrdered((Object)XMPPTCPConnection.this, new Runnable(){

                                @Override
                                public void run() {
                                    XMPPTCPConnection.this.disconnect();
                                }
                            });
                            break;
                        }
                        case END_DOCUMENT: {
                            throw new SmackException.SmackMessageException("Parser got END_DOCUMENT event. This could happen e.g. if the server closed the connection without sending a closing stream element");
                        }
                    }
                    event = this.parser.next();
                }
            }
            catch (Exception exception) {
                this.running = false;
                String string = null;
                boolean bl = XMPPTCPConnection.this.packetWriter.queue.isShutdown();
                if (bl) {
                    string = "writer";
                } else if (this.done) {
                    string = "reader";
                }
                if (string != null) {
                    LOGGER.log(Level.FINER, "Ignoring " + exception + " as " + string + " was already shut down");
                    return;
                }
                XMPPTCPConnection.this.notifyConnectionError(exception);
            }
        }
    }
}

