/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.e.a.c.a;
import org.e.a.i;
import org.e.d.a.e;
import org.e.d.a.f;
import org.e.d.a.g;
import org.e.d.a.j;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.SmackReactor;
import org.jivesoftware.smack.XmppInputOutputFilter;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionModule;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionModuleDescriptor;
import org.jivesoftware.smack.c2s.XmppClientToServerTransport;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.c2s.internal.WalkStateGraphContext;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.fsm.State;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.fsm.StateTransitionResult;
import org.jivesoftware.smack.internal.SmackTlsContext;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StartTls;
import org.jivesoftware.smack.packet.TlsFailure;
import org.jivesoftware.smack.packet.TlsProceed;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.tcp.ConnectionAttemptState;
import org.jivesoftware.smack.tcp.XmppTcpTransportModuleDescriptor;
import org.jivesoftware.smack.tcp.rce.RemoteXmppTcpConnectionEndpoints;
import org.jivesoftware.smack.tcp.rce.Rfc6120TcpRemoteConnectionEndpoint;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.UTF8;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpointLookupFailure;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class XmppTcpTransportModule
extends ModularXmppClientToServerConnectionModule<XmppTcpTransportModuleDescriptor> {
    private static final Logger LOGGER = Logger.getLogger(XmppTcpTransportModule.class.getName());
    private static final int CALLBACK_MAX_BYTES_READ = 0xA00000;
    private static final int CALLBACK_MAX_BYTES_WRITEN = 0xA00000;
    private static final int MAX_ELEMENT_SIZE = 65536;
    private final XmppTcpNioTransport tcpNioTransport;
    private SelectionKey selectionKey;
    private SmackReactor.SelectionKeyAttachment selectionKeyAttachment;
    private SocketChannel socketChannel;
    private InetSocketAddress remoteAddress;
    private TlsState tlsState;
    private Iterator<CharSequence> outgoingCharSequenceIterator;
    private final List<TopLevelStreamElement> currentlyOutgoingElements = new ArrayList<TopLevelStreamElement>();
    private final Map<ByteBuffer, List<TopLevelStreamElement>> bufferToElementMap = new IdentityHashMap<ByteBuffer, List<TopLevelStreamElement>>();
    private ByteBuffer outgoingBuffer;
    private ByteBuffer filteredOutgoingBuffer;
    private final List<ByteBuffer> networkOutgoingBuffers = new ArrayList<ByteBuffer>();
    private long networkOutgoingBuffersBytes;
    private final ByteBuffer incomingBuffer = ByteBuffer.allocateDirect(8192);
    private final ReentrantLock channelSelectedCallbackLock = new ReentrantLock();
    private long totalBytesRead;
    private long totalBytesWritten;
    private long totalBytesReadAfterFilter;
    private long totalBytesWrittenBeforeFilter;
    private long handledChannelSelectedCallbacks;
    private long callbackPreemtBecauseBytesWritten;
    private long callbackPreemtBecauseBytesRead;
    private int sslEngineDelegatedTasks;
    private int maxPendingSslEngineDelegatedTasks;
    private final AtomicLong setWriteInterestAfterChannelSelectedCallback = new AtomicLong();
    private final AtomicLong reactorThreadAlreadyRacing = new AtomicLong();
    private final AtomicLong afterOutgoingElementsQueueModifiedSetInterestOps = new AtomicLong();
    private final AtomicLong rejectedChannelSelectedCallbacks = new AtomicLong();
    private i lastDestinationAddress;
    private boolean pendingInputFilterData;
    private boolean pendingOutputFilterData;
    private boolean pendingWriteInterestAfterRead;
    private e splitter;
    private j outputDebugSplitter;
    private static final Level STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL = Level.FINER;
    private final org.e.d.a.i xmppElementCallback = new org.e.d.a.i(){
        private String streamOpen;
        private String streamClose;

        public void onCompleteElement(String string) {
            assert (this.streamOpen != null);
            assert (this.streamClose != null);
            XmppTcpTransportModule.this.connectionInternal.withSmackDebugger(smackDebugger -> smackDebugger.onIncomingElementCompleted());
            String string2 = this.streamOpen + string + this.streamClose;
            XmppTcpTransportModule.this.connectionInternal.parseAndProcessElement(string2);
        }

        public void streamOpened(String string, Map<String, String> map) {
            XmlPullParser xmlPullParser;
            if (LOGGER.isLoggable(STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL)) {
                LOGGER.log(STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL, "Stream of " + this + " opened. prefix=" + string + " attributes=" + map);
            }
            String string2 = "xmlns:" + string;
            StringBuilder stringBuilder = new StringBuilder(32);
            StringBuilder stringBuilder2 = new StringBuilder(256);
            stringBuilder2.append('<');
            stringBuilder.append("</");
            if (StringUtils.isNotEmpty((CharSequence)string)) {
                stringBuilder2.append(string).append(':');
                stringBuilder.append(string).append(':');
            }
            stringBuilder2.append("stream");
            stringBuilder.append("stream>");
            block15: for (Map.Entry<String, String> entry : map.entrySet()) {
                String string3 = entry.getKey();
                String string4 = entry.getValue();
                switch (string3) {
                    case "to": 
                    case "from": 
                    case "id": 
                    case "version": {
                        continue block15;
                    }
                    case "xml:lang": {
                        stringBuilder2.append(" xml:lang='").append(string4).append('\'');
                        continue block15;
                    }
                    case "xmlns": {
                        stringBuilder2.append(" xmlns='").append(string4).append('\'');
                        continue block15;
                    }
                }
                if (string3.equals(string2)) {
                    stringBuilder2.append(' ').append(string2).append("='").append(string4).append('\'');
                    continue;
                }
                LOGGER.info("Unknown <stream/> attribute: " + string3);
            }
            stringBuilder2.append('>');
            this.streamOpen = stringBuilder2.toString();
            this.streamClose = stringBuilder.toString();
            try {
                xmlPullParser = PacketParserUtils.getParserFor((String)this.streamOpen);
            }
            catch (IOException | XmlPullParserException throwable) {
                throw new AssertionError((Object)throwable);
            }
            XmppTcpTransportModule.this.connectionInternal.onStreamOpen(xmlPullParser);
        }

        public void streamClosed() {
            if (LOGGER.isLoggable(STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL)) {
                LOGGER.log(STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL, "Stream of " + this + " closed");
            }
            XmppTcpTransportModule.this.connectionInternal.onStreamClosed();
        }
    };
    XmppTcpNioTransport.DiscoveredTcpEndpoints discoveredTcpEndpoints;
    private static final Level SSL_ENGINE_DEBUG_LOG_LEVEL = Level.FINEST;

    XmppTcpTransportModule(XmppTcpTransportModuleDescriptor xmppTcpTransportModuleDescriptor, ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
        super((ModularXmppClientToServerConnectionModuleDescriptor)xmppTcpTransportModuleDescriptor, modularXmppClientToServerConnectionInternal);
        j j2;
        this.tcpNioTransport = new XmppTcpNioTransport(modularXmppClientToServerConnectionInternal);
        f f2 = null;
        SmackDebugger smackDebugger = modularXmppClientToServerConnectionInternal.smackDebugger;
        if (smackDebugger != null) {
            f2 = f.d().a(stringBuilder -> smackDebugger.incomingStreamSink((CharSequence)stringBuilder)).a();
            j2 = f.d().a(stringBuilder -> smackDebugger.outgoingStreamSink((CharSequence)stringBuilder)).a();
            this.outputDebugSplitter = new j((g)j2);
        }
        j2 = new j(65536, this.xmppElementCallback, (g)f2);
        this.splitter = new e(j2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChannelSelected(SelectableChannel selectableChannel, SelectionKey selectionKey) {
        int n;
        block55: {
            assert (this.selectionKey == null || this.selectionKey == selectionKey);
            SocketChannel socketChannel = (SocketChannel)selectableChannel;
            n = 1;
            boolean bl = false;
            if (!this.channelSelectedCallbackLock.tryLock()) {
                this.rejectedChannelSelectedCallbacks.incrementAndGet();
                return;
            }
            ++this.handledChannelSelectedCallbacks;
            long l = 0L;
            long l2 = 0L;
            try {
                Object object;
                Object object2;
                int n2;
                block54: {
                    boolean bl2 = false;
                    boolean bl3 = false;
                    TopLevelStreamElement topLevelStreamElement = null;
                    StringBuilder stringBuilder = null;
                    while (true) {
                        XmppInputOutputFilter.OutputResult outputResult;
                        int n3 = n2 = !bl3 || !this.connectionInternal.outgoingElementsQueue.isEmpty() ? 1 : 0;
                        if (this.filteredOutgoingBuffer != null || !this.networkOutgoingBuffers.isEmpty()) {
                            long l3;
                            if (this.filteredOutgoingBuffer != null) {
                                this.networkOutgoingBuffers.add(this.filteredOutgoingBuffer);
                                this.networkOutgoingBuffersBytes += (long)this.filteredOutgoingBuffer.remaining();
                                this.filteredOutgoingBuffer = null;
                                if (n2 != 0 && this.networkOutgoingBuffersBytes < 8096L) continue;
                            }
                            object2 = this.networkOutgoingBuffers.toArray(new ByteBuffer[this.networkOutgoingBuffers.size()]);
                            try {
                                l3 = socketChannel.write((ByteBuffer[])object2);
                            }
                            catch (IOException iOException) {
                                this.handleReadWriteIoException(iOException);
                                break block54;
                            }
                            if (l3 == 0L) {
                                n |= 4;
                            } else {
                                l2 += l3;
                                this.networkOutgoingBuffersBytes -= l3;
                                outputResult = XmppTcpTransportModule.pruneBufferList(this.networkOutgoingBuffers);
                                for (Buffer buffer : outputResult) {
                                    List<TopLevelStreamElement> list = this.bufferToElementMap.remove(buffer);
                                    if (list == null) continue;
                                    for (TopLevelStreamElement topLevelStreamElement2 : list) {
                                        this.connectionInternal.fireFirstLevelElementSendListeners(topLevelStreamElement2);
                                    }
                                }
                                if (l2 <= 0xA00000L) continue;
                                n |= 4;
                                ++this.callbackPreemtBecauseBytesWritten;
                            }
                            break block54;
                        }
                        if (this.outgoingBuffer != null || this.pendingOutputFilterData) {
                            this.pendingOutputFilterData = false;
                            if (this.outgoingBuffer != null) {
                                this.totalBytesWrittenBeforeFilter += (long)this.outgoingBuffer.remaining();
                                if (bl3) {
                                    assert (topLevelStreamElement != null);
                                    this.currentlyOutgoingElements.add(topLevelStreamElement);
                                }
                            }
                            object2 = this.outgoingBuffer;
                            this.outgoingBuffer = null;
                            ListIterator listIterator = this.connectionInternal.getXmppInputOutputFilterBeginIterator();
                            while (listIterator.hasNext()) {
                                object = (XmppInputOutputFilter)listIterator.next();
                                try {
                                    outputResult = object.output((ByteBuffer)object2, bl3, bl2, n2 != 0);
                                }
                                catch (IOException iOException) {
                                    this.connectionInternal.notifyConnectionError((Exception)iOException);
                                    break block54;
                                }
                                bl |= outputResult.pendingFilterData;
                                object2 = outputResult.filteredOutputData;
                                if (object2 == null) continue;
                                ((ByteBuffer)object2).flip();
                            }
                            this.filteredOutgoingBuffer = object2 != null && ((Buffer)object2).hasRemaining() ? object2 : null;
                            if (this.filteredOutgoingBuffer == null && bl) {
                                this.pendingWriteInterestAfterRead = true;
                            }
                            if (this.filteredOutgoingBuffer != null && bl3) {
                                this.bufferToElementMap.put(this.filteredOutgoingBuffer, new ArrayList<TopLevelStreamElement>(this.currentlyOutgoingElements));
                                this.currentlyOutgoingElements.clear();
                            }
                            if (!bl2) continue;
                            bl2 = false;
                            continue;
                        }
                        if (this.outgoingCharSequenceIterator != null) {
                            SmackDebugger smackDebugger;
                            object2 = this.outgoingCharSequenceIterator.next();
                            this.outgoingBuffer = UTF8.encode((CharSequence)object2);
                            if (!this.outgoingCharSequenceIterator.hasNext()) {
                                this.outgoingCharSequenceIterator = null;
                                bl3 = true;
                            } else {
                                bl3 = false;
                            }
                            if ((smackDebugger = this.connectionInternal.smackDebugger) == null) continue;
                            if (stringBuilder == null) {
                                stringBuilder = new StringBuilder();
                            }
                            stringBuilder.append((CharSequence)object2);
                            if (!bl3) continue;
                            try {
                                this.outputDebugSplitter.append((CharSequence)stringBuilder);
                            }
                            catch (IOException iOException) {
                                throw new AssertionError((Object)iOException);
                            }
                            smackDebugger.onOutgoingElementCompleted();
                            stringBuilder = null;
                            continue;
                        }
                        if (this.connectionInternal.outgoingElementsQueue.isEmpty()) break block54;
                        topLevelStreamElement = (TopLevelStreamElement)this.connectionInternal.outgoingElementsQueue.poll();
                        if (topLevelStreamElement instanceof Stanza) {
                            object2 = (Stanza)topLevelStreamElement;
                            i i2 = object2.getTo();
                            bl2 = !a.a((i)this.lastDestinationAddress, (i)i2);
                            this.lastDestinationAddress = i2;
                        }
                        if ((object2 = topLevelStreamElement.toXML("jabber:client")) instanceof XmlStringBuilder) {
                            XmlStringBuilder xmlStringBuilder = (XmlStringBuilder)object2;
                            object = this.connectionInternal.getOutgoingStreamXmlEnvironment();
                            this.outgoingCharSequenceIterator = xmlStringBuilder.toList((XmlEnvironment)object).iterator();
                        } else {
                            this.outgoingCharSequenceIterator = Collections.singletonList(object2).iterator();
                        }
                        if (!$assertionsDisabled && this.outgoingCharSequenceIterator == null) break;
                    }
                    throw new AssertionError();
                }
                this.pendingOutputFilterData = bl;
                if (!this.pendingWriteInterestAfterRead && this.pendingOutputFilterData) {
                    n |= 4;
                }
                while (true) {
                    if (l > 0xA00000L) {
                        ++this.callbackPreemtBecauseBytesRead;
                        break;
                    }
                    this.incomingBuffer.clear();
                    try {
                        n2 = socketChannel.read(this.incomingBuffer);
                    }
                    catch (IOException iOException) {
                        this.handleReadWriteIoException(iOException);
                        this.totalBytesWritten += l2;
                        this.totalBytesRead += l;
                        this.channelSelectedCallbackLock.unlock();
                        return;
                    }
                    if (n2 < 0) {
                        LOGGER.finer("NIO read() returned " + n2 + " for " + (Object)((Object)this) + ". This probably means that the TCP connection was terminated.");
                        return;
                    }
                    if (!this.pendingInputFilterData) {
                        if (n2 == 0) {
                            break;
                        }
                    } else {
                        this.pendingInputFilterData = false;
                    }
                    if (this.pendingWriteInterestAfterRead) {
                        this.pendingWriteInterestAfterRead = false;
                        n |= 4;
                    }
                    l += (long)n2;
                    object2 = this.incomingBuffer;
                    ListIterator listIterator = this.connectionInternal.getXmppInputOutputFilterEndIterator();
                    while (listIterator.hasPrevious()) {
                        ((ByteBuffer)object2).flip();
                        try {
                            object = ((XmppInputOutputFilter)listIterator.previous()).input((ByteBuffer)object2);
                        }
                        catch (IOException iOException) {
                            this.connectionInternal.notifyConnectionError((Exception)iOException);
                            this.totalBytesWritten += l2;
                            this.totalBytesRead += l;
                            this.channelSelectedCallbackLock.unlock();
                            return;
                        }
                        if (object == null) {
                            break block55;
                        }
                        object2 = object;
                    }
                    int n4 = ((ByteBuffer)object2).flip().remaining();
                    this.totalBytesReadAfterFilter += (long)n4;
                    try {
                        this.splitter.a((ByteBuffer)object2);
                    }
                    catch (IOException iOException) {
                        this.connectionInternal.notifyConnectionError((Exception)iOException);
                        this.totalBytesWritten += l2;
                        this.totalBytesRead += l;
                        this.channelSelectedCallbackLock.unlock();
                        return;
                    }
                }
            }
            finally {
                this.totalBytesWritten += l2;
                this.totalBytesRead += l;
                this.channelSelectedCallbackLock.unlock();
            }
        }
        SmackReactor.SelectionKeyAttachment selectionKeyAttachment = this.selectionKeyAttachment;
        if (selectionKeyAttachment != null) {
            selectionKeyAttachment.resetReactorThreadRacing();
        }
        if (!this.connectionInternal.outgoingElementsQueue.isEmpty()) {
            this.setWriteInterestAfterChannelSelectedCallback.incrementAndGet();
            n |= 4;
        }
        this.connectionInternal.setInterestOps(this.selectionKey, n);
    }

    private void handleReadWriteIoException(IOException iOException) {
        if (iOException instanceof ClosedChannelException && !this.tcpNioTransport.isConnected()) {
            return;
        }
        this.connectionInternal.notifyConnectionError((Exception)iOException);
    }

    private void afterOutgoingElementsQueueModified() {
        SmackReactor.SelectionKeyAttachment selectionKeyAttachment = this.selectionKeyAttachment;
        if (selectionKeyAttachment != null && selectionKeyAttachment.isReactorThreadRacing()) {
            this.reactorThreadAlreadyRacing.incrementAndGet();
            return;
        }
        this.afterOutgoingElementsQueueModifiedSetInterestOps.incrementAndGet();
        this.connectionInternal.setInterestOps(this.selectionKey, 5);
    }

    protected XmppTcpNioTransport getTransport() {
        return this.tcpNioTransport;
    }

    private EstablishingTcpConnectionState constructEstablishingTcpConnectionState(EstablishingTcpConnectionStateDescriptor establishingTcpConnectionStateDescriptor, ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
        return new EstablishingTcpConnectionState(establishingTcpConnectionStateDescriptor, modularXmppClientToServerConnectionInternal);
    }

    private EstablishTlsState constructEstablishingTlsState(EstablishTlsStateDescriptor establishTlsStateDescriptor, ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
        return new EstablishTlsState(establishTlsStateDescriptor, modularXmppClientToServerConnectionInternal);
    }

    private static void debugLogSslEngineResult(String string, SSLEngineResult sSLEngineResult) {
        if (!LOGGER.isLoggable(SSL_ENGINE_DEBUG_LOG_LEVEL)) {
            return;
        }
        LOGGER.log(SSL_ENGINE_DEBUG_LOG_LEVEL, "SSLEngineResult of " + string + "(): " + sSLEngineResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callChannelSelectedCallback(boolean bl, boolean bl2) {
        SocketChannel socketChannel = this.socketChannel;
        SelectionKey selectionKey = this.selectionKey;
        if (socketChannel == null || selectionKey == null) {
            LOGGER.info("Not calling channel selected callback because the connection was eventually disconnected");
            return;
        }
        this.channelSelectedCallbackLock.lock();
        try {
            if (bl) {
                this.pendingInputFilterData = true;
            }
            if (bl2) {
                this.pendingOutputFilterData = true;
            }
            this.onChannelSelected(socketChannel, selectionKey);
        }
        finally {
            this.channelSelectedCallbackLock.unlock();
        }
    }

    private void closeSocketAndCleanup() {
        SocketChannel socketChannel;
        SelectionKey selectionKey = this.selectionKey;
        if (selectionKey != null) {
            selectionKey.cancel();
        }
        if ((socketChannel = this.socketChannel) != null) {
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.selectionKey = null;
        this.socketChannel = null;
        this.selectionKeyAttachment = null;
        this.remoteAddress = null;
    }

    private static List<? extends Buffer> pruneBufferList(Collection<? extends Buffer> collection) {
        return CollectionUtil.removeUntil(collection, buffer -> buffer.hasRemaining());
    }

    public Stats getStats() {
        return new Stats(this);
    }

    public static final class Stats
    extends XmppClientToServerTransport.Stats {
        public final long totalBytesWritten;
        public final long totalBytesWrittenBeforeFilter;
        public final double writeRatio;
        public final long totalBytesRead;
        public final long totalBytesReadAfterFilter;
        public final double readRatio;
        public final long handledChannelSelectedCallbacks;
        public final long setWriteInterestAfterChannelSelectedCallback;
        public final long reactorThreadAlreadyRacing;
        public final long afterOutgoingElementsQueueModifiedSetInterestOps;
        public final long rejectedChannelSelectedCallbacks;
        public final long totalCallbackRequests;
        public final long callbackPreemtBecauseBytesWritten;
        public final long callbackPreemtBecauseBytesRead;
        public final int sslEngineDelegatedTasks;
        public final int maxPendingSslEngineDelegatedTasks;
        private transient String toStringCache;

        private Stats(XmppTcpTransportModule xmppTcpTransportModule) {
            this.totalBytesWritten = xmppTcpTransportModule.totalBytesWritten;
            this.totalBytesWrittenBeforeFilter = xmppTcpTransportModule.totalBytesWrittenBeforeFilter;
            this.writeRatio = (double)this.totalBytesWritten / (double)this.totalBytesWrittenBeforeFilter;
            this.totalBytesReadAfterFilter = xmppTcpTransportModule.totalBytesReadAfterFilter;
            this.totalBytesRead = xmppTcpTransportModule.totalBytesRead;
            this.readRatio = (double)this.totalBytesRead / (double)this.totalBytesReadAfterFilter;
            this.handledChannelSelectedCallbacks = xmppTcpTransportModule.handledChannelSelectedCallbacks;
            this.setWriteInterestAfterChannelSelectedCallback = xmppTcpTransportModule.setWriteInterestAfterChannelSelectedCallback.get();
            this.reactorThreadAlreadyRacing = xmppTcpTransportModule.reactorThreadAlreadyRacing.get();
            this.afterOutgoingElementsQueueModifiedSetInterestOps = xmppTcpTransportModule.afterOutgoingElementsQueueModifiedSetInterestOps.get();
            this.rejectedChannelSelectedCallbacks = xmppTcpTransportModule.rejectedChannelSelectedCallbacks.get();
            this.totalCallbackRequests = this.handledChannelSelectedCallbacks + this.rejectedChannelSelectedCallbacks;
            this.callbackPreemtBecauseBytesRead = xmppTcpTransportModule.callbackPreemtBecauseBytesRead;
            this.callbackPreemtBecauseBytesWritten = xmppTcpTransportModule.callbackPreemtBecauseBytesWritten;
            this.sslEngineDelegatedTasks = xmppTcpTransportModule.sslEngineDelegatedTasks;
            this.maxPendingSslEngineDelegatedTasks = xmppTcpTransportModule.maxPendingSslEngineDelegatedTasks;
        }

        public String toString() {
            if (this.toStringCache != null) {
                return this.toStringCache;
            }
            this.toStringCache = "Total bytes\nrecv: " + this.totalBytesRead + '\n' + "send: " + this.totalBytesWritten + '\n' + "recv-aft-filter: " + this.totalBytesReadAfterFilter + '\n' + "send-bef-filter: " + this.totalBytesWrittenBeforeFilter + '\n' + "read-ratio: " + this.readRatio + '\n' + "write-ratio: " + this.writeRatio + '\n' + "Events\ntotal-callback-requests: " + this.totalCallbackRequests + '\n' + "handled-channel-selected-callbacks: " + this.handledChannelSelectedCallbacks + '\n' + "rejected-channel-selected-callbacks: " + this.rejectedChannelSelectedCallbacks + '\n' + "set-write-interest-after-callback: " + this.setWriteInterestAfterChannelSelectedCallback + '\n' + "reactor-thread-already-racing: " + this.reactorThreadAlreadyRacing + '\n' + "after-queue-modified-set-interest-ops: " + this.afterOutgoingElementsQueueModifiedSetInterestOps + '\n' + "callback-preemt-because-bytes-read: " + this.callbackPreemtBecauseBytesRead + '\n' + "callback-preemt-because-bytes-written: " + this.callbackPreemtBecauseBytesWritten + '\n' + "ssl-engine-delegated-tasks: " + this.sslEngineDelegatedTasks + '\n' + "max-pending-ssl-engine-delegated-tasks: " + this.maxPendingSslEngineDelegatedTasks + '\n';
            return this.toStringCache;
        }
    }

    public static final class TlsStateStats {
        public final long wrapInBytes;
        public final long wrapOutBytes;
        public final double wrapRatio;
        public final long unwrapInBytes;
        public final long unwrapOutBytes;
        public final double unwrapRatio;
        private transient String toStringCache;

        private TlsStateStats(TlsState tlsState) {
            this.wrapOutBytes = tlsState.wrapOutBytes;
            this.wrapInBytes = tlsState.wrapInBytes;
            this.wrapRatio = (double)this.wrapOutBytes / (double)this.wrapInBytes;
            this.unwrapOutBytes = tlsState.unwrapOutBytes;
            this.unwrapInBytes = tlsState.unwrapInBytes;
            this.unwrapRatio = (double)this.unwrapInBytes / (double)this.unwrapOutBytes;
        }

        public String toString() {
            if (this.toStringCache != null) {
                return this.toStringCache;
            }
            this.toStringCache = "wrap-in-bytes: " + this.wrapInBytes + '\n' + "wrap-out-bytes: " + this.wrapOutBytes + '\n' + "wrap-ratio: " + this.wrapRatio + '\n' + "unwrap-in-bytes: " + this.unwrapInBytes + '\n' + "unwrap-out-bytes: " + this.unwrapOutBytes + '\n' + "unwrap-ratio: " + this.unwrapRatio + '\n';
            return this.toStringCache;
        }
    }

    private final class TlsState
    implements XmppInputOutputFilter {
        private static final int MAX_PENDING_OUTPUT_BYTES = 8096;
        private final SmackTlsContext smackTlsContext;
        private final SSLEngine engine;
        private TlsHandshakeStatus handshakeStatus = TlsHandshakeStatus.initial;
        private SSLException handshakeException;
        private ByteBuffer myNetData;
        private ByteBuffer peerAppData;
        private final List<ByteBuffer> pendingOutputData = new ArrayList<ByteBuffer>();
        private int pendingOutputBytes;
        private ByteBuffer pendingInputData;
        private final AtomicInteger pendingDelegatedTasks = new AtomicInteger();
        private long wrapInBytes;
        private long wrapOutBytes;
        private long unwrapInBytes;
        private long unwrapOutBytes;

        private TlsState(SmackTlsContext smackTlsContext) {
            this.smackTlsContext = smackTlsContext;
            String string = ((XmppTcpTransportModule)XmppTcpTransportModule.this).connectionInternal.connection.getConfiguration().getXMPPServiceDomain().toString();
            this.engine = smackTlsContext.sslContext.createSSLEngine(string, XmppTcpTransportModule.this.remoteAddress.getPort());
            this.engine.setUseClientMode(true);
            SSLSession sSLSession = this.engine.getSession();
            int n = sSLSession.getApplicationBufferSize();
            int n2 = sSLSession.getPacketBufferSize();
            this.myNetData = ByteBuffer.allocateDirect(n2);
            this.peerAppData = ByteBuffer.allocate(n);
        }

        public XmppInputOutputFilter.OutputResult output(ByteBuffer byteBuffer, boolean bl, boolean bl2, boolean bl3) {
            if (byteBuffer != null) {
                this.pendingOutputData.add(byteBuffer);
                this.pendingOutputBytes += byteBuffer.remaining();
                if (bl3 && this.pendingOutputBytes < 8096) {
                    return XmppInputOutputFilter.OutputResult.NO_OUTPUT;
                }
            }
            ByteBuffer[] byteBufferArray = this.pendingOutputData.toArray(new ByteBuffer[this.pendingOutputData.size()]);
            this.myNetData.clear();
            block12: while (true) {
                SSLEngineResult sSLEngineResult;
                try {
                    sSLEngineResult = this.engine.wrap(byteBufferArray, this.myNetData);
                }
                catch (SSLException sSLException) {
                    this.handleSslException(sSLException);
                    throw sSLException;
                }
                XmppTcpTransportModule.debugLogSslEngineResult("wrap", sSLEngineResult);
                SSLEngineResult.Status status = sSLEngineResult.getStatus();
                this.pendingOutputBytes -= sSLEngineResult.bytesConsumed();
                if (status == SSLEngineResult.Status.OK) {
                    this.wrapInBytes += (long)sSLEngineResult.bytesConsumed();
                    this.wrapOutBytes += (long)sSLEngineResult.bytesProduced();
                    SSLEngineResult.HandshakeStatus handshakeStatus = this.handleHandshakeStatus(sSLEngineResult);
                    switch (handshakeStatus) {
                        case NEED_UNWRAP: {
                            break;
                        }
                        case NEED_WRAP: 
                        case NEED_TASK: {
                            return new XmppInputOutputFilter.OutputResult(true, this.myNetData);
                        }
                    }
                }
                switch (status) {
                    case OK: {
                        XmppTcpTransportModule.pruneBufferList(this.pendingOutputData);
                        return new XmppInputOutputFilter.OutputResult(!this.pendingOutputData.isEmpty(), this.myNetData);
                    }
                    case CLOSED: {
                        this.pendingOutputData.clear();
                        return XmppInputOutputFilter.OutputResult.NO_OUTPUT;
                    }
                    case BUFFER_OVERFLOW: {
                        LOGGER.warning("SSLEngine status BUFFER_OVERFLOW, this is hopefully uncommon");
                        int n = byteBuffer != null ? byteBuffer.remaining() : 0;
                        int n2 = (int)(1.3 * (double)n);
                        if (n2 <= this.myNetData.capacity()) {
                            n2 = 2 * this.myNetData.capacity();
                        }
                        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n2);
                        this.myNetData.flip();
                        byteBuffer2.put(this.myNetData);
                        this.myNetData = byteBuffer2;
                        continue block12;
                    }
                    case BUFFER_UNDERFLOW: {
                        throw new IllegalStateException("Buffer underflow as result of SSLEngine.wrap() should never happen");
                    }
                }
            }
        }

        public ByteBuffer input(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2;
            if (this.pendingInputData == null) {
                byteBuffer2 = byteBuffer;
            } else {
                assert (this.pendingInputData != byteBuffer);
                int n = this.pendingInputData.remaining() + byteBuffer.remaining();
                byteBuffer2 = ByteBuffer.allocate(n);
                byteBuffer2.put(this.pendingInputData).put(byteBuffer).flip();
                this.pendingInputData = null;
            }
            this.peerAppData.clear();
            block13: while (true) {
                SSLEngineResult sSLEngineResult;
                try {
                    sSLEngineResult = this.engine.unwrap(byteBuffer2, this.peerAppData);
                }
                catch (SSLException sSLException) {
                    this.handleSslException(sSLException);
                    throw sSLException;
                }
                XmppTcpTransportModule.debugLogSslEngineResult("unwrap", sSLEngineResult);
                SSLEngineResult.Status status = sSLEngineResult.getStatus();
                if (status == SSLEngineResult.Status.OK) {
                    this.unwrapInBytes += (long)sSLEngineResult.bytesConsumed();
                    this.unwrapOutBytes += (long)sSLEngineResult.bytesProduced();
                    SSLEngineResult.HandshakeStatus handshakeStatus = this.handleHandshakeStatus(sSLEngineResult);
                    switch (handshakeStatus) {
                        case NEED_TASK: {
                            this.addAsPendingInputData(byteBuffer2);
                            return null;
                        }
                        case NEED_UNWRAP: {
                            continue block13;
                        }
                        case NEED_WRAP: {
                            this.addAsPendingInputData(byteBuffer2);
                            XmppTcpTransportModule.this.connectionInternal.asyncGo(() -> XmppTcpTransportModule.this.callChannelSelectedCallback(false, true));
                            return null;
                        }
                    }
                }
                switch (status) {
                    case OK: {
                        if (byteBuffer2.hasRemaining()) continue block13;
                        return this.peerAppData;
                    }
                    case CLOSED: {
                        return null;
                    }
                    case BUFFER_UNDERFLOW: {
                        this.addAsPendingInputData(byteBuffer2);
                        return null;
                    }
                    case BUFFER_OVERFLOW: {
                        int n = this.engine.getSession().getApplicationBufferSize();
                        assert (this.peerAppData.remaining() < n);
                        this.peerAppData = ByteBuffer.allocate(n);
                        continue block13;
                    }
                }
            }
        }

        private void addAsPendingInputData(ByteBuffer byteBuffer) {
            this.pendingInputData = ByteBuffer.allocate(byteBuffer.remaining());
            this.pendingInputData.put(byteBuffer).flip();
            XmppTcpTransportModule.this.pendingInputFilterData = this.pendingInputData.hasRemaining();
        }

        private SSLEngineResult.HandshakeStatus handleHandshakeStatus(SSLEngineResult sSLEngineResult) {
            Object object;
            SSLEngineResult.HandshakeStatus handshakeStatus = sSLEngineResult.getHandshakeStatus();
            switch (handshakeStatus) {
                case NEED_TASK: {
                    while ((object = this.engine.getDelegatedTask()) != null) {
                        XmppTcpTransportModule.this.sslEngineDelegatedTasks++;
                        int n = this.pendingDelegatedTasks.incrementAndGet();
                        if (n > XmppTcpTransportModule.this.maxPendingSslEngineDelegatedTasks) {
                            XmppTcpTransportModule.this.maxPendingSslEngineDelegatedTasks = n;
                        }
                        Runnable runnable = () -> this.lambda$handleHandshakeStatus$1((Runnable)object);
                        XmppTcpTransportModule.this.connectionInternal.asyncGo(runnable);
                    }
                    break;
                }
                case FINISHED: {
                    this.onHandshakeFinished();
                    break;
                }
            }
            object = this.engine.getHandshakeStatus();
            return object;
        }

        private void handleSslException(SSLException sSLException) {
            this.handshakeException = sSLException;
            this.handshakeStatus = TlsHandshakeStatus.failed;
            XmppTcpTransportModule.this.connectionInternal.notifyWaitingThreads();
        }

        private void onHandshakeFinished() {
            this.handshakeStatus = TlsHandshakeStatus.successful;
            XmppTcpTransportModule.this.connectionInternal.notifyWaitingThreads();
        }

        private boolean isHandshakeFinished() {
            return this.handshakeStatus == TlsHandshakeStatus.successful || this.handshakeStatus == TlsHandshakeStatus.failed;
        }

        private void waitForHandshakeFinished() {
            XmppTcpTransportModule.this.connectionInternal.waitForConditionOrThrowConnectionException(() -> this.isHandshakeFinished(), "TLS handshake to finish");
            if (this.handshakeStatus == TlsHandshakeStatus.failed) {
                throw this.handshakeException;
            }
            assert (this.handshakeStatus == TlsHandshakeStatus.successful);
            if (this.smackTlsContext.daneVerifier != null) {
                this.smackTlsContext.daneVerifier.finish(this.engine.getSession());
            }
        }

        public Object getStats() {
            return new TlsStateStats(this);
        }

        public void closeInputOutput() {
            this.engine.closeOutbound();
            try {
                this.engine.closeInbound();
            }
            catch (SSLException sSLException) {
                LOGGER.log(Level.FINEST, "SSLException when closing inbound TLS session. This can likely be ignored if a possible truncation attack is suggested. You may want to ask your XMPP server vendor to implement a clean TLS session shutdown sending close_notify after </stream>", sSLException);
            }
        }

        public void waitUntilInputOutputClosed() {
            this.waitForHandshakeFinished();
        }

        public String getFilterName() {
            return "TLS (" + this.engine + ')';
        }

        private /* synthetic */ void lambda$handleHandshakeStatus$1(Runnable runnable) {
            runnable.run();
            int n = this.pendingDelegatedTasks.decrementAndGet();
            if (n == 0) {
                XmppTcpTransportModule.this.callChannelSelectedCallback(true, true);
            }
        }
    }

    private static enum TlsHandshakeStatus {
        initial,
        initiated,
        successful,
        failed;

    }

    private final class EstablishTlsState
    extends State {
        private EstablishTlsState(EstablishTlsStateDescriptor establishTlsStateDescriptor, ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
            super((StateDescriptor)establishTlsStateDescriptor, modularXmppClientToServerConnectionInternal);
        }

        public StateTransitionResult.TransitionImpossible isTransitionToPossible(WalkStateGraphContext walkStateGraphContext) {
            StartTls startTls = (StartTls)this.connectionInternal.connection.getFeature(StartTls.class);
            ConnectionConfiguration.SecurityMode securityMode = this.connectionInternal.connection.getConfiguration().getSecurityMode();
            switch (securityMode) {
                case required: 
                case ifpossible: {
                    if (startTls == null) {
                        if (securityMode == ConnectionConfiguration.SecurityMode.ifpossible) {
                            return new StateTransitionResult.TransitionImpossibleReason("Server does not announce support for TLS and we do not required it");
                        }
                        throw new SmackException.SecurityRequiredByClientException();
                    }
                    return null;
                }
                case disabled: {
                    if (startTls != null && startTls.required()) {
                        throw new SmackException.SecurityRequiredByServerException();
                    }
                    return new StateTransitionResult.TransitionImpossibleReason("TLS disabled in client settings and server does not require it");
                }
            }
            throw new AssertionError((Object)("Unknown security mode: " + securityMode));
        }

        public StateTransitionResult.AttemptResult transitionInto(WalkStateGraphContext walkStateGraphContext) {
            this.connectionInternal.sendAndWaitForResponse((Nonza)StartTls.INSTANCE, TlsProceed.class, TlsFailure.class);
            SmackTlsContext smackTlsContext = this.connectionInternal.getSmackTlsContext();
            XmppTcpTransportModule.this.tlsState = new TlsState(smackTlsContext);
            this.connectionInternal.addXmppInputOutputFilter((XmppInputOutputFilter)XmppTcpTransportModule.this.tlsState);
            XmppTcpTransportModule.this.channelSelectedCallbackLock.lock();
            try {
                XmppTcpTransportModule.this.pendingOutputFilterData = true;
                XmppTcpTransportModule.this.tlsState.engine.beginHandshake();
                XmppTcpTransportModule.this.tlsState.handshakeStatus = TlsHandshakeStatus.initiated;
            }
            finally {
                XmppTcpTransportModule.this.channelSelectedCallbackLock.unlock();
            }
            this.connectionInternal.setInterestOps(XmppTcpTransportModule.this.selectionKey, 5);
            try {
                XmppTcpTransportModule.this.tlsState.waitForHandshakeFinished();
            }
            catch (CertificateException certificateException) {
                throw new SmackException.SmackCertificateException(certificateException);
            }
            this.connectionInternal.newStreamOpenWaitForFeaturesSequence("stream features after TLS established");
            return new TlsEstablishedResult(XmppTcpTransportModule.this.tlsState.engine);
        }

        public void resetState() {
            XmppTcpTransportModule.this.tlsState = null;
        }
    }

    static final class EstablishTlsStateDescriptor
    extends StateDescriptor {
        private EstablishTlsStateDescriptor() {
            super(EstablishTlsState.class, "RFC 6120 \u00a7 5");
            this.addSuccessor(ModularXmppClientToServerConnection.ConnectedButUnauthenticatedStateDescriptor.class);
            this.declarePrecedenceOver(ModularXmppClientToServerConnection.ConnectedButUnauthenticatedStateDescriptor.class);
        }

        protected EstablishTlsState constructState(ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
            XmppTcpTransportModule xmppTcpTransportModule = (XmppTcpTransportModule)modularXmppClientToServerConnectionInternal.connection.getConnectionModuleFor(XmppTcpTransportModuleDescriptor.class);
            return xmppTcpTransportModule.constructEstablishingTlsState(this, modularXmppClientToServerConnectionInternal);
        }
    }

    public static final class TlsEstablishedResult
    extends StateTransitionResult.Success {
        private TlsEstablishedResult(SSLEngine sSLEngine) {
            super("TLS established: " + sSLEngine.getSession());
        }
    }

    public static final class TcpSocketConnectedResult
    extends StateTransitionResult.Success {
        private final InetSocketAddress remoteAddress;

        private TcpSocketConnectedResult(InetSocketAddress inetSocketAddress) {
            super("TCP connection established to " + inetSocketAddress);
            this.remoteAddress = inetSocketAddress;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.remoteAddress;
        }
    }

    final class EstablishingTcpConnectionState
    extends State {
        private EstablishingTcpConnectionState(EstablishingTcpConnectionStateDescriptor establishingTcpConnectionStateDescriptor, ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
            super((StateDescriptor)establishingTcpConnectionStateDescriptor, modularXmppClientToServerConnectionInternal);
        }

        public StateTransitionResult.AttemptResult transitionInto(WalkStateGraphContext walkStateGraphContext) {
            ConnectionAttemptState connectionAttemptState = new ConnectionAttemptState(this.connectionInternal, XmppTcpTransportModule.this.discoveredTcpEndpoints, this);
            StateTransitionResult.Failure failure = connectionAttemptState.establishTcpConnection();
            if (failure != null) {
                return failure;
            }
            XmppTcpTransportModule.this.socketChannel = connectionAttemptState.socketChannel;
            XmppTcpTransportModule.this.remoteAddress = (InetSocketAddress)XmppTcpTransportModule.this.socketChannel.socket().getRemoteSocketAddress();
            XmppTcpTransportModule.this.selectionKey = this.connectionInternal.registerWithSelector((SelectableChannel)XmppTcpTransportModule.this.socketChannel, 1, (selectableChannel, selectionKey) -> XmppTcpTransportModule.this.onChannelSelected(selectableChannel, selectionKey));
            XmppTcpTransportModule.this.selectionKeyAttachment = (SmackReactor.SelectionKeyAttachment)XmppTcpTransportModule.this.selectionKey.attachment();
            this.connectionInternal.setTransport((XmppClientToServerTransport)XmppTcpTransportModule.this.tcpNioTransport);
            this.connectionInternal.newStreamOpenWaitForFeaturesSequence("stream features after initial connection");
            return new TcpSocketConnectedResult(XmppTcpTransportModule.this.remoteAddress);
        }

        public void resetState() {
            XmppTcpTransportModule.this.closeSocketAndCleanup();
        }
    }

    static final class EstablishingTcpConnectionStateDescriptor
    extends StateDescriptor {
        private EstablishingTcpConnectionStateDescriptor() {
            super(EstablishingTcpConnectionState.class);
            this.addPredeccessor(ModularXmppClientToServerConnection.LookupRemoteConnectionEndpointsStateDescriptor.class);
            this.addSuccessor(EstablishTlsStateDescriptor.class);
            this.addSuccessor(ModularXmppClientToServerConnection.ConnectedButUnauthenticatedStateDescriptor.class);
        }

        protected EstablishingTcpConnectionState constructState(ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
            XmppTcpTransportModule xmppTcpTransportModule = (XmppTcpTransportModule)modularXmppClientToServerConnectionInternal.connection.getConnectionModuleFor(XmppTcpTransportModuleDescriptor.class);
            return xmppTcpTransportModule.constructEstablishingTcpConnectionState(this, modularXmppClientToServerConnectionInternal);
        }
    }

    final class XmppTcpNioTransport
    extends XmppClientToServerTransport {
        protected XmppTcpNioTransport(ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
            super(modularXmppClientToServerConnectionInternal);
        }

        protected void resetDiscoveredConnectionEndpoints() {
            XmppTcpTransportModule.this.discoveredTcpEndpoints = null;
        }

        protected List<SmackFuture<XmppClientToServerTransport.LookupConnectionEndpointsResult, Exception>> lookupConnectionEndpoints() {
            assert (XmppTcpTransportModule.this.discoveredTcpEndpoints == null);
            ArrayList<SmackFuture<XmppClientToServerTransport.LookupConnectionEndpointsResult, Exception>> arrayList = new ArrayList<SmackFuture<XmppClientToServerTransport.LookupConnectionEndpointsResult, Exception>>(2);
            SmackFuture.InternalSmackFuture internalSmackFuture = new SmackFuture.InternalSmackFuture();
            this.connectionInternal.asyncGo(() -> {
                RemoteXmppTcpConnectionEndpoints.Result<Rfc6120TcpRemoteConnectionEndpoint> result = RemoteXmppTcpConnectionEndpoints.lookup((ConnectionConfiguration)this.connectionInternal.connection.getConfiguration());
                Object object = result.discoveredRemoteConnectionEndpoints.isEmpty() ? new TcpEndpointDiscoveryFailed(result) : new DiscoveredTcpEndpoints(result);
                internalSmackFuture.setResult(object);
            });
            arrayList.add((SmackFuture<XmppClientToServerTransport.LookupConnectionEndpointsResult, Exception>)internalSmackFuture);
            if (((XmppTcpTransportModuleDescriptor)XmppTcpTransportModule.this.moduleDescriptor).isDirectTlsEnabled()) {
                throw new IllegalArgumentException("DirectTLS is not implemented yet");
            }
            return arrayList;
        }

        protected void loadConnectionEndpoints(XmppClientToServerTransport.LookupConnectionEndpointsSuccess lookupConnectionEndpointsSuccess) {
            XmppTcpTransportModule.this.discoveredTcpEndpoints = (DiscoveredTcpEndpoints)lookupConnectionEndpointsSuccess;
        }

        protected void afterFiltersClosed() {
            XmppTcpTransportModule.this.pendingInputFilterData = (XmppTcpTransportModule.this.pendingOutputFilterData = true);
            XmppTcpTransportModule.this.afterOutgoingElementsQueueModified();
        }

        protected void disconnect() {
            XmppTcpTransportModule.this.closeSocketAndCleanup();
        }

        protected void notifyAboutNewOutgoingElements() {
            XmppTcpTransportModule.this.afterOutgoingElementsQueueModified();
        }

        public SSLSession getSslSession() {
            TlsState tlsState = XmppTcpTransportModule.this.tlsState;
            if (tlsState == null) {
                return null;
            }
            return tlsState.engine.getSession();
        }

        public boolean isConnected() {
            SocketChannel socketChannel = XmppTcpTransportModule.this.socketChannel;
            if (socketChannel == null) {
                return false;
            }
            return socketChannel.isConnected();
        }

        public boolean isTransportSecured() {
            TlsState tlsState = XmppTcpTransportModule.this.tlsState;
            return tlsState != null && tlsState.handshakeStatus == TlsHandshakeStatus.successful;
        }

        public Stats getStats() {
            return XmppTcpTransportModule.this.getStats();
        }

        final class TcpEndpointDiscoveryFailed
        implements XmppClientToServerTransport.LookupConnectionEndpointsFailed {
            final List<RemoteConnectionEndpointLookupFailure> lookupFailures;

            TcpEndpointDiscoveryFailed(RemoteXmppTcpConnectionEndpoints.Result<Rfc6120TcpRemoteConnectionEndpoint> result) {
                this.lookupFailures = result.lookupFailures;
            }
        }

        final class DiscoveredTcpEndpoints
        implements XmppClientToServerTransport.LookupConnectionEndpointsSuccess {
            final RemoteXmppTcpConnectionEndpoints.Result<Rfc6120TcpRemoteConnectionEndpoint> result;

            DiscoveredTcpEndpoints(RemoteXmppTcpConnectionEndpoints.Result<Rfc6120TcpRemoteConnectionEndpoint> result) {
                this.result = result;
            }
        }
    }
}

