/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.JsonDecodingException;
import kotlinx.serialization.json.internal.JsonEncodingException;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0000\u001a\u0016\u0010\u0011\u001a\u00020\u000e*\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0000\u001a \u0010\u0017\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0000\u001a \u0010\u0018\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\u0019\u001a\u00020\u0007*\u00020\u00072\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u001a"}, d2={"JsonDecodingException", "Lkotlinx/serialization/json/internal/JsonDecodingException;", "offset", "", "message", "", "input", "", "InvalidFloatingPointEncoded", "Lkotlinx/serialization/json/internal/JsonEncodingException;", "value", "", "output", "throwInvalidFloatingPointDecoded", "", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "result", "invalidTrailingComma", "entity", "InvalidKeyKindException", "keyDescriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "key", "InvalidFloatingPointDecoded", "unexpectedFpErrorMessage", "minify", "kotlinx-serialization-json"})
public final class JsonExceptionsKt {
    public static final JsonDecodingException JsonDecodingException(int n, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return new JsonDecodingException(n >= 0 ? "Unexpected JSON token at offset " + n + ": " + string : string);
    }

    public static final JsonDecodingException JsonDecodingException(int n, String string, CharSequence charSequence) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"");
        return JsonExceptionsKt.JsonDecodingException(n, string + "\nJSON input: " + JsonExceptionsKt.minify(charSequence, n));
    }

    public static final JsonEncodingException InvalidFloatingPointEncoded(Number number, String string) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return new JsonEncodingException("Unexpected special floating-point value " + number + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + JsonExceptionsKt.minify$default(string, 0, 1, null));
    }

    public static final Void throwInvalidFloatingPointDecoded(AbstractJsonLexer abstractJsonLexer, Number number) {
        Intrinsics.checkNotNullParameter((Object)abstractJsonLexer, (String)"");
        Intrinsics.checkNotNullParameter((Object)number, (String)"");
        AbstractJsonLexer.fail$default(abstractJsonLexer, "Unexpected special floating-point value " + number + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification", 0, "It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'", 2, null);
        throw new KotlinNothingValueException();
    }

    public static final Void invalidTrailingComma(AbstractJsonLexer abstractJsonLexer, String string) {
        Intrinsics.checkNotNullParameter((Object)abstractJsonLexer, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        abstractJsonLexer.fail("Trailing comma before the end of JSON " + string, abstractJsonLexer.currentPosition - 1, "Trailing commas are non-complaint JSON and not allowed by default. Use 'allowTrailingComma = true' in 'Json {}' builder to support them.");
        throw new KotlinNothingValueException();
    }

    public static /* synthetic */ Void invalidTrailingComma$default(AbstractJsonLexer abstractJsonLexer, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "object";
        }
        return JsonExceptionsKt.invalidTrailingComma(abstractJsonLexer, string);
    }

    public static final JsonEncodingException InvalidKeyKindException(SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        return new JsonEncodingException("Value of type '" + serialDescriptor.getSerialName() + "' can't be used in JSON as a key in the map. It should have either primitive or enum kind, but its kind is '" + serialDescriptor.getKind() + "'.\nUse 'allowStructuredMapKeys = true' in 'Json {}' builder to convert such maps to [key1, value1, key2, value2,...] arrays.");
    }

    public static final JsonEncodingException InvalidFloatingPointEncoded(Number number, String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return new JsonEncodingException(JsonExceptionsKt.unexpectedFpErrorMessage(number, string, string2));
    }

    public static final JsonDecodingException InvalidFloatingPointDecoded(Number number, String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return JsonExceptionsKt.JsonDecodingException(-1, JsonExceptionsKt.unexpectedFpErrorMessage(number, string, string2));
    }

    private static final String unexpectedFpErrorMessage(Number number, String string, String string2) {
        return "Unexpected special floating-point value " + number + " with key " + string + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + JsonExceptionsKt.minify$default(string2, 0, 1, null);
    }

    public static final CharSequence minify(CharSequence charSequence, int n) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"");
        if (charSequence.length() < 200) {
            return charSequence;
        }
        if (n == -1) {
            int n2 = charSequence.length() - 60;
            if (n2 <= 0) {
                return charSequence;
            }
            CharSequence charSequence2 = charSequence;
            int n3 = charSequence2.length();
            return "....." + ((Object)charSequence2.subSequence(n2, n3)).toString();
        }
        int n4 = n - 30;
        int n5 = n + 30;
        String string = n4 <= 0 ? "" : ".....";
        String string2 = n5 >= charSequence.length() ? "" : ".....";
        CharSequence charSequence3 = charSequence;
        int n6 = RangesKt.coerceAtLeast((int)n4, (int)0);
        int n7 = RangesKt.coerceAtMost((int)n5, (int)charSequence.length());
        return string + ((Object)charSequence3.subSequence(n6, n7)).toString() + string2;
    }

    public static /* synthetic */ CharSequence minify$default(CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return JsonExceptionsKt.minify(charSequence, n);
    }
}

