/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Iterator;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.DecodeSequenceMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.JsonIteratorArrayWrapped;
import kotlinx.serialization.json.internal.JsonIteratorWsSeparated;
import kotlinx.serialization.json.internal.ReaderJsonLexer;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a:\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\nH\u0000\u001a\u0014\u0010\u000b\u001a\u00020\u0004*\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\fH\u0002\u00a8\u0006\u0010"}, d2={"JsonIterator", "", "T", "mode", "Lkotlinx/serialization/json/DecodeSequenceMode;", "json", "Lkotlinx/serialization/json/Json;", "lexer", "Lkotlinx/serialization/json/internal/ReaderJsonLexer;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "determineFormat", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "suggested", "tryConsumeStartArray", "", "kotlinx-serialization-json"})
public final class JsonIteratorKt {
    public static final <T> Iterator<T> JsonIterator(DecodeSequenceMode decodeSequenceMode, Json json, ReaderJsonLexer readerJsonLexer, DeserializationStrategy<? extends T> deserializationStrategy) {
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)((Object)decodeSequenceMode), (String)"");
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)readerJsonLexer, (String)"");
        Intrinsics.checkNotNullParameter(deserializationStrategy, (String)"");
        switch (WhenMappings.$EnumSwitchMapping$0[JsonIteratorKt.determineFormat(readerJsonLexer, decodeSequenceMode).ordinal()]) {
            case 1: {
                iterator = new JsonIteratorWsSeparated<T>(json, readerJsonLexer, deserializationStrategy);
                break;
            }
            case 2: {
                iterator = new JsonIteratorArrayWrapped<T>(json, readerJsonLexer, deserializationStrategy);
                break;
            }
            case 3: {
                throw new IllegalStateException("AbstractJsonLexer.determineFormat must be called beforehand.".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return iterator;
    }

    private static final DecodeSequenceMode determineFormat(AbstractJsonLexer abstractJsonLexer, DecodeSequenceMode decodeSequenceMode) {
        DecodeSequenceMode decodeSequenceMode2;
        switch (WhenMappings.$EnumSwitchMapping$0[decodeSequenceMode.ordinal()]) {
            case 1: {
                decodeSequenceMode2 = DecodeSequenceMode.WHITESPACE_SEPARATED;
                break;
            }
            case 2: {
                String string;
                if (JsonIteratorKt.tryConsumeStartArray(abstractJsonLexer)) {
                    decodeSequenceMode2 = DecodeSequenceMode.ARRAY_WRAPPED;
                    break;
                }
                AbstractJsonLexer abstractJsonLexer2 = abstractJsonLexer;
                byte by = 8;
                boolean bl = true;
                boolean bl2 = false;
                String string2 = AbstractJsonLexerKt.tokenDescription(by);
                int n = abstractJsonLexer2.currentPosition - 1;
                String string3 = string = abstractJsonLexer2.currentPosition == AbstractJsonLexer.access$getSource(abstractJsonLexer2).length() || n < 0 ? "EOF" : String.valueOf(AbstractJsonLexer.access$getSource(abstractJsonLexer2).charAt(n));
                String string4 = string2;
                AbstractJsonLexer abstractJsonLexer3 = abstractJsonLexer2;
                boolean bl3 = false;
                AbstractJsonLexer.fail$default(abstractJsonLexer3, "Expected " + string4 + ", but had '" + string3 + "' instead", n, null, 4, null);
                throw new KotlinNothingValueException();
            }
            case 3: {
                if (JsonIteratorKt.tryConsumeStartArray(abstractJsonLexer)) {
                    decodeSequenceMode2 = DecodeSequenceMode.ARRAY_WRAPPED;
                    break;
                }
                decodeSequenceMode2 = DecodeSequenceMode.WHITESPACE_SEPARATED;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return decodeSequenceMode2;
    }

    private static final boolean tryConsumeStartArray(AbstractJsonLexer abstractJsonLexer) {
        if (abstractJsonLexer.peekNextToken() == 8) {
            abstractJsonLexer.consumeNextToken((byte)8);
            return true;
        }
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DecodeSequenceMode.values().length];
            try {
                nArray[DecodeSequenceMode.WHITESPACE_SEPARATED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DecodeSequenceMode.ARRAY_WRAPPED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DecodeSequenceMode.AUTO_DETECT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

