/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.StructureKind;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nJ\u0010\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001J\u0006\u0010\u0013\u001a\u00020\fJ\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0002J\b\u0010\u0019\u001a\u00020\fH\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0016R\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lkotlinx/serialization/json/internal/JsonPath;", "", "<init>", "()V", "currentObjectPath", "", "[Ljava/lang/Object;", "indicies", "", "currentDepth", "", "pushDescriptor", "", "sd", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "updateDescriptorIndex", "index", "updateCurrentMapKey", "key", "resetCurrentMapKey", "popDescriptor", "getPath", "", "prettyString", "it", "resize", "toString", "Tombstone", "kotlinx-serialization-json"})
public final class JsonPath {
    private Object[] currentObjectPath = new Object[8];
    private int[] indicies;
    private int currentDepth;

    public JsonPath() {
        int n = 0;
        int[] nArray = new int[8];
        JsonPath jsonPath = this;
        while (n < 8) {
            int n2 = n++;
            nArray[n2] = -1;
        }
        jsonPath.indicies = nArray;
        this.currentDepth = -1;
    }

    public final void pushDescriptor(SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        ++this.currentDepth;
        int n = this.currentDepth;
        if (n == this.currentObjectPath.length) {
            this.resize();
        }
        this.currentObjectPath[n] = serialDescriptor;
    }

    public final void updateDescriptorIndex(int n) {
        this.indicies[this.currentDepth] = n;
    }

    public final void updateCurrentMapKey(Object object) {
        if (this.indicies[this.currentDepth] != -2) {
            ++this.currentDepth;
            if (this.currentDepth == this.currentObjectPath.length) {
                this.resize();
            }
        }
        this.currentObjectPath[this.currentDepth] = object;
        this.indicies[this.currentDepth] = -2;
    }

    public final void resetCurrentMapKey() {
        if (this.indicies[this.currentDepth] == -2) {
            this.currentObjectPath[this.currentDepth] = Tombstone.INSTANCE;
        }
    }

    public final void popDescriptor() {
        int n;
        int n2 = this.currentDepth;
        if (this.indicies[n2] == -2) {
            this.indicies[n2] = -1;
            n = this.currentDepth;
            this.currentDepth = n + -1;
        }
        if (this.currentDepth != -1) {
            n = this.currentDepth;
            this.currentDepth = n + -1;
        }
    }

    public final String getPath() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder2.append("$");
        int n = this.currentDepth + 1;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            boolean bl2 = false;
            Object object = this.currentObjectPath[n2];
            if (object instanceof SerialDescriptor) {
                if (Intrinsics.areEqual((Object)((SerialDescriptor)object).getKind(), (Object)StructureKind.LIST.INSTANCE)) {
                    if (this.indicies[n2] == -1) continue;
                    stringBuilder2.append("[");
                    stringBuilder2.append(this.indicies[n2]);
                    stringBuilder2.append("]");
                    continue;
                }
                int n3 = this.indicies[n2];
                if (n3 < 0) continue;
                stringBuilder2.append(".");
                stringBuilder2.append(((SerialDescriptor)object).getElementName(n3));
                continue;
            }
            if (object == Tombstone.INSTANCE) continue;
            stringBuilder2.append("[");
            stringBuilder2.append("'");
            stringBuilder2.append(object);
            stringBuilder2.append("'");
            stringBuilder2.append("]");
        }
        return stringBuilder.toString();
    }

    private final String prettyString(Object object) {
        Object object2 = object instanceof SerialDescriptor ? (SerialDescriptor)object : null;
        if (object2 == null || (object2 = object2.getSerialName()) == null) {
            object2 = String.valueOf(object);
        }
        return object2;
    }

    private final void resize() {
        int n = this.currentDepth * 2;
        Object[] objectArray = Arrays.copyOf(this.currentObjectPath, n);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"");
        this.currentObjectPath = objectArray;
        int n2 = 0;
        int[] nArray = new int[n];
        while (n2 < n) {
            int n3 = n2++;
            nArray[n3] = -1;
        }
        int[] nArray2 = nArray;
        ArraysKt.copyInto$default((int[])this.indicies, (int[])nArray2, (int)0, (int)0, (int)0, (int)14, null);
        this.indicies = nArray2;
    }

    public String toString() {
        return this.getPath();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lkotlinx/serialization/json/internal/JsonPath$Tombstone;", "", "<init>", "()V", "kotlinx-serialization-json"})
    private static final class Tombstone {
        public static final Tombstone INSTANCE = new Tombstone();

        private Tombstone() {
        }
    }
}

